/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.siftscience.FieldSet;
import com.siftscience.exception.MissingFieldException;
import java.lang.reflect.Type;

public class ApplyDecisionFieldSet
extends FieldSet<ApplyDecisionFieldSet> {
    @Expose
    @SerializedName(value="decision_id")
    private String decisionId;
    @Expose
    @SerializedName(value="source")
    private DecisionSource source;
    @Expose
    @SerializedName(value="analyst")
    private String analyst;
    @Expose
    @SerializedName(value="description")
    private String description;
    @Expose
    @SerializedName(value="time")
    private Long time;
    private String userId;
    private String orderId;
    private String sessionId;
    private String contentId;

    public ApplyDecisionFieldSet setDecisionId(String decisionId) {
        this.decisionId = decisionId;
        return this;
    }

    public ApplyDecisionFieldSet setSource(DecisionSource source) {
        this.source = source;
        return this;
    }

    public ApplyDecisionFieldSet setDescription(String description) {
        this.description = description;
        return this;
    }

    public ApplyDecisionFieldSet setAnalyst(String analyst) {
        this.analyst = analyst;
        return this;
    }

    public ApplyDecisionFieldSet setTime(Long time) {
        this.time = time;
        return this;
    }

    public String getUserId() {
        return this.userId;
    }

    public ApplyDecisionFieldSet setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public ApplyDecisionFieldSet setOrderId(String orderId) {
        this.orderId = orderId;
        return this;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public ApplyDecisionFieldSet setSessionId(String sessionId) {
        this.sessionId = sessionId;
        return this;
    }

    public String getContentId() {
        return this.contentId;
    }

    public ApplyDecisionFieldSet setContentId(String contentId) {
        this.contentId = contentId;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (DecisionSource.MANUAL_REVIEW.equals((Object)this.source) && (this.analyst == null || this.analyst.isEmpty())) {
            throw new MissingFieldException("'analyst' required for decisions with source type MANUAL_REVIEW");
        }
    }

    public static enum DecisionSource {
        MANUAL_REVIEW("manual_review"),
        AUTOMATED_RULE("automated_rule"),
        CHARGEBACK("chargeback");

        private final String value;

        private DecisionSource(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        static class DecisionSourceSerializer
        implements JsonSerializer<DecisionSource> {
            DecisionSourceSerializer() {
            }

            public JsonElement serialize(DecisionSource source, Type typeOfSrc, JsonSerializationContext context) {
                return gson.toJsonTree((Object)source.value);
            }
        }

        static class DecisionSourceDeserializer
        implements JsonDeserializer<DecisionSource> {
            DecisionSourceDeserializer() {
            }

            public DecisionSource deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                return DecisionSource.valueOf(json.getAsString().toUpperCase());
            }
        }
    }
}

