/*
 * Decompiled with CFR 0.152.
 */
package com.siftscience;

import com.siftscience.ApplyDecisionRequest;
import com.siftscience.DecisionStatusRequest;
import com.siftscience.EventRequest;
import com.siftscience.FieldSet;
import com.siftscience.GetDecisionsRequest;
import com.siftscience.LabelRequest;
import com.siftscience.ScoreRequest;
import com.siftscience.UnlabelRequest;
import com.siftscience.UserScoreRequest;
import com.siftscience.WorkflowStatusRequest;
import com.siftscience.model.ApplyDecisionFieldSet;
import com.siftscience.model.DecisionStatusFieldSet;
import com.siftscience.model.GetDecisionFieldSet;
import com.siftscience.model.LabelFieldSet;
import com.siftscience.model.ScoreFieldSet;
import com.siftscience.model.UnlabelFieldSet;
import com.siftscience.model.UserScoreFieldSet;
import com.siftscience.model.WorkflowStatusFieldSet;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;

public class SiftClient {
    private final String accountId;
    private final String apiKey;
    private final OkHttpClient okClient;
    private HttpUrl baseUrl = HttpUrl.parse((String)"https://api.sift.com");

    public SiftClient(String apiKey, String accountId) {
        this(apiKey, accountId, new OkHttpClient());
    }

    public SiftClient(String apiKey, String accountId, OkHttpClient okHttpClient) {
        this.apiKey = apiKey;
        this.accountId = accountId;
        this.okClient = okHttpClient;
    }

    public SiftClient(String apiKey, String accountId, HttpUrl baseUrl) {
        this(apiKey, accountId, new OkHttpClient());
        this.baseUrl = baseUrl;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public EventRequest buildRequest(FieldSet fields) {
        this.setupApiKey(fields);
        return new EventRequest(this.baseUrl, this.getAccountId(), this.okClient, fields);
    }

    public ApplyDecisionRequest buildRequest(ApplyDecisionFieldSet fields) {
        this.setupApiKey(fields);
        return new ApplyDecisionRequest(this.baseUrl, this.getAccountId(), this.okClient, fields);
    }

    public GetDecisionsRequest buildRequest(GetDecisionFieldSet fields) {
        this.setupApiKey(fields);
        return new GetDecisionsRequest(this.baseUrl, this.getAccountId(), this.okClient, fields);
    }

    public DecisionStatusRequest buildRequest(DecisionStatusFieldSet fields) {
        this.setupApiKey(fields);
        return new DecisionStatusRequest(this.baseUrl, this.getAccountId(), this.okClient, fields);
    }

    public LabelRequest buildRequest(LabelFieldSet fields) {
        this.setupApiKey(fields);
        return new LabelRequest(this.baseUrl, this.getAccountId(), this.okClient, fields);
    }

    public UnlabelRequest buildRequest(UnlabelFieldSet fields) {
        this.setupApiKey(fields);
        return new UnlabelRequest(this.baseUrl, this.getAccountId(), this.okClient, fields);
    }

    public ScoreRequest buildRequest(ScoreFieldSet fields) {
        this.setupApiKey(fields);
        return new ScoreRequest(this.baseUrl, this.getAccountId(), this.okClient, fields);
    }

    public UserScoreRequest buildRequest(UserScoreFieldSet fields) {
        this.setupApiKey(fields);
        return new UserScoreRequest(this.baseUrl, this.getAccountId(), this.okClient, fields);
    }

    public WorkflowStatusRequest buildRequest(WorkflowStatusFieldSet fields) {
        this.setupApiKey(fields);
        return new WorkflowStatusRequest(this.baseUrl, this.getAccountId(), this.okClient, fields);
    }

    private void setupApiKey(FieldSet fields) {
        fields.setApiKey(this.getApiKey());
    }
}

