/*
 * Decompiled with CFR 0.152.
 */
package com.sigpwned.chardet4j;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;

public enum ByteOrderMark {
    UTF_8(new byte[]{-17, -69, -65}, StandardCharsets.UTF_8),
    UTF_16BE(new byte[]{-2, -1}, StandardCharsets.UTF_16BE),
    UTF_16LE(new byte[]{-1, -2}, StandardCharsets.UTF_16LE);

    public static final int MAX_BYTE_LENGTH;
    private final byte[] bytes;
    private final Charset charset;

    public static Optional<ByteOrderMark> detect(byte[] data) {
        for (ByteOrderMark value : ByteOrderMark.values()) {
            byte[] bom = value.getBytes();
            int bomlength = value.getBytes().length;
            if (bomlength > data.length || !ByteOrderMark.equals(data, 0, bomlength, bom, 0, bomlength)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public static Optional<ByteOrderMark> detect(byte[] data, int datalen) {
        for (ByteOrderMark value : ByteOrderMark.values()) {
            byte[] bom = value.getBytes();
            int bomlen = value.getBytes().length;
            if (bomlen > datalen || !ByteOrderMark.equals(data, 0, bomlen, bom, 0, bomlen)) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static void rangeCheck(int arrayLength, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLength) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    private static boolean equals(byte[] a, int aFromIndex, int aToIndex, byte[] b, int bFromIndex, int bToIndex) {
        ByteOrderMark.rangeCheck(a.length, aFromIndex, aToIndex);
        ByteOrderMark.rangeCheck(b.length, bFromIndex, bToIndex);
        int aLength = aToIndex - aFromIndex;
        int bLength = bToIndex - bFromIndex;
        if (aLength != bLength) {
            return false;
        }
        int length = aLength;
        for (int i = 0; i < length; ++i) {
            if (a[aFromIndex + i] == b[bFromIndex + i]) continue;
            return false;
        }
        return true;
    }

    private ByteOrderMark(byte[] bytes, Charset charset) {
        this.bytes = bytes;
        this.charset = charset;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public Charset getCharset() {
        return this.charset;
    }

    static {
        MAX_BYTE_LENGTH = Arrays.stream(ByteOrderMark.values()).mapToInt(bom -> bom.getBytes().length).max().getAsInt();
    }
}

