/*
 * Decompiled with CFR 0.152.
 */
package com.sigpwned.chardet4j;

import com.sigpwned.chardet4j.ByteOrderMark;
import com.sigpwned.chardet4j.com.ibm.icu.text.CharsetDetector;
import com.sigpwned.chardet4j.com.ibm.icu.text.CharsetMatch;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Chardet {
    private static final int MIN_CONFIDENCE = 0;
    private static final int MAX_CONFIDENCE = 100;
    private static final int DECLARED_ENCODING_BUMP = Optional.ofNullable(System.getProperty("chardet4j.detect.bump")).map(Integer::parseInt).orElse(10);
    public static final int DECODE_DETECT_BUFSIZE = Optional.ofNullable(System.getProperty("chardet4j.detect.bufsize")).map(Integer::parseInt).orElse(8192);

    private Chardet() {
    }

    public static Optional<Charset> detectCharset(byte[] data) {
        return Chardet.detectCharset(data, null);
    }

    public static Optional<Charset> detectCharset(byte[] data, String declaredEncoding) {
        Optional<ByteOrderMark> maybeBom = ByteOrderMark.detect(data);
        if (maybeBom.isPresent()) {
            return maybeBom.map(ByteOrderMark::getCharset);
        }
        CharsetDetector chardet = new CharsetDetector();
        chardet.setText(data);
        List matches = Arrays.stream(chardet.detectAll()).map(mi -> {
            String name = mi.getName();
            int confidence = name.equalsIgnoreCase(declaredEncoding) ? Math.min(mi.getConfidence() + DECLARED_ENCODING_BUMP, 100) : mi.getConfidence();
            return ChardetMatch.of(name, confidence);
        }).sorted(Comparator.reverseOrder()).collect(Collectors.toList());
        return matches.isEmpty() ? Optional.empty() : Optional.of(((ChardetMatch)matches.get(0)).getName()).map(Charset::forName);
    }

    public static Optional<Charset> detectCharset(byte[] data, int datalen, String declaredEncoding) {
        Optional<ByteOrderMark> maybeBom = ByteOrderMark.detect(data, datalen);
        if (maybeBom.isPresent()) {
            return maybeBom.map(ByteOrderMark::getCharset);
        }
        CharsetDetector chardet = new CharsetDetector();
        if (datalen == data.length) {
            chardet.setText(data);
        } else {
            try {
                chardet.setText(new ByteArrayInputStream(data, 0, datalen));
            }
            catch (IOException e) {
                throw new UncheckedIOException("unexpected exception when reading from byte array", e);
            }
        }
        if (declaredEncoding != null) {
            chardet.setDeclaredEncoding(declaredEncoding);
        }
        CharsetMatch match = chardet.detect();
        return Optional.ofNullable(match).map(m -> Charset.forName(m.getName()));
    }

    public static InputStreamReader decode(InputStream input, Charset defaultCharset) throws IOException {
        return Chardet.decode(input, null, defaultCharset);
    }

    public static InputStreamReader decode(InputStream input, String declaredEncoding, Charset defaultCharset) throws IOException {
        int buflen = 0;
        byte[] buf = new byte[DECODE_DETECT_BUFSIZE];
        int nread = input.read(buf, buflen, buf.length - buflen);
        while (nread != -1 && (buflen += nread) != buf.length) {
            nread = input.read(buf, buflen, buf.length - buflen);
        }
        Charset charset = Chardet.detectCharset(buf, buflen, declaredEncoding).orElse(defaultCharset);
        Optional<ByteOrderMark> maybeBom = ByteOrderMark.detect(buf, buflen);
        int offset = maybeBom.isPresent() ? maybeBom.map(bom -> bom.getBytes().length).get() : 0;
        return new InputStreamReader((InputStream)new SequenceInputStream(new ByteArrayInputStream(buf, offset, buflen - offset), input), charset);
    }

    public static String decode(byte[] data, String declaredEncoding, Charset defaultCharset) {
        return Chardet.decode(data, data.length, declaredEncoding, defaultCharset);
    }

    public static String decode(byte[] data, int datalen, String declaredEncoding, Charset defaultCharset) {
        Charset charset = Chardet.detectCharset(data, datalen, declaredEncoding).orElse(defaultCharset);
        Optional<ByteOrderMark> maybeBom = ByteOrderMark.detect(data, datalen);
        int offset = maybeBom.isPresent() ? maybeBom.map(bom -> bom.getBytes().length).get() : 0;
        return new String(data, offset, datalen - offset, charset);
    }

    private static class ChardetMatch
    implements Comparable<ChardetMatch> {
        private final String name;
        private final int confidence;

        public static ChardetMatch of(String name, int confidence) {
            return new ChardetMatch(name, confidence);
        }

        public ChardetMatch(String name, int confidence) {
            if (name == null) {
                throw new NullPointerException();
            }
            if (confidence < 0 || confidence > 100) {
                throw new IllegalArgumentException("confidence out of range " + confidence);
            }
            this.name = name;
            this.confidence = confidence;
        }

        public String getName() {
            return this.name;
        }

        public int getConfidence() {
            return this.confidence;
        }

        public int hashCode() {
            return Objects.hash(this.confidence, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChardetMatch other = (ChardetMatch)obj;
            return this.confidence == other.confidence && Objects.equals(this.name, other.name);
        }

        public String toString() {
            return "PossibleMatch [name=" + this.name + ", confidence=" + this.confidence + "]";
        }

        @Override
        public int compareTo(ChardetMatch o) {
            return this.getConfidence() - o.getConfidence();
        }
    }
}

