/*
 * Decompiled with CFR 0.152.
 */
package com.sigpwned.maven.jacoco;

import com.sigpwned.maven.jacoco.Coverage;
import com.sigpwned.maven.jacoco.Metric;
import com.sigpwned.maven.jacoco.util.Coverages;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="badge", defaultPhase=LifecyclePhase.VERIFY)
public class BadgeMojo
extends AbstractMojo {
    @Parameter(defaultValue="instruction", property="metric", required=false)
    private Metric metric;
    @Parameter(defaultValue="70", property="passing", required=false)
    private int passing;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/jacoco-aggregate/jacoco.csv", property="reportFile", required=false)
    private File reportFile;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/jacoco-aggregate/jacoco.svg", property="outputFile", required=false)
    private File badgeFile;
    private static final String PASSING_COLOR = "rgb(55,179,17)";
    private static final String FAILING_COLOR = "rgb(192,64,49)";
    private static final String INFO_COLOR = "rgb(18,80,172)";

    public void execute() throws MojoExecutionException {
        String template;
        Coverage coverage;
        File reportFile;
        File badgeFile = this.badgeFile;
        if (!badgeFile.getParentFile().exists()) {
            badgeFile.getParentFile().mkdirs();
        }
        if (!(reportFile = this.reportFile).getParentFile().exists()) {
            reportFile.getParentFile().mkdirs();
        }
        if (this.passing < 0 || this.passing > 100) {
            throw new MojoExecutionException((Object)this.passing, "Invalid passing score: " + this.passing, "Passing score must be from 0-100: " + this.passing);
        }
        try {
            coverage = Coverages.report(reportFile, this.metric);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to read coverage", (Exception)e);
        }
        int percent = (int)(100.0 * coverage.getPercent());
        boolean passed = percent >= this.passing;
        try (InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("template.svg");){
            template = new String(BadgeMojo.read(in), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to load badge template", (Exception)e);
        }
        String badge = template;
        badge = badge.replace("{{message}}", Integer.toString(percent) + "%");
        badge = badge.replace("{{color}}", passed ? PASSING_COLOR : FAILING_COLOR);
        try (FileOutputStream out = new FileOutputStream(badgeFile);){
            ((OutputStream)out).write(badge.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write badge", (Exception)e);
        }
        this.getLog().info((CharSequence)("jacoco coverage=" + percent + " pass=" + this.passing));
    }

    private static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        int nread = in.read(buf);
        while (nread != -1) {
            result.write(buf, 0, nread);
            nread = in.read(buf);
        }
        return result.toByteArray();
    }
}

