/*
 * Decompiled with CFR 0.152.
 */
package com.sigpwned.maven.jacoco;

import com.sigpwned.maven.jacoco.Coverage;
import com.sigpwned.maven.jacoco.Metric;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

public class CoverageReport
implements AutoCloseable {
    public static final List<String> HEADERS = Arrays.asList("GROUP", "PACKAGE", "CLASS", "INSTRUCTION_MISSED", "INSTRUCTION_COVERED", "BRANCH_MISSED", "BRANCH_COVERED", "LINE_MISSED", "LINE_COVERED", "COMPLEXITY_MISSED", "COMPLEXITY_COVERED", "METHOD_MISSED", "METHOD_COVERED");
    private final BufferedReader lines;

    public CoverageReport(Reader r) throws IOException {
        this(new BufferedReader(r));
    }

    public CoverageReport(BufferedReader lines) throws IOException {
        this.lines = lines;
        String line = lines.readLine();
        if (line == null) {
            throw new EOFException();
        }
        List<String> headers = Arrays.asList(line.trim().split(","));
        if (!this.getHeaders().equals(HEADERS)) {
            throw new IOException("unexpected headers; expected=" + HEADERS + ", found=" + headers);
        }
    }

    public Row next() throws IOException {
        String line = this.getLines().readLine();
        Row result = line != null ? Row.fromStrings(Arrays.asList(line.split(","))) : null;
        return result;
    }

    @Override
    public void close() throws IOException {
        this.getLines().close();
    }

    private BufferedReader getLines() {
        return this.lines;
    }

    private List<String> getHeaders() {
        return HEADERS;
    }

    public static class Row {
        private final String grp;
        private final String pkg;
        private final String cls;
        private final Map<Metric, Coverage> coverages;

        public static Row fromStrings(List<String> fields) {
            String grp = fields.get(HEADERS.indexOf("GROUP"));
            String pkg = fields.get(HEADERS.indexOf("PACKAGE"));
            String cls = fields.get(HEADERS.indexOf("CLASS"));
            EnumMap<Metric, Coverage> coverages = new EnumMap<Metric, Coverage>(Metric.class);
            for (Metric metric : Metric.values()) {
                coverages.put(metric, new Coverage(Long.parseLong(fields.get(HEADERS.indexOf(metric.name().toUpperCase() + "_COVERED"))), Long.parseLong(fields.get(HEADERS.indexOf(metric.name().toUpperCase() + "_MISSED")))));
            }
            return new Row(grp, pkg, cls, coverages);
        }

        public Row(String grp, String pkg, String cls, Map<Metric, Coverage> coverages) {
            this.grp = grp;
            this.pkg = pkg;
            this.cls = cls;
            this.coverages = Collections.unmodifiableMap(coverages);
        }

        public String getGroup() {
            return this.grp;
        }

        public String getPackage() {
            return this.pkg;
        }

        public String getKlass() {
            return this.cls;
        }

        public Coverage getCoverage(Metric metric) {
            return this.getCoverages().get((Object)metric);
        }

        private Map<Metric, Coverage> getCoverages() {
            return this.coverages;
        }

        public List<String> toStrings() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.getGroup());
            result.add(this.getPackage());
            result.add(this.getKlass());
            for (Coverage coverage : this.getCoverages().values()) {
                result.add(Long.toString(coverage.getMissed()));
                result.add(Long.toString(coverage.getCovered()));
            }
            return Collections.unmodifiableList(result);
        }
    }
}

