/*
 * Decompiled with CFR 0.152.
 */
package com.siirush.annoscan;

import com.siirush.annoscan.AnnoScan;
import com.siirush.annoscan.AnnotatedProperty;
import com.siirush.annoscan.PropertyAccessor;
import com.siirush.annoscan.reflection.GetterLocator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.inject.Inject;
import javax.inject.Singleton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class AnnoScanImpl
implements AnnoScan {
    private final GetterLocator getterLocator;

    @Inject
    public AnnoScanImpl(GetterLocator getterLocatorImpl) {
        this.getterLocator = getterLocatorImpl;
    }

    @Override
    public <T extends Annotation> Set<AnnotatedProperty<T>> getAnnotatedProperties(Class<?> classToScan, Class<T> annotationToFind) {
        HashSet<AnnotatedProperty<T>> properties = new HashSet<AnnotatedProperty<T>>();
        this.populateAnnotatedProperties(classToScan, annotationToFind, properties);
        return properties;
    }

    @Override
    public <T extends Annotation> SortedSet<AnnotatedProperty<T>> getAnnotatedPropertiesSorted(Class<?> classToScan, Class<T> annotationToFind, Comparator<AnnotatedProperty<T>> comparator) {
        TreeSet<AnnotatedProperty<T>> properties = new TreeSet<AnnotatedProperty<T>>(comparator);
        this.populateAnnotatedProperties(classToScan, annotationToFind, properties);
        return properties;
    }

    private <T extends Annotation> void populateAnnotatedProperties(Class<?> classToScan, Class<T> annotationToFind, Set<AnnotatedProperty<T>> properties) {
        properties.addAll(this.findAnnotatedFields(classToScan, annotationToFind));
        properties.addAll(this.findAnnotatedMethods(classToScan, annotationToFind));
    }

    private <T extends Annotation> Set<AnnotatedProperty<T>> findAnnotatedFields(Class<?> classToScan, Class<T> annotationToFind) {
        HashSet<AnnotatedProperty<T>> annotatedFields = new HashSet<AnnotatedProperty<T>>();
        Field[] fields = classToScan.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.isAnnotationPresent(annotationToFind)) continue;
            T annotation = field.getAnnotation(annotationToFind);
            PropertyAccessor propertyAccessor = this.createPropertyAccessor(field);
            annotatedFields.add(new AnnotatedProperty<T>(annotation, propertyAccessor));
        }
        return annotatedFields;
    }

    private PropertyAccessor createPropertyAccessor(Field field) {
        PropertyAccessor propertyAccessor = Modifier.isPublic(field.getModifiers()) ? new PropertyAccessor(field) : this.createPropertyAccessorForGetter(field);
        return propertyAccessor;
    }

    private PropertyAccessor createPropertyAccessorForGetter(Field field) {
        Method method = this.getterLocator.findGetterMethod(field);
        PropertyAccessor propertyAccessor = method == null ? null : new PropertyAccessor(method);
        return propertyAccessor;
    }

    private <T extends Annotation> Set<AnnotatedProperty<T>> findAnnotatedMethods(Class<?> classToScan, Class<T> annotationToFind) {
        HashSet<AnnotatedProperty<T>> annotatedMethods = new HashSet<AnnotatedProperty<T>>();
        Method[] methods = classToScan.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.isAnnotationPresent(annotationToFind)) continue;
            T annotation = method.getAnnotation(annotationToFind);
            PropertyAccessor propertyAccessor = new PropertyAccessor(method);
            annotatedMethods.add(new AnnotatedProperty<T>(annotation, propertyAccessor));
        }
        return annotatedMethods;
    }
}

