/*
 * Decompiled with CFR 0.152.
 */
package com.siirush.annoscan;

import com.siirush.annoscan.exception.PropertyAccessException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropertyAccessor {
    final Method method;
    final Field field;
    final PropertyAccessType propertyAccessType;

    public PropertyAccessor(Method method) {
        this.propertyAccessType = PropertyAccessType.METHOD;
        this.method = method;
        this.field = null;
    }

    public PropertyAccessor(Field field) {
        this.propertyAccessType = PropertyAccessType.FIELD;
        this.field = field;
        this.method = null;
    }

    public Object getValue(Object target) {
        Exception thrown;
        try {
            return this.getValueFromUnderlyingObject(target);
        }
        catch (IllegalArgumentException e) {
            thrown = e;
        }
        catch (IllegalAccessException e) {
            thrown = e;
        }
        catch (InvocationTargetException e) {
            thrown = e;
        }
        throw new PropertyAccessException(thrown);
    }

    public Method getMethod() {
        return this.method;
    }

    public Field getField() {
        return this.field;
    }

    public PropertyAccessType getPropertyAccessType() {
        return this.propertyAccessType;
    }

    private Object getValueFromUnderlyingObject(Object target) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object value = this.propertyAccessType.equals((Object)PropertyAccessType.FIELD) ? this.field.get(target) : this.method.invoke(target, new Object[0]);
        return value;
    }

    public int hashCode() {
        int hashCode = this.propertyAccessType.hashCode();
        hashCode = this.propertyAccessType.equals((Object)PropertyAccessType.FIELD) ? (hashCode += this.field.hashCode()) : (hashCode += this.method.hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (obj instanceof PropertyAccessor) {
            PropertyAccessor other = (PropertyAccessor)obj;
            equals = this.equals(other);
        } else {
            equals = false;
        }
        return equals;
    }

    private boolean equals(PropertyAccessor other) {
        boolean equals = !this.propertyAccessType.equals((Object)other.propertyAccessType) ? false : (this.propertyAccessType.equals((Object)PropertyAccessType.FIELD) ? this.field.equals(other.field) : this.method.equals(other.method));
        return equals;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PropertyAccessType {
        METHOD,
        FIELD;

    }
}

