/*
 * Decompiled with CFR 0.152.
 */
package com.sikulix.vnc;

import com.tigervnc.rfb.PixelBuffer;
import com.tigervnc.rfb.PixelFormat;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.nio.ByteOrder;

class VNCFrameBuffer
extends PixelBuffer {
    private final Object imageLock = new Object();
    private BufferedImage image;
    private DataBuffer db;
    private PixelFormat pixelFormat = null;
    private ColorModel colorModel = null;

    public DataBuffer getDB() {
        return this.db;
    }

    public VNCFrameBuffer(int width, int height, PixelFormat serverPF) {
        PixelFormat nativePF = this.getNativePF();
        this.pixelFormat = nativePF.depth > serverPF.depth ? serverPF : nativePF;
        this.setPF(this.pixelFormat);
        this.colorModel = this.cm;
        this.resize(width, height);
    }

    public void resize(int width, int height) {
        if (width != this.width() || height != this.height()) {
            this.width_ = width;
            this.height_ = height;
            this.createImage(width, height);
        }
    }

    private PixelFormat getNativePF() {
        return new PixelFormat(32, 24, ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN, true, 255, 255, 255, 16, 8, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImage(int width, int height) {
        Object object = this.imageLock;
        synchronized (object) {
            if (width != 0 && height != 0) {
                WritableRaster raster = this.colorModel.createCompatibleWritableRaster(width, height);
                this.image = new BufferedImage(this.colorModel, raster, false, null);
                this.db = raster.getDataBuffer();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fillRect(int x, int y, int w, int h, int pixelValue) {
        Object object = this.imageLock;
        synchronized (object) {
            Graphics2D g2d = this.image.createGraphics();
            switch (this.format.depth) {
                case 24: {
                    g2d.setColor(new Color(pixelValue));
                    g2d.fillRect(x, y, w, h);
                    break;
                }
                default: {
                    g2d.setColor(new Color(0xFF000000 | this.colorModel.getRed(pixelValue) << 16 | this.colorModel.getGreen(pixelValue) << 8 | this.colorModel.getBlue(pixelValue)));
                    g2d.fillRect(x, y, w, h);
                }
            }
            g2d.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void imageRect(int x, int y, int w, int h, Object p) {
        if (p instanceof Image) {
            Image img = (Image)p;
            Object object = this.imageLock;
            synchronized (object) {
                Graphics2D g2d = this.image.createGraphics();
                g2d.drawImage(img, x, y, w, h, null);
                g2d.dispose();
            }
            img.flush();
        } else {
            Object object = this.imageLock;
            synchronized (object) {
                SampleModel sampleModel = this.image.getSampleModel();
                if (sampleModel.getTransferType() == 0) {
                    byte[] byteData = new byte[((int[])p).length];
                    for (int i = 0; i < byteData.length; ++i) {
                        byteData[i] = (byte)((int[])p)[i];
                    }
                    p = byteData;
                }
                sampleModel.setDataElements(x, y, w, h, p, this.db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyRect(int dx, int dy, int w, int h, int sx, int sy) {
        Object object = this.imageLock;
        synchronized (object) {
            Graphics2D g2d = this.image.createGraphics();
            g2d.copyArea(sx, sy, w, h, dx - sx, dy - sy);
            g2d.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage(int x, int y, int w, int h) {
        BufferedImage i;
        Object object = this.imageLock;
        synchronized (object) {
            i = new BufferedImage(this.image.getColorModel(), this.image.getColorModel().createCompatibleWritableRaster(w, h), false, null);
            Graphics2D g2d = i.createGraphics();
            g2d.drawImage(this.image, 0, 0, w, h, x, y, x + w, y + h, null);
            g2d.dispose();
        }
        return i;
    }
}

