/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.network.FileDescriptor;
import com.tigervnc.rdr.Exception;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public class SocketDescriptor
implements FileDescriptor {
    protected SocketChannel channel;
    protected Selector writeSelector;
    protected Selector readSelector;

    public SocketDescriptor() throws Exception {
        SocketDescriptor.DefaultSelectorProvider();
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.writeSelector = Selector.open();
            this.readSelector = Selector.open();
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        try {
            this.channel.register(this.writeSelector, 4);
            this.channel.register(this.readSelector, 1);
        }
        catch (ClosedChannelException e) {
            throw new Exception(e.getMessage());
        }
    }

    public void shutdown() throws IOException {
        try {
            this.channel.socket().shutdownInput();
            this.channel.socket().shutdownOutput();
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        catch (IOException e) {
            throw new IOException(e.getMessage());
        }
    }

    private static SelectorProvider DefaultSelectorProvider() {
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac OS X")) {
            System.setProperty("java.nio.channels.spi.SelectorProvider", "sun.nio.ch.PollSelectorProvider");
        }
        return SelectorProvider.provider();
    }

    @Override
    public synchronized int read(byte[] buf, int bufPtr, int length) throws Exception {
        int n;
        ByteBuffer b = ByteBuffer.allocate(length);
        try {
            n = this.channel.read(b);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        if (n <= 0) {
            return n == 0 ? -1 : 0;
        }
        b.flip();
        b.get(buf, bufPtr, n);
        b.clear();
        return n;
    }

    @Override
    public synchronized int write(byte[] buf, int bufPtr, int length) throws Exception {
        int n;
        ByteBuffer b = ByteBuffer.allocate(length);
        b.put(buf, bufPtr, length);
        b.flip();
        try {
            n = this.channel.write(b);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        b.clear();
        return n;
    }

    @Override
    public synchronized int select(int interestOps, Integer timeout) throws Exception {
        int n;
        Selector selector = (interestOps & 1) != 0 ? this.readSelector : this.writeSelector;
        selector.selectedKeys().clear();
        try {
            if (timeout == null) {
                n = selector.select();
            } else {
                int tv = timeout;
                switch (tv) {
                    case 0: {
                        n = selector.selectNow();
                        break;
                    }
                    default: {
                        n = selector.select(tv);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        return n;
    }

    public int write(ByteBuffer buf) throws Exception {
        int n = 0;
        try {
            n = this.channel.write(buf);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        return n;
    }

    public long write(ByteBuffer[] buf, int offset, int length) throws IOException {
        long n = 0L;
        try {
            n = this.channel.write(buf, offset, length);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        return n;
    }

    public int read(ByteBuffer buf) throws IOException {
        int n = 0;
        try {
            n = this.channel.read(buf);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        return n;
    }

    public long read(ByteBuffer[] buf, int offset, int length) throws IOException {
        long n = 0L;
        try {
            n = this.channel.read(buf, offset, length);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        return n;
    }

    public Socket socket() {
        return this.channel.socket();
    }

    public SocketAddress getRemoteAddress() throws IOException {
        if (this.isConnected()) {
            return this.channel.socket().getRemoteSocketAddress();
        }
        return null;
    }

    public SocketAddress getLocalAddress() throws IOException {
        if (this.isConnected()) {
            return this.channel.socket().getLocalSocketAddress();
        }
        return null;
    }

    public boolean isConnectionPending() {
        return this.channel.isConnectionPending();
    }

    public boolean connect(SocketAddress remote) throws IOException {
        return this.channel.connect(remote);
    }

    public boolean finishConnect() throws IOException {
        return this.channel.finishConnect();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    protected void implConfigureBlocking(boolean block) throws IOException {
        this.channel.configureBlocking(block);
    }

    protected synchronized void implCloseSelectableChannel() throws IOException {
        this.channel.close();
        this.notifyAll();
    }

    protected void setChannel(SocketChannel channel_) {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.readSelector != null) {
                this.readSelector.close();
            }
            if (this.writeSelector != null) {
                this.writeSelector.close();
            }
            this.channel = channel_;
            this.channel.configureBlocking(false);
            this.writeSelector = Selector.open();
            this.readSelector = Selector.open();
        }
        catch (IOException e) {
            throw new Exception(e.getMessage());
        }
        try {
            this.channel.register(this.writeSelector, 4);
            this.channel.register(this.readSelector, 1);
        }
        catch (ClosedChannelException e) {
            System.out.println(e.toString());
        }
    }
}

