/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rfb.CMsgHandler;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public abstract class CMsgReader {
    public int imageBufIdealSize = 0;
    protected CMsgHandler handler;
    protected InStream is;
    protected Decoder[] decoders;
    protected int[] imageBuf;
    protected int imageBufSize;
    static LogWriter vlog = new LogWriter("CMsgReader");

    protected CMsgReader(CMsgHandler handler_, InStream is_) {
        this.handler = handler_;
        this.is = is_;
        this.imageBuf = null;
        this.imageBufSize = 0;
        this.decoders = new Decoder[256];
    }

    protected void readSetColourMapEntries() {
        this.is.skip(1);
        int firstColour = this.is.readU16();
        int nColours = this.is.readU16();
        int[] rgbs = new int[nColours * 3];
        for (int i = 0; i < nColours * 3; ++i) {
            rgbs[i] = this.is.readU16();
        }
        this.handler.setColourMapEntries(firstColour, nColours, rgbs);
    }

    protected void readBell() {
        this.handler.bell();
    }

    protected void readServerCutText() {
        this.is.skip(3);
        int len = this.is.readU32();
        if (len > 262144) {
            this.is.skip(len);
            vlog.error("cut text too long (" + len + " bytes) - ignoring");
            return;
        }
        byte[] buf = new byte[len];
        this.is.readBytes(buf, 0, len);
        Charset latin1 = Charset.forName("ISO-8859-1");
        CharBuffer chars = latin1.decode(ByteBuffer.wrap(buf));
        this.handler.serverCutText(chars.toString(), len);
    }

    protected void readFramebufferUpdateStart() {
        this.handler.framebufferUpdateStart();
    }

    protected void readFramebufferUpdateEnd() {
        this.handler.framebufferUpdateEnd();
    }

    protected void readRect(Rect r, int encoding) {
        if (r.br.x > this.handler.cp.width || r.br.y > this.handler.cp.height) {
            vlog.error("Rect too big: " + r.width() + "x" + r.height() + " at " + r.tl.x + "," + r.tl.y + " exceeds " + this.handler.cp.width + "x" + this.handler.cp.height);
            throw new Exception("Rect too big");
        }
        if (r.is_empty()) {
            vlog.error("Ignoring zero size rect");
        }
        this.handler.beginRect(r, encoding);
        if (encoding == 1) {
            this.readCopyRect(r);
        } else {
            if (this.decoders[encoding] == null) {
                this.decoders[encoding] = Decoder.createDecoder(encoding, this);
                if (this.decoders[encoding] == null) {
                    vlog.error("Unknown rect encoding " + encoding);
                    throw new Exception("Unknown rect encoding");
                }
            }
            this.decoders[encoding].readRect(r, this.handler);
        }
        this.handler.endRect(r, encoding);
    }

    protected void readCopyRect(Rect r) {
        int srcX = this.is.readU16();
        int srcY = this.is.readU16();
        this.handler.copyRect(r, srcX, srcY);
    }

    protected void readSetCursor(int width, int height, Point hotspot) {
        int data_len = width * height;
        int mask_len = (width + 7) / 8 * height;
        int[] data = new int[data_len];
        byte[] mask = new byte[mask_len];
        this.is.readPixels(data, data_len, this.handler.cp.pf().bpp / 8, this.handler.cp.pf().bigEndian);
        this.is.readBytes(mask, 0, mask_len);
        this.handler.setCursor(width, height, hotspot, data, mask);
    }

    public int[] getImageBuf(int required) {
        return this.getImageBuf(required, 0, 0);
    }

    public int[] getImageBuf(int required, int requested, int nPixels) {
        int requiredBytes = required;
        int requestedBytes = requested;
        int size = requestedBytes;
        if (size > this.imageBufIdealSize) {
            size = this.imageBufIdealSize;
        }
        if (size < requiredBytes) {
            size = requiredBytes;
        }
        if (this.imageBufSize < size) {
            this.imageBufSize = size;
            this.imageBuf = new int[this.imageBufSize];
        }
        if (nPixels != 0) {
            nPixels = this.imageBufSize / (this.handler.cp.pf().bpp / 8);
        }
        return this.imageBuf;
    }

    public final int bpp() {
        return this.handler.cp.pf().bpp;
    }

    public abstract void readServerInit();

    public abstract void readMsg();

    public InStream getInStream() {
        return this.is;
    }
}

