/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rfb.CMsgHandler;
import com.tigervnc.rfb.CMsgReader;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Point;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.Screen;
import com.tigervnc.rfb.ScreenSet;

public class CMsgReaderV3
extends CMsgReader {
    int nUpdateRectsLeft = 0;
    static LogWriter vlog = new LogWriter("CMsgReaderV3");

    public CMsgReaderV3(CMsgHandler handler_, InStream is_) {
        super(handler_, is_);
    }

    @Override
    public void readServerInit() {
        int width = this.is.readU16();
        int height = this.is.readU16();
        this.handler.setDesktopSize(width, height);
        PixelFormat pf = new PixelFormat();
        pf.read(this.is);
        this.handler.setPixelFormat(pf);
        String name = this.is.readString();
        this.handler.setName(name);
        this.handler.serverInit();
    }

    @Override
    public void readMsg() {
        if (this.nUpdateRectsLeft == 0) {
            int type = this.is.readU8();
            switch (type) {
                case 0: {
                    this.readFramebufferUpdate();
                    break;
                }
                case 1: {
                    this.readSetColourMapEntries();
                    break;
                }
                case 2: {
                    this.readBell();
                    break;
                }
                case 3: {
                    this.readServerCutText();
                    break;
                }
                case 248: {
                    this.readFence();
                    break;
                }
                case 150: {
                    this.readEndOfContinuousUpdates();
                    break;
                }
                default: {
                    vlog.error("unknown message type " + type);
                    throw new Exception("unknown message type");
                }
            }
        } else {
            int x = this.is.readU16();
            int y = this.is.readU16();
            int w = this.is.readU16();
            int h = this.is.readU16();
            int encoding = this.is.readS32();
            switch (encoding) {
                case -223: {
                    this.handler.setDesktopSize(w, h);
                    break;
                }
                case -308: {
                    this.readExtendedDesktopSize(x, y, w, h);
                    break;
                }
                case -307: {
                    this.readSetDesktopName(x, y, w, h);
                    break;
                }
                case -239: {
                    this.readSetCursor(w, h, new Point(x, y));
                    break;
                }
                case -224: {
                    this.nUpdateRectsLeft = 1;
                    break;
                }
                case -311: {
                    this.readClientRedirect(x, y, w, h);
                    break;
                }
                default: {
                    this.readRect(new Rect(x, y, x + w, y + h), encoding);
                }
            }
            --this.nUpdateRectsLeft;
            if (this.nUpdateRectsLeft == 0) {
                this.handler.framebufferUpdateEnd();
            }
        }
    }

    void readFramebufferUpdate() {
        this.is.skip(1);
        this.nUpdateRectsLeft = this.is.readU16();
        this.handler.framebufferUpdateStart();
    }

    void readSetDesktopName(int x, int y, int w, int h) {
        String name = this.is.readString();
        if (x != 0 || y != 0 || w != 0 || h != 0) {
            vlog.error("Ignoring DesktopName rect with non-zero position/size");
        } else {
            this.handler.setName(name);
        }
    }

    void readExtendedDesktopSize(int x, int y, int w, int h) {
        ScreenSet layout = new ScreenSet();
        int screens = this.is.readU8();
        this.is.skip(3);
        for (int i = 0; i < screens; ++i) {
            int id = this.is.readU32();
            int sx = this.is.readU16();
            int sy = this.is.readU16();
            int sw = this.is.readU16();
            int sh = this.is.readU16();
            int flags = this.is.readU32();
            layout.add_screen(new Screen(id, sx, sy, sw, sh, flags));
        }
        this.handler.setExtendedDesktopSize(x, y, w, h, layout);
    }

    void readFence() {
        byte[] data = new byte[64];
        this.is.skip(3);
        int flags = this.is.readU32();
        int len = this.is.readU8();
        if (len > data.length) {
            System.out.println("Ignoring fence with too large payload\n");
            this.is.skip(len);
            return;
        }
        this.is.readBytes(data, 0, len);
        this.handler.fence(flags, len, data);
    }

    void readEndOfContinuousUpdates() {
        this.handler.endOfContinuousUpdates();
    }

    void readClientRedirect(int x, int y, int w, int h) {
        int port = this.is.readU16();
        String host = this.is.readString();
        String x509subject = this.is.readString();
        if (x != 0 || y != 0 || w != 0 || h != 0) {
            vlog.error("Ignoring ClientRedirect rect with non-zero position/size");
        } else {
            this.handler.clientRedirect(port, host, x509subject);
        }
    }
}

