/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.AuthFailureException;
import com.tigervnc.rfb.CConnection;
import com.tigervnc.rfb.CSecurity;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.Security;
import com.tigervnc.rfb.SecurityClient;
import com.tigervnc.rfb.StringParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CSecurityVeNCrypt
extends CSecurity {
    public static StringParameter secTypesStr;
    private CSecurity csecurity;
    SecurityClient security;
    private boolean haveRecvdMajorVersion = false;
    private boolean haveRecvdMinorVersion = false;
    private boolean haveSentVersion = false;
    private boolean haveAgreedVersion = false;
    private boolean haveListOfTypes = false;
    private boolean haveNumberOfTypes = false;
    private boolean haveChosenType = false;
    private int majorVersion = 0;
    private int minorVersion = 0;
    private int chosenType = 19;
    private int nAvailableTypes = 0;
    private int[] availableTypes = null;
    private int iAvailableType = 0;
    static LogWriter vlog;

    public CSecurityVeNCrypt(SecurityClient sec) {
        this.security = sec;
    }

    @Override
    public boolean processMsg(CConnection cc) {
        InStream is = cc.getInStream();
        OutStream os = cc.getOutStream();
        if (!this.haveRecvdMinorVersion) {
            this.minorVersion = is.readU8();
            this.haveRecvdMinorVersion = true;
            return false;
        }
        if (!this.haveRecvdMajorVersion) {
            this.majorVersion = is.readU8();
            this.haveRecvdMajorVersion = true;
        }
        int Version = this.majorVersion << 8 | this.minorVersion;
        if (!this.haveSentVersion) {
            if (Version < 2) {
                this.majorVersion = 0;
                this.minorVersion = 0;
                os.writeU8(this.majorVersion);
                os.writeU8(this.minorVersion);
                os.flush();
                throw new Exception("Server reported an unsupported VeNCrypt version");
            }
            this.majorVersion = 0;
            this.minorVersion = 2;
            os.writeU8(this.majorVersion);
            os.writeU8(this.minorVersion);
            os.flush();
            this.haveSentVersion = true;
            return false;
        }
        if (!this.haveAgreedVersion) {
            if (is.readU8() != 0) {
                throw new Exception("Server reported it could not support the VeNCrypt version");
            }
            this.haveAgreedVersion = true;
            return false;
        }
        if (!this.haveNumberOfTypes) {
            this.nAvailableTypes = is.readU8();
            this.iAvailableType = 0;
            if (this.nAvailableTypes <= 0) {
                throw new Exception("The server reported no VeNCrypt sub-types");
            }
            this.availableTypes = new int[this.nAvailableTypes];
            this.haveNumberOfTypes = true;
            return false;
        }
        if (this.nAvailableTypes > 0) {
            if (!this.haveListOfTypes) {
                if (is.checkNoWait(4)) {
                    this.availableTypes[this.iAvailableType++] = is.readU32();
                    this.haveListOfTypes = this.iAvailableType >= this.nAvailableTypes;
                    vlog.debug("Server offers security type " + Security.secTypeName(this.availableTypes[this.iAvailableType - 1]) + " (" + this.availableTypes[this.iAvailableType - 1] + ")");
                    if (!this.haveListOfTypes) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (!this.haveChosenType) {
                this.chosenType = 0;
                List<Object> secTypes = new ArrayList();
                secTypes = Security.GetEnabledExtSecTypes();
                for (int i = 0; i < this.nAvailableTypes; ++i) {
                    Iterator<Object> j = secTypes.iterator();
                    while (j.hasNext()) {
                        int refType = (Integer)j.next();
                        if (refType != this.availableTypes[i]) continue;
                        this.chosenType = refType;
                        break;
                    }
                    if (this.chosenType != 0) break;
                }
                vlog.debug("Choosing security type " + Security.secTypeName(this.chosenType) + " (" + this.chosenType + ")");
                if (this.chosenType == 0 || this.chosenType == 19) {
                    throw new AuthFailureException("No valid VeNCrypt sub-type");
                }
                this.csecurity = this.security.GetCSecurity(this.chosenType);
                os.writeU32(this.chosenType);
                os.flush();
                this.haveChosenType = true;
            }
        } else {
            throw new AuthFailureException("The server reported 0 VeNCrypt sub-types");
        }
        return this.csecurity.processMsg(cc);
    }

    @Override
    public final int getType() {
        return this.chosenType;
    }

    @Override
    public final String description() {
        return Security.secTypeName(this.chosenType);
    }

    static {
        vlog = new LogWriter("CSecurityVeNCrypt");
    }
}

