/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.ZlibInStream;
import com.tigervnc.rfb.CMsgHandler;
import com.tigervnc.rfb.CMsgReader;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.Exception;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.PixelFormat;
import com.tigervnc.rfb.Rect;
import java.awt.Image;
import java.awt.Toolkit;

public class TightDecoder
extends Decoder {
    static final int TIGHT_MAX_WIDTH = 2048;
    static final int rfbTightExplicitFilter = 4;
    static final int rfbTightFill = 8;
    static final int rfbTightJpeg = 9;
    static final int rfbTightMaxSubencoding = 9;
    static final int rfbTightFilterCopy = 0;
    static final int rfbTightFilterPalette = 1;
    static final int rfbTightFilterGradient = 2;
    static final int rfbTightMinToCompress = 12;
    static final Toolkit tk = Toolkit.getDefaultToolkit();
    private CMsgReader reader;
    private ZlibInStream[] zis;
    private PixelFormat serverpf;
    private PixelFormat clientpf;
    static LogWriter vlog = new LogWriter("TightDecoder");

    public TightDecoder(CMsgReader reader_) {
        this.reader = reader_;
        this.zis = new ZlibInStream[4];
        for (int i = 0; i < 4; ++i) {
            this.zis[i] = new ZlibInStream();
        }
    }

    @Override
    public void readRect(Rect r, CMsgHandler handler) {
        InStream input;
        InStream is = this.reader.getInStream();
        boolean cutZeros = false;
        this.clientpf = handler.getPreferredPF();
        this.serverpf = handler.cp.pf();
        int bpp = this.serverpf.bpp;
        cutZeros = false;
        if (bpp == 32 && this.serverpf.is888()) {
            cutZeros = true;
        }
        int comp_ctl = is.readU8();
        boolean bigEndian = handler.cp.pf().bigEndian;
        for (int i = 0; i < 4; ++i) {
            if ((comp_ctl & 1) != 0) {
                this.zis[i].reset();
            }
            comp_ctl >>= 1;
        }
        if (comp_ctl == 8) {
            int[] pix = new int[1];
            if (cutZeros) {
                byte[] bytebuf = new byte[3];
                is.readBytes(bytebuf, 0, 3);
                this.serverpf.bufferFromRGB(pix, 0, bytebuf, 0, 1);
            } else {
                pix[0] = is.readPixel(this.serverpf.bpp / 8, this.serverpf.bigEndian);
            }
            handler.fillRect(r, pix[0]);
            return;
        }
        if (comp_ctl == 9) {
            this.DECOMPRESS_JPEG_RECT(r, is, handler);
            return;
        }
        if (comp_ctl > 9) {
            throw new Exception("TightDecoder: bad subencoding value received");
        }
        int palSize = 0;
        int[] palette = new int[256];
        boolean useGradient = false;
        if ((comp_ctl & 4) != 0) {
            int filterId = is.readU8();
            switch (filterId) {
                case 1: {
                    palSize = is.readU8() + 1;
                    if (cutZeros) {
                        byte[] tightPalette = new byte[768];
                        is.readBytes(tightPalette, 0, palSize * 3);
                        this.serverpf.bufferFromRGB(palette, 0, tightPalette, 0, palSize);
                        break;
                    }
                    is.readPixels(palette, palSize, this.serverpf.bpp / 8, this.serverpf.bigEndian);
                    break;
                }
                case 2: {
                    useGradient = true;
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    throw new Exception("TightDecoder: unknown filter code recieved");
                }
            }
        }
        int bppp = bpp;
        if (palSize != 0) {
            bppp = palSize <= 2 ? 1 : 8;
        } else if (cutZeros) {
            bppp = 24;
        }
        int rowSize = (r.width() * bppp + 7) / 8;
        int dataSize = r.height() * rowSize;
        int streamId = -1;
        if (dataSize < 12) {
            input = is;
        } else {
            int length = is.readCompactLength();
            streamId = comp_ctl & 3;
            this.zis[streamId].setUnderlying(is, length);
            input = this.zis[streamId];
        }
        byte[] netbuf = new byte[dataSize];
        input.readBytes(netbuf, 0, dataSize);
        int stride = r.width();
        int[] buf = this.reader.getImageBuf(r.area());
        if (palSize == 0) {
            if (useGradient) {
                if (bpp == 32 && cutZeros) {
                    this.FilterGradient24(netbuf, buf, stride, r);
                } else {
                    this.FilterGradient(netbuf, buf, stride, r);
                }
            } else {
                int h;
                int ptr = 0;
                int srcPtr = 0;
                int w = r.width();
                if (cutZeros) {
                    this.serverpf.bufferFromRGB(buf, ptr, netbuf, srcPtr, w * h);
                } else {
                    int pixelSize;
                    int n = pixelSize = bpp >= 24 ? 3 : bpp / 8;
                    for (h = r.height(); h > 0; --h) {
                        for (int i = 0; i < w; ++i) {
                            if (bpp == 8) {
                                buf[ptr + i] = netbuf[srcPtr + i] & 0xFF;
                                continue;
                            }
                            for (int j = pixelSize - 1; j >= 0; --j) {
                                int n2 = ptr + i;
                                buf[n2] = buf[n2] | (netbuf[srcPtr + i + j] & 0xFF) << j * 8;
                            }
                        }
                        ptr += stride;
                        srcPtr += w * pixelSize;
                    }
                }
            }
        } else {
            int h;
            int w = r.width();
            int pad = stride - w;
            int ptr = 0;
            int srcPtr = 0;
            if (palSize <= 2) {
                for (h = r.height(); h > 0; --h) {
                    int b;
                    byte bits;
                    for (int x = 0; x < w / 8; ++x) {
                        bits = netbuf[srcPtr++];
                        for (b = 7; b >= 0; --b) {
                            buf[ptr++] = palette[bits >> b & 1];
                        }
                    }
                    if (w % 8 != 0) {
                        bits = netbuf[srcPtr++];
                        for (b = 7; b >= 8 - w % 8; --b) {
                            buf[ptr++] = palette[bits >> b & 1];
                        }
                    }
                    ptr += pad;
                }
            } else {
                while (h > 0) {
                    int endOfRow = ptr + w;
                    while (ptr < endOfRow) {
                        buf[ptr++] = palette[netbuf[srcPtr++] & 0xFF];
                    }
                    ptr += pad;
                    --h;
                }
            }
        }
        handler.imageRect(r, buf);
        if (streamId != -1) {
            this.zis[streamId].reset();
        }
    }

    private final void DECOMPRESS_JPEG_RECT(Rect r, InStream is, CMsgHandler handler) {
        int compressedLen = is.readCompactLength();
        if (compressedLen <= 0) {
            vlog.info("Incorrect data received from the server.");
        }
        byte[] netbuf = new byte[compressedLen];
        is.readBytes(netbuf, 0, compressedLen);
        Image jpeg = tk.createImage(netbuf);
        jpeg.setAccelerationPriority(1.0f);
        handler.imageRect(r, jpeg);
        jpeg.flush();
    }

    private final void FilterGradient24(byte[] netbuf, int[] buf, int stride, Rect r) {
        byte[] prevRow = new byte[6144];
        byte[] thisRow = new byte[6144];
        byte[] pix = new byte[3];
        int[] est = new int[3];
        int rectHeight = r.height();
        int rectWidth = r.width();
        for (int y = 0; y < rectHeight; ++y) {
            int c;
            for (c = 0; c < 3; ++c) {
                pix[c] = (byte)(netbuf[y * rectWidth * 3 + c] + prevRow[c]);
                thisRow[c] = pix[c];
            }
            this.serverpf.bufferFromRGB(buf, y * stride, pix, 0, 1);
            for (int x = 1; x < rectWidth; ++x) {
                for (c = 0; c < 3; ++c) {
                    est[c] = prevRow[x * 3 + c] + pix[c] - prevRow[(x - 1) * 3 + c];
                    if (est[c] > 255) {
                        est[c] = 255;
                    } else if (est[c] < 0) {
                        est[c] = 0;
                    }
                    pix[c] = (byte)(netbuf[(y * rectWidth + x) * 3 + c] + est[c]);
                    thisRow[x * 3 + c] = pix[c];
                }
                this.serverpf.bufferFromRGB(buf, y * stride + x, pix, 0, 1);
            }
            System.arraycopy(thisRow, 0, prevRow, 0, prevRow.length);
        }
    }

    private final void FilterGradient(byte[] netbuf, int[] buf, int stride, Rect r) {
        byte[] prevRow = new byte[2048];
        byte[] thisRow = new byte[2048];
        byte[] pix = new byte[3];
        int[] est = new int[3];
        int rectHeight = r.height();
        int rectWidth = r.width();
        for (int y = 0; y < rectHeight; ++y) {
            int c;
            for (c = 0; c < 3; ++c) {
                int n = c;
                pix[n] = (byte)(pix[n] + prevRow[c]);
            }
            System.arraycopy(pix, 0, thisRow, 0, pix.length);
            this.serverpf.bufferFromRGB(buf, y * stride, pix, 0, 1);
            for (int x = 1; x < rectWidth; ++x) {
                for (c = 0; c < 3; ++c) {
                    est[c] = prevRow[x * 3 + c] + pix[c] - prevRow[(x - 1) * 3 + c];
                    if (est[c] > 255) {
                        est[c] = 255;
                        continue;
                    }
                    if (est[c] >= 0) continue;
                    est[c] = 0;
                }
                for (c = 0; c < 3; ++c) {
                    int n = c;
                    pix[n] = (byte)(pix[n] + est[c]);
                }
                System.arraycopy(pix, 0, thisRow, x * 3, pix.length);
                this.serverpf.bufferFromRGB(buf, y * stride + x, pix, 0, 1);
            }
            System.arraycopy(thisRow, 0, prevRow, 0, prevRow.length);
        }
    }
}

