/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.vncviewer.Viewport;
import com.tigervnc.vncviewer.VncViewer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.PlainDocument;

class Dialog
extends JDialog
implements ActionListener,
ItemListener,
KeyListener {
    static double HEAVY = 1.0;
    static double LIGHT = 0.0;
    private Window fullScreenWindow;
    protected boolean ret = true;

    public Dialog(boolean modal) {
        this.setIconImage(VncViewer.frameIcon);
        if (modal) {
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        } else {
            this.setModalityType(Dialog.ModalityType.MODELESS);
        }
    }

    public boolean showDialog(Component c) {
        this.initDialog();
        if (c != null) {
            this.setLocationRelativeTo(c);
        } else {
            Dimension dpySize = this.getToolkit().getScreenSize();
            Dimension mySize = this.getSize();
            int x = (dpySize.width - mySize.width) / 2;
            int y = (dpySize.height - mySize.height) / 2;
            this.setLocation(x, y);
        }
        this.fullScreenWindow = Viewport.getFullScreenWindow();
        if (this.fullScreenWindow != null) {
            Viewport.setFullScreenWindow(null);
        }
        if (this.getModalityType() == Dialog.ModalityType.APPLICATION_MODAL) {
            this.setAlwaysOnTop(true);
        }
        this.setVisible(true);
        return this.ret;
    }

    public boolean showDialog() {
        return this.showDialog(null);
    }

    public void endDialog() {
        this.setVisible(false);
        this.setAlwaysOnTop(false);
        this.fullScreenWindow = Viewport.getFullScreenWindow();
        if (this.fullScreenWindow != null) {
            Viewport.setFullScreenWindow(this.fullScreenWindow);
        }
    }

    public void initDialog() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
    }

    protected void addListeners(Container c) {
        for (Component ch : c.getComponents()) {
            if (ch instanceof JCheckBox) {
                ((JCheckBox)ch).addItemListener(this);
                continue;
            }
            if (ch instanceof JRadioButton) {
                ((JRadioButton)ch).addActionListener(this);
                continue;
            }
            if (ch instanceof JButton) {
                ((JButton)ch).addActionListener(this);
                continue;
            }
            if (ch instanceof JComboBox) {
                ((JComboBox)ch).addActionListener(this);
                continue;
            }
            if (ch instanceof JTextField) {
                ((JTextField)ch).addKeyListener(this);
                continue;
            }
            if (!(ch instanceof Container)) continue;
            this.addListeners((Container)ch);
        }
    }

    public int getButtonLabelInset(AbstractButton b) {
        int width = 18;
        int gap = 4;
        Icon ico = b.getIcon();
        if (ico == null) {
            if (b instanceof JCheckBox) {
                ico = (Icon)UIManager.get("CheckBox.icon");
            } else if (b instanceof JRadioButton) {
                ico = (Icon)UIManager.get("RadioButton.icon");
            }
        }
        if (ico != null) {
            width = Math.max(width, ico.getIconWidth());
        }
        if (b != null) {
            gap = Math.max(gap, b.getIconTextGap());
        }
        return width + gap;
    }

    protected class MyJComboBox
    extends JComboBox {
        public MyJComboBox(Object[] items) {
            super(items);
            if (UIManager.getLookAndFeel().getID().equals("Windows")) {
                this.setBorder(BorderFactory.createCompoundBorder(this.getBorder(), BorderFactory.createEmptyBorder(0, 1, 0, 0)));
            } else if (UIManager.getLookAndFeel().getID().equals("Metal")) {
                ComboBoxEditor editor = this.getEditor();
                JTextField jtf = (JTextField)editor.getEditorComponent();
                jtf.setBorder(new CompoundBorder(jtf.getBorder(), new EmptyBorder(0, 2, 0, 0)));
            }
        }

        public MyJComboBox() {
            new MyJComboBox(null);
        }

        public void setPrototypeDisplayValue(Object prototypeDisplayValue) {
            super.setPrototypeDisplayValue(prototypeDisplayValue);
            boolean e = this.isEditable();
            this.setEditable(false);
            Dimension d = this.getPreferredSize();
            this.setPreferredSize(d);
            this.setEditable(e);
        }

        public void setDocument(PlainDocument doc) {
            ComboBoxEditor editor = this.getEditor();
            JTextField jtf = (JTextField)editor.getEditorComponent();
            jtf.setDocument(doc);
        }
    }

    protected class GroupedJRadioButton
    extends JRadioButton {
        public GroupedJRadioButton(String l, ButtonGroup g, JComponent c) {
            super(l);
            c.add(this);
            if (g != null) {
                g.add(this);
            }
        }
    }
}

