/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.vncviewer;

import com.tigervnc.network.Socket;
import com.tigervnc.network.TcpListener;
import com.tigervnc.network.TcpSocket;
import com.tigervnc.rfb.AliasParameter;
import com.tigervnc.rfb.BoolParameter;
import com.tigervnc.rfb.Configuration;
import com.tigervnc.rfb.IntParameter;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.SecurityClient;
import com.tigervnc.rfb.StringParameter;
import com.tigervnc.vncviewer.CConn;
import com.tigervnc.vncviewer.FileUtils;
import com.tigervnc.vncviewer.UserPreferences;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class VncViewer
extends JApplet
implements Runnable,
ActionListener {
    public static final String aboutText = new String("TigerVNC Java Viewer v%s (%s)%nBuilt on %s at %s%nCopyright (C) 1999-2016 TigerVNC Team and many others (see README.txt)%nSee http://www.tigervnc.org for information on TigerVNC.");
    public static String version = null;
    public static String build = null;
    public static String buildDate = null;
    public static String buildTime = null;
    static ImageIcon frameIconSrc = new ImageIcon(VncViewer.class.getResource("tigervnc.ico"));
    public static final Image frameIcon = frameIconSrc.getImage();
    public static final ImageIcon logoIcon = new ImageIcon(VncViewer.class.getResource("tigervnc.png"));
    public static final Image logoImage = logoIcon.getImage();
    public static final InputStream timestamp = VncViewer.class.getResourceAsStream("timestamp");
    public static final String os = System.getProperty("os.name").toLowerCase();
    CConn cc;
    static BoolParameter noLionFS = new BoolParameter("NoLionFS", "On Mac systems, setting this parameter will force the use of the old (pre-Lion) full-screen mode, even if the viewer is running on OS X 10.7 Lion or later.", false);
    BoolParameter embed = new BoolParameter("Embed", "If the viewer is being run as an applet, display its output to an embedded frame in the browser window rather than to a dedicated window. Embed=1 implies FullScreen=0 and Scale=100.", false);
    BoolParameter useLocalCursor = new BoolParameter("UseLocalCursor", "Render the mouse cursor locally", true);
    BoolParameter sendLocalUsername = new BoolParameter("SendLocalUsername", "Send the local username for SecurityTypes such as Plain rather than prompting", true);
    StringParameter passwordFile = new StringParameter("PasswordFile", "Password file for VNC authentication", "");
    AliasParameter passwd = new AliasParameter("passwd", "Alias for PasswordFile", this.passwordFile);
    BoolParameter autoSelect = new BoolParameter("AutoSelect", "Auto select pixel format and encoding", true);
    BoolParameter fullColour = new BoolParameter("FullColour", "Use full colour - otherwise 6-bit colour is used until AutoSelect decides the link is fast enough", true);
    AliasParameter fullColourAlias = new AliasParameter("FullColor", "Alias for FullColour", this.fullColour);
    IntParameter lowColourLevel = new IntParameter("LowColorLevel", "Color level to use on slow connections. 0 = Very Low (8 colors), 1 = Low (64 colors), 2 = Medium (256 colors)", 2);
    AliasParameter lowColourLevelAlias = new AliasParameter("LowColourLevel", "Alias for LowColorLevel", this.lowColourLevel);
    StringParameter preferredEncoding = new StringParameter("PreferredEncoding", "Preferred encoding to use (Tight, ZRLE, hextile or raw) - implies AutoSelect=0", "Tight");
    BoolParameter viewOnly = new BoolParameter("ViewOnly", "Don't send any mouse or keyboard events to the server", false);
    BoolParameter shared = new BoolParameter("Shared", "Don't disconnect other viewers upon connection - share the desktop instead", false);
    BoolParameter fullScreen = new BoolParameter("FullScreen", "Full Screen Mode", false);
    BoolParameter fullScreenAllMonitors = new BoolParameter("FullScreenAllMonitors", "Enable full screen over all monitors", true);
    BoolParameter acceptClipboard = new BoolParameter("AcceptClipboard", "Accept clipboard changes from the server", true);
    BoolParameter sendClipboard = new BoolParameter("SendClipboard", "Send clipboard changes to the server", true);
    static IntParameter maxCutText = new IntParameter("MaxCutText", "Maximum permitted length of an outgoing clipboard update", 262144);
    StringParameter menuKey = new StringParameter("MenuKey", "The key which brings up the popup menu", "F8");
    StringParameter desktopSize = new StringParameter("DesktopSize", "Reconfigure desktop size on the server on connect (if possible)", "");
    BoolParameter listenMode = new BoolParameter("listen", "Listen for connections from VNC servers", false);
    StringParameter scalingFactor = new StringParameter("ScalingFactor", "Reduce or enlarge the remote desktop image. The value is interpreted as a scaling factor in percent. If the parameter is set to \"Auto\", then automatic scaling is performed. Auto-scaling tries to choose a scaling factor in such a way that the whole remote desktop will fit on the local screen. If the parameter is set to \"FixedRatio\", then automatic scaling is performed, but the original aspect ratio is preserved.", "100");
    BoolParameter alwaysShowServerDialog = new BoolParameter("AlwaysShowServerDialog", "Always show the server dialog even if a server has been specified in an applet parameter or on the command line", false);
    StringParameter vncServerName = new StringParameter("Server", "The VNC server <host>[:<dpyNum>] or <host>::<port>", null);
    IntParameter vncServerPort = new IntParameter("Port", "The VNC server's port number, assuming it is on the host from which the applet was downloaded", 0);
    BoolParameter acceptBell = new BoolParameter("AcceptBell", "Produce a system beep when requested to by the server.", true);
    StringParameter via = new StringParameter("Via", "Automatically create an encrypted TCP tunnel to the gateway machine, then connect to the VNC host through that tunnel. By default, this option invokes SSH local port forwarding using the embedded JSch client, however an external SSH client may be specified using the \"-extSSH\" parameter. Note that when using the -via option, the VNC host machine name should be specified from the point of view of the gateway machine, e.g. \"localhost\" denotes the gateway, not the machine on which the viewer was launched. See the System Properties section below for information on configuring the -Via option.", null);
    BoolParameter tunnel = new BoolParameter("Tunnel", "The -Tunnel command is basically a shorthand for the -via command when the VNC server and SSH gateway are one and the same. -Tunnel creates an SSH connection to the server and forwards the VNC through the tunnel without the need to specify anything else.", false);
    BoolParameter extSSH = new BoolParameter("extSSH", "By default, SSH tunneling uses the embedded JSch client for tunnel creation. This option causes the client to invoke an external SSH client application for all tunneling operations. By default, \"/usr/bin/ssh\" is used, however the path to the external application may be specified using the -SSHClient option.", false);
    StringParameter extSSHClient = new StringParameter("extSSHClient", "Specifies the path to an external SSH client application that is to be used for tunneling operations when the -extSSH option is in effect.", "/usr/bin/ssh");
    StringParameter extSSHArgs = new StringParameter("extSSHArgs", "Specifies the arguments string or command template to be used by the external SSH client application when the -extSSH option is in effect. The string will be processed according to the same pattern substitution rules as the VNC_TUNNEL_CMD and VNC_VIA_CMD system properties, and can be used to override those in a more command-line friendly way. If not specified, then the appropriate VNC_TUNNEL_CMD or VNC_VIA_CMD command template will be used.", null);
    StringParameter sshConfig = new StringParameter("SSHConfig", "Specifies the path to an OpenSSH configuration file that to be parsed by the embedded JSch SSH client during tunneling operations.", FileUtils.getHomeDir() + ".ssh/config");
    StringParameter sshKey = new StringParameter("SSHKey", "When using the Via or Tunnel options with the embedded SSH client, this parameter specifies the text of the SSH private key to use when authenticating with the SSH server. You can use \\n within the string to specify a new line.", null);
    StringParameter sshKeyFile = new StringParameter("SSHKeyFile", "When using the Via or Tunnel options with the embedded SSH client, this parameter specifies a file that contains an SSH private key (or keys) to use when authenticating with the SSH server. If not specified, ~/.ssh/id_dsa or ~/.ssh/id_rsa will be used (if they exist). Otherwise, the client will fallback to prompting for an SSH password.", null);
    StringParameter sshKeyPass = new StringParameter("SSHKeyPass", "When using the Via or Tunnel options with the embedded SSH client, this parameter specifies the passphrase for the SSH key.", null);
    BoolParameter customCompressLevel = new BoolParameter("CustomCompressLevel", "Use custom compression level. Default if CompressLevel is specified.", false);
    IntParameter compressLevel = new IntParameter("CompressLevel", "Use specified compression level 0 = Low, 6 = High", 1);
    BoolParameter noJpeg = new BoolParameter("NoJPEG", "Disable lossy JPEG compression in Tight encoding.", false);
    IntParameter qualityLevel = new IntParameter("QualityLevel", "JPEG quality level. 0 = Low, 9 = High", 8);
    StringParameter x509ca = new StringParameter("X509CA", "Path to CA certificate to use when authenticating remote servers using any of the X509 security schemes (X509None, X509Vnc, etc.). Must be in PEM format.", FileUtils.getHomeDir() + ".vnc/x509_ca.pem");
    StringParameter x509crl = new StringParameter("X509CRL", "Path to certificate revocation list to use in conjunction with -X509CA. Must also be in PEM format.", FileUtils.getHomeDir() + ".vnc/x509_crl.pem");
    StringParameter config = new StringParameter("config", "Specifies a configuration file to load.", null);
    Thread thread;
    Socket sock;
    static int nViewers;
    static LogWriter vlog;

    public static void setLookAndFeel() {
        try {
            String laf;
            if (os.startsWith("mac os x")) {
                Class<?> appClass = Class.forName("com.apple.eawt.Application");
                Method getApplication = appClass.getMethod("getApplication", null);
                Object app = getApplication.invoke(appClass, new Object[0]);
                Class[] paramTypes = new Class[]{Image.class};
                Method setDockIconImage = appClass.getMethod("setDockIconImage", paramTypes);
                setDockIconImage.invoke(app, logoImage);
            }
            if ((laf = System.getProperty("swing.defaultlaf")) == null) {
                UIManager.LookAndFeelInfo[] installedLafs = UIManager.getInstalledLookAndFeels();
                for (int i = 0; i < installedLafs.length; ++i) {
                    if (!installedLafs[i].getName().equals("Nimbus")) continue;
                    laf = installedLafs[i].getClassName();
                }
                if (laf == null) {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            UIManager.setLookAndFeel(laf);
            if (UIManager.getLookAndFeel().getName().equals("Metal")) {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                Enumeration keys = UIManager.getDefaults().keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    Object value = UIManager.get(key);
                    if (!(value instanceof FontUIResource)) continue;
                    String name = ((FontUIResource)value).getName();
                    int style = ((FontUIResource)value).getStyle();
                    int size = ((FontUIResource)value).getSize() - 1;
                    FontUIResource f = new FontUIResource(name, style, size);
                    UIManager.put(key, f);
                }
            } else if (UIManager.getLookAndFeel().getName().equals("Nimbus")) {
                Font f = UIManager.getFont("TitledBorder.font");
                String name = f.getName();
                int style = f.getStyle();
                int size = f.getSize() - 2;
                FontUIResource r = new FontUIResource(name, style, size);
                UIManager.put("TitledBorder.font", r);
            }
        }
        catch (Exception e) {
            vlog.info(e.toString());
        }
    }

    public static void main(String[] argv) {
        VncViewer.setLookAndFeel();
        VncViewer viewer = new VncViewer(argv);
        viewer.start();
    }

    public VncViewer(String[] argv) {
        this.embed.setParam(false);
        UserPreferences.load("global");
        SecurityClient.setDefaults();
        this.getTimestamp();
        System.err.format("%n", new Object[0]);
        System.err.format(aboutText, version, build, buildDate, buildTime);
        System.err.format("%n", new Object[0]);
        Configuration.enableViewerParams();
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].length() == 0) continue;
            if (argv[i].equalsIgnoreCase("-config")) {
                if (++i >= argv.length) {
                    VncViewer.usage();
                }
                Configuration.load(argv[i]);
                continue;
            }
            if (argv[i].equalsIgnoreCase("-log")) {
                if (++i >= argv.length) {
                    VncViewer.usage();
                }
                System.err.println("Log setting: " + argv[i]);
                LogWriter.setLogParams(argv[i]);
                continue;
            }
            if (Configuration.setParam(argv[i])) continue;
            if (argv[i].charAt(0) == '-') {
                if (i + 1 < argv.length && Configuration.setParam(argv[i].substring(1), argv[i + 1])) {
                    ++i;
                    continue;
                }
                VncViewer.usage();
            }
            if (this.vncServerName.getValue() != null) {
                VncViewer.usage();
            }
            this.vncServerName.setParam(argv[i]);
        }
        if (!this.autoSelect.hasBeenSet()) {
            this.autoSelect.setParam(!this.preferredEncoding.hasBeenSet() && !this.fullColour.hasBeenSet() && !this.fullColourAlias.hasBeenSet());
        }
        if (!(this.fullColour.hasBeenSet() || this.fullColourAlias.hasBeenSet() || this.autoSelect.getValue() || !this.lowColourLevel.hasBeenSet() && !this.lowColourLevelAlias.hasBeenSet())) {
            this.fullColour.setParam(false);
        }
        if (!this.customCompressLevel.hasBeenSet()) {
            this.customCompressLevel.setParam(this.compressLevel.hasBeenSet());
        }
    }

    public static void usage() {
        String usage = "\nusage: vncviewer [options/parameters] [host:displayNum]\n       vncviewer [options/parameters] -listen [port] [options/parameters]\n\nOptions:\n  -log <level>    configure logging level\n\nParameters can be turned on with -<param> or off with -<param>=0\nParameters which take a value can be specified as -<param> <value>\nOther valid forms are <param>=<value> -<param>=<value> --<param>=<value>\nParameter names are case-insensitive.  The parameters are:\n\n";
        System.err.print(usage);
        Configuration.listParams(79, 14);
        String propertiesString = "\nSystem Properties (adapted from the TurboVNC vncviewer man page)\n  When started with the -via option, vncviewer reads the VNC_VIA_CMD\n  System property, expands patterns beginning with the \"%\" character,\n  and uses the resulting command line to establish the secure tunnel\n  to the VNC gateway.  If VNC_VIA_CMD is not set, this command line\n  defaults to \"/usr/bin/ssh -f -L %L:%H:%R %G sleep 20\".\n\n  The following patterns are recognized in the VNC_VIA_CMD property\n  (note that all of the patterns %G, %H, %L and %R must be present in \n  the command template):\n\n  \t%%     A literal \"%\";\n\n  \t%G     gateway machine name;\n\n  \t%H     remote VNC machine name, (as known to the gateway);\n\n  \t%L     local TCP port number;\n\n  \t%R     remote TCP port number.\n\n  When started with the -tunnel option, vncviewer reads the VNC_TUNNEL_CMD\n  System property, expands patterns beginning with the \"%\" character, and\n  uses the resulting command line to establish the secure tunnel to the\n  VNC server.  If VNC_TUNNEL_CMD is not set, this command line defaults\n  to \"/usr/bin/ssh -f -L %L:localhost:%R %H sleep 20\".\n\n  The following patterns are recognized in the VNC_TUNNEL_CMD property\n  (note that all of the patterns %H, %L and %R must be present in \n  the command template):\n\n  \t%%     A literal \"%\";\n\n  \t%H     remote VNC machine name (as known to the client);\n\n  \t%L     local TCP port number;\n\n  \t%R     remote TCP port number.\n\n";
        System.err.print(propertiesString);
        System.exit(1);
    }

    public VncViewer() {
        UserPreferences.load("global");
        this.embed.setParam(true);
    }

    public static void newViewer(VncViewer oldViewer, Socket sock, boolean close) {
        VncViewer viewer = new VncViewer();
        viewer.embed.setParam(oldViewer.embed.getValue());
        viewer.sock = sock;
        viewer.start();
        if (close) {
            oldViewer.exit(0);
        }
    }

    public static void newViewer(VncViewer oldViewer, Socket sock) {
        VncViewer.newViewer(oldViewer, sock, false);
    }

    public static void newViewer(VncViewer oldViewer) {
        VncViewer.newViewer(oldViewer, null);
    }

    public boolean isAppletDragStart(MouseEvent e) {
        if (e.getID() == 506) {
            if (os.startsWith("mac os x")) {
                return false;
            }
            if (os.startsWith("windows")) {
                return (e.getModifiersEx() & 0x200) != 0;
            }
            return (e.getModifiersEx() & 0x40) != 0;
        }
        return false;
    }

    public void appletDragStarted() {
        this.embed.setParam(false);
        this.cc.recreateViewport();
        JFrame f = (JFrame)JOptionPane.getFrameForComponent(this);
        if (f != null) {
            f.setSize(0, 0);
        }
    }

    public void appletDragFinished() {
        this.cc.setEmbeddedFeatures(true);
        JFrame f = (JFrame)JOptionPane.getFrameForComponent(this);
        if (f != null) {
            f.dispose();
        }
    }

    public void setAppletCloseListener(ActionListener cl) {
        this.cc.setCloseListener(cl);
    }

    public void appletRestored() {
        this.cc.setEmbeddedFeatures(false);
        this.cc.setCloseListener(null);
    }

    @Override
    public void init() {
        vlog.debug("init called");
        Container parent = this.getParent();
        while (!parent.isFocusCycleRoot()) {
            parent = parent.getParent();
        }
        ((Frame)parent).setModalExclusionType(null);
        parent.setFocusable(false);
        parent.setFocusTraversalKeysEnabled(false);
        VncViewer.setLookAndFeel();
        this.setBackground(Color.white);
    }

    private void getTimestamp() {
        if (version == null || build == null) {
            try {
                Manifest manifest = new Manifest(timestamp);
                Attributes attributes = manifest.getMainAttributes();
                version = attributes.getValue("Version");
                build = attributes.getValue("Build");
                buildDate = attributes.getValue("Package-Date");
                buildTime = attributes.getValue("Package-Time");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void start() {
        vlog.debug("start called");
        this.getTimestamp();
        if (this.embed.getValue() && nViewers == 0) {
            this.alwaysShowServerDialog.setParam(false);
            Configuration.global().readAppletParams(this);
            this.fullScreen.setParam(false);
            this.scalingFactor.setParam("100");
            String host = this.getCodeBase().getHost();
            if (this.vncServerName.getValue() == null && this.vncServerPort.getValue() != 0) {
                int port = this.vncServerPort.getValue();
                this.vncServerName.setParam(host + (port >= 5900 && port <= 5999 ? ":" + (port - 5900) : "::" + port));
            }
        }
        ++nViewers;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void exit(int n) {
        if (--nViewers > 0) {
            return;
        }
        if (this.embed.getValue()) {
            this.destroy();
        } else {
            System.exit(n);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.getContentPane().removeAll();
        this.start();
    }

    void reportException(Exception e) {
        String msg = e.getMessage();
        int msgType = 0;
        String title = "TigerVNC Viewer : Error";
        e.printStackTrace();
        if (this.embed.getValue()) {
            this.getContentPane().removeAll();
            JLabel label = new JLabel("<html><center><b>" + title + "</b><p><i>" + msg + "</i></center></html>", 0);
            label.setFont(new Font("Helvetica", 0, 24));
            label.setMaximumSize(new Dimension(this.getSize().width, 100));
            label.setVerticalAlignment(0);
            label.setAlignmentX(0.5f);
            JButton button = new JButton("Reconnect");
            button.addActionListener(this);
            button.setMaximumSize(new Dimension(200, 30));
            button.setAlignmentX(0.5f);
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.add(label);
            this.add(button);
            this.validate();
            this.repaint();
        } else {
            JOptionPane.showMessageDialog(null, msg, title, msgType);
        }
    }

    @Override
    public void run() {
        this.cc = null;
        if (this.listenMode.getValue()) {
            int port = 5500;
            if (this.vncServerName.getValue() != null && Character.isDigit(this.vncServerName.getValue().charAt(0))) {
                port = Integer.parseInt(this.vncServerName.getValue());
            }
            TcpListener listener = null;
            try {
                listener = new TcpListener(null, port);
            }
            catch (Exception e) {
                this.reportException(e);
                this.exit(1);
            }
            vlog.info("Listening on port " + port);
            while (true) {
                TcpSocket new_sock;
                if ((new_sock = listener.accept()) == null) {
                    continue;
                }
                VncViewer.newViewer(this, new_sock, true);
            }
        }
        try {
            this.cc = new CConn(this, this.sock, this.vncServerName.getValue());
            while (!this.cc.shuttingDown) {
                this.cc.processMsg();
            }
            this.exit(0);
        }
        catch (Exception e) {
            if (this.cc == null || !this.cc.shuttingDown) {
                this.reportException(e);
                if (this.cc != null) {
                    this.cc.deleteWindow();
                }
            } else if (this.embed.getValue()) {
                this.reportException(new Exception("Connection closed"));
                this.exit(0);
            }
            this.exit(1);
        }
    }

    static {
        vlog = new LogWriter("VncViewer");
    }
}

