/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.utils.Converters;

public class Algorithm {
    protected final long nativeObj;

    protected Algorithm(long addr) {
        this.nativeObj = addr;
    }

    public boolean getBool(String name) {
        boolean retVal = Algorithm.getBool_0(this.nativeObj, name);
        return retVal;
    }

    public double getDouble(String name) {
        double retVal = Algorithm.getDouble_0(this.nativeObj, name);
        return retVal;
    }

    public int getInt(String name) {
        int retVal = Algorithm.getInt_0(this.nativeObj, name);
        return retVal;
    }

    public Mat getMat(String name) {
        Mat retVal = new Mat(Algorithm.getMat_0(this.nativeObj, name));
        return retVal;
    }

    public List<Mat> getMatVector(String name) {
        ArrayList<Mat> retVal = new ArrayList<Mat>();
        Mat retValMat = new Mat(Algorithm.getMatVector_0(this.nativeObj, name));
        Converters.Mat_to_vector_Mat(retValMat, retVal);
        return retVal;
    }

    public String getString(String name) {
        String retVal = Algorithm.getString_0(this.nativeObj, name);
        return retVal;
    }

    public String paramHelp(String name) {
        String retVal = Algorithm.paramHelp_0(this.nativeObj, name);
        return retVal;
    }

    public int paramType(String name) {
        int retVal = Algorithm.paramType_0(this.nativeObj, name);
        return retVal;
    }

    public void setBool(String name, boolean value) {
        Algorithm.setBool_0(this.nativeObj, name, value);
    }

    public void setDouble(String name, double value) {
        Algorithm.setDouble_0(this.nativeObj, name, value);
    }

    public void setInt(String name, int value) {
        Algorithm.setInt_0(this.nativeObj, name, value);
    }

    public void setMat(String name, Mat value) {
        Algorithm.setMat_0(this.nativeObj, name, value.nativeObj);
    }

    public void setMatVector(String name, List<Mat> value) {
        Mat value_mat = Converters.vector_Mat_to_Mat(value);
        Algorithm.setMatVector_0(this.nativeObj, name, value_mat.nativeObj);
    }

    public void setString(String name, String value) {
        Algorithm.setString_0(this.nativeObj, name, value);
    }

    protected void finalize() throws Throwable {
        Algorithm.delete(this.nativeObj);
    }

    private static native boolean getBool_0(long var0, String var2);

    private static native double getDouble_0(long var0, String var2);

    private static native int getInt_0(long var0, String var2);

    private static native long getMat_0(long var0, String var2);

    private static native long getMatVector_0(long var0, String var2);

    private static native String getString_0(long var0, String var2);

    private static native String paramHelp_0(long var0, String var2);

    private static native int paramType_0(long var0, String var2);

    private static native void setBool_0(long var0, String var2, boolean var3);

    private static native void setDouble_0(long var0, String var2, double var3);

    private static native void setInt_0(long var0, String var2, int var3);

    private static native void setMat_0(long var0, String var2, long var3);

    private static native void setMatVector_0(long var0, String var2, long var3);

    private static native void setString_0(long var0, String var2, String var3);

    private static native void delete(long var0);
}

