/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.highgui;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.Size;

public class VideoCapture {
    protected final long nativeObj;

    protected VideoCapture(long addr) {
        this.nativeObj = addr;
    }

    public VideoCapture() {
        this.nativeObj = VideoCapture.VideoCapture_0();
    }

    public VideoCapture(String filename) {
        this.nativeObj = VideoCapture.VideoCapture_1(filename);
    }

    public VideoCapture(int device) {
        this.nativeObj = VideoCapture.VideoCapture_2(device);
    }

    public double get(int propId) {
        double retVal = VideoCapture.get_0(this.nativeObj, propId);
        return retVal;
    }

    public boolean grab() {
        boolean retVal = VideoCapture.grab_0(this.nativeObj);
        return retVal;
    }

    public boolean isOpened() {
        boolean retVal = VideoCapture.isOpened_0(this.nativeObj);
        return retVal;
    }

    public boolean open(String filename) {
        boolean retVal = VideoCapture.open_0(this.nativeObj, filename);
        return retVal;
    }

    public boolean open(int device) {
        boolean retVal = VideoCapture.open_1(this.nativeObj, device);
        return retVal;
    }

    public boolean read(Mat image) {
        boolean retVal = VideoCapture.read_0(this.nativeObj, image.nativeObj);
        return retVal;
    }

    public void release() {
        VideoCapture.release_0(this.nativeObj);
    }

    public boolean retrieve(Mat image, int channel) {
        boolean retVal = VideoCapture.retrieve_0(this.nativeObj, image.nativeObj, channel);
        return retVal;
    }

    public boolean retrieve(Mat image) {
        boolean retVal = VideoCapture.retrieve_1(this.nativeObj, image.nativeObj);
        return retVal;
    }

    public boolean set(int propId, double value) {
        boolean retVal = VideoCapture.set_0(this.nativeObj, propId, value);
        return retVal;
    }

    public List<Size> getSupportedPreviewSizes() {
        String[] sizes_str = VideoCapture.getSupportedPreviewSizes_0(this.nativeObj).split(",");
        ArrayList<Size> sizes = new ArrayList<Size>(sizes_str.length);
        for (String str : sizes_str) {
            String[] wh = str.split("x");
            sizes.add(new Size(Double.parseDouble(wh[0]), Double.parseDouble(wh[1])));
        }
        return sizes;
    }

    protected void finalize() throws Throwable {
        VideoCapture.delete(this.nativeObj);
    }

    private static native long VideoCapture_0();

    private static native long VideoCapture_1(String var0);

    private static native long VideoCapture_2(int var0);

    private static native double get_0(long var0, int var2);

    private static native boolean grab_0(long var0);

    private static native boolean isOpened_0(long var0);

    private static native boolean open_0(long var0, String var2);

    private static native boolean open_1(long var0, int var2);

    private static native boolean read_0(long var0, long var2);

    private static native void release_0(long var0);

    private static native boolean retrieve_0(long var0, long var2, int var4);

    private static native boolean retrieve_1(long var0, long var2);

    private static native boolean set_0(long var0, int var2, double var3);

    private static native String getSupportedPreviewSizes_0(long var0);

    private static native void delete(long var0);
}

