/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.android;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opencv.core.CvType;
import org.opencv.core.Mat;
import org.opencv.imgproc.Imgproc;
import org.sikuli.android.ADBClient;
import org.sikuli.android.ADBRobot;
import org.sikuli.android.ADBScreen;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;
import se.vidstige.jadb.JadbDevice;
import se.vidstige.jadb.JadbException;

public class ADBDevice {
    private static int lvl = 3;
    private JadbDevice device = null;
    private int devW = -1;
    private int devH = -1;
    private ADBRobot robot = null;
    private ADBScreen screen = null;
    private List<String> deviceProps = new ArrayList<String>();
    private int deviceVersion = -1;
    private String sDeviceVersion = "???";
    private static ADBDevice adbDevice = null;
    public static int KEY_HOME = 3;
    public static int KEY_BACK = 4;
    public static int KEY_MENU = 82;
    public static int KEY_POWER = 26;
    private static final int BUFFER_SIZE = 4096;
    private String textBuffer = "";
    private boolean typing = false;
    public static float inputDelay = 0.05f;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, "ADBDevice: " + message, args);
    }

    private ADBDevice() {
    }

    public static ADBDevice init() {
        if (adbDevice == null) {
            adbDevice = new ADBDevice();
            ADBDevice.adbDevice.device = ADBClient.getDevice();
            if (ADBDevice.adbDevice.device == null) {
                adbDevice = null;
            } else {
                ADBDevice.adbDevice.deviceProps = Arrays.asList(adbDevice.exec("getprop", new String[0]).split("\n"));
                Pattern pProp = Pattern.compile("\\[(.*?)\\]:.*?\\[(.*)\\]");
                Matcher mProp = null;
                String val = "";
                String key = "";
                for (String prop : ADBDevice.adbDevice.deviceProps) {
                    if (!prop.startsWith("[ro.") || !(mProp = pProp.matcher(prop)).find() || !(key = mProp.group(1)).contains("build.version.release")) continue;
                    val = mProp.group(2);
                    try {
                        ADBDevice.adbDevice.deviceVersion = Integer.parseInt(val.split("\\.")[0]);
                        ADBDevice.adbDevice.sDeviceVersion = val;
                    }
                    catch (Exception exception) {}
                }
                ADBDevice.log(lvl, "init: %s", adbDevice.toString());
            }
        }
        return adbDevice;
    }

    public static void reset() {
        adbDevice = null;
        ADBClient.reset();
    }

    public String toString() {
        return String.format("attached device: serial(%s) display(%dx%d) version(%s)", this.getDeviceSerial(), this.getBounds().width, this.getBounds().height, this.sDeviceVersion);
    }

    public ADBRobot getRobot(ADBScreen screen) {
        if (this.robot == null) {
            this.screen = screen;
            this.robot = new ADBRobot(screen, this);
        }
        return this.robot;
    }

    public String getDeviceSerial() {
        return this.device.getSerial();
    }

    public Rectangle getBounds() {
        if (this.devW < 0) {
            Dimension dim = this.getDisplayDimension();
            this.devW = (int)dim.getWidth();
            this.devH = (int)dim.getHeight();
        }
        return new Rectangle(0, 0, this.devW, this.devH);
    }

    public ScreenImage captureScreen() {
        BufferedImage bimg = this.captureDeviceScreen();
        return new ScreenImage(this.getBounds(), bimg);
    }

    public ScreenImage captureScreen(Rectangle rect) {
        BufferedImage bimg = this.captureDeviceScreen(rect.x, rect.y, rect.width, rect.height);
        return new ScreenImage(rect, bimg);
    }

    public BufferedImage captureDeviceScreen() {
        return this.captureDeviceScreen(0, 0, -1, -1);
    }

    public BufferedImage captureDeviceScreen(int x, int y, int w, int h) {
        Mat matImage = this.captureDeviceScreenMat(x, y, w, h);
        BufferedImage bImage = null;
        if (matImage != null) {
            bImage = new BufferedImage(matImage.width(), matImage.height(), 5);
            byte[] bImageData = ((DataBufferByte)bImage.getRaster().getDataBuffer()).getData();
            matImage.get(0, 0, bImageData);
        }
        return bImage;
    }

    public Mat captureDeviceScreenMat(int x, int y, int actW, int actH) {
        byte[] imagePrefix = new byte[12];
        byte[] image = new byte[]{};
        Debug timer = Debug.startTimer();
        boolean isfullScreen = false;
        if (x == 0 && y == 0 && actW < 0 && actH < 0) {
            isfullScreen = true;
        }
        try {
            InputStream stdout = this.device.executeShell("screencap", new String[0]);
            stdout.read(imagePrefix);
            if (imagePrefix[8] != 1) {
                ADBDevice.log(-1, "captureDeviceScreenMat: image type not RGBA", new Object[0]);
                return null;
            }
            int currentW = this.byte2int(imagePrefix, 0, 4);
            int currentH = this.byte2int(imagePrefix, 4, 4);
            if (!(currentW == this.devW && currentH == this.devH || currentH == this.devW && currentW == this.devH)) {
                ADBDevice.log(-1, "captureDeviceScreenMat: width or height differ from device values", new Object[0]);
                return null;
            }
            if (isfullScreen) {
                actW = currentW;
                actH = currentH;
            } else {
                if (x + actW > currentW) {
                    actW = currentW - x;
                }
                if (y + actW > currentH) {
                    actH = currentH - y;
                }
            }
            image = new byte[actW * actH * 4];
            int lenRow = currentW * 4;
            byte[] row = new byte[lenRow];
            for (int count = 0; count < y; ++count) {
                stdout.read(row);
            }
            boolean shortRow = x + actW < currentW;
            for (int count = 0; count < actH; ++count) {
                if (shortRow) {
                    stdout.read(row);
                    System.arraycopy(row, x * 4, image, count * actW * 4, actW * 4);
                    continue;
                }
                stdout.read(image, count * actW * 4, actW * 4);
            }
            long duration = timer.end();
            ADBDevice.log(lvl, "captureDeviceScreenMat:[%d,%d %dx%d] %d", x, y, actW, actH, duration);
        }
        catch (IOException | JadbException e) {
            ADBDevice.log(-1, "captureDeviceScreenMat: [%d,%d %dx%d] %s", x, y, actW, actH, e);
        }
        Mat matOrg = new Mat(actH, actW, CvType.CV_8UC4);
        matOrg.put(0, 0, image);
        Mat matImage = new Mat();
        Imgproc.cvtColor(matOrg, matImage, 3, 3);
        return matImage;
    }

    private int byte2int(byte[] bytes, int start, int len) {
        int val = 0;
        int fact = 1;
        for (int i = start; i < start + len; ++i) {
            int b = bytes[i] & 0xFF;
            val += b * fact;
            fact *= 256;
        }
        return val;
    }

    private Dimension getDisplayDimension() {
        String dump = this.dumpsys("display");
        String token = "mDefaultViewport= ... deviceWidth=1200, deviceHeight=1920}";
        Dimension dim = null;
        Pattern displayDimension = Pattern.compile("mDefaultViewport.*?=.*?deviceWidth=(\\d*).*?deviceHeight=(\\d*)");
        Matcher match = displayDimension.matcher(dump);
        if (match.find()) {
            int w = Integer.parseInt(match.group(1));
            int h = Integer.parseInt(match.group(2));
            dim = new Dimension(w, h);
        } else {
            ADBDevice.log(-1, "getDisplayDimension: dumpsys display: token not found: %s", token);
        }
        return dim;
    }

    public String exec(String command, String ... args) {
        InputStream stdout = null;
        String out = "";
        try {
            stdout = this.device.executeShell(command, args);
            out = ADBDevice.inputStreamToString(stdout, "UTF-8");
        }
        catch (IOException | JadbException e) {
            ADBDevice.log(-1, "exec: %s: %s", command, e);
        }
        return out;
    }

    public String dumpsys(String component) {
        InputStream stdout = null;
        String out = "";
        try {
            if (component == null || component.isEmpty()) {
                component = "power";
            }
            stdout = component.toLowerCase().contains("all") ? this.device.executeShell("dumpsys", new String[0]) : this.device.executeShell("dumpsys", new String[]{component});
            out = ADBDevice.inputStreamToString(stdout, "UTF-8");
        }
        catch (IOException | JadbException e) {
            ADBDevice.log(-1, "dumpsys: %s: %s", component, e);
        }
        return out;
    }

    public String printDump(String component) {
        String dump = this.dumpsys(component);
        if (!dump.isEmpty()) {
            System.out.println("***** Android device dump: " + component);
            System.out.println(dump);
        }
        return dump;
    }

    public String printDump() {
        String dump = this.dumpsys("all");
        if (!dump.isEmpty()) {
            File out = new File(RunTime.get().fSikulixStore, "android_dump_" + this.getDeviceSerial() + ".txt");
            System.out.println("***** Android device dump all services");
            System.out.println("written to file: " + out.getAbsolutePath());
            FileManager.writeStringToFile(dump, out);
        }
        return dump;
    }

    private static String inputStreamToString(InputStream inputStream, String charsetName) {
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = null;
        try {
            int length;
            reader = new InputStreamReader(inputStream, charsetName);
            char[] buffer = new char[4096];
            while ((length = reader.read(buffer)) != -1) {
                builder.append(buffer, 0, length);
            }
            return builder.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public void wakeUp(int seconds) {
        int times = seconds * 4;
        try {
            if (null == this.isDisplayOn()) {
                ADBDevice.log(-1, "wakeUp: not possible - see log", new Object[0]);
                return;
            }
            this.device.executeShell("input", new String[]{"keyevent", "26"});
            while (0 < times--) {
                if (this.isDisplayOn().booleanValue()) {
                    return;
                }
                RunTime.pause(0.25f);
            }
        }
        catch (Exception e) {
            ADBDevice.log(-1, "wakeUp: did not work: %s", e);
        }
        ADBDevice.log(-1, "wakeUp: timeout: %d seconds", seconds);
    }

    public Boolean isDisplayOn() {
        Matcher match;
        String dump = this.dumpsys("power");
        Pattern displayOn = Pattern.compile("mScreenOn=(..)");
        String isOn = "tr";
        if (this.deviceVersion > 4) {
            displayOn = Pattern.compile("Display Power: state=(..)");
            isOn = "ON";
        }
        if ((match = displayOn.matcher(dump)).find()) {
            if (match.group(1).contains(isOn)) {
                return true;
            }
            return false;
        }
        ADBDevice.log(-1, "isDisplayOn: (Android version %d) dumpsys power: pattern not found: %s", this.deviceVersion, displayOn);
        return null;
    }

    public void inputKeyEvent(int key) {
        try {
            this.device.executeShell("input", new String[]{"keyevent", Integer.toString(key)});
        }
        catch (Exception e) {
            ADBDevice.log(-1, "inputKeyEvent: %d did not work: %s", e.getMessage());
        }
    }

    public void tap(int x, int y) {
        try {
            this.device.executeShell("input tap", new String[]{Integer.toString(x), Integer.toString(y)});
        }
        catch (IOException | JadbException e) {
            ADBDevice.log(-1, "tap: %s", e);
        }
    }

    public void swipe(int x1, int y1, int x2, int y2) {
        try {
            this.device.executeShell("input swipe", new String[]{Integer.toString(x1), Integer.toString(y1), Integer.toString(x2), Integer.toString(y2)});
        }
        catch (IOException | JadbException e) {
            ADBDevice.log(-1, "swipe: %s", e);
        }
    }

    public synchronized boolean typeStarts() {
        if (!this.typing) {
            this.textBuffer = "";
            this.typing = true;
            return true;
        }
        return false;
    }

    public synchronized void typeEnds() {
        if (this.typing) {
            this.input(this.textBuffer);
            this.typing = false;
        }
    }

    public void typeChar(char character) {
        if (this.typing) {
            this.textBuffer = this.textBuffer + character;
        }
    }

    public void input(String text) {
        try {
            this.device.executeShell("input text ", new String[]{text});
            RunTime.pause((float)text.length() * inputDelay);
        }
        catch (Exception e) {
            ADBDevice.log(-1, "input: %s", e);
        }
    }
}

