/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.android;

import org.sikuli.android.ADBDevice;
import org.sikuli.android.ADBScreen;
import org.sikuli.basics.Debug;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Image;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;
import org.sikuli.script.Sikulix;

public class ADBTest {
    private static int lvl = 3;
    private static RunTime rt = null;
    private static boolean runTests = true;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, "ADBDevice: " + message, args);
    }

    private static void logp(String message, Object ... args) {
        System.out.println(String.format(message, args));
    }

    public static void main(String[] args) throws FindFailed {
        ADBScreen aScr = ADBTest.startTest();
        if (aScr.isValid()) {
            if (runTests) {
                ADBTest.basicTest(aScr);
                ADBScreen.stop();
                System.exit(0);
            }
        } else {
            System.exit(1);
        }
    }

    private static ADBScreen startTest() {
        Debug.on(3);
        rt = RunTime.get();
        ADBScreen adbs = new ADBScreen();
        if (adbs.isValid()) {
            adbs.wakeUp(2);
            adbs.wait(1.0);
            if (runTests) {
                adbs.aKey(ADBDevice.KEY_HOME);
                adbs.wait(1.0);
            }
        }
        return adbs;
    }

    private static void basicTest(ADBScreen adbs) throws FindFailed {
        ADBTest.log(lvl, "**************** running basic test", new Object[0]);
        adbs.aSwipeLeft();
        adbs.aSwipeRight();
        adbs.wait(1.0);
        ScreenImage sIMg = adbs.userCapture("Android");
        sIMg.save(RunTime.get().fSikulixStore.getAbsolutePath(), "android");
        adbs.aTap(new Image(sIMg));
    }

    public static void ideTest(ADBScreen aScr) {
        String title = "Android Support - Testing device";
        Sikulix.popup("Take care\n\nthat device is on and unlocked\n\nbefore clicking ok", title);
        aScr.wakeUp(2);
        aScr.aKey(ADBDevice.KEY_HOME);
        if (Sikulix.popAsk("Now the device should show the HOME screen.\n\nclick YES to proceed watching the test on the device\nclick NO to end the test now", title)) {
            aScr.aSwipeLeft();
            aScr.aSwipeRight();
            aScr.wait(1.0);
            if (Sikulix.popAsk("You should have seen a swipe left and a swipe right.\n\nclick YES to capture an icon from homescreen and then aTap it\nclick NO to end the test now", title)) {
                ScreenImage sIMg = aScr.userCapture("AndroidTest");
                sIMg.save(RunTime.get().fSikulixStore.getAbsolutePath(), "android");
                try {
                    aScr.aTap(new Image(sIMg));
                    Sikulix.popup("The image was found on the device's current screen\nand should have been tapped.\n\nIf you think it worked, you can now try\nto capture needed images from the device.\n\nYou have to come back here and click Default!", title);
                }
                catch (FindFailed findFailed) {
                    Sikulix.popError("Sorry, the image you captured was\nnot found on the device's current screen", title);
                }
            }
        }
    }
}

