/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import java.io.File;
import java.net.InetAddress;
import java.net.Proxy;
import java.util.Date;
import org.sikuli.basics.Debug;
import org.sikuli.basics.PreferencesUser;
import org.sikuli.script.Image;
import org.sikuli.script.RunTime;

public class Settings {
    public static boolean experimental = false;
    private static String me = "Settings: ";
    private static int lvl = 3;
    public static boolean noPupUps = false;
    public static boolean FindProfiling = false;
    public static boolean InputFontMono = false;
    public static int InputFontSize = 14;
    public static boolean runningSetupInValidContext = false;
    public static String runningSetupInContext = null;
    public static String runningSetupWithJar = null;
    public static boolean isRunningIDE = false;
    public static int breakPoint = 0;
    public static boolean handlesMacBundles = true;
    public static boolean runningSetup = false;
    private static PreferencesUser prefs;
    public static String OcrDataPath;
    public static final float FOREVER = Float.POSITIVE_INFINITY;
    public static final int JavaVersion;
    public static final String JREVersion;
    public static final String JavaArch;
    public static final String SIKULI_LIB = "*sikuli_lib";
    public static String proxyName;
    public static String proxyIP;
    public static InetAddress proxyAddress;
    public static String proxyPort;
    public static boolean proxyChecked;
    public static Proxy proxy;
    public static final int ISWINDOWS = 0;
    public static final int ISMAC = 1;
    public static final int ISLINUX = 2;
    public static final int ISNOTSUPPORTED = 3;
    public static boolean isMacApp;
    public static boolean isWinApp;
    public static final String appPathMac = "/Applications/SikuliX-IDE.app/Contents";
    public static boolean ThrowException;
    public static float AutoWaitTimeout;
    public static float WaitScanRate;
    public static float ObserveScanRate;
    public static int ObserveMinChangedPixels;
    public static int RepeatWaitTime;
    public static double MinSimilarity;
    public static boolean CheckLastSeen;
    public static float CheckLastSeenSimilar;
    public static boolean UseImageFinder;
    private static int ImageCache;
    public static double DelayValue;
    public static double DelayBeforeMouseDown;
    @Deprecated
    public static double DelayAfterDrag;
    public static double DelayBeforeDrag;
    public static double DelayBeforeDrop;
    public static double TypeDelay;
    public static double ClickDelay;
    public static boolean ClickFast;
    public static boolean RobotFake;
    public static String BundlePath;
    public static boolean OcrTextSearch;
    public static boolean OcrTextRead;
    public static String OcrLanguage;
    public static boolean TRUE;
    public static boolean FALSE;
    private static boolean ShowActions;
    public static boolean OverwriteImages;
    public static float SlowMotionDelay;
    public static float MoveMouseDelay;
    private static float MoveMouseDelaySaved;
    public static boolean Highlight;
    public static float DefaultHighlightTime;
    public static float WaitAfterHighlight;
    public static boolean ActionLogs;
    public static boolean InfoLogs;
    public static boolean DebugLogs;
    public static boolean ProfileLogs;
    public static boolean LogTime;
    public static boolean UserLogs;
    public static String UserLogPrefix;
    public static boolean UserLogTime;
    public static boolean TraceLogs;
    public static final int DefaultPadding = 50;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    private static int makeJavaVersion() {
        int major = 0;
        String jversion = System.getProperty("java.version");
        if (jversion.startsWith("1.")) {
            try {
                major = Integer.parseInt(jversion.substring(2, 3));
            }
            catch (Exception exception) {}
        } else if (jversion.startsWith("9.")) {
            major = 9;
        }
        return major;
    }

    public static synchronized void init() {
        Settings.getOS();
    }

    @Deprecated
    public static String getInstallBase() {
        return RunTime.get().fSxBase.getAbsolutePath();
    }

    public static boolean isValidImageFilename(String fname) {
        String validEndings = ".png.jpg.jpeg";
        String defaultEnding = ".png";
        int dot = fname.lastIndexOf(".");
        String ending = defaultEnding;
        return dot > 0 && validEndings.contains((ending = fname.substring(dot)).toLowerCase());
    }

    public static String getValidImageFilename(String fname) {
        if (Settings.isValidImageFilename(fname)) {
            return fname;
        }
        return fname + ".png";
    }

    public static void setImageCache(int max) {
        if (ImageCache > max) {
            Image.clearCache(max);
        }
        ImageCache = max;
    }

    public static int getImageCache() {
        return ImageCache;
    }

    public static boolean isShowActions() {
        return ShowActions;
    }

    public static void setShowActions(boolean ShowActions) {
        if (ShowActions) {
            MoveMouseDelaySaved = MoveMouseDelay;
        } else {
            MoveMouseDelay = MoveMouseDelaySaved;
        }
        Settings.ShowActions = ShowActions;
    }

    public static boolean isJava7() {
        return JavaVersion > 6;
    }

    public static boolean isJava6() {
        return JavaVersion < 7;
    }

    public static String getFilePathSeperator() {
        return File.separator;
    }

    public static String getPathSeparator() {
        if (Settings.isWindows()) {
            return ";";
        }
        return ":";
    }

    public static String getSikuliDataPath() {
        String sikuliPath;
        String home;
        if (Settings.isWindows()) {
            home = System.getenv("APPDATA");
            sikuliPath = "Sikulix";
        } else if (Settings.isMac()) {
            home = System.getProperty("user.home") + "/Library/Application Support";
            sikuliPath = "Sikulix";
        } else {
            home = System.getProperty("user.home");
            sikuliPath = ".Sikulix";
        }
        File fHome = new File(home, sikuliPath);
        return fHome.getAbsolutePath();
    }

    public static String getUserExtPath() {
        String ret = Settings.getSikuliDataPath() + File.separator + "Extensions";
        File f = new File(ret);
        if (!f.exists()) {
            f.mkdirs();
        }
        return ret;
    }

    public static int getOS() {
        String os = System.getProperty("os.name").toLowerCase();
        int osRet = os.startsWith("mac") ? 1 : (os.startsWith("windows") ? 0 : 2);
        return osRet;
    }

    public static boolean isWindows() {
        return Settings.getOS() == 0;
    }

    public static boolean isLinux() {
        return Settings.getOS() == 2;
    }

    public static boolean isMac() {
        return Settings.getOS() == 1;
    }

    public static boolean isMac10() {
        return Settings.isMac() && Settings.getOSVersion().startsWith("10.1");
    }

    public static String getShortOS() {
        if (Settings.isWindows()) {
            return "win";
        }
        if (Settings.isMac()) {
            return "mac";
        }
        return "lux";
    }

    public static String getOSVersion() {
        return System.getProperty("os.version");
    }

    public static String getTimestamp() {
        return new Date().getTime() + "";
    }

    static {
        OcrDataPath = null;
        JavaVersion = Settings.makeJavaVersion();
        JREVersion = System.getProperty("java.runtime.version");
        JavaArch = System.getProperty("os.arch");
        proxyName = "";
        proxyIP = "";
        proxyAddress = null;
        proxyPort = "";
        proxyChecked = false;
        proxy = null;
        isMacApp = false;
        isWinApp = false;
        ThrowException = true;
        AutoWaitTimeout = 3.0f;
        WaitScanRate = 3.0f;
        ObserveScanRate = 3.0f;
        ObserveMinChangedPixels = 50;
        RepeatWaitTime = 1;
        MinSimilarity = 0.7;
        CheckLastSeen = true;
        CheckLastSeenSimilar = 0.95f;
        UseImageFinder = false;
        ImageCache = 64;
        DelayBeforeMouseDown = DelayValue = 0.3;
        DelayAfterDrag = DelayValue;
        DelayBeforeDrag = -DelayValue;
        DelayBeforeDrop = DelayValue;
        TypeDelay = 0.0;
        ClickDelay = 0.0;
        ClickFast = false;
        RobotFake = true;
        BundlePath = null;
        OcrTextSearch = true;
        OcrTextRead = true;
        OcrLanguage = "eng";
        TRUE = true;
        FALSE = false;
        ShowActions = false;
        OverwriteImages = false;
        SlowMotionDelay = 2.0f;
        MoveMouseDelaySaved = MoveMouseDelay = 0.5f;
        Highlight = false;
        DefaultHighlightTime = 2.0f;
        WaitAfterHighlight = 0.3f;
        ActionLogs = true;
        InfoLogs = true;
        DebugLogs = false;
        ProfileLogs = false;
        LogTime = false;
        UserLogs = true;
        UserLogPrefix = "user";
        UserLogTime = true;
        TraceLogs = false;
    }
}

