/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.hotkey;

import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.swing.KeyStroke;
import org.sikuli.basics.Debug;
import org.sikuli.basics.HotkeyListener;
import org.sikuli.hotkey.HotkeyCallback;
import org.sikuli.hotkey.HotkeyEvent;
import org.sikuli.hotkey.Keys;
import org.sikuli.script.KeyModifier;

public class HotkeyController {
    private static HotkeyController instance = null;
    private Provider hotkeyProvider = null;
    private Map<String, HotKeyListenerWrapper> hotkeys = new HashMap<String, HotKeyListenerWrapper>();
    private static Map<String, Integer> oldFashionedKeys = new HashMap<String, Integer>();

    public static HotkeyController get() {
        if (Keys.isNull(instance)) {
            instance = new HotkeyController();
            instance.initProvider();
        }
        return instance;
    }

    private void initProvider() {
        if (Keys.isNull(this.hotkeyProvider)) {
            this.hotkeyProvider = Provider.getCurrentProvider((boolean)false);
        }
    }

    public void stop() {
        if (Keys.isNull(this.hotkeyProvider)) {
            return;
        }
        Debug.log(3, "stopping hotkey provider", new Object[0]);
        this.hotkeyProvider.reset();
        this.hotkeyProvider.stop();
        this.hotkeyProvider = null;
        this.hotkeys.clear();
    }

    public String addHotkey(HotkeyCallback callback, String ... hotkeys) {
        this.initProvider();
        String finalKey = this.installHotkey(callback, hotkeys);
        if (Keys.isNotSet(finalKey)) {
            String hotkey = "";
            for (String key : hotkeys) {
                hotkey = hotkey + key + " ";
            }
            Debug.log(-1, "HotkeyController: addHotkey: invalid arguments: %s %s", new Object[]{hotkey, Keys.isNull(callback) ? "(no callback)" : ""});
        }
        return finalKey;
    }

    public String addHotkey(HotkeyListener callback, int key, int modifier) {
        String sKey = Keys.getKeyName(key);
        oldFashionedKeys.put(sKey, key);
        String sMod = KeyModifier.getModifierNames(modifier);
        oldFashionedKeys.put(sMod, modifier);
        Debug.log(3, "HotkeyController: addHotkey: %d mod:%d (%s %s)", key, modifier, sKey, sMod);
        return this.installHotkey(callback, sKey + " " + sMod);
    }

    private String installHotkey(Object listener, String ... keys) {
        if (Keys.isNull(listener)) {
            return "";
        }
        if (keys.length > 0) {
            String hkey = "";
            String hmods = "";
            if (keys.length == 1) {
                keys = keys[0].split("\\s");
            }
            if (keys.length > 0 && Keys.isNotNull(listener)) {
                for (String key : keys) {
                    String modifier = Keys.getModifierName(key.trim());
                    if (Keys.isSet(modifier)) {
                        hmods = hmods + modifier + " ";
                        continue;
                    }
                    if (!hkey.isEmpty()) continue;
                    hkey = Keys.getKeyName(key.trim());
                }
            }
            if (Keys.isSet(hkey)) {
                String finalKey = (hmods + hkey).trim();
                Debug.log(3, "installHotkey: %s", finalKey);
                HotKeyListenerWrapper hotKeyListenerWrapper = new HotKeyListenerWrapper(hkey, hmods, listener);
                this.hotkeyProvider.register(KeyStroke.getKeyStroke(finalKey), (HotKeyListener)hotKeyListenerWrapper);
                this.hotkeys.put(finalKey, hotKeyListenerWrapper);
                return finalKey;
            }
        }
        return "";
    }

    public boolean removeHotkey(String givenKey) {
        if (Keys.isNotNull(this.hotkeyProvider) && !this.hotkeys.isEmpty()) {
            this.hotkeyProvider.reset();
            this.hotkeys.remove(givenKey.trim());
            Debug.log(3, "removeHotkey: %s", givenKey);
            if (!this.hotkeys.isEmpty()) {
                for (String keys : this.hotkeys.keySet()) {
                    Debug.log(3, "installHotkey again: %s", keys);
                    HotKeyListenerWrapper callback = this.hotkeys.get(keys);
                    this.hotkeyProvider.register(KeyStroke.getKeyStroke(keys), (HotKeyListener)callback);
                }
            }
        }
        return true;
    }

    public boolean removeHotkey(int key, int modifier) {
        String sKey = Keys.getKeyName(key);
        String sMod = KeyModifier.getModifierNames(modifier);
        Debug.log(3, "HotkeyController: removeHotkey: %d mod:%d (%s %s)", key, modifier, sKey, sMod);
        return this.removeHotkey(sKey + " " + sMod);
    }

    private class HotKeyListenerWrapper
    implements HotKeyListener {
        private String key = "";
        private String modifier = "";
        private Object callback = null;

        private boolean isOldFashion() {
            return this.callback instanceof HotkeyListener;
        }

        public HotKeyListenerWrapper(String key, String modifier, Object callback) {
            this.key = key;
            this.modifier = modifier.trim();
            this.callback = callback;
        }

        public HotKeyListenerWrapper(String keys, Object callback) {
            String[] keyParts = keys.split("\\s");
            this.key = keyParts[keyParts.length - 1];
            this.modifier = keys.substring(0, keys.length() - this.key.length()).trim();
            this.callback = callback;
        }

        public void onHotKey(HotKey hotKey) {
            if (this.isOldFashion()) {
                int nkey = (Integer)oldFashionedKeys.get(this.key);
                int nmod = (Integer)oldFashionedKeys.get(this.modifier);
                org.sikuli.basics.HotkeyEvent hotkeyEvent = new org.sikuli.basics.HotkeyEvent(nkey, nmod);
                ((HotkeyListener)this.callback).hotkeyPressed(hotkeyEvent);
            } else {
                ((HotkeyCallback)this.callback).hotkeyPressed(new HotkeyEvent(this.key, this.modifier));
            }
        }
    }
}

