/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Desktop;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.natives.OSUtil;
import org.sikuli.natives.SysUtil;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;
import org.sikuli.script.Screen;

public class App {
    static RunTime runTime = RunTime.get();
    private static final OSUtil _osUtil = SysUtil.getOSUtil();
    private String appNameGiven;
    private String appOptions;
    private String appName;
    private String appWindow;
    private int appPID;
    private boolean isImmediate = false;
    private boolean notFound = false;
    private static final Map<Type, String> appsWindows;
    private static final Map<Type, String> appsMac;
    private static final Region aRegion;
    public static int lastRunReturnCode;
    public static String lastRunStdout;
    public static String lastRunStderr;
    public static String lastRunResult;

    public static Region start(Type appType) {
        App app = null;
        try {
            if (Type.EDITOR.equals((Object)appType)) {
                if (App.runTime.runningMac) {
                    app = new App(appsMac.get((Object)appType));
                    if (app.window() != null) {
                        app.focus();
                        aRegion.wait(0.5);
                        Region win = app.window();
                        aRegion.click(win);
                        aRegion.write("#M.a#B.");
                        return win;
                    }
                    app.open();
                    Region win = app.waitForWindow();
                    app.focus();
                    aRegion.wait(0.5);
                    aRegion.click(win);
                    return win;
                }
                if (App.runTime.runningWindows) {
                    app = new App(appsWindows.get((Object)appType));
                    if (app.window() != null) {
                        app.focus();
                        aRegion.wait(0.5);
                        Region win = app.window();
                        aRegion.click(win);
                        aRegion.write("#C.a#B.");
                        return win;
                    }
                    app.open();
                    Region win = app.waitForWindow();
                    app.focus();
                    aRegion.wait(0.5);
                    aRegion.click(win);
                    return win;
                }
            } else {
                if (Type.BROWSER.equals((Object)appType)) {
                    if (App.runTime.runningWindows) {
                        app = new App(appsWindows.get((Object)appType));
                        if (app.window() != null) {
                            app.focus();
                            aRegion.wait(0.5);
                            Region win = app.window();
                            aRegion.click(win);
                            return win;
                        }
                        app.open();
                        Region win = app.waitForWindow();
                        app.focus();
                        aRegion.wait(0.5);
                        aRegion.click(win);
                        return win;
                    }
                    return null;
                }
                if (Type.VIEWER.equals((Object)appType)) {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Region waitForWindow() {
        return this.waitForWindow(5);
    }

    public Region waitForWindow(int seconds) {
        Region win = null;
        while ((win = this.window()) == null && seconds > 0) {
            aRegion.wait(0.5);
            seconds = (int)((double)seconds - 0.5);
        }
        return win;
    }

    public static boolean openLink(String url) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private static Region asRegion(Rectangle r) {
        if (r != null) {
            return Region.create(r);
        }
        return null;
    }

    public static void pause(int time) {
        try {
            Thread.sleep(time * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void pause(float time) {
        try {
            Thread.sleep((int)(time * 1000.0f));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public AppEntry makeAppEntry() {
        String name = this.appName;
        String window = this.appWindow;
        if (name.isEmpty() && this.appOptions.isEmpty()) {
            name = this.appNameGiven;
        }
        if (this.isImmediate && !window.startsWith("!")) {
            window = "!" + window;
        }
        if (this.notFound) {
            name = "!" + name;
        }
        String pid = this.getPID().toString();
        AppEntry appEntry = new AppEntry(name, pid, window, this.appNameGiven, this.appOptions);
        return appEntry;
    }

    public App(String name) {
        this.appNameGiven = name;
        this.appName = name;
        this.appPID = -1;
        this.appWindow = "";
        this.appOptions = "";
        String execName = "";
        if (this.appNameGiven.startsWith("+")) {
            this.isImmediate = true;
            this.appNameGiven = this.appNameGiven.substring(1);
            Debug.log(3, "App.immediate: %s", this.appNameGiven);
            this.appName = this.appNameGiven;
            if (this.appName.startsWith("\"")) {
                String[] parts = this.appName.substring(1).split("\"");
                if (parts.length > 1) {
                    this.appOptions = this.appName.substring(parts[0].length() + 3);
                    this.appName = "\"" + parts[0] + "\"";
                }
            } else {
                String[] parts = this.appName.split(" ");
                if (parts.length > 1) {
                    this.appOptions = this.appName.substring(parts[0].length() + 1);
                    this.appName = parts[0];
                }
            }
            execName = this.appName.startsWith("\"") ? this.appName.substring(1, this.appName.length() - 1) : this.appName;
            this.appName = new File(execName).getName();
            File checkName = new File(execName);
            if (checkName.isAbsolute() && !checkName.exists()) {
                this.appName = "";
                this.appOptions = "";
                this.appWindow = "!";
                this.notFound = true;
            }
        } else {
            this.init(this.appNameGiven);
        }
        Debug.log(3, "App.create: %s", this.toStringShort());
    }

    private void init(String name) {
        AppEntry app = null;
        if (!this.isImmediate || !this.notFound) {
            app = _osUtil.getApp(-1, name);
        }
        if (app != null) {
            this.appName = app.name;
            if (app.options.isEmpty()) {
                this.appPID = app.pid;
                if (!app.window.contains("N/A")) {
                    this.appWindow = app.window;
                    if (this.notFound) {
                        this.notFound = false;
                    }
                }
            } else {
                this.appOptions = app.options;
                this.appNameGiven = this.appName;
            }
        }
    }

    public App(int pid) {
        this.appNameGiven = "FromPID";
        this.appName = "";
        this.appPID = pid;
        this.appWindow = "";
        this.init(pid);
    }

    private void init(int pid) {
        AppEntry app = _osUtil.getApp(pid, this.appName);
        if (app != null) {
            this.appName = app.name;
            this.appPID = app.pid;
            if (!app.window.contains("N/A")) {
                this.appWindow = app.window;
            }
        } else {
            this.appPID = -1;
        }
    }

    private void init() {
        if (this.appPID > -1) {
            this.init(this.appPID);
        } else {
            String name = this.appName;
            if (name.isEmpty() && this.appOptions.isEmpty()) {
                name = this.appNameGiven;
            }
            this.init(name);
        }
    }

    public static void getApps(String name) {
        Map<Integer, String[]> theApps = _osUtil.getApps(name);
        int count = 0;
        for (Integer pid : theApps.keySet()) {
            String[] item = theApps.get(pid);
            if (pid < 0) {
                pid = -pid.intValue();
                Debug.logp("%d:%s (N/A)", pid, item[0]);
                continue;
            }
            Debug.logp("%d:%s (%s)", pid, item[0], item[1]);
            ++count;
        }
        Debug.logp("App.getApps: %d apps (%d having window)", theApps.size(), count);
    }

    public static void getApps() {
        App.getApps(null);
    }

    public App setUsing(String options) {
        this.appOptions = options != null ? options : "";
        return this;
    }

    public Integer getPID() {
        return this.appPID;
    }

    public String getName() {
        return this.appName;
    }

    public String getWindow() {
        return this.appWindow;
    }

    public boolean isValid() {
        return !this.notFound;
    }

    public boolean isRunning() {
        return this.isRunning(1);
    }

    public boolean isRunning(int maxTime) {
        if (!this.isValid()) {
            return false;
        }
        for (int n = 0; n < maxTime; ++n) {
            int retVal = _osUtil.isRunning(this.makeAppEntry());
            if (retVal > 0) {
                return true;
            }
            RunTime.pause(1);
        }
        return false;
    }

    public boolean hasWindow() {
        if (!this.isValid()) {
            return false;
        }
        this.init(this.appName);
        return !this.getWindow().isEmpty();
    }

    public String toString() {
        if (!this.appWindow.startsWith("!")) {
            this.init();
        }
        return String.format("[%d:%s (%s)] %s", this.appPID, this.appName, this.appWindow, this.appNameGiven);
    }

    public String toStringShort() {
        return String.format("[%d:%s]", this.appPID, this.appName);
    }

    public static App open(String appName) {
        return new App("+" + appName).open();
    }

    public App open() {
        return this.openAndWait(0);
    }

    public App open(int waitTime) {
        return this.openAndWait(waitTime);
    }

    private App openAndWait(int waitTime) {
        if (this.isImmediate) {
            this.appPID = _osUtil.open(this.appNameGiven);
        } else {
            AppEntry appEntry = this.makeAppEntry();
            this.init(_osUtil.open(appEntry));
        }
        if (this.appPID < 0) {
            Debug.error("App.open failed: " + this.appNameGiven + " not found", new Object[0]);
            this.notFound = true;
        } else {
            Debug.action("App.open " + this.toStringShort(), new Object[0]);
        }
        if (this.isImmediate && this.notFound) {
            return null;
        }
        if (waitTime > 0 && !this.isRunning(waitTime)) {
            return null;
        }
        return this;
    }

    public static int close(String appName) {
        return new App("+" + appName).close();
    }

    public int close() {
        if (!this.isValid()) {
            return 0;
        }
        if (this.appPID > -1) {
            this.init(this.appPID);
        } else if (this.isImmediate) {
            this.init();
        }
        int ret = _osUtil.close(this.makeAppEntry());
        if (ret > -1) {
            Debug.action("App.close: %s", this.toStringShort());
            this.appPID = -1;
            this.appWindow = "";
        } else {
            Debug.error("App.close %s did not work", this);
        }
        return ret;
    }

    public static App focus(String appName) {
        return App.focus(appName, 0);
    }

    public static App focus(String appName, int num) {
        return new App("+" + appName).focus(num);
    }

    public App focus() {
        if (this.appPID > -1) {
            this.init(this.appPID);
        }
        return this.focus(0);
    }

    public App focus(int num) {
        if (!this.isValid() && !this.appWindow.startsWith("!")) {
            return this;
        }
        if (this.isImmediate) {
            this.appPID = _osUtil.switchto(this.appNameGiven, num);
        } else {
            this.init(_osUtil.switchto(this.makeAppEntry(), num));
        }
        if (this.appPID < 0) {
            Debug.error("App.focus failed: " + (num > 0 ? " #" + num : "") + " " + this.toString(), new Object[0]);
            return null;
        }
        Debug.action("App.focus: " + (num > 0 ? " #" + num : "") + " " + this.toStringShort(), new Object[0]);
        if (this.appPID < 1) {
            this.init();
        }
        return this;
    }

    public Region window() {
        if (this.appPID != 0) {
            return App.asRegion(_osUtil.getWindow(this.appPID));
        }
        return App.asRegion(_osUtil.getWindow(this.appNameGiven));
    }

    public Region window(int winNum) {
        if (this.appPID != 0) {
            return App.asRegion(_osUtil.getWindow(this.appPID, winNum));
        }
        return App.asRegion(_osUtil.getWindow(this.appNameGiven, winNum));
    }

    public static Region focusedWindow() {
        return App.asRegion(_osUtil.getFocusedWindow());
    }

    public static int run(String cmd) {
        lastRunResult = runTime.runcmd(cmd);
        String NL = App.runTime.runningWindows ? "\r\n" : "\n";
        String[] res = lastRunResult.split(NL);
        try {
            lastRunReturnCode = Integer.parseInt(res[0].trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        lastRunStdout = "";
        lastRunStderr = "";
        boolean isError = false;
        for (int n = 1; n < res.length; ++n) {
            if (isError) {
                lastRunStderr = lastRunStderr + res[n] + NL;
                continue;
            }
            if ("*****error*****".equals(res[n])) {
                isError = true;
                continue;
            }
            lastRunStdout = lastRunStdout + res[n] + NL;
        }
        return lastRunReturnCode;
    }

    public static String getClipboard() {
        Transferable content = null;
        try {
            content = Clipboard.getSystemClipboard().getContents(null);
        }
        catch (Exception ex) {
            Debug.error("Env.getClipboard: %s", ex.getMessage());
        }
        if (content != null) {
            try {
                if (content.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    return (String)content.getTransferData(DataFlavor.stringFlavor);
                }
            }
            catch (UnsupportedFlavorException ex) {
                Debug.error("Env.getClipboard: UnsupportedFlavorException: " + content, new Object[0]);
            }
            catch (IOException ex) {
                Debug.error("Env.getClipboard: %s", ex.getMessage());
            }
        }
        return "";
    }

    public static void setClipboard(String text) {
        try {
            Clipboard.putText(Clipboard.PLAIN, Clipboard.UTF8, Clipboard.CHAR_BUFFER, text);
        }
        catch (Exception ex) {
            Debug.error("Env.setClipboard: %s", ex.getMessage());
        }
    }

    static {
        aRegion = new Region();
        new Screen();
        _osUtil.checkFeatureAvailability();
        appsWindows = new HashMap<Type, String>();
        appsWindows.put(Type.EDITOR, "Notepad");
        appsWindows.put(Type.BROWSER, "Google Chrome");
        appsWindows.put(Type.VIEWER, "");
        appsMac = new HashMap<Type, String>();
        appsMac.put(Type.EDITOR, "TextEdit");
        appsMac.put(Type.BROWSER, "Safari");
        appsMac.put(Type.VIEWER, "Preview");
        lastRunReturnCode = -1;
        lastRunStdout = "";
        lastRunStderr = "";
        lastRunResult = "";
    }

    private static class Clipboard {
        public static final TextType HTML = new TextType("text/html");
        public static final TextType PLAIN = new TextType("text/plain");
        public static final Charset UTF8 = new Charset("UTF-8");
        public static final Charset UTF16 = new Charset("UTF-16");
        public static final Charset UNICODE = new Charset("unicode");
        public static final Charset US_ASCII = new Charset("US-ASCII");
        public static final TransferType READER = new TransferType(Reader.class);
        public static final TransferType INPUT_STREAM = new TransferType(InputStream.class);
        public static final TransferType CHAR_BUFFER = new TransferType(CharBuffer.class);
        public static final TransferType BYTE_BUFFER = new TransferType(ByteBuffer.class);
        private static java.awt.datatransfer.Clipboard systemClipboard = null;

        private Clipboard() {
        }

        public static void putText(CharSequence data) throws Exception {
            StringSelection copy = new StringSelection(data.toString());
            Clipboard.getSystemClipboard().setContents(copy, copy);
        }

        public static void putText(TextType type, Charset charset, TransferType transferType, CharSequence data) throws Exception {
            String mimeType = type + "; charset=" + charset + "; class=" + transferType;
            TextTransferable transferable = new TextTransferable(mimeType, data.toString());
            Clipboard.getSystemClipboard().setContents(transferable, transferable);
        }

        public static java.awt.datatransfer.Clipboard getSystemClipboard() throws Exception {
            if (systemClipboard == null && (systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard()) == null) {
                throw new Exception("Clipboard: Toolkit.getDefaultToolkit().getSystemClipboard() returns null");
            }
            return systemClipboard;
        }

        public static class TransferType {
            private Class dataClass;

            private TransferType(Class streamClass) {
                this.dataClass = streamClass;
            }

            public Class getDataClass() {
                return this.dataClass;
            }

            public String toString() {
                return this.dataClass.getName();
            }
        }

        public static class Charset {
            private String name;

            private Charset(String name) {
                this.name = name;
            }

            public String toString() {
                return this.name;
            }
        }

        public static class TextType {
            private String type;

            private TextType(String type) {
                this.type = type;
            }

            public String toString() {
                return this.type;
            }
        }

        private static class TextTransferable
        implements Transferable,
        ClipboardOwner {
            private String data;
            private DataFlavor flavor;

            public TextTransferable(String mimeType, String data) {
                this.flavor = new DataFlavor(mimeType, "Text");
                this.data = data;
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{this.flavor, DataFlavor.stringFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                boolean b = this.flavor.getPrimaryType().equals(flavor.getPrimaryType());
                return b || flavor.equals(DataFlavor.stringFlavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (flavor.isRepresentationClassInputStream()) {
                    return new StringReader(this.data);
                }
                if (flavor.isRepresentationClassReader()) {
                    return new StringReader(this.data);
                }
                if (flavor.isRepresentationClassCharBuffer()) {
                    return CharBuffer.wrap(this.data);
                }
                if (flavor.isRepresentationClassByteBuffer()) {
                    return ByteBuffer.wrap(this.data.getBytes());
                }
                if (flavor.equals(DataFlavor.stringFlavor)) {
                    return this.data;
                }
                throw new UnsupportedFlavorException(flavor);
            }

            @Override
            public void lostOwnership(java.awt.datatransfer.Clipboard clipboard, Transferable contents) {
            }
        }
    }

    public static class AppEntry {
        public String name;
        public String execName;
        public String options;
        public String window;
        public int pid;

        public AppEntry(String theName, String thePID, String theWindow, String theExec, String theOptions) {
            this.name = theName;
            this.window = theWindow;
            this.options = theOptions;
            this.pid = -1;
            this.execName = theExec;
            try {
                this.pid = Integer.parseInt(thePID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static enum Type {
        EDITOR,
        BROWSER,
        VIEWER;

    }
}

