/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.opencv.core.Core;
import org.opencv.core.Mat;
import org.opencv.core.MatOfDouble;
import org.opencv.core.Rect;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Image;
import org.sikuli.script.ImageFinder;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;

public class ImageFind
implements Iterator<Match> {
    private static String me = "ImageFind: ";
    private static int lvl = 3;
    private ImageFinder owner = null;
    private boolean isValid = false;
    private boolean isInnerFind = false;
    private Image pImage = null;
    private Mat probe = new Mat();
    private boolean isPlainColor = false;
    private boolean isBlack = false;
    private double similarity = Settings.MinSimilarity;
    private double waitingTime = Settings.AutoWaitTimeout;
    private boolean shouldCheckLastSeen = Settings.CheckLastSeen;
    private Object[] findArgs = null;
    private int resizeMinDownSample = 12;
    private double resizeFactor;
    private float[] resizeLevels = new float[]{1.0f, 0.4f};
    private int resizeMaxLevel = this.resizeLevels.length - 1;
    private double resizeMinSim = 0.9;
    private double resizeMinFactor = 1.5;
    private Core.MinMaxLocResult findDownRes = null;
    private int sorted;
    public static final int AS_ROWS = 0;
    public static final int AS_COLUMNS = 1;
    public static final int BEST_FIRST = 2;
    private int finding = -1;
    public static final int FINDING_ANY = 0;
    public static final int FINDING_SOME = 1;
    public static final int FINDING_ALL = 2;
    private int count = 0;
    public static int SOME_COUNT = 5;
    public static int ALL_MAX = 100;
    private int allMax = 0;
    private List<Match> matches = Collections.synchronizedList(new ArrayList());
    private boolean repeating;
    private long lastFindTime = 0L;
    private long lastSearchTime = 0L;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public ImageFind() {
        this.matches.add(null);
    }

    public boolean isValid() {
        return true;
    }

    public void setIsInnerFind() {
        this.isInnerFind = true;
    }

    void setSimilarity(double sim) {
        this.similarity = sim;
    }

    public void setFindTimeout(double t) {
        this.waitingTime = t;
    }

    public void setFinding(int ftyp) {
        this.finding = ftyp;
    }

    public void setSorted(int styp) {
        this.sorted = styp;
    }

    public void setCount(int c) {
        this.count = c;
    }

    public List<Match> getMatches() {
        return this.matches;
    }

    protected boolean checkFind(ImageFinder owner, Object pprobe, Object ... args) {
        if (!owner.isValid()) {
            return false;
        }
        this.owner = owner;
        this.isValid = false;
        this.shouldCheckLastSeen = Settings.CheckLastSeen;
        if (pprobe instanceof String) {
            this.pImage = Image.create((String)pprobe);
            if (this.pImage.isValid()) {
                this.isValid = true;
            }
        } else if (pprobe instanceof Image) {
            if (((Image)pprobe).isValid()) {
                this.isValid = true;
                this.pImage = (Image)pprobe;
            }
        } else if (pprobe instanceof Pattern) {
            if (((Pattern)pprobe).getImage().isValid()) {
                this.isValid = true;
                this.pImage = ((Pattern)pprobe).getImage();
                this.similarity = ((Pattern)pprobe).getSimilar();
            }
        } else if (pprobe instanceof Mat) {
            this.isValid = true;
            this.probe = (Mat)pprobe;
            this.waitingTime = 0.0;
            this.shouldCheckLastSeen = false;
        } else {
            ImageFind.log(-1, "find(... some, any, all): probe invalid (not Pattern, String nor valid Image)", new Object[0]);
            return false;
        }
        if (this.probe.empty()) {
            this.probe = Image.createMat(this.pImage.get());
        }
        this.checkProbe();
        if (!owner.isImage()) {
            if (args.length > 0) {
                if (args[0] instanceof Integer) {
                    this.waitingTime = 0.0 + (double)((Integer)args[0]).intValue();
                } else if (args[0] instanceof Double) {
                    this.waitingTime = (Double)args[0];
                }
            }
            this.findArgs = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : null;
        }
        return this.isValid;
    }

    private void checkProbe() {
        int i;
        MatOfDouble pMean = new MatOfDouble();
        MatOfDouble pStdDev = new MatOfDouble();
        Core.meanStdDev(this.probe, pMean, pStdDev);
        double min = 1.0E-5;
        this.isPlainColor = false;
        double sum = 0.0;
        double[] arr = pStdDev.toArray();
        for (i = 0; i < arr.length; ++i) {
            sum += arr[i];
        }
        if (sum < min) {
            this.isPlainColor = true;
        }
        sum = 0.0;
        arr = pMean.toArray();
        for (i = 0; i < arr.length; ++i) {
            sum += arr[i];
        }
        if (sum < min && this.isPlainColor) {
            this.isBlack = true;
        }
        this.resizeFactor = Math.min((double)this.probe.width() / (double)this.resizeMinDownSample, (double)this.probe.height() / (double)this.resizeMinDownSample);
        this.resizeFactor = Math.max(1.0, this.resizeFactor);
    }

    protected ImageFind doFind() {
        Debug.enter(me + ": doFind", new Object[0]);
        Core.MinMaxLocResult fres = null;
        this.repeating = false;
        long begin = new Date().getTime();
        while (true) {
            long l;
            this.lastFindTime = new Date().getTime();
            if (this.shouldCheckLastSeen && !this.repeating && !this.owner.isImage && this.pImage.getLastSeen() != null) {
                ImageFind.log(3, "checkLastSeen: trying ...", new Object[0]);
                ImageFinder f = new ImageFinder(new Region(this.pImage.getLastSeen()));
                if (null != f.findInner(this.probe, this.pImage.getLastSeenScore() - 0.01)) {
                    ImageFind.log(lvl, "checkLastSeen: success", new Object[0]);
                    this.set(f.next());
                    if (this.pImage == null) break;
                    this.pImage.setLastSeen(this.get().getRect(), this.get().getScore());
                    break;
                }
                ImageFind.log(lvl, "checkLastSeen: not found", new Object[0]);
            }
            if (!this.owner.isMultiFinder || this.owner.base.empty()) {
                if (this.owner.isRegion) {
                    this.owner.setBase(this.owner.region.getScreen().capture(this.owner.region).getImage());
                } else if (this.owner.isScreen) {
                    this.owner.setBase(this.owner.screen.capture().getImage());
                }
            }
            if (!this.isInnerFind && this.resizeFactor > this.resizeMinFactor) {
                ImageFind.log(3, "downsampling: trying ...", new Object[0]);
                this.doFindDown(0, this.resizeFactor);
                fres = this.findDownRes;
            }
            if (fres == null) {
                if (!this.isInnerFind) {
                    ImageFind.log(3, "downsampling: not found with (%f) - trying original size", this.resizeFactor);
                }
                if ((fres = this.doFindDown(0, 0.0)) != null && fres.maxVal > this.similarity - 0.01) {
                    this.set(new Match((int)fres.maxLoc.x + this.owner.offX, (int)fres.maxLoc.y + this.owner.offY, this.probe.width(), this.probe.height(), fres.maxVal, null, null));
                }
            } else {
                ImageFind.log(lvl, "downsampling: success: adjusting match", new Object[0]);
                this.set(this.checkFound(fres));
            }
            this.lastFindTime = new Date().getTime() - this.lastFindTime;
            if (this.hasNext()) {
                this.get().setTimes(this.lastFindTime, this.lastSearchTime);
                if (this.pImage == null) break;
                this.pImage.setLastSeen(this.get().getRect(), this.get().getScore());
                break;
            }
            if (this.isInnerFind || this.owner.isImage() || this.waitingTime < 0.001) break;
            long lap = new Date().getTime() - begin;
            if ((double)l > this.waitingTime * 1000.0) break;
            if (this.owner.MaxTimePerScan > lap) {
                try {
                    Thread.sleep(this.owner.MaxTimePerScan - lap);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.repeating = true;
        }
        return this;
    }

    private Match checkFound(Core.MinMaxLocResult res) {
        ImageFinder f;
        Match match = null;
        Rect r = null;
        if (this.owner.isImage()) {
            int off = (int)this.resizeFactor + 1;
            r = ImageFind.getSubMatRect(this.owner.base, (int)res.maxLoc.x, (int)res.maxLoc.y, this.probe.width(), this.probe.height(), off);
            f = new ImageFinder(this.owner.base.submat(r));
        } else {
            f = new ImageFinder(new Region((int)res.maxLoc.x + this.owner.offX, (int)res.maxLoc.y + this.owner.offY, this.probe.width(), this.probe.height()).grow((int)this.resizeFactor + 1));
        }
        if (null != f.findInner(this.probe, this.similarity)) {
            ImageFind.log(lvl, "check after downsampling: success", new Object[0]);
            match = f.next();
            if (this.owner.isImage()) {
                match.x += r.x;
                match.y += r.y;
            }
        }
        return match;
    }

    private static Rect getSubMatRect(Mat mat, int x, int y, int w, int h, int margin) {
        x = Math.max(0, x - margin);
        y = Math.max(0, y - margin);
        w = Math.min(w + 2 * margin, mat.width() - x);
        h = Math.min(h + 2 * margin, mat.height() - y);
        return new Rect(x, y, w, h);
    }

    private Core.MinMaxLocResult doFindDown(int level, double factor) {
        double rfactor;
        Debug.enter(me + ": doFindDown (%d - 1/%.2f)", level, factor * (double)this.resizeLevels[level]);
        Debug timer = Debug.startTimer("doFindDown", new Object[0]);
        Mat b = new Mat();
        Mat p = new Mat();
        Core.MinMaxLocResult dres = null;
        if (factor > 0.0) {
            rfactor = factor * (double)this.resizeLevels[level];
            if (rfactor < this.resizeMinFactor) {
                return null;
            }
        } else {
            dres = this.doFindMatch(this.owner.base, this.probe);
            timer.end();
            return dres;
        }
        Size sb = new Size((double)this.owner.base.cols() / rfactor, (double)this.owner.base.rows() / factor);
        Size sp = new Size((double)this.probe.cols() / rfactor, (double)this.probe.rows() / factor);
        Imgproc.resize(this.owner.base, b, sb, 0.0, 0.0, 3);
        Imgproc.resize(this.probe, p, sp, 0.0, 0.0, 3);
        dres = this.doFindMatch(b, p);
        ImageFind.log(lvl, "doFindDown: score: %.2f at (%d, %d)", dres.maxVal, (int)(dres.maxLoc.x * rfactor), (int)(dres.maxLoc.y * rfactor));
        if (dres.maxVal < this.resizeMinSim) {
            if (level == this.resizeMaxLevel) {
                timer.end();
                return null;
            }
            if (level == 0) {
                this.findDownRes = null;
            }
            this.doFindDown(++level, factor);
        } else {
            dres.maxLoc.x *= rfactor;
            dres.maxLoc.y *= rfactor;
            this.findDownRes = dres;
        }
        timer.end();
        return null;
    }

    private Core.MinMaxLocResult doFindMatch(Mat base, Mat probe) {
        Mat res = new Mat();
        Mat bi = new Mat();
        Mat pi = new Mat();
        if (!this.isPlainColor) {
            Imgproc.matchTemplate(base, probe, res, 5);
        } else {
            if (this.isBlack) {
                Core.bitwise_not(base, bi);
                Core.bitwise_not(probe, pi);
            } else {
                bi = base;
                pi = probe;
            }
            Imgproc.matchTemplate(bi, pi, res, 1);
            Core.subtract(Mat.ones(res.size(), 5), res, res);
        }
        return Core.minMaxLoc(res);
    }

    @Override
    public boolean hasNext() {
        if (this.matches.size() > 0) {
            return this.matches.get(0) != null;
        }
        return false;
    }

    @Override
    public Match next() {
        Match m = null;
        if (this.matches.size() > 0) {
            m = this.matches.get(0);
            this.remove();
        }
        return m;
    }

    @Override
    public void remove() {
        if (this.matches.size() > 0) {
            this.matches.remove(0);
        }
    }

    public Match get() {
        return this.get(0);
    }

    public Match get(int n) {
        if (n < this.matches.size()) {
            return this.matches.get(n);
        }
        return null;
    }

    private Match add(Match m) {
        if (this.matches.add(m)) {
            return m;
        }
        return null;
    }

    private Match set(Match m) {
        if (this.matches.size() > 0) {
            this.matches.set(0, m);
        } else {
            this.matches.add(m);
        }
        return m;
    }

    public int getSize() {
        return this.matches.size();
    }
}

