/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.natives.Mat;
import org.sikuli.natives.OCRWord;
import org.sikuli.natives.OCRWords;
import org.sikuli.natives.Vision;
import org.sikuli.script.Image;
import org.sikuli.script.Match;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;

public class TextRecognizer {
    static RunTime runTime = RunTime.get();
    private static TextRecognizer _instance = null;
    private static boolean initSuccess = false;
    private static int lvl = 3;

    private TextRecognizer() {
        this.init();
    }

    private void init() {
        File fTessdataPath = null;
        initSuccess = false;
        if (Settings.OcrDataPath != null) {
            fTessdataPath = new File(FileManager.slashify(Settings.OcrDataPath, false), "tessdata");
            initSuccess = fTessdataPath.exists();
        }
        if (!(initSuccess || (initSuccess = (fTessdataPath = new File(TextRecognizer.runTime.fSikulixAppPath, "SikulixTesseract/tessdata")).exists()) || (initSuccess = null != runTime.extractTessData(fTessdataPath)))) {
            Debug.error("TextRecognizer: init: export tessdata not possible - run setup with option 3", new Object[0]);
        }
        if (!new File(fTessdataPath, "eng.traineddata").exists()) {
            initSuccess = false;
        }
        if (!initSuccess) {
            Debug.error("TextRecognizer not working: tessdata stuff not available at:\n%s", fTessdataPath);
            Settings.OcrTextRead = false;
            Settings.OcrTextSearch = false;
        } else {
            Settings.OcrDataPath = fTessdataPath.getParent();
            Vision.initOCR(FileManager.slashify(Settings.OcrDataPath, true));
            Debug.log(lvl, "TextRecognizer: init OK: using as data folder:\n%s", Settings.OcrDataPath);
        }
    }

    public static TextRecognizer getInstance() {
        if (_instance == null) {
            _instance = new TextRecognizer();
        }
        if (!initSuccess) {
            return null;
        }
        return _instance;
    }

    public static void reset() {
        _instance = null;
        Vision.setSParameter("OCRLang", Settings.OcrLanguage);
    }

    public static void reset(String language) {
        _instance = null;
        Vision.setSParameter("OCRLang", language);
    }

    public List<Match> listText(ScreenImage simg, Region parent) {
        return this.listText(simg, parent, ListTextMode.WORD);
    }

    public List<Match> listText(ScreenImage simg, Region parent, ListTextMode mode) {
        Mat mat = Image.convertBufferedImageToMat(simg.getImage());
        OCRWords words = Vision.recognize_as_ocrtext(mat).getWords();
        LinkedList<Match> ret = new LinkedList<Match>();
        int i = 0;
        while ((long)i < words.size()) {
            OCRWord w = words.get(i);
            Match m = new Match(parent.x + w.getX(), parent.y + w.getY(), w.getWidth(), w.getHeight(), w.getScore(), parent.getScreen(), w.getString());
            ret.add(m);
            ++i;
        }
        return ret;
    }

    public String recognize(ScreenImage simg) {
        BufferedImage img = simg.getImage();
        return this.recognize(img);
    }

    public String recognize(BufferedImage img) {
        if (initSuccess) {
            Mat mat = Image.convertBufferedImageToMat(img);
            return Vision.recognize(mat).trim();
        }
        return "";
    }

    public String recognizeWord(ScreenImage simg) {
        BufferedImage img = simg.getImage();
        return this.recognizeWord(img);
    }

    public String recognizeWord(BufferedImage img) {
        if (initSuccess) {
            Mat mat = Image.convertBufferedImageToMat(img);
            return Vision.recognizeWord(mat).trim();
        }
        return "";
    }

    static {
        RunTime.loadLibrary("VisionProxy");
    }

    public static enum ListTextMode {
        WORD,
        LINE,
        PARAGRAPH;

    }
}

