/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.vnc;

import com.sikulix.vnc.VNCClient;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.FindFailed;
import org.sikuli.script.IRobot;
import org.sikuli.script.IScreen;
import org.sikuli.script.Location;
import org.sikuli.script.Region;
import org.sikuli.script.RunTime;
import org.sikuli.script.ScreenImage;
import org.sikuli.util.OverlayCapturePrompt;
import org.sikuli.util.ScreenHighlighter;
import org.sikuli.vnc.VNCRobot;

public class VNCScreen
extends Region
implements IScreen,
Closeable {
    private final VNCClient client;
    private volatile boolean closed;
    private final IRobot robot;
    private ScreenImage lastScreenImage;
    private static Map<VNCScreen, VNCClient> screens = new HashMap<VNCScreen, VNCClient>();

    public static VNCScreen start(String theIP, int thePort, String password, int cTimeout, int timeout) throws IOException {
        VNCScreen scr = null;
        if (RunTime.get().runningMac && !RunTime.get().isJava9("VNCScreen not yet working on Mac")) {
            scr = new VNCScreen(VNCClient.connect((String)theIP, (int)thePort, (String)password, (boolean)true));
            screens.put(scr, scr.client);
        }
        return scr;
    }

    public static VNCScreen start(String theIP, int thePort, int cTimeout, int timeout) throws IOException {
        VNCScreen scr = new VNCScreen(VNCClient.connect((String)theIP, (int)thePort, null, (boolean)true));
        screens.put(scr, scr.client);
        return scr;
    }

    public static VNCScreen start(String theIP, int thePort) throws IOException {
        return VNCScreen.start(theIP, thePort, 0, 0);
    }

    public void stop() {
        try {
            this.close();
        }
        catch (IOException e) {
            Debug.error("VNCScreen: stop: %s", e.getMessage());
        }
        screens.put(this, null);
    }

    public static void stopAll() {
        for (VNCScreen scr : screens.keySet()) {
            if (screens.get(scr) == null) continue;
            try {
                scr.close();
            }
            catch (IOException e) {
                Debug.error("VNCScreen: stopAll: %s", e.getMessage());
            }
        }
        screens.clear();
    }

    private VNCScreen(final VNCClient client) {
        this.client = client;
        this.robot = new VNCRobot(this);
        this.setOtherScreen(this);
        this.setRect(this.getBounds());
        this.initScreen(this);
        new Thread(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        client.processMessages();
                    }
                    catch (RuntimeException e) {
                        if (VNCScreen.this.closed) break block2;
                        throw e;
                    }
                }
            }
        }).start();
        client.refreshFramebuffer();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.client.close();
        screens.put(this, null);
    }

    @Override
    public IRobot getRobot() {
        return this.robot;
    }

    @Override
    public Rectangle getBounds() {
        return this.client.getBounds();
    }

    @Override
    public ScreenImage capture() {
        return this.capture(this.getBounds());
    }

    @Override
    public ScreenImage capture(Region reg) {
        return this.capture(reg.x, reg.y, reg.w, reg.h);
    }

    @Override
    public ScreenImage capture(Rectangle rect) {
        return this.capture(rect.x, rect.y, rect.width, rect.height);
    }

    @Override
    public ScreenImage capture(int x, int y, int w, int h) {
        ScreenImage img;
        BufferedImage image = this.client.getFrameBuffer(x, y, w, h);
        this.lastScreenImage = img = new ScreenImage(new Rectangle(x, y, w, h), image);
        return img;
    }

    @Override
    public void showTarget(Location loc) {
        this.showTarget(loc, Settings.SlowMotionDelay);
    }

    protected void showTarget(Location loc, double secs) {
        if (Settings.isShowActions()) {
            ScreenHighlighter overlay = new ScreenHighlighter(this, null);
            overlay.showTarget(loc, (float)secs);
        }
    }

    @Override
    public int getID() {
        return 0;
    }

    @Override
    public int getIdFromPoint(int srcx, int srcy) {
        return 0;
    }

    @Override
    protected <PSIMRL> Location getLocationFromTarget(PSIMRL target) throws FindFailed {
        Location location = super.getLocationFromTarget(target);
        if (location != null) {
            location.setOtherScreen(this);
        }
        return location;
    }

    @Override
    public ScreenImage getLastScreenImageFromScreen() {
        return this.lastScreenImage;
    }

    @Override
    public ScreenImage userCapture(final String msg) {
        if (this.robot == null) {
            return null;
        }
        final OverlayCapturePrompt prompt = new OverlayCapturePrompt(this);
        Thread th = new Thread(){

            @Override
            public void run() {
                prompt.prompt(msg);
            }
        };
        th.start();
        boolean hasShot = false;
        ScreenImage simg = null;
        int count = 0;
        while (!hasShot) {
            this.wait(0.1f);
            if (count++ > 300) break;
            if (!prompt.isComplete()) continue;
            simg = prompt.getSelection();
            if (simg != null) {
                this.lastScreenImage = simg;
            }
            hasShot = true;
            prompt.close();
        }
        if (!hasShot) {
            prompt.close();
        }
        return simg;
    }

    public VNCClient getClient() {
        return this.client;
    }

    public Region set(Region element) {
        return this.setOther(element);
    }

    public Location set(Location element) {
        return this.setOther(element);
    }

    @Override
    public Region setOther(Region element) {
        element.setOtherScreen(this);
        return element;
    }

    @Override
    public Location setOther(Location element) {
        element.setOtherScreen(this);
        return element;
    }

    @Override
    public Location newLocation(int x, int y) {
        Location loc = new Location(x, y);
        loc.setOtherScreen(this);
        return loc;
    }

    @Override
    public Location newLocation(Location loc) {
        return this.newLocation(loc.x, loc.y);
    }

    @Override
    public Region newRegion(int x, int y, int w, int h) {
        Region reg = Region.create(x, y, w, h);
        reg.setOtherScreen(this);
        return reg;
    }

    @Override
    public Region newRegion(Location loc, int w, int h) {
        return this.newRegion(loc.x, loc.y, w, h);
    }

    @Override
    public Region newRegion(Region reg) {
        return this.newRegion(reg.x, reg.y, reg.w, reg.h);
    }
}

