/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.basics;

import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import org.sikuli.basics.Debug;
import org.sikuli.basics.PreferencesUser;
import org.sikuli.basics.Settings;
import org.sikuli.basics.SplashFrame;
import org.sikuli.script.Image;
import org.sikuli.script.ImagePath;
import org.sikuli.script.Sikulix;
import org.sikuli.script.support.RunTime;

public class FileManager {
    private static String me = "FileManager";
    private static int lvl = 3;
    static final int DOWNLOAD_BUFFER_SIZE = 153600;
    private static SplashFrame _progress = null;
    private static final String EXECUTABLE = "#executable";
    private static String makeFileListString;
    private static String makeFileListPrefix;

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + ": " + message, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int tryGetFileSize(URL aUrl) {
        HttpURLConnection conn = null;
        try {
            conn = FileManager.getProxy() != null ? (HttpURLConnection)aUrl.openConnection(FileManager.getProxy()) : (HttpURLConnection)aUrl.openConnection();
            conn.setConnectTimeout(30000);
            conn.setReadTimeout(30000);
            conn.setRequestMethod("HEAD");
            conn.getInputStream();
            int n = conn.getContentLength();
            return n;
        }
        catch (Exception ex) {
            int n = 0;
            return n;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static int isUrlUseabel(String sURL) {
        try {
            return FileManager.isUrlUseabel(new URL(sURL));
        }
        catch (Exception ex) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int isUrlUseabel(URL aURL) {
        HttpURLConnection conn = null;
        try {
            conn = FileManager.getProxy() != null ? (HttpURLConnection)aURL.openConnection(FileManager.getProxy()) : (HttpURLConnection)aURL.openConnection();
            conn.setRequestMethod("HEAD");
            int retval = conn.getResponseCode();
            if (retval == 200) {
                int n = 1;
                return n;
            }
            if (retval == 404) {
                int n = 0;
                return n;
            }
            if (retval == 403) {
                int n = 0;
                return n;
            }
            int n = -1;
            return n;
        }
        catch (Exception ex) {
            int n = -1;
            return n;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    public static Proxy getProxy() {
        Proxy proxy = Settings.proxy;
        if (!Settings.proxyChecked) {
            String phost = Settings.proxyName;
            String padr = Settings.proxyIP;
            String pport = Settings.proxyPort;
            InetAddress a = null;
            int p = -1;
            if (phost != null) {
                a = FileManager.getProxyAddress(phost);
            }
            if (a == null && padr != null) {
                a = FileManager.getProxyAddress(padr);
            }
            if (a != null && pport != null) {
                p = FileManager.getProxyPort(pport);
            }
            if (a != null && p > 1024) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(a, p));
                FileManager.log(lvl, "Proxy defined: %s : %d", a.getHostAddress(), p);
            }
            Settings.proxyChecked = true;
            Settings.proxy = proxy;
        }
        return proxy;
    }

    public static InetAddress getProxyAddress(String arg) {
        try {
            return InetAddress.getByName(arg);
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    public static int getProxyPort(String p) {
        int port;
        int pDefault = 8080;
        if (p != null) {
            try {
                port = Integer.parseInt(p);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        } else {
            return pDefault;
        }
        return port;
    }

    public static boolean setProxy(String pName, String pPort) {
        InetAddress a = null;
        String host = null;
        String adr = null;
        int p = -1;
        if (pName != null) {
            a = FileManager.getProxyAddress(pName);
            if (a == null) {
                a = FileManager.getProxyAddress(pName);
                if (a != null) {
                    adr = pName;
                }
            } else {
                host = pName;
            }
        }
        if (a != null && pPort != null) {
            p = FileManager.getProxyPort(pPort);
        }
        if (a != null && p > 1024) {
            FileManager.log(lvl, "Proxy stored: %s : %d", a.getHostAddress(), p);
            Settings.proxyChecked = true;
            Settings.proxyName = host;
            Settings.proxyIP = adr;
            Settings.proxyPort = pPort;
            Settings.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(a, p));
            PreferencesUser prefs = PreferencesUser.get();
            prefs.put("ProxyName", host == null ? "" : host);
            prefs.put("ProxyIP", adr == null ? "" : adr);
            prefs.put("ProxyPort", "" + p);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadURL(URL url, String localPath) {
        String[] path = url.getPath().split("/");
        String filename = path[path.length - 1];
        String targetPath = null;
        int srcLength = 1;
        int srcLengthKB = 0;
        int totalBytesRead = 0;
        File fullpath = new File(localPath);
        if (fullpath.exists()) {
            if (fullpath.isFile()) {
                FileManager.log(-1, "download: target path must be a folder:\n%s", localPath);
                fullpath = null;
            }
        } else if (!fullpath.mkdirs()) {
            FileManager.log(-1, "download: could not create target folder:\n%s", localPath);
            fullpath = null;
        }
        if (fullpath != null) {
            srcLength = FileManager.tryGetFileSize(url);
            srcLengthKB = srcLength / 1024;
            if (srcLength > 0) {
                FileManager.log(lvl, "Downloading %s having %d KB", filename, srcLengthKB);
            } else {
                FileManager.log(lvl, "Downloading %s with unknown size", filename);
            }
            fullpath = new File(localPath, filename);
            targetPath = fullpath.getAbsolutePath();
            int done = 0;
            if (_progress != null) {
                _progress.setProFile(filename);
                _progress.setProSize(srcLengthKB);
                _progress.setProDone(0);
                _progress.setVisible(true);
            }
            InputStream reader = null;
            FileOutputStream writer = null;
            try {
                writer = new FileOutputStream(fullpath);
                reader = FileManager.getProxy() != null ? url.openConnection(FileManager.getProxy()).getInputStream() : url.openConnection().getInputStream();
                byte[] buffer = new byte[153600];
                int bytesRead = 0;
                long begin_t = new Date().getTime();
                long chunk = new Date().getTime();
                while ((bytesRead = reader.read(buffer)) > 0) {
                    writer.write(buffer, 0, bytesRead);
                    done = srcLength > 0 ? (int)((double)totalBytesRead / (double)srcLength * 100.0) : (totalBytesRead += bytesRead) / 1024;
                    if (new Date().getTime() - chunk <= 1000L) continue;
                    if (_progress != null) {
                        _progress.setProDone(done);
                    }
                    chunk = new Date().getTime();
                }
                writer.close();
                FileManager.log(lvl, "downloaded %d KB to:\n%s", totalBytesRead / 1024, targetPath);
                FileManager.log(lvl, "download time: %d", (int)((new Date().getTime() - begin_t) / 1000L));
            }
            catch (Exception ex) {
                FileManager.log(-1, "problems while downloading\n%s", ex);
                targetPath = null;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            if (_progress != null) {
                if (targetPath == null) {
                    _progress.setProDone(-1);
                } else {
                    if (srcLength <= 0) {
                        _progress.setProSize(totalBytesRead / 1024);
                    }
                    _progress.setProDone(100);
                }
                _progress.closeAfter(3);
                _progress = null;
            }
        }
        if (targetPath == null) {
            fullpath.delete();
        }
        return targetPath;
    }

    public static String downloadURL(String url, String localPath) {
        URL urlSrc = null;
        try {
            urlSrc = new URL(url);
        }
        catch (MalformedURLException ex) {
            FileManager.log(-1, "download: bad URL: " + url, new Object[0]);
            return null;
        }
        return FileManager.downloadURL(urlSrc, localPath);
    }

    public static String downloadURL(String url, String localPath, JFrame progress) {
        _progress = (SplashFrame)progress;
        return FileManager.downloadURL(url, localPath);
    }

    public static String downloadURLtoString(String src) {
        boolean silent = false;
        if (src.startsWith("#")) {
            silent = true;
            src = src.substring(1);
        }
        URL url = null;
        try {
            url = new URL(src);
        }
        catch (MalformedURLException ex) {
            FileManager.log(-1, "download to string: bad URL:\n%s", src);
            return null;
        }
        return FileManager.downloadURLtoString(url, silent);
    }

    public static String downloadURLtoString(URL uSrc) {
        return FileManager.downloadURLtoString(uSrc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String downloadURLtoString(URL uSrc, boolean silent) {
        String content = "";
        InputStream reader = null;
        if (!silent) {
            FileManager.log(lvl, "download to string from:\n%s,", uSrc);
        }
        try {
            reader = FileManager.getProxy() != null ? uSrc.openConnection(FileManager.getProxy()).getInputStream() : uSrc.openConnection().getInputStream();
            byte[] buffer = new byte[153600];
            int bytesRead = 0;
            while ((bytesRead = reader.read(buffer)) > 0) {
                content = content + new String(Arrays.copyOfRange(buffer, 0, bytesRead), Charset.forName("utf-8"));
            }
        }
        catch (Exception ex) {
            if (!silent) {
                FileManager.log(-1, "problems while downloading\n" + ex.getMessage(), new Object[0]);
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return content;
    }

    public static boolean openURL(String url) {
        try {
            URL u = new URL(url);
            Desktop.getDesktop().browse(u.toURI());
        }
        catch (Exception ex) {
            FileManager.log(-1, "show in browser: bad URL: " + url, new Object[0]);
            return false;
        }
        return true;
    }

    public static File createTempDir(String path) {
        File fTempDir = new File(RunTime.get().fpBaseTempPath, path);
        FileManager.log(lvl, "createTempDir:\n%s", fTempDir);
        if (!fTempDir.exists()) {
            fTempDir.mkdirs();
        } else {
            FileManager.resetFolder(fTempDir);
        }
        if (!fTempDir.exists()) {
            FileManager.log(-1, "createTempDir: not possible: %s", fTempDir);
            return null;
        }
        return fTempDir;
    }

    public static File createTempDir() {
        File fTempDir = FileManager.createTempDir("tmp-" + FileManager.getRandomInt() + ".sikuli");
        if (null != fTempDir) {
            fTempDir.deleteOnExit();
        }
        return fTempDir;
    }

    public static int getRandomInt() {
        int rand = 1 + new Random().nextInt();
        return rand < 0 ? rand * -1 : rand;
    }

    public static void deleteTempDir(String path) {
        if (!FileManager.deleteFileOrFolder(path)) {
            FileManager.log(-1, "deleteTempDir: not possible", new Object[0]);
        }
    }

    public static boolean deleteFileOrFolder(File fPath, FileFilter filter) {
        return FileManager.doDeleteFileOrFolder(fPath, filter);
    }

    public static boolean deleteFileOrFolder(File fPath) {
        return FileManager.doDeleteFileOrFolder(fPath, null);
    }

    public static boolean deleteFileOrFolder(String fpPath, FileFilter filter) {
        if (fpPath.startsWith("#")) {
            fpPath = fpPath.substring(1);
        } else {
            FileManager.log(lvl, "deleteFileOrFolder: %s\n%s", filter == null ? "" : "filtered: ", fpPath);
        }
        return FileManager.doDeleteFileOrFolder(new File(fpPath), filter);
    }

    public static boolean deleteFileOrFolder(String fpPath) {
        if (fpPath.startsWith("#")) {
            fpPath = fpPath.substring(1);
        } else {
            FileManager.log(lvl, "deleteFileOrFolder:\n%s", fpPath);
        }
        return FileManager.doDeleteFileOrFolder(new File(fpPath), null);
    }

    public static void resetFolder(File fPath) {
        FileManager.log(lvl, "resetFolder:\n%s", fPath);
        FileManager.doDeleteFileOrFolder(fPath, null);
        fPath.mkdirs();
    }

    private static boolean doDeleteFileOrFolder(File fPath, FileFilter filter) {
        if (fPath == null) {
            return false;
        }
        boolean somethingLeft = false;
        if (fPath.exists() && fPath.isDirectory()) {
            String[] entries = fPath.list();
            for (int i = 0; i < entries.length; ++i) {
                File aFile = new File(fPath, entries[i]);
                if (filter != null && !filter.accept(aFile)) {
                    somethingLeft = true;
                    continue;
                }
                if (aFile.isDirectory()) {
                    if (FileManager.doDeleteFileOrFolder(aFile, filter)) continue;
                    return false;
                }
                try {
                    aFile.delete();
                    continue;
                }
                catch (Exception ex) {
                    FileManager.log(-1, "deleteFile: not deleted:\n%s\n%s", aFile, ex);
                    return false;
                }
            }
        }
        if (!somethingLeft && fPath.exists()) {
            try {
                fPath.delete();
            }
            catch (Exception ex) {
                FileManager.log(-1, "deleteFolder: not deleted:\n" + fPath.getAbsolutePath() + "\n" + ex.getMessage(), new Object[0]);
                return false;
            }
        }
        return true;
    }

    public static void traverseFolder(File fPath, FileFilter filter) {
        if (fPath == null) {
            return;
        }
        if (fPath.isDirectory()) {
            String[] entries = fPath.list();
            for (int i = 0; i < entries.length; ++i) {
                File aFile = new File(fPath, entries[i]);
                if (filter != null) {
                    filter.accept(aFile);
                }
                if (!aFile.isDirectory()) continue;
                FileManager.traverseFolder(aFile, filter);
            }
        }
    }

    public static File createTempFile(String suffix) {
        return FileManager.createTempFile(suffix, null);
    }

    public static File createTempFile(String suffix, String path) {
        String fPrefix = "sikulitemp-";
        String fSuffix = "." + suffix;
        File fpath = new File(RunTime.get().fpBaseTempPath);
        if (path != null) {
            fpath = new File(path);
        }
        try {
            fpath.mkdirs();
            File temp = File.createTempFile(fPrefix, fSuffix, fpath);
            temp.deleteOnExit();
            return temp;
        }
        catch (IOException ex) {
            FileManager.log(-1, "createTempFile: IOException: %s\n%s", ex.getMessage(), fpath + File.separator + fPrefix + "12....56" + fSuffix);
            return null;
        }
    }

    public static String saveTmpImage(BufferedImage img) {
        return FileManager.saveTmpImage(img, null);
    }

    public static String saveTmpImage(BufferedImage img, String path) {
        try {
            File tempFile = FileManager.createTempFile("png", path);
            if (tempFile != null) {
                ImageIO.write((RenderedImage)img, "png", tempFile);
                return tempFile.getAbsolutePath();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String saveTimedImage(BufferedImage img) {
        return FileManager.saveTimedImage(img, ImagePath.getBundlePath(), null);
    }

    public static String saveTimedImage(BufferedImage img, String path) {
        return FileManager.saveTimedImage(img, path, null);
    }

    public static String saveTimedImage(BufferedImage img, String path, String name) {
        RunTime.pause(0.01f);
        if (null == path) {
            return null;
        }
        if (name == null) {
            name = "nonamegiven";
        }
        File fImage = new File(path, String.format("%s-%d.png", name, new Date().getTime()));
        try {
            ImageIO.write((RenderedImage)img, "png", fImage);
        }
        catch (Exception ex) {
            FileManager.log(-1, "saveTimedImage: did not work: %s (%s)", fImage, ex.getMessage());
            return null;
        }
        return fImage.getAbsolutePath();
    }

    public static boolean unzip(String inpZip, String target) {
        return FileManager.unzip(new File(inpZip), new File(target));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean unzip(File fZip, File fTarget) {
        block20: {
            String fpZip = null;
            String fpTarget = null;
            FileManager.log(lvl, "unzip: from: %s\nto: %s", fZip, fTarget);
            try {
                fpZip = fZip.getCanonicalPath();
                if (!new File(fpZip).exists()) {
                    throw new IOException();
                }
            }
            catch (IOException ex) {
                FileManager.log(-1, "unzip: source not found:\n%s\n%s", fpZip, ex);
                return false;
            }
            try {
                fpTarget = fTarget.getCanonicalPath();
                FileManager.deleteFileOrFolder(fpTarget);
                new File(fpTarget).mkdirs();
                if (!new File(fpTarget).exists()) {
                    throw new IOException();
                }
            }
            catch (IOException ex) {
                FileManager.log(-1, "unzip: target cannot be created:\n%s\n%s", fpTarget, ex);
                return false;
            }
            ZipInputStream inpZip = null;
            ZipEntry entry = null;
            int BUF_SIZE = 2048;
            inpZip = new ZipInputStream(new BufferedInputStream(new FileInputStream(fZip)));
            while ((entry = inpZip.getNextEntry()) != null) {
                int count;
                if (entry.getName().endsWith("/") || entry.getName().endsWith("\\")) {
                    new File(fpTarget, entry.getName()).mkdir();
                    continue;
                }
                byte[] data = new byte[2048];
                File outFile = new File(fpTarget, entry.getName());
                File outFileParent = outFile.getParentFile();
                if (!outFileParent.exists()) {
                    outFileParent.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(outFile);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                while ((count = inpZip.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.close();
            }
            try {
                inpZip.close();
            }
            catch (IOException ex) {
                FileManager.log(-1, "unzip: closing source:\n%s\n%s", fpZip, ex);
            }
            break block20;
            catch (Exception ex) {
                boolean bl;
                try {
                    FileManager.log(-1, "unzip: not possible: source:\n%s\ntarget:\n%s\n(%s)%s", fpZip, fpTarget, entry.getName(), ex);
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        inpZip.close();
                    }
                    catch (IOException ex2) {
                        FileManager.log(-1, "unzip: closing source:\n%s\n%s", fpZip, ex2);
                    }
                    throw throwable;
                }
                try {
                    inpZip.close();
                }
                catch (IOException ex3) {
                    FileManager.log(-1, "unzip: closing source:\n%s\n%s", fpZip, ex3);
                }
                return bl;
            }
        }
        return true;
    }

    public static boolean xcopy(File fSrc, File fDest) {
        if (fSrc == null || fDest == null) {
            return false;
        }
        try {
            FileManager.doXcopy(fSrc, fDest, null);
        }
        catch (Exception ex) {
            FileManager.log(lvl, "xcopy from: %s\nto: %s\n%s", fSrc, fDest, ex);
            return false;
        }
        return true;
    }

    public static boolean xcopy(File fSrc, File fDest, FileFilter filter) {
        if (fSrc == null || fDest == null) {
            return false;
        }
        try {
            FileManager.doXcopy(fSrc, fDest, filter);
        }
        catch (Exception ex) {
            FileManager.log(lvl, "xcopy from: %s\nto: %s\n%s", fSrc, fDest, ex);
            return false;
        }
        return true;
    }

    public static void xcopy(String src, String dest) throws IOException {
        FileManager.doXcopy(new File(src), new File(dest), null);
    }

    public static void xcopy(String src, String dest, FileFilter filter) throws IOException {
        FileManager.doXcopy(new File(src), new File(dest), filter);
    }

    private static void doXcopy(File fSrc, File fDest, FileFilter filter) throws IOException {
        block9: {
            block8: {
                String[] children;
                if (fSrc.getAbsolutePath().equals(fDest.getAbsolutePath())) {
                    return;
                }
                if (!fSrc.isDirectory()) break block8;
                if (filter != null && !filter.accept(fSrc)) break block9;
                if (!fDest.exists()) {
                    fDest.mkdirs();
                }
                for (String child : children = fSrc.list()) {
                    if (child.equals(fDest.getName())) continue;
                    FileManager.doXcopy(new File(fSrc, child), new File(fDest, child), filter);
                }
                break block9;
            }
            if (filter == null || filter.accept(fSrc)) {
                try {
                    int len;
                    if (fDest.isDirectory()) {
                        fDest = new File(fDest, fSrc.getName());
                    }
                    FileInputStream in = new FileInputStream(fSrc);
                    FileOutputStream out = new FileOutputStream(fDest);
                    byte[] buf = new byte[1024];
                    while ((len = ((InputStream)in).read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
                catch (IOException ex) {
                    FileManager.log(-1, "xcopy: %s to: %s (%s)", fSrc, fDest, ex.getMessage());
                    throw new IOException(ex.getMessage(), ex.getCause());
                }
            }
        }
    }

    public static String makeFileList(File path, String prefix) {
        makeFileListPrefix = prefix;
        return FileManager.makeFileListDo(path, true);
    }

    private static String makeFileListDo(File path, boolean starting) {
        if (starting) {
            makeFileListString = "";
        }
        if (!path.exists()) {
            return makeFileListString;
        }
        if (path.isDirectory()) {
            String[] fcl;
            for (String fc : fcl = path.list()) {
                FileManager.makeFileListDo(new File(path, fc), false);
            }
        } else {
            String x = path.getAbsolutePath();
            if (!makeFileListPrefix.isEmpty() && (x = x.replace(makeFileListPrefix, "").replace("\\", "/")).startsWith("/")) {
                x = x.substring(1);
            }
            makeFileListString = makeFileListString + x + "\n";
        }
        return makeFileListString;
    }

    public static File smartCopy(String src, String dest) throws IOException {
        File fSrc = new File(src);
        String newName = fSrc.getName();
        File fDest = new File(dest, newName);
        if (fSrc.equals(fDest)) {
            return fDest;
        }
        while (fDest.exists()) {
            newName = FileManager.getAltFilename(newName);
            fDest = new File(dest, newName);
        }
        FileManager.xcopy(src, fDest.getAbsolutePath());
        if (fDest.exists()) {
            return fDest;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String getAltFilename(String filename) {
        String name;
        int pDot = filename.lastIndexOf(46);
        int pDash = filename.lastIndexOf(45);
        String postfix = filename.substring(pDot);
        String versionText = "1";
        if (pDash >= 0) {
            name = filename.substring(0, pDash);
            versionText = filename.substring(pDash + 1, pDot);
            try {
                versionText = "" + (Integer.parseInt(versionText) + 1);
            }
            catch (NumberFormatException e) {
                versionText = versionText + "-1";
            }
        } else {
            name = filename.substring(0, pDot);
        }
        return name + "-" + versionText + postfix;
    }

    public static boolean exists(String path) {
        File f = new File(path);
        return f.exists();
    }

    public static void mkdir(String path) {
        File f = new File(path);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static String getName(String filename) {
        File f = new File(filename);
        return f.getName();
    }

    public static String slashify(String path, Boolean isDirectory) {
        if (path != null) {
            if (path.contains("%")) {
                try {
                    path = URLDecoder.decode(path, "UTF-8");
                }
                catch (Exception ex) {
                    FileManager.log(-1, "slashify: filename might not be useable: %s", path);
                }
            }
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (isDirectory != null) {
                if (isDirectory.booleanValue()) {
                    if (!path.endsWith("/")) {
                        path = path + "/";
                    }
                } else if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
            }
            if (path.startsWith("./")) {
                path = path.substring(2);
            }
            FileManager.log(lvl, "slashify: file: %s", path);
            return path;
        }
        FileManager.log(lvl, "slashify: file: null", new Object[0]);
        return "";
    }

    public static String normalize(String path) {
        String pathNormalized = path;
        if (path != null) {
            if (path.contains("%")) {
                try {
                    pathNormalized = URLDecoder.decode(path, "UTF-8");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!new File(pathNormalized).isAbsolute() && pathNormalized.startsWith("\\")) {
                pathNormalized = new File(pathNormalized).getAbsoluteFile().getPath();
            }
        }
        return pathNormalized;
    }

    public static String normalizeAbsolute(String filename) {
        filename = FileManager.normalize(filename);
        String jarSuffix = "";
        int nJarSuffix = filename.indexOf(".jar!");
        if (0 < nJarSuffix) {
            jarSuffix = filename.substring(nJarSuffix + 4);
            filename = filename.substring(0, nJarSuffix + 4);
        }
        File aFile = new File(filename);
        try {
            aFile = aFile.getCanonicalFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileManager.log(lvl, "normalizeAbsolute: file: %s", aFile);
        return aFile.getPath() + jarSuffix;
    }

    public static boolean isFilenameDotted(String name) {
        String nameParent = new File(name).getParent();
        return nameParent != null && nameParent.contains(".");
    }

    public static File resolveImagePath(File scriptFile) {
        if (!scriptFile.isDirectory()) {
            return scriptFile.getParentFile();
        }
        return scriptFile;
    }

    public static URL makeURL(String fName) {
        return FileManager.makeURL(fName, "file");
    }

    public static URL makeJarURL(File fJar) {
        return FileManager.makeURL(fJar.getAbsolutePath(), "jar");
    }

    public static URL makeURL(String fName, String type) {
        try {
            File aFile;
            if ("file".equals(type) && !(fName = FileManager.normalizeAbsolute(fName)).startsWith("/")) {
                fName = "/" + fName;
            }
            if ("jar".equals(type)) {
                if (!fName.contains("!/")) {
                    fName = fName + "!/";
                }
                fName = fName.startsWith("file:") ? "jar:" + fName : "jar:file:" + fName;
                URL url = new URL(fName);
                return url;
            }
            if ("file".equals(type) && (aFile = new File(fName)).exists() && aFile.isDirectory() && !fName.endsWith("/")) {
                fName = fName + "/";
            }
            return new URL(type, null, fName);
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static URL makeURL(URL path, String fName) {
        try {
            if ("file".equals(path.getProtocol())) {
                return FileManager.makeURL(new File(path.getFile(), fName).getAbsolutePath());
            }
            if ("jar".equals(path.getProtocol())) {
                String jp = path.getPath();
                if (!jp.contains("!/")) {
                    jp = jp + "!/";
                }
                String jpu = "jar:" + jp;
                jpu = jp.endsWith("!/") ? jpu + fName : jpu + "/" + fName;
                return new URL(jpu);
            }
            return new URL(path, FileManager.slashify(fName, false));
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    public static URL getURLForContentFromURL(URL uRes, String fName) {
        URL aURL = null;
        if ("jar".equals(uRes.getProtocol())) {
            return FileManager.makeURL(uRes, fName);
        }
        if ("file".equals(uRes.getProtocol())) {
            aURL = FileManager.makeURL(new File(FileManager.slashify(uRes.getPath(), false), FileManager.slashify(fName, false)).getPath(), uRes.getProtocol());
        } else if (uRes.getProtocol().startsWith("http")) {
            String sRes = uRes.toString();
            if (!sRes.endsWith("/")) {
                sRes = sRes + "/";
            }
            try {
                aURL = new URL(sRes + fName);
                if (1 == FileManager.isUrlUseabel(aURL)) {
                    return aURL;
                }
                return null;
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        try {
            if (aURL != null) {
                aURL.getContent();
                return aURL;
            }
        }
        catch (IOException ex) {
            return null;
        }
        return aURL;
    }

    public static boolean checkJarContent(String jarPath, String jarContent) {
        URL jpu = FileManager.makeURL(jarPath, "jar");
        if (jpu != null && jarContent != null) {
            jpu = FileManager.makeURL(jpu, jarContent);
        }
        if (jpu != null) {
            try {
                jpu.getContent();
                return true;
            }
            catch (IOException ex) {
                ex.getMessage();
            }
        }
        return false;
    }

    public static int getPort(String p) {
        int port;
        int pDefault = 50000;
        if (p != null) {
            try {
                port = Integer.parseInt(p);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        } else {
            return pDefault;
        }
        if (port < 1024) {
            port += pDefault;
        }
        return port;
    }

    public static String getAddress(String arg) {
        try {
            if (arg == null) {
                return InetAddress.getLocalHost().getHostAddress();
            }
            return InetAddress.getByName(arg).getHostAddress();
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    public static String saveImage(BufferedImage img, String sImage, String bundlePath) {
        int count;
        int MAX_ALT_NUM = 3;
        String fullpath = bundlePath;
        File fBundle = new File(fullpath);
        if (!fBundle.exists()) {
            fBundle.mkdir();
        }
        if (!sImage.endsWith(".png")) {
            sImage = sImage + ".png";
        }
        File fImage = new File(fBundle, sImage);
        boolean shouldReload = false;
        String msg = fImage.getName() + " exists - using ";
        for (count = 0; count < 3; ++count) {
            if (fImage.exists()) {
                if (Settings.OverwriteImages) {
                    shouldReload = true;
                    break;
                }
            } else {
                if (count <= 0) break;
                Debug.log(msg + fImage.getName() + " (Utils.saveImage)", new Object[0]);
                break;
            }
            fImage = new File(fBundle, FileManager.getAltFilename(fImage.getName()));
        }
        if (count >= 3) {
            fImage = new File(fBundle, Settings.getTimestamp() + ".png");
            Debug.log(msg + fImage.getName() + " (Utils.saveImage)", new Object[0]);
        }
        String fpImage = fImage.getAbsolutePath();
        fpImage = fpImage.replaceAll("\\\\", "/");
        try {
            ImageIO.write((RenderedImage)img, "png", new File(fpImage));
        }
        catch (IOException e) {
            Debug.error("Util.saveImage: Problem trying to save image file: %s\n%s", fpImage, e.getMessage());
            return null;
        }
        if (shouldReload) {
            Image.reload(sImage);
        }
        return fpImage;
    }

    public static void deleteNotUsedImages(String bundle, Set<String> usedImages) {
        File scriptFolder = new File(bundle);
        if (!scriptFolder.isDirectory()) {
            return;
        }
        for (File image : scriptFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name.endsWith(".png") || name.endsWith(".jpg") || name.endsWith(".jpeg")) && !name.startsWith("_");
            }
        })) {
            if (usedImages.contains(image.getName())) continue;
            Debug.log(3, "FileManager: delete not used: %s", image.getName());
            image.delete();
        }
    }

    public static boolean isBundle(String dir) {
        return dir.endsWith(".sikuli");
    }

    public static String getJarPath(Class cname) {
        CodeSource src = cname.getProtectionDomain().getCodeSource();
        if (src.getLocation() != null) {
            return new File(src.getLocation().getPath()).getAbsolutePath();
        }
        return "";
    }

    public static String getJarName(Class cname) {
        String jp = FileManager.getJarPath(cname);
        if (jp.isEmpty()) {
            return "";
        }
        return new File(jp).getName();
    }

    public static boolean writeStringToFile(String text, String path) {
        return FileManager.writeStringToFile(text, new File(path));
    }

    public static boolean writeStringToFile(String text, File fPath) {
        PrintStream out = null;
        try {
            out = new PrintStream((OutputStream)new FileOutputStream(fPath), false, "UTF-8");
            out.print(text);
        }
        catch (Exception e) {
            FileManager.log(-1, "writeStringToFile: did not work: " + fPath + "\n" + e.getMessage(), new Object[0]);
        }
        if (out != null) {
            out.close();
            return true;
        }
        return false;
    }

    public static String readFileToString(File fPath) {
        try {
            return FileManager.doRreadFileToString(fPath);
        }
        catch (Exception ex) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String doRreadFileToString(File fPath) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(fPath));
            char[] buf = new char[1024];
            int r = 0;
            while ((r = reader.read(buf)) != -1) {
                result.append(buf, 0, r);
            }
        }
        return result.toString();
    }

    public static String makeScriptjar(List<String> options) {
        File fSikulixTemp = new File(RunTime.get().fSikulixStore, "SikulixTemp");
        FileManager.resetFolder(fSikulixTemp);
        String target = FileManager.doMakeScriptjar(options, fSikulixTemp);
        FileManager.deleteFileOrFolder(fSikulixTemp);
        return target;
    }

    private static String doMakeScriptjar(List<String> options, File fSikulixTemp) {
        String targetJar;
        boolean makingScriptjarPlain = false;
        RunTime runTime = RunTime.get();
        if (options.size() > 0 && "plain".equals(options.get(0))) {
            makingScriptjarPlain = true;
            options.remove(0);
        }
        File scriptFile = null;
        File scriptFolder = null;
        File scriptFolderSikuli = null;
        String scriptName = null;
        String[] fileList = new String[]{null, null, null};
        String[] preList = new String[]{null, null, null};
        if (options.size() > 0) {
            scriptFolder = new File(options.get(0));
            if (!scriptFolder.exists()) {
                scriptFolderSikuli = new File(scriptFolder.getAbsolutePath() + ".sikuli");
                if (!scriptFolderSikuli.exists()) {
                    FileManager.log(-1, "makingScriptJar: script folder invalid: " + scriptFolder.getAbsolutePath(), new Object[0]);
                    return null;
                }
            } else if (scriptFolder.getAbsolutePath().endsWith(".sikuli")) {
                scriptFolderSikuli = scriptFolder;
            } else {
                scriptFile = new File(scriptFolder, "__run__.py");
                if (!scriptFile.exists()) {
                    FileManager.log(-1, "makingScriptJar: script file missing: " + scriptFile.getAbsolutePath(), new Object[0]);
                    return null;
                }
            }
        } else {
            FileManager.log(-1, "makingScriptJar: no script file given", new Object[0]);
            return null;
        }
        String fpScriptJar = "";
        File fScriptSource = new File(fSikulixTemp, "scriptSource");
        File fScriptCompiled = new File(fSikulixTemp, "scriptCompiled");
        File fWorkdir = scriptFolder.getParentFile();
        FileFilter skipCompiled = new FileFilter(){

            @Override
            public boolean accept(File entry) {
                return !entry.getName().contains("$py.class");
            }
        };
        if (null != scriptFolderSikuli) {
            FileManager.log(lvl, "makingScriptJar: compiling sikuli script: %s", scriptFolderSikuli);
            fWorkdir = scriptFolderSikuli.getParentFile();
            scriptName = scriptFolder.getName().replace(".sikuli", "");
            fpScriptJar = scriptName + "_sikuli.jar";
            scriptFile = new File(scriptFolderSikuli, scriptName + ".py");
            if (!scriptFile.exists()) {
                FileManager.log(-1, "makingScriptJar: script folder invalid: " + scriptFolderSikuli.getAbsolutePath(), new Object[0]);
                return null;
            }
            FileManager.xcopy(scriptFolderSikuli, fScriptSource, skipCompiled);
            String script = "";
            String prolog = "import org.sikuli.script.SikulixForJython\nfrom sikuli import *\nDebug.on(3)\nfor e in sys.path:\n    print e\n    if e.endswith(\".jar\"):\n        jar = e\n        break\nImagePath.addJar(jar, \"\")\nimport " + scriptName + "\n";
            FileManager.writeStringToFile(prolog + script, new File(fScriptSource, "__run__.py"));
            FileManager.writeStringToFile(prolog + script, new File(fScriptSource, "__main__.py"));
            script = FileManager.readFileToString(new File(fScriptSource, scriptName + ".py"));
            prolog = "from sikuli import *\n";
            FileManager.writeStringToFile(prolog + script, new File(fScriptSource, scriptName + ".py"));
        } else {
            FileManager.log(lvl, "makingScriptJar: compiling plain script: %s", scriptFolder);
            FileManager.xcopy(scriptFolder, fScriptSource, skipCompiled);
        }
        Sikulix.compileJythonFolder(fScriptSource.getAbsolutePath(), fScriptCompiled.getAbsolutePath());
        FileManager.xcopy(fScriptCompiled, fSikulixTemp);
        FileManager.deleteFileOrFolder(fScriptSource);
        FileManager.deleteFileOrFolder(fScriptCompiled);
        fileList[0] = fSikulixTemp.getAbsolutePath();
        String[] jarsList = new String[]{null, null};
        if (!makingScriptjarPlain) {
            // empty if block
        }
        if (!FileManager.buildJar(targetJar = new File(fWorkdir, fpScriptJar).getAbsolutePath(), jarsList, fileList, preList, new JarFileFilter(){

            @Override
            public boolean accept(ZipEntry entry, String jarname) {
                return !entry.getName().startsWith("META-INF");
            }
        })) {
            FileManager.log(-1, "makingScriptJar: problems building jar - for details see logfile", new Object[0]);
            return null;
        }
        FileManager.log(lvl, "makingScriptJar: ended successfully: %s", targetJar);
        return targetJar;
    }

    public static boolean packJar(String folderName, String jarName, String prefix) {
        if (!(jarName = FileManager.slashify(jarName, false)).endsWith(".jar")) {
            jarName = jarName + ".jar";
        }
        if (!new File(folderName = FileManager.slashify(folderName, true)).isDirectory()) {
            FileManager.log(-1, "packJar: not a directory or does not exist: " + folderName, new Object[0]);
            return false;
        }
        try {
            File dir = new File(new File(jarName).getAbsolutePath()).getParentFile();
            if (dir != null) {
                if (!dir.exists()) {
                    dir.mkdirs();
                }
            } else {
                throw new Exception("workdir is null");
            }
            FileManager.log(lvl, "packJar: %s from %s in workDir %s", jarName, folderName, dir.getAbsolutePath());
            if (!folderName.startsWith("http://") && !folderName.startsWith("https://")) {
                folderName = "file://" + new File(folderName).getAbsolutePath();
            }
            URL src = new URL(folderName);
            JarOutputStream jout = new JarOutputStream(new FileOutputStream(jarName));
            FileManager.addToJar(jout, new File(src.getFile()), prefix);
            jout.close();
        }
        catch (Exception ex) {
            FileManager.log(-1, "packJar: " + ex.getMessage(), new Object[0]);
            return false;
        }
        FileManager.log(lvl, "packJar: completed", new Object[0]);
        return true;
    }

    public static boolean buildJar(String targetJar, String[] jars, String[] files, String[] prefixs, JarFileFilter filter) {
        boolean logShort = false;
        if (targetJar.startsWith("#")) {
            logShort = true;
            targetJar = targetJar.substring(1);
            FileManager.log(lvl, "buildJar: %s", new File(targetJar).getName());
        } else {
            FileManager.log(lvl, "buildJar:\n%s", targetJar);
        }
        try {
            int i;
            JarOutputStream jout = new JarOutputStream(new FileOutputStream(targetJar));
            ArrayList<String> done = new ArrayList<String>();
            for (i = 0; i < jars.length; ++i) {
                if (jars[i] == null) continue;
                if (logShort) {
                    FileManager.log(lvl, "buildJar: adding: %s", new File(jars[i]).getName());
                } else {
                    FileManager.log(lvl, "buildJar: adding:\n%s", jars[i]);
                }
                BufferedInputStream bin = new BufferedInputStream(new FileInputStream(jars[i]));
                ZipInputStream zin = new ZipInputStream(bin);
                ZipEntry zipentry = zin.getNextEntry();
                while (zipentry != null) {
                    if ((filter == null || filter.accept(zipentry, jars[i])) && !done.contains(zipentry.getName())) {
                        jout.putNextEntry(zipentry);
                        if (!zipentry.isDirectory()) {
                            FileManager.bufferedWrite(zin, jout);
                        }
                        done.add(zipentry.getName());
                        FileManager.log(lvl + 1, "adding: %s", zipentry.getName());
                    }
                    zipentry = zin.getNextEntry();
                }
                zin.close();
                bin.close();
            }
            if (files != null) {
                for (i = 0; i < files.length; ++i) {
                    if (files[i] == null) continue;
                    if (logShort) {
                        FileManager.log(lvl, "buildJar: adding %s at %s", new File(files[i]).getName(), prefixs[i]);
                    } else {
                        FileManager.log(lvl, "buildJar: adding %s at %s", files[i], prefixs[i]);
                    }
                    FileManager.addToJar(jout, new File(files[i]), prefixs[i]);
                }
            }
            jout.close();
        }
        catch (Exception ex) {
            FileManager.log(-1, "buildJar: %s", ex);
            return false;
        }
        FileManager.log(lvl, "buildJar: completed", new Object[0]);
        return true;
    }

    public static boolean unpackJar(String jarName, String folderName, boolean del, boolean strip, JarFileFilter filter) {
        if (!(jarName = FileManager.slashify(jarName, false)).endsWith(".jar")) {
            jarName = jarName + ".jar";
        }
        if (!new File(jarName).isAbsolute()) {
            FileManager.log(-1, "unpackJar: jar path not absolute", new Object[0]);
            return false;
        }
        if (folderName == null) {
            folderName = jarName.substring(0, jarName.length() - 4);
        } else if (!new File(folderName).isAbsolute()) {
            FileManager.log(-1, "unpackJar: folder path not absolute", new Object[0]);
            return false;
        }
        folderName = FileManager.slashify(folderName, true);
        try {
            if (del) {
                FileManager.deleteFileOrFolder(folderName);
            }
            ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(jarName)));
            FileManager.log(lvl, "unpackJar: %s to %s", jarName, folderName);
            ZipEntry z = in.getNextEntry();
            while (z != null) {
                if (filter == null || filter.accept(z, null)) {
                    if (z.isDirectory()) {
                        new File(folderName, z.getName()).mkdirs();
                    } else {
                        boolean isExecutable;
                        File f;
                        int n = z.getName().lastIndexOf(EXECUTABLE);
                        if (n >= 0) {
                            f = new File(folderName, z.getName().substring(0, n));
                            isExecutable = true;
                        } else {
                            f = new File(folderName, z.getName());
                            isExecutable = false;
                        }
                        if (strip) {
                            f = new File(folderName, f.getName());
                        } else {
                            f.getParentFile().mkdirs();
                        }
                        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
                        FileManager.bufferedWrite(in, out);
                        out.close();
                        if (isExecutable) {
                            f.setExecutable(true, false);
                        }
                    }
                }
                z = in.getNextEntry();
            }
            in.close();
        }
        catch (Exception ex) {
            FileManager.log(-1, "unpackJar: " + ex.getMessage(), new Object[0]);
            return false;
        }
        FileManager.log(lvl, "unpackJar: completed", new Object[0]);
        return true;
    }

    private static void addToJar(JarOutputStream jar, File dir, String prefix) throws IOException {
        String string = prefix = prefix == null ? "" : prefix;
        if (dir.isDirectory()) {
            File[] content = dir.listFiles();
            int l = content.length;
            for (int i = 0; i < l; ++i) {
                if (content[i].isDirectory()) {
                    jar.putNextEntry(new ZipEntry(prefix + (prefix.equals("") ? "" : "/") + content[i].getName() + "/"));
                    FileManager.addToJar(jar, content[i], prefix + (prefix.equals("") ? "" : "/") + content[i].getName());
                    continue;
                }
                FileManager.addToJarWriteFile(jar, content[i], prefix);
            }
        } else {
            FileManager.addToJarWriteFile(jar, dir, prefix);
        }
    }

    private static void addToJarWriteFile(JarOutputStream jar, File file, String prefix) throws IOException {
        if (file.getName().startsWith(".")) {
            return;
        }
        String suffix = "";
        jar.putNextEntry(new ZipEntry(prefix + (prefix.equals("") ? "" : "/") + file.getName() + suffix));
        FileInputStream in = new FileInputStream(file);
        FileManager.bufferedWrite(in, jar);
        in.close();
    }

    public static String unzipSKL(String fpSkl) {
        File fSkl = new File(fpSkl);
        if (!fSkl.exists()) {
            FileManager.log(-1, "unzipSKL: file not found: %s", fpSkl);
        }
        String name = fSkl.getName();
        File fSikuliDir = FileManager.createTempDir((name = name.substring(0, name.lastIndexOf(46))) + ".sikuli");
        if (null != fSikuliDir) {
            fSikuliDir.deleteOnExit();
            FileManager.unzip(fSkl, fSikuliDir);
        }
        if (null == fSikuliDir) {
            FileManager.log(-1, "unzipSKL: not possible for:\n%s", fpSkl);
            return null;
        }
        return fSikuliDir.getAbsolutePath();
    }

    private static synchronized void bufferedWrite(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[524288];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        out.flush();
    }

    public static boolean pathEquals(String path1, String path2) {
        return new File(path1).equals(new File(path2));
    }

    public static interface FileFilter {
        public boolean accept(File var1);
    }

    public static interface JarFileFilter {
        public boolean accept(ZipEntry var1, String var2);
    }
}

