/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.Image;
import org.sikuli.script.support.RunTime;

public class ImagePath {
    private static final String me = "ImagePath: ";
    private static final int lvl = 3;
    private static final List<PathEntry> imagePaths = Collections.synchronizedList(new ArrayList());

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    public static List<PathEntry> getPaths() {
        return imagePaths;
    }

    private static int getCount() {
        int count = imagePaths.size();
        for (PathEntry path : imagePaths) {
            if (path != null) continue;
            --count;
        }
        return count;
    }

    public static String[] get() {
        int i = 0;
        for (PathEntry p : imagePaths) {
            if (p == null) continue;
            ++i;
        }
        String[] paths = new String[i];
        i = 0;
        for (PathEntry p : imagePaths) {
            if (p == null) continue;
            paths[i++] = p.getPath();
            if (!p.isFile()) continue;
            paths[i - 1] = new File(p.getPath()).getAbsolutePath();
        }
        return paths;
    }

    public static void dump(int lvl) {
        ImagePath.log(lvl, "ImagePath has %d entries (valid %d)", imagePaths.size(), ImagePath.getCount());
        String bundle = "(taken as bundle path)";
        for (PathEntry p : imagePaths) {
            if (p == null) {
                ImagePath.log(lvl, "Path: NULL %s", bundle);
            } else {
                ImagePath.log(lvl, "Path: given: %s\nis: %s", p.path, p.getPath());
            }
            bundle = "";
        }
    }

    public static void reset() {
        ImagePath.log(3, "reset", new Object[0]);
        if (imagePaths.isEmpty()) {
            return;
        }
        for (PathEntry pathEntry : imagePaths) {
            if (pathEntry == null) continue;
            Image.purge(pathEntry);
        }
        PathEntry bundlePath = ImagePath.getBundle();
        imagePaths.clear();
        imagePaths.add(bundlePath);
    }

    private static PathEntry makePathURL(String fpMainPath, String fpAltPath) {
        if (fpMainPath == null || fpMainPath.isEmpty()) {
            return null;
        }
        URL pathURL = null;
        File fPath = new File(FileManager.normalizeAbsolute(fpMainPath));
        if (fPath.exists()) {
            pathURL = FileManager.makeURL(fPath.getAbsolutePath());
        } else {
            CodeSource codeSrc;
            String klassName;
            if (fpMainPath.contains("\\")) {
                ImagePath.log(-1, "add: folder does not exist (%s)", fPath);
                return null;
            }
            Class<?> cls = null;
            String fpSubPath = "";
            int n = fpMainPath.indexOf("/");
            if (n > 0) {
                klassName = fpMainPath.substring(0, n);
                if (n < fpMainPath.length() - 2) {
                    fpSubPath = fpMainPath.substring(n + 1);
                }
            } else {
                klassName = fpMainPath;
            }
            try {
                cls = Class.forName(klassName);
            }
            catch (ClassNotFoundException ex) {
                ImagePath.log(-1, "add: class not found (%s) or folder does not exist (%s)", klassName, fPath);
            }
            if (cls != null && (codeSrc = cls.getProtectionDomain().getCodeSource()) != null && codeSrc.getLocation() != null) {
                URL jarURL = codeSrc.getLocation();
                if (jarURL.getPath().endsWith(".jar")) {
                    pathURL = FileManager.makeURL(jarURL.toString() + "!/" + fpSubPath, "jar");
                } else {
                    if (fpAltPath == null || fpAltPath.isEmpty()) {
                        fpAltPath = jarURL.getPath();
                    }
                    if (new File(FileManager.normalizeAbsolute(fpAltPath), fpSubPath).exists()) {
                        File fAltPath = new File(FileManager.normalizeAbsolute(fpAltPath), fpSubPath);
                        pathURL = FileManager.makeURL(fAltPath.getPath());
                    }
                }
            }
        }
        if (pathURL != null) {
            return new PathEntry(fpMainPath, pathURL);
        }
        return null;
    }

    public static boolean add(String mainPath) {
        return ImagePath.add(mainPath, null);
    }

    public static boolean addHTTP(String pathHTTP) {
        try {
            String proto = "http://";
            String protos = "https://";
            if (pathHTTP.startsWith(proto) || pathHTTP.startsWith(protos)) {
                proto = "";
            }
            pathHTTP = FileManager.slashify(pathHTTP, false);
            URL aURL = new URL(proto + pathHTTP);
            if (0 != FileManager.isUrlUseabel(new URL(aURL.toString() + "/THIS_FILE_SHOULD_RETURN_404"))) {
                return false;
            }
            PathEntry path = new PathEntry(pathHTTP, aURL);
            if (ImagePath.hasPath(path) < 0) {
                ImagePath.log(3, "add: %s", path);
                imagePaths.add(path);
            } else {
                ImagePath.log(3, "duplicate not added: %s", path);
            }
        }
        catch (Exception ex) {
            ImagePath.log(-1, "addHTTP: not possible: %s\n%s", pathHTTP, ex);
            return false;
        }
        return true;
    }

    public static boolean removeHTTP(String pathHTTP) {
        try {
            String proto = "http://";
            String protos = "https://";
            if (pathHTTP.startsWith(proto) || pathHTTP.startsWith(protos)) {
                proto = "";
            }
            pathHTTP = FileManager.slashify(pathHTTP, false);
            return ImagePath.remove(new URL(proto + pathHTTP));
        }
        catch (Exception ex) {
            ImagePath.log(-1, "removeHTTP: not possible: %s\n%s", pathHTTP, ex);
            return false;
        }
    }

    public static boolean add(String mainPath, String altPath) {
        PathEntry pathEntry = null;
        File fPath = new File(mainPath);
        if (!fPath.isAbsolute() && mainPath.contains(":") && fPath.getAbsolutePath().charAt(2) != ":".charAt(0)) {
            return ImagePath.addHTTP(mainPath);
        }
        pathEntry = ImagePath.makePathURL(mainPath, altPath);
        if (pathEntry != null) {
            if (ImagePath.hasPath(pathEntry) < 0) {
                ImagePath.log(3, "add: %s", pathEntry);
                imagePaths.add(pathEntry);
            } else {
                ImagePath.log(3, "duplicate not added: %s", pathEntry);
            }
            return true;
        }
        ImagePath.log(-1, "add: not valid: %s %s", mainPath, altPath == null ? "" : " / " + altPath);
        return false;
    }

    public static boolean addJar(String fpJar, String fpImage) {
        URL pathURL = null;
        if (".".equals(fpJar) && !(fpJar = RunTime.get().fSxBaseJar.getAbsolutePath()).endsWith(".jar")) {
            return false;
        }
        if (new File(fpJar).exists()) {
            if (fpImage == null) {
                fpImage = "";
            }
            ImagePath.log(3, "addJar: %s", fpJar);
            pathURL = FileManager.makeURL(fpJar + "!/" + fpImage, "jar");
            ImagePath.add(pathURL);
        }
        return true;
    }

    private static int hasPath(PathEntry path) {
        PathEntry bundle = ImagePath.getBundle();
        if (imagePaths.size() == 1 && bundle == null) {
            return -1;
        }
        if (bundle != null && bundle.equals(path)) {
            return 0;
        }
        for (PathEntry pathEntry : imagePaths.subList(1, imagePaths.size())) {
            if (pathEntry == null || !pathEntry.equals(path)) continue;
            return 1;
        }
        return -1;
    }

    public static void add(URL pURL) {
        imagePaths.add(new PathEntry("__PATH_URL__", pURL));
    }

    public static boolean remove(String path) {
        File fPath = new File(path);
        if (!fPath.isAbsolute() && (path.contains("http://") || path.contains("https://"))) {
            return ImagePath.removeHTTP(path);
        }
        return ImagePath.remove(ImagePath.makePathURL((String)FileManager.normalize((String)path), null).pathURL);
    }

    public static boolean remove(File directory) {
        return ImagePath.remove(ImagePath.makePathURL((String)directory.getAbsolutePath(), null).pathURL);
    }

    private static boolean remove(URL pURL) {
        if (ImagePath.bundleEquals(pURL)) {
            Image.purge();
            return true;
        }
        Iterator<PathEntry> it = imagePaths.subList(1, imagePaths.size()).iterator();
        while (it.hasNext()) {
            PathEntry pathEntry = it.next();
            if (!pathEntry.equals(pURL)) continue;
            it.remove();
            Image.purge(pathEntry);
        }
        return true;
    }

    public static boolean hasBundlePath() {
        return ImagePath.getBundle() != null;
    }

    private static boolean bundleEquals(Object path) {
        if (ImagePath.hasBundlePath()) {
            return ImagePath.getBundle().equals(path);
        }
        return false;
    }

    public static boolean reset(String path) {
        ImagePath.reset();
        if (ImagePath.bundleEquals(path)) {
            return true;
        }
        return ImagePath.setBundlePath(path);
    }

    private static boolean setBundlePath() {
        return ImagePath.setBundlePath(null);
    }

    public static boolean setBundlePath(String newBundlePath) {
        if (newBundlePath == null && (newBundlePath = Settings.BundlePath) == null) {
            return false;
        }
        File newBundleFile = new File(newBundlePath);
        if (!newBundleFile.isAbsolute()) {
            if (ImagePath.hasBundlePath()) {
                return false;
            }
            newBundleFile = new File(ImagePath.getBundlePath(), newBundlePath);
        }
        return null != ImagePath.setBundleFolder(newBundleFile);
    }

    public static File setBundleFolder(File folder) {
        try {
            folder = folder.getCanonicalFile();
        }
        catch (IOException e) {
            ImagePath.log(-1, "canonical file problem: %s", folder);
            return null;
        }
        if (null == folder || ImagePath.bundleEquals(folder)) {
            return folder;
        }
        if (folder.exists()) {
            PathEntry oldBundle = ImagePath.getBundle();
            Image.purge(oldBundle);
            PathEntry pathEntry = new PathEntry(folder);
            if (pathEntry.isValid()) {
                ImagePath.setBundle(pathEntry);
                ImagePath.log(3, "new BundlePath: %s", pathEntry);
                return pathEntry.getFile();
            }
        }
        return null;
    }

    static PathEntry getBundle() {
        return imagePaths.get(0);
    }

    private static void setBundle(PathEntry pathEntry) {
        imagePaths.set(0, pathEntry);
    }

    public static String getBundlePath() {
        if (!ImagePath.hasBundlePath() && !ImagePath.setBundlePath()) {
            return null;
        }
        return ImagePath.getBundle().getPath();
    }

    public static URL find(String imageFileName) {
        URL fURL = null;
        String proto = "";
        File imageFile = new File(imageFileName);
        if (imageFile.isAbsolute()) {
            if (imageFile.exists()) {
                try {
                    fURL = new URL("file", null, new File(imageFileName).getPath());
                }
                catch (MalformedURLException malformedURLException) {}
            } else {
                ImagePath.log(-1, "find: File does not exist: %s", imageFileName);
            }
            return fURL;
        }
        for (PathEntry path : ImagePath.getPaths()) {
            if (path == null) continue;
            proto = path.pathURL.getProtocol();
            if ("file".equals(proto)) {
                if (!new File(path.pathURL.getPath(), imageFileName).exists()) continue;
                try {
                    fURL = new URL("file", null, new File(path.pathURL.getPath(), imageFileName).getPath());
                    break;
                }
                catch (MalformedURLException malformedURLException) {
                    continue;
                }
            }
            if (!"jar".equals(proto) && !proto.startsWith("http") || (fURL = FileManager.getURLForContentFromURL(path.pathURL, imageFileName)) == null) continue;
            break;
        }
        if (fURL == null) {
            ImagePath.log(-1, "find: not there: %s", imageFileName);
            ImagePath.dump(3);
        }
        return fURL;
    }

    public static BufferedReader open(String fname) {
        ImagePath.log(3, "open: " + fname, new Object[0]);
        URL furl = ImagePath.find(fname);
        if (furl != null) {
            BufferedReader br = null;
            try {
                br = new BufferedReader(new InputStreamReader(furl.openStream()));
            }
            catch (IOException ex) {
                ImagePath.log(-1, "open: %s", ex.getMessage());
                return null;
            }
            try {
                br.mark(10);
                if (br.read() < 0) {
                    br.close();
                    return null;
                }
                br.reset();
                return br;
            }
            catch (IOException ex) {
                ImagePath.log(-1, "open: %s", ex.getMessage());
                try {
                    br.close();
                }
                catch (IOException ex1) {
                    ImagePath.log(-1, "open: %s", ex1.getMessage());
                    return null;
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isImageBundled(URL fURL) {
        if ("file".equals(fURL.getProtocol())) {
            return ImagePath.bundleEquals(new File(fURL.getPath()).getParent());
        }
        return false;
    }

    static {
        imagePaths.add(null);
    }

    public static class PathEntry {
        public URL pathURL = null;
        public String path = null;

        public PathEntry(String givenName, URL eqivalentURL) {
            this.path = FileManager.normalize(givenName);
            this.pathURL = eqivalentURL != null ? eqivalentURL : ImagePath.makePathURL((String)this.path, null).pathURL;
            ImagePath.log(4, "ImagePathEntry: %s (%s)", new Object[]{this.path, this.pathURL});
        }

        public PathEntry(File folder) {
            try {
                this.path = folder.getPath();
                this.pathURL = new URL("file", null, this.path);
                ImagePath.log(4, "ImagePathEntry: %s (%s)", new Object[]{this.path, this.pathURL});
            }
            catch (IOException e) {
                ImagePath.log(-1, "ImagePathEntry: %s", new Object[]{folder});
            }
        }

        public boolean isValid() {
            return this.path != null && this.pathURL != null;
        }

        public String getPath() {
            if (this.pathURL == null) {
                return "-- empty --";
            }
            if (this.isFile()) {
                return this.pathURL.getPath();
            }
            return null;
        }

        public boolean isFile() {
            if (this.pathURL == null) {
                return false;
            }
            return "file".equals(this.pathURL.getProtocol());
        }

        public boolean isJar() {
            if (this.pathURL == null) {
                return false;
            }
            return "jar".equals(this.pathURL.getProtocol());
        }

        public boolean isHTTP() {
            if (this.pathURL == null) {
                return false;
            }
            return this.pathURL.getProtocol().startsWith("http");
        }

        public File getFile() {
            if (this.isFile()) {
                return new File(this.getPath());
            }
            return null;
        }

        public boolean existsFile() {
            if (this.pathURL == null) {
                return false;
            }
            return new File(this.getPath()).exists();
        }

        public boolean equals(Object other) {
            if (this.pathURL == null) {
                return false;
            }
            if (!(other instanceof PathEntry)) {
                if (other instanceof URL) {
                    if (this.pathURL.equals(other)) {
                        return true;
                    }
                } else {
                    if (other instanceof String) {
                        if (this.isFile()) {
                            try {
                                return new File(this.pathURL.getFile()).equals(new File((String)other).getCanonicalFile());
                            }
                            catch (IOException e) {
                                return false;
                            }
                        }
                        return false;
                    }
                    if (other instanceof File) {
                        if (this.isFile()) {
                            try {
                                return new File(this.pathURL.getFile()).equals(((File)other).getCanonicalFile());
                            }
                            catch (IOException e) {
                                return false;
                            }
                        }
                        return false;
                    }
                }
                return false;
            }
            return this.pathURL.equals(((PathEntry)other).pathURL);
        }

        public String toString() {
            return this.getPath();
        }
    }
}

