/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.io.File;
import java.net.URL;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.runnerSupport.JythonSupport;
import org.sikuli.script.support.RunTime;

public class SikulixForJython {
    private static SikulixForJython instance = null;
    private static final int lvl = 3;

    static void staticInit() {
        JythonSupport helper = JythonSupport.get();
        helper.log(3, "SikulixForJython: init: starting", new Object[0]);
        RunTime runTime = RunTime.get();
        String sikuliStuff = "sikuli/Sikuli";
        File fSikuliStuff = helper.existsSysPathModule(sikuliStuff);
        String libSikuli = "/Lib/" + sikuliStuff + ".py";
        if (null == fSikuliStuff) {
            URL uSikuliStuff = runTime.resourceLocation(libSikuli);
            if (uSikuliStuff == null) {
                runTime.dumpClassPath();
                throw new SikuliXception(String.format("fatal: Jython: no suitable sikulix...jar on classpath", new Object[0]));
            }
            String fpSikuliStuff = runTime.fSikulixLib.getAbsolutePath();
            if (!helper.hasSysPath(fpSikuliStuff)) {
                helper.log(3, "sikuli/*.py not found on current Jython::sys.path", new Object[0]);
                helper.addSysPath(fpSikuliStuff);
                if (!helper.hasSysPath(fpSikuliStuff)) {
                    throw new SikuliXception(String.format("fatal: Jython: not possible to add to Jython::sys.path: %s", fpSikuliStuff));
                }
                helper.log(3, "added as Jython::sys.path[0]:\n%s", fpSikuliStuff);
            } else {
                helper.log(3, "sikuli/*.py is on Jython::sys.path at:\n%s", fpSikuliStuff);
            }
        }
        helper.addSitePackages();
        helper.log(3, "SikulixForJython: init: success", new Object[0]);
    }

    SikulixForJython() {
    }

    public static SikulixForJython get() {
        if (null == instance) {
            instance = new SikulixForJython();
        }
        return instance;
    }

    static {
        SikulixForJython.staticInit();
    }
}

