/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.runners;

import com.sun.jna.ptr.IntByReference;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.sikuli.basics.Debug;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.support.IScriptRunner;

public abstract class AbstractScriptRunner
implements IScriptRunner {
    private boolean ready = false;
    private boolean running = false;
    PrintStream redirectedStdout;
    PrintStream redirectedStderr;
    private static volatile Thread worker = null;
    private static final ScheduledExecutorService TIMEOUT_EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private static final Object WORKER_LOCK = new Object();
    private boolean aborted = false;
    static ArrayList<String> codeBefore = null;
    static ArrayList<String> codeAfter = null;

    protected void log(int level, String message, Object ... args) {
        Debug.logx(level, this.getName() + "Runner: " + message, args);
    }

    private void logNotSupported(String method) {
        Debug.log(-1, "%s does not (yet) support %s", new Object[]{this.getName(), method});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void init(String[] args) throws SikuliXception {
        Class<AbstractScriptRunner> clazz = AbstractScriptRunner.class;
        synchronized (AbstractScriptRunner.class) {
            if (!this.ready) {
                try {
                    this.doInit(args);
                    if (this.redirectedStdout != null && this.redirectedStderr != null) {
                        this.redirectNow(this.redirectedStdout, this.redirectedStderr);
                    }
                    this.ready = true;
                }
                catch (Exception e) {
                    throw new SikuliXception("Cannot initialize Script runner " + this.getName(), e);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void doInit(String[] args) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isReady() {
        Class<AbstractScriptRunner> clazz = AbstractScriptRunner.class;
        synchronized (AbstractScriptRunner.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.ready;
        }
    }

    @Override
    public boolean isSupported() {
        return false;
    }

    @Override
    public final boolean hasExtension(String ending) {
        for (String suf : this.getExtensions()) {
            if (!suf.equals(ending.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultExtension() {
        return this.getExtensions()[0];
    }

    @Override
    public boolean canHandle(String identifier) {
        if (identifier != null) {
            if (this.getType().equals(identifier)) {
                return true;
            }
            if (identifier.toLowerCase().equals(this.getName().toLowerCase())) {
                return true;
            }
            if (identifier.toLowerCase().startsWith(this.getName().toLowerCase() + "*")) {
                return true;
            }
            if (this.hasExtension(identifier)) {
                return true;
            }
            if (this.canHandleFileEnding(identifier)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void redirect(PrintStream stdout, PrintStream stderr) {
        Class<AbstractScriptRunner> clazz = AbstractScriptRunner.class;
        synchronized (AbstractScriptRunner.class) {
            Debug.log(3, "%s: Initiate IO redirect", this.getName());
            this.redirectedStdout = stdout;
            this.redirectedStderr = stderr;
            if (this.ready) {
                if (stdout != null && stderr != null) {
                    this.redirectNow(stdout, stderr);
                } else {
                    this.doRedirect(System.out, System.err);
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private final void redirectNow(PrintStream stdout, PrintStream stderr) {
        boolean ret = this.doRedirect(stdout, stderr);
        if (ret) {
            Debug.log(3, "%s: IO redirect established", this.getName());
        }
    }

    protected boolean doRedirect(PrintStream stdout, PrintStream stderr) {
        return false;
    }

    @Override
    public final int runScript(String script, String[] scriptArgs, IScriptRunner.Options maybeOptions) {
        IScriptRunner.Options options = null != maybeOptions ? maybeOptions : new IScriptRunner.Options();
        return this.runSynchronized(options, () -> {
            int savedLevel = Debug.getDebugLevel();
            if (!Debug.isGlobalDebug()) {
                Debug.off();
            }
            int exitCode = this.doRunScript(script, scriptArgs, options);
            Debug.setDebugLevel(savedLevel);
            return exitCode;
        });
    }

    @Override
    public IScriptRunner.EffectiveRunner getEffectiveRunner(String script) {
        return new IScriptRunner.EffectiveRunner(this, script, false);
    }

    protected int doRunScript(String scriptfile, String[] scriptArgs, IScriptRunner.Options options) {
        this.logNotSupported("runScript");
        return 257;
    }

    @Override
    public final int evalScript(String script, IScriptRunner.Options maybeOptions) {
        IScriptRunner.Options options = null != maybeOptions ? maybeOptions : new IScriptRunner.Options();
        return this.runSynchronized(options, () -> this.doEvalScript(script, options));
    }

    protected int doEvalScript(String script, IScriptRunner.Options options) {
        this.logNotSupported("evalScript");
        return -1;
    }

    @Override
    public final void runLines(String lines, IScriptRunner.Options maybeOptions) {
        IScriptRunner.Options options = null != maybeOptions ? maybeOptions : new IScriptRunner.Options();
        this.runSynchronized(options, () -> {
            this.doRunLines(lines, options);
            return 0;
        });
    }

    protected void doRunLines(String lines, IScriptRunner.Options options) {
        this.logNotSupported("runLines");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() {
        Class<AbstractScriptRunner> clazz = AbstractScriptRunner.class;
        synchronized (AbstractScriptRunner.class) {
            this.ready = false;
            this.doClose();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void doClose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reset() {
        Class<AbstractScriptRunner> clazz = AbstractScriptRunner.class;
        synchronized (AbstractScriptRunner.class) {
            try {
                this.close();
                this.init(null);
                this.log(3, "reset requested (experimental: please report oddities)", new Object[0]);
            }
            catch (Exception e) {
                this.log(-1, "reset requested but did not work. Please report this case.Do not run scripts anymore and restart the IDE after having saved your work", new Object[0]);
            }
            return;
        }
    }

    @Override
    public void execBefore(String[] stmts) {
        if (stmts == null) {
            codeBefore = null;
            return;
        }
        if (codeBefore == null) {
            codeBefore = new ArrayList();
        }
        codeBefore.addAll(Arrays.asList(stmts));
    }

    @Override
    public void execAfter(String[] stmts) {
        if (stmts == null) {
            codeAfter = null;
            return;
        }
        if (codeAfter == null) {
            codeAfter = new ArrayList();
        }
        codeAfter.addAll(Arrays.asList(stmts));
    }

    @Override
    public final boolean isRunning() {
        return this.running;
    }

    @Override
    public boolean isAbortSupported() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void abort() {
        Object object = WORKER_LOCK;
        synchronized (object) {
            if (worker != null && this.running && this.isAbortSupported()) {
                this.aborted = true;
                this.doAbort();
            }
        }
    }

    protected void doAbort() {
        worker.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isAborted() {
        Object object = WORKER_LOCK;
        synchronized (object) {
            return this.aborted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runAbortable(IScriptRunner.Options options, final IntSupplier block) {
        boolean newWorker;
        final IntByReference exitCode = new IntByReference(1);
        Object object = WORKER_LOCK;
        synchronized (object) {
            this.aborted = false;
            boolean bl = newWorker = worker == null;
            if (newWorker) {
                worker = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Class<AbstractScriptRunner> clazz = AbstractScriptRunner.class;
                        synchronized (AbstractScriptRunner.class) {
                            try {
                                exitCode.setValue(block.getAsInt());
                            }
                            finally {
                                AbstractScriptRunner.class.notify();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                };
                worker.start();
            }
        }
        if (newWorker) {
            ScheduledFuture<?> timeoutFuture = null;
            try {
                if (options.getTimeout() > 0L) {
                    long timeout = options.getTimeout();
                    timeoutFuture = TIMEOUT_EXECUTOR.schedule(() -> {
                        Debug.info("%s script timed out after %d ms", this.getName(), timeout);
                        this.abort();
                    }, timeout, TimeUnit.MILLISECONDS);
                }
                AbstractScriptRunner.class.wait();
            }
            catch (InterruptedException e) {
                Debug.log(-1, "Script interrupted unexpectedly: %s", e.getMessage());
            }
            finally {
                if (timeoutFuture != null) {
                    timeoutFuture.cancel(false);
                    timeoutFuture = null;
                }
                Object object2 = WORKER_LOCK;
                synchronized (object2) {
                    worker = null;
                }
            }
        } else {
            exitCode.setValue(block.getAsInt());
        }
        return exitCode.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runSynchronized(IScriptRunner.Options options, IntSupplier block) {
        Class<AbstractScriptRunner> clazz = AbstractScriptRunner.class;
        synchronized (AbstractScriptRunner.class) {
            int n;
            this.running = true;
            this.init(null);
            try {
                n = this.runAbortable(options, block);
                this.running = false;
            }
            catch (Throwable throwable) {
                this.running = false;
                throw throwable;
            }
            return n;
        }
    }

    public final boolean canHandleFileEnding(String identifier) {
        for (String suf : this.getFileEndings()) {
            if (!identifier.toLowerCase().endsWith(suf.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String[] getFileEndings() {
        String[] extensions = this.getExtensions();
        String[] endings = new String[extensions.length];
        for (int i = 0; i < extensions.length; ++i) {
            endings[i] = "." + extensions[i];
        }
        return endings;
    }
}

