/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.support;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sikuli.script.FindFailedResponse;
import org.sikuli.script.Image;

public class FindFailedDialog
extends JDialog
implements ActionListener {
    JButton retryButton;
    JButton skipButton;
    JButton abortButton;
    FindFailedResponse _response;
    boolean isCapture = false;

    public FindFailedDialog(Image target) {
        this.init(target, false);
    }

    public FindFailedDialog(Image target, boolean isCapture) {
        this.init(target, isCapture);
    }

    private void init(Image target, boolean isCapture) {
        this.isCapture = isCapture;
        this.setModal(true);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        Component targetComp = this.createTargetComponent(target);
        panel.add(targetComp, "North");
        JPanel buttons = new JPanel();
        String textRetry = "Retry";
        if (isCapture) {
            textRetry = "Capture";
        }
        String textSkip = "Capture/Skip";
        if (isCapture) {
            textSkip = "Skip";
        }
        this.retryButton = new JButton(textRetry);
        this.retryButton.addActionListener(this);
        this.skipButton = new JButton(textSkip);
        this.skipButton.addActionListener(this);
        this.abortButton = new JButton("Abort");
        this.abortButton.addActionListener(this);
        buttons.add(this.retryButton);
        buttons.add(this.skipButton);
        buttons.add(this.abortButton);
        panel.add((Component)buttons, "South");
        this.add(panel);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FindFailedDialog.this._response = FindFailedResponse.ABORT;
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.retryButton == e.getSource()) {
            this._response = FindFailedResponse.RETRY;
        } else if (this.abortButton == e.getSource()) {
            this._response = FindFailedResponse.ABORT;
        } else if (this.skipButton == e.getSource()) {
            this._response = FindFailedResponse.SKIP;
        }
        this.dispose();
    }

    public FindFailedResponse getResponse() {
        return this._response;
    }

    <PatternString> Component createTargetComponent(Image img) {
        JLabel cause = null;
        JPanel dialog = new JPanel();
        dialog.setLayout(new BorderLayout());
        if (img.isValid()) {
            if (!img.isText()) {
                java.awt.Image bimage = img.get();
                if (bimage != null) {
                    String rescale = "";
                    JLabel iconLabel = new JLabel();
                    int w = ((java.awt.Image)bimage).getWidth(this);
                    int h = ((java.awt.Image)bimage).getHeight(this);
                    if (w > 500) {
                        w = 500;
                        h = -h;
                        rescale = " (rescaled 500x...)";
                    }
                    if (h > 300) {
                        h = 300;
                        w = -w;
                        rescale = " (rescaled ...x300)";
                    }
                    if (h < 0 && w < 0) {
                        w = 500;
                        h = 300;
                        rescale = " (rescaled 500x300)";
                    }
                    bimage = bimage.getScaledInstance(w, h, 1);
                    iconLabel.setIcon(new ImageIcon(bimage));
                    cause = new JLabel("Cannot find " + img.getName() + rescale);
                    dialog.add((Component)iconLabel, "Last");
                }
            } else {
                cause = new JLabel("Sikuli cannot find text:" + img.getName());
            }
        }
        if (this.isCapture) {
            cause = new JLabel("Request to capture: " + img.getName());
        }
        dialog.add(cause, "First");
        return dialog;
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag) {
            this.pack();
            this.setAlwaysOnTop(true);
            this.setResizable(false);
            this.setLocationRelativeTo(this);
            this.requestFocus();
        }
        super.setVisible(flag);
    }
}

