/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Crawler {
    private static void p(String message, Object ... args) {
        if (message.isEmpty()) {
            message = "%s";
        }
        System.out.println(String.format(message, args));
    }

    public static void main(String[] args) {
        String packg;
        if (args.length == 0) {
            return;
        }
        String thisPackg = packg = "org.sikuli.";
        for (String arg : args) {
            if (arg.startsWith("#")) break;
            if (arg.endsWith(".")) {
                thisPackg = packg + arg;
                continue;
            }
            String className = thisPackg + arg;
            HashMap<String, List<String>> functions = new HashMap<String, List<String>>();
            String orgSignature = "";
            String signature = "";
            try {
                Object function;
                String[] strings;
                Class<?> aClass = Class.forName(className);
                String cName = aClass.getSimpleName();
                String superClass = aClass.getSuperclass().getSimpleName();
                Crawler.p("------- Class: %s (%s)", className, superClass);
                Method[] declaredMethods = aClass.getDeclaredMethods();
                Constructor<?>[] declaredConstructors = aClass.getDeclaredConstructors();
                Field[] declaredFields = aClass.getDeclaredFields();
                for (Constructor<?> constructor : declaredConstructors) {
                    signature = constructor.toGenericString();
                    if (!signature.startsWith("public")) continue;
                    strings = signature.split("\\(");
                    signature = "(" + strings[1];
                    signature = signature.replace("org.sikuli.script.", "");
                    if (functions.containsKey(" ")) {
                        ((List)functions.get(" ")).add(signature);
                        continue;
                    }
                    ArrayList<String> signatures = new ArrayList<String>();
                    signatures.add(signature);
                    functions.put(" ", signatures);
                }
                for (Executable executable : declaredMethods) {
                    orgSignature = signature = ((Method)executable).toGenericString();
                    if (!signature.startsWith("public")) continue;
                    boolean isStatic = false;
                    boolean hasThrows = false;
                    signature = signature.replace("public ", "").trim();
                    signature = signature.replace("java.lang.", "");
                    signature = signature.replace("java.util.", "");
                    signature = signature.replace("org.sikuli.script.", "");
                    if ((signature = signature.replace(cName + ".", "")).startsWith("<")) {
                        strings = signature.split("> ");
                        signature = signature.substring(strings[0].length() + 2);
                    }
                    if (signature.startsWith("static")) {
                        signature = signature.substring(7);
                        isStatic = true;
                    }
                    strings = signature.split(" ");
                    strings = strings[1].split("\\(");
                    Object functionName = function = strings[0];
                    if (((String)function).startsWith("get") || ((String)function).startsWith("set")) {
                        functionName = ((String)function).substring(3);
                        function = "+" + (String)functionName;
                    }
                    if ((signature = signature.replace((CharSequence)functionName, "")).contains("throws")) {
                        strings = signature.split(" throws ");
                        hasThrows = true;
                        signature = strings[0];
                    }
                    strings = signature.split(" ");
                    signature = strings[1] + " -> " + strings[0] + (hasThrows ? "!" : "");
                    if (isStatic) {
                        function = " " + (String)function;
                    }
                    if (functions.containsKey(function)) {
                        ((List)functions.get(function)).add(signature);
                        continue;
                    }
                    ArrayList<String> signatures = new ArrayList<String>();
                    signatures.add(signature);
                    functions.put((String)function, signatures);
                }
                ArrayList<String> notBeans = new ArrayList<String>();
                for (String function2 : functions.keySet()) {
                    if (!function2.startsWith("+")) continue;
                    String string = function2.substring(1);
                    int nGet = 0;
                    int nSet = 0;
                    function = ((List)functions.get(function2)).iterator();
                    while (function.hasNext()) {
                        String sig = (String)function.next();
                        if (sig.startsWith("get")) {
                            ++nGet;
                            continue;
                        }
                        if (!sig.startsWith("set")) continue;
                        ++nSet;
                    }
                    if (nSet > 0 && nGet > 0) continue;
                    notBeans.add((nGet > 0 ? "get" : "set") + function2.substring(1));
                }
                if (notBeans.size() > 0) {
                    for (String function3 : notBeans) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        List listSignatures = (List)functions.remove("+" + function3.substring(3));
                        for (String sig : listSignatures) {
                            sig = sig.replace("get", "").replace("set", "");
                            arrayList.add(sig);
                        }
                        functions.put(function3, arrayList);
                    }
                }
                Map<String, List<String>> sortedFunctions = Crawler.sortMap(functions);
                for (String string : sortedFunctions.keySet()) {
                    Crawler.p("%-20s : %s", string, sortedFunctions.get(string));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Crawler.p("Error: class %s (%s)", className, orgSignature);
            }
        }
    }

    static Map<String, List<String>> sortMap(Map<String, List<String>> map) {
        ArrayList<Map.Entry<String, List<String>>> entries = new ArrayList<Map.Entry<String, List<String>>>(map.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, List<String>>>(){

            @Override
            public int compare(Map.Entry<String, List<String>> o1, Map.Entry<String, List<String>> o2) {
                return o1.getKey().toLowerCase().compareTo(o2.getKey().toLowerCase());
            }
        });
        LinkedHashMap<String, List<String>> sortedMap = new LinkedHashMap<String, List<String>>();
        for (Map.Entry entry : entries) {
            sortedMap.put((String)entry.getKey(), (List)entry.getValue());
        }
        return sortedMap;
    }
}

