/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import org.sikuli.guide.Visual;
import org.sikuli.script.Image;
import org.sikuli.script.Region;

public class SxImage
extends Visual {
    private BufferedImage image = null;
    float scale;
    int w;
    int h;

    public SxImage(String filename) {
        this.init(Image.create(filename).get());
    }

    public SxImage(BufferedImage image) {
        this.init(image);
    }

    private void init(BufferedImage image) {
        this.image = image;
        this.setScale(1.0f);
    }

    @Override
    public void updateComponent() {
        this.setActualBounds(this.getTarget().getRect());
    }

    @Override
    public Visual setScale(float scale) {
        this.scale = scale;
        if (scale == 0.0f) {
            int x = this.getTarget().getCenter().x - this.image.getWidth() / 2;
            int y = this.getTarget().getCenter().y - this.image.getHeight() / 2;
            this.setTarget(Region.create(x, y, this.image.getWidth(), this.image.getHeight()));
        } else {
            this.w = (int)(scale * (float)this.image.getWidth());
            this.h = (int)(scale * (float)this.image.getHeight());
        }
        return this;
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.image == null) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        int aw = this.w > this.getActualWidth() ? this.getActualWidth() : this.w;
        int ah = this.h > this.getActualHeight() ? this.getActualHeight() : this.h;
        int ay = (this.getActualHeight() - ah) / 2;
        g2d.drawImage(this.image, 0, ay, aw, ah, null);
        g2d.drawRect(0, 0, this.getActualWidth() - 1, this.getActualHeight() - 1);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage getImage() {
        return this.image;
    }
}

