/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import org.sikuli.basics.Debug;
import org.sikuli.guide.Guide;
import org.sikuli.guide.SxAnchor;
import org.sikuli.guide.TrackerListener;
import org.sikuli.guide.Visual;
import org.sikuli.script.Match;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;

public class Tracker
extends Thread {
    Guide guide;
    Pattern pattern;
    Region match;
    Screen screen;
    String image_filename;
    Pattern centerPattern;
    boolean initialFound = false;
    ArrayList<Visual> components = new ArrayList();
    ArrayList<Point> offsets = new ArrayList();
    SxAnchor anchor;
    TrackerListener listener;
    boolean running;

    public Tracker(Pattern pattern) {
        this.screen = new Screen();
        this.pattern = pattern;
        BufferedImage image = pattern.getBImage();
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage center = image.getSubimage(w / 4, h / 4, w / 2, h / 2);
        this.centerPattern = new Pattern(center);
        this.centerPattern = new Pattern(pattern);
    }

    public Tracker(Guide guide, Pattern pattern, Region match) {
        this.guide = guide;
        this.screen = new Screen();
        this.pattern = pattern;
        try {
            BufferedImage image = pattern.getBImage();
            int w = image.getWidth();
            int h = image.getHeight();
            BufferedImage center = image.getSubimage(w / 4, h / 4, w / 2, h / 2);
            this.centerPattern = new Pattern(center);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAnchor(Visual component) {
        Point loc = component.getLocation();
        Point offset = new Point(0, 0);
        this.offsets.add(offset);
        this.components.add(component);
        this.anchor = (SxAnchor)component;
    }

    @Override
    public void run() {
        this.running = true;
        this.initialFound = true;
        this.match = null;
        Debug.log("[Tracker] Looking for the target for the first time", new Object[0]);
        while (this.running && this.match == null) {
            this.match = this.screen.exists(this.pattern, 0.5);
        }
        if (this.match == null) {
            return;
        }
        Debug.log("[Tracker] Pattern is found for the first time", new Object[0]);
        Rectangle bounds = this.match.getRect();
        this.anchor.found(bounds);
        while (this.running) {
            if (this.match != null && this.isPatternStillThereInTheSameLocation()) continue;
            Match newMatch = this.screen.exists(this.pattern, 1.0);
            if (newMatch == null) {
                Debug.log("[Tracker] Pattern is not found on the screen", new Object[0]);
                this.anchor.addFadeoutAnimation();
                this.anchor.startAnimation();
            } else {
                Debug.log("[Tracker] Pattern is found in a new location: " + newMatch, new Object[0]);
                this.anchor.addFadeinAnimation();
                this.anchor.startAnimation();
                int dest_x = newMatch.x + newMatch.w / 2;
                int dest_y = newMatch.y + newMatch.h / 2;
                Debug.log("[Tracker] Pattern is moving to: (" + dest_x + "," + dest_y + ")", new Object[0]);
                this.anchor.moveTo(new Point(dest_x, dest_y));
            }
            this.match = newMatch;
        }
    }

    public void stopTracking() {
        this.running = false;
    }

    public boolean isAlreadyTracking(Pattern pattern, Region match) {
        try {
            boolean sameMatch = this.match == match;
            boolean sameBufferedImage = this.pattern.getBImage() == pattern.getBImage();
            boolean sameFilename = this.pattern.getFilename() != null && this.pattern.getFilename().compareTo(pattern.getFilename()) == 0;
            return sameMatch || sameBufferedImage || sameFilename;
        }
        catch (Exception e) {
            return false;
        }
    }

    boolean isAnimationStillRunning() {
        for (Visual comp : this.components) {
            if (!(comp instanceof SxAnchor) || !comp.animationRunning) continue;
            return true;
        }
        return false;
    }

    boolean isPatternStillThereInTheSameLocation() {
        try {
            Tracker.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Region center = new Region(this.match);
        Match m = center.exists(this.centerPattern, 0.0);
        if (m == null) {
            Debug.log("[Tracker] Pattern is not seen in the same location.", new Object[0]);
        }
        return m != null;
    }
}

