/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.List;
import org.opencv.core.Mat;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Finder;
import org.sikuli.script.Image;
import org.sikuli.script.Location;
import org.sikuli.script.ScreenImage;

public class Pattern {
    private Image image = null;
    private double similarity = Settings.MinSimilarity;
    private Location offset = new Location(0, 0);
    private int waitAfter = 0;
    private boolean imagePattern = false;
    private float resizeFactor = 0.0f;
    private Mat patternMask = Finder.Finder2.getNewMat();
    private boolean isMask = false;
    private boolean withMask = false;

    public Pattern() {
    }

    public Pattern(Pattern p) {
        this.image = p.getImage();
        this.similarity = p.similarity;
        this.offset.x = p.offset.x;
        this.offset.y = p.offset.y;
        this.imagePattern = this.image.isPattern();
    }

    public Pattern(Image img) {
        this.image = Image.create(img);
        this.image.setIsPattern(false);
        this.imagePattern = true;
    }

    public Pattern resize(float factor) {
        this.resizeFactor = factor;
        return this;
    }

    public float getResize() {
        return this.resizeFactor;
    }

    public boolean isImagePattern() {
        return this.imagePattern;
    }

    public Pattern(String imgpath) {
        this.image = Image.create(imgpath);
    }

    public Pattern(URL url) {
        this.image = Image.create(url);
    }

    public Pattern(BufferedImage bimg) {
        this.image = new Image(bimg);
    }

    public Pattern(ScreenImage simg) {
        this.image = new Image(simg.getImage());
    }

    public boolean isValid() {
        return this.image.isValid() || this.imagePattern;
    }

    public Mat getMask() {
        return this.patternMask;
    }

    public boolean hasMask() {
        return !this.patternMask.empty();
    }

    private Mat extractMask() {
        List<Mat> mats = Finder.Finder2.extractMask(Finder.Finder2.makeMat(this.image.get(), false), false);
        return mats.get(1);
    }

    public Pattern mask() {
        return this.asMask();
    }

    public Pattern asMask() {
        if (this.isValid()) {
            Debug.log(3, "Pattern: asMask: %s", this.image);
            Mat mask = this.extractMask();
            if (!mask.empty()) {
                this.patternMask = mask;
                this.isMask = true;
            } else {
                Debug.log(-1, "Pattern: asMask: not valid", this.image);
            }
        }
        return this;
    }

    public Pattern mask(String sMask) {
        return this.withMask(new Pattern(Image.create(sMask)));
    }

    public Pattern mask(Image iMask) {
        return this.withMask(new Pattern(iMask));
    }

    public Pattern mask(Pattern pMask) {
        return this.withMask(pMask);
    }

    public Pattern withMask(Pattern pMask) {
        if (this.isValid()) {
            Mat mask = Finder.Finder2.getNewMat();
            if (pMask.isValid()) {
                mask = pMask.hasMask() ? pMask.getMask() : pMask.extractMask();
            }
            if (mask.empty() || this.image.getSize().getWidth() != (double)mask.width() || this.image.getSize().getHeight() != (double)mask.height()) {
                Debug.log(-1, "Pattern (%s): withMask: not valid", this.image, pMask.image);
                mask = Finder.Finder2.getNewMat();
            } else {
                Debug.log(3, "Pattern: %s withMask: %s", this.image, pMask.image);
            }
            if (!mask.empty()) {
                this.patternMask = mask;
                this.withMask = true;
            }
        }
        return this;
    }

    public Pattern withMask() {
        return this.mask();
    }

    public Pattern setFilename(String fileName) {
        this.image = Image.create(fileName);
        return this;
    }

    public Pattern setFilename(URL fileURL) {
        this.image = Image.create(fileURL);
        return this;
    }

    public Pattern setFilename(Image img) {
        this.image = img;
        return this;
    }

    public String getFilename() {
        return this.image.getFilename();
    }

    public URL getFileURL() {
        return this.image.getURL();
    }

    public Pattern similar(double sim) {
        this.similarity = sim;
        return this;
    }

    public Pattern exact() {
        this.similarity = 0.99;
        return this;
    }

    public double getSimilar() {
        return this.similarity;
    }

    public Pattern targetOffset(int dx, int dy) {
        this.offset.x = dx;
        this.offset.y = dy;
        return this;
    }

    public Pattern targetOffset(Location loc) {
        this.offset.x = loc.x;
        this.offset.y = loc.y;
        return this;
    }

    public Location getTargetOffset() {
        return this.offset;
    }

    public BufferedImage getBImage() {
        return this.image.get();
    }

    public Pattern setBImage(BufferedImage bimg) {
        this.image = new Image(bimg);
        return this;
    }

    public Pattern setImage(Image img) {
        this.image = img;
        return this;
    }

    public Image getImage() {
        return this.image;
    }

    public void setTimeAfter(int secs) {
        this.waitAfter = secs;
    }

    public int getTimeAfter() {
        return this.waitAfter;
    }

    public String toString() {
        String ret = "P(" + this.image.getName() + (this.isValid() ? "" : " -- not valid!") + ")";
        ret = ret + " S: " + this.similarity;
        if (this.offset.x != 0 || this.offset.y != 0) {
            ret = ret + " T: " + this.offset.x + "," + this.offset.y;
        }
        if (this.withMask || this.isMask) {
            ret = ret + " masked";
        }
        return ret;
    }
}

