/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.support;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.sikuli.basics.Debug;
import org.sikuli.script.support.ExtensionManager;
import org.sikuli.script.support.RunTime;

public class ExtensionManagerFrame
extends JFrame {
    static final String EXTENSION_LIST_URL = "";
    private static ExtensionManagerFrame _instance = null;
    private int selected_idx = 0;
    ArrayList<ExtensionItem> _extensions;
    private File[] fExtensions;
    private List<String> classpath;

    private ExtensionManagerFrame() {
        this.fExtensions = RunTime.get().fSikulixExtensions.listFiles();
    }

    public static ExtensionManagerFrame getInstance() {
        if (_instance == null) {
            _instance = new ExtensionManagerFrame();
        }
        return _instance;
    }

    public List<String> getClasspath() {
        return this.classpath;
    }

    public List<File> getExtensionFiles() {
        ArrayList<File> extensions = new ArrayList<File>();
        for (File extension : this.fExtensions) {
            String name = extension.getName();
            if (name.startsWith(".") || !name.endsWith(".jar")) continue;
            extensions.add(extension);
        }
        return extensions;
    }

    private void init() {
        this.setTitle("Sikuli Extensions");
        this.setResizable(false);
        this.createComponents();
        this.addKeyListener(new SelectExtensionKeyListener());
        this.pack();
        this.setLocationRelativeTo(null);
    }

    private void createComponents() {
        Container pane = this.getContentPane();
        pane.setLayout(new BoxLayout(pane, 1));
        try {
            this._extensions = this.retrieveExtensions();
            for (ExtensionItem ext : this._extensions) {
                pane.add(ext);
            }
            this.select(0);
        }
        catch (IOException io) {
            String msg = "Unable to load extensions list from: ";
            JTextField txt = new JTextField(msg);
            txt.setBackground(null);
            txt.setBorder(null);
            txt.setEditable(false);
            pane.add(txt);
        }
        JPanel bottomBar = new JPanel();
        bottomBar.setLayout(new BorderLayout());
        bottomBar.setMinimumSize(new Dimension(400, 20));
        JButton closeBtn = new JButton("Close");
        closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ExtensionManagerFrame.this.dispose();
            }
        });
        closeBtn.setFocusable(false);
        bottomBar.add((Component)closeBtn, "After");
        pane.add(bottomBar);
    }

    private ArrayList<ExtensionItem> retrieveExtensions() throws IOException {
        ArrayList<ExtensionItem> extensions = new ArrayList<ExtensionItem>();
        Debug.log(2, "Retrieving from ", new Object[0]);
        String json = ExtensionManagerFrame.html2txt(EXTENSION_LIST_URL);
        Object obj = null;
        Map map = obj;
        Map extension_list = (Map)map.get("extension-list");
        List exts = (List)extension_list.get("extensions");
        for (Object o : exts) {
            Map ext = (Map)o;
            String name = (String)ext.get("name");
            String version = (String)ext.get("version");
            String description = (String)ext.get("description");
            String imgurl = (String)ext.get("imgurl");
            String infourl = (String)ext.get("infourl");
            String jarurl = (String)ext.get("jarurl");
            extensions.add(new ExtensionItem(name, version, description, imgurl, infourl, jarurl));
        }
        return extensions;
    }

    private static String html2txt(String urlstring) throws IOException {
        String inputLine;
        URL url = new URL(urlstring);
        URLConnection yc = url.openConnection();
        yc.setConnectTimeout(5000);
        BufferedReader in = new BufferedReader(new InputStreamReader(yc.getInputStream()));
        String txt = EXTENSION_LIST_URL;
        while ((inputLine = in.readLine()) != null) {
            txt = txt + inputLine;
        }
        in.close();
        return txt;
    }

    protected void select(ExtensionItem ext) {
        int idx = this._extensions.indexOf(ext);
        this.select(idx);
    }

    private void select(int idx) {
        this._extensions.get(this.selected_idx).setSelected(false);
        this.selected_idx = idx;
        this._extensions.get(this.selected_idx).setSelected(true);
    }

    private void selectPrevious() {
        if (this.selected_idx == 0) {
            return;
        }
        this.select(this.selected_idx - 1);
    }

    private void selectNext() {
        if (this.selected_idx == this._extensions.size() - 1) {
            return;
        }
        this.select(this.selected_idx + 1);
    }

    private class SelectExtensionKeyListener
    implements KeyListener {
        private SelectExtensionKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 38) {
                ExtensionManagerFrame.this.selectPrevious();
            } else if (key == 40) {
                ExtensionManagerFrame.this.selectNext();
            }
        }

        @Override
        public void keyReleased(KeyEvent arg0) {
        }

        @Override
        public void keyTyped(KeyEvent arg0) {
        }
    }

    static class ExtensionItem
    extends JPanel
    implements ActionListener {
        JButton _installCtrl;
        JButton _infoCtrl;
        String _name;
        String _infourl;
        String _jarurl;
        String _version;
        String _description;
        boolean _installed;
        final int NOT_INSTALLED = 0;
        final int INSTALLED = 1;
        final int OUT_OF_DATE = 2;
        int _status = 0;
        JPanel _controls;
        JPanel _content;
        JLabel _htmlLabel;

        public ExtensionItem(String name, String version, String description, String imgurl, String infourl, String jarurl) {
            this._name = name;
            this._version = version;
            this._infourl = infourl;
            this._infourl = infourl;
            this._jarurl = jarurl;
            this._description = description;
            this._status = this.getStatus();
            this.setLayout(new BoxLayout(this, 1));
            Border loweredetched = BorderFactory.createEtchedBorder(1);
            this.setBorder(loweredetched);
            this._content = new JPanel();
            BufferedImage image = null;
            try {
                URL url = new URL(imgurl);
                image = ImageIO.read(url);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (image == null) {
                // empty if block
            }
            JLabel iconLabel = new JLabel();
            iconLabel.setIcon(new ImageIcon(image));
            iconLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this._content.setLayout(new BorderLayout(5, 5));
            this._content.add((Component)iconLabel, "Before");
            this._htmlLabel = new JLabel(this.renderHTML());
            this._content.add(this._htmlLabel);
            this.add(this._content);
            JButton btn = new JButton("extBtnInstall");
            btn.addActionListener(this);
            btn.setActionCommand("Install");
            this._installCtrl = btn;
            this._installCtrl.setFocusable(false);
            btn = new JButton("extBtnInfo");
            btn.addActionListener(this);
            btn.setActionCommand("Info");
            this._infoCtrl = btn;
            this._infoCtrl.setFocusable(false);
            this._controls = new JPanel();
            this._controls.setLayout(new BorderLayout(5, 5));
            this._controls.add((Component)this._infoCtrl, "Before");
            this._controls.add((Component)this._installCtrl, "After");
            this.add(this._controls);
            this.updateControls();
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    ExtensionManagerFrame.getInstance().select((ExtensionItem)e.getSource());
                }
            });
        }

        protected void setSelected(boolean selected) {
            this._controls.setVisible(selected);
        }

        private String renderHTML() {
            String installed_version = ExtensionManager.getInstance().getVersion(this._name);
            if (installed_version == null) {
                installed_version = "Not installed";
            }
            return "<html><div style='width:300px'><b>" + this._name + "</b> (" + installed_version + ")<br>" + this._description + "</div></html>";
        }

        private void updateControls() {
            int status = this.getStatus();
            if (status == 1) {
                this._installCtrl.setEnabled(false);
                this._installCtrl.setText("extMsgInstalled");
            } else if (status == 0) {
                this._installCtrl.setEnabled(true);
                this._installCtrl.setText("extBtnInstallVer");
            } else if (status == 2) {
                this._installCtrl.setEnabled(true);
                this._installCtrl.setText("extBtnUpdateVer");
            }
            this._htmlLabel.setText(this.renderHTML());
        }

        private int getStatus() {
            ExtensionManager extMgr = ExtensionManager.getInstance();
            if (!extMgr.isInstalled(this._name)) {
                return 0;
            }
            if (extMgr.isOutOfDate(this._name, this._version)) {
                return 2;
            }
            return 1;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("Install")) {
                Debug.log("Installing " + this._name + " from " + this._jarurl, new Object[0]);
                ExtensionManager extMgr = ExtensionManager.getInstance();
                if (extMgr.install(this._name, this._jarurl, this._version)) {
                    this.updateControls();
                }
            } else if (cmd.equals("Info")) {
                Debug.log("Openning URL: " + this._infourl, new Object[0]);
                ExtensionItem.openURL(this._infourl, this._name);
            }
        }

        static void openURL(String url, String name) {
            try {
                URL u = new URL(url);
                Desktop.getDesktop().browse(u.toURI());
            }
            catch (Exception ex) {
                Debug.error("SikuliExtension: " + name + " -- no information available!", new Object[0]);
            }
        }
    }
}

