/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.support;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.CommandLine;
import org.opencv.core.Core;
import org.sikuli.android.ADBScreen;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.HotkeyEvent;
import org.sikuli.basics.HotkeyListener;
import org.sikuli.basics.HotkeyManager;
import org.sikuli.basics.Settings;
import org.sikuli.natives.WinUtil;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Mouse;
import org.sikuli.script.Options;
import org.sikuli.script.Screen;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.Sikulix;
import org.sikuli.script.runnerSupport.JythonSupport;
import org.sikuli.script.runners.ProcessRunner;
import org.sikuli.script.support.ExtensionManager;
import org.sikuli.script.support.IScriptRunner;
import org.sikuli.script.support.Observing;
import org.sikuli.script.support.RobotDesktop;
import org.sikuli.script.support.Runner;
import org.sikuli.util.CommandArgs;
import org.sikuli.util.CommandArgsEnum;
import org.sikuli.util.Highlight;
import org.sikuli.vnc.VNCScreen;
import py4j.GatewayServer;

public class RunTime {
    private static RunTime runTime = null;
    private static final String osNameShort = System.getProperty("os.name").substring(0, 1).toLowerCase();
    private static boolean startAsIDE = true;
    private static GatewayServer pythonServer = null;
    private static String[] userArgs = new String[0];
    private static String[] sxArgs = new String[0];
    private static long elapsedStart = new Date().getTime();
    private static String logFile = "";
    private static String userLogFile = "";
    private static String[] loadScripts = new String[0];
    private static boolean shouldRunScript = false;
    private static String[] runScripts = new String[0];
    private static boolean asServer = false;
    private static String[] serverOptions = null;
    private static String serverGroups = null;
    private static String serverExtra = null;
    private static boolean asPyServer = false;
    private static boolean allowMultiple = false;
    private static File sxAppPath = null;
    private int lvl;
    private int minLvl;
    private static String preLogMessages = "";
    private static boolean verbose = false;
    private static boolean quiet = false;
    public RunType runningAs;
    private static Options sxOptions = null;
    private static boolean isTerminating = false;
    public static String appDataMsg = "";
    public static boolean testing = false;
    public static boolean testingWinApp = false;
    public Type runType;
    public String sxBuild;
    public String sxBuildStamp;
    public String jreVersion;
    public Preferences optionsIDE;
    public ClassLoader classLoader;
    public String userName;
    private Class clsRef;
    private List<URL> classPathActual;
    private List<String> classPathList;
    public File fTempPath;
    public File fBaseTempPath;
    public String fpBaseTempPath;
    public File fLibsFolder;
    public String fpJarLibs;
    public String fpSysLibs;
    boolean areLibsExported;
    private Map<String, Boolean> libsLoaded;
    public File fUserDir;
    public File fWorkDir;
    private int lastScriptRunReturnCode;
    public File fAppPath;
    public File fSikulixAppPath;
    public File fSikulixExtensions;
    public String[] standardExtensions;
    public File fSikulixLib;
    public File fSikulixStore;
    public File fSikulixDownloadsGeneric;
    public File fSikulixDownloadsBuild;
    public File fSikulixSetup;
    public File fSxBase;
    public File fSxBaseJar;
    public File fSxProject;
    public File fSxProjectTestScriptsJS;
    public File fSxProjectTestScripts;
    public String fpContent;
    public boolean runningJar;
    public boolean runningInProject;
    public boolean runningWindows;
    public boolean runningMac;
    public boolean runningLinux;
    private final String osNameSysProp;
    private final String osVersionSysProp;
    public String javaShow;
    public int javaArch;
    public String osArch;
    public int javaVersion;
    public File javahome;
    public String osName;
    public String sysName;
    public String osVersion;
    private String appType;
    public String linuxDistro;
    public int SikuliVersionMajor;
    public int SikuliVersionMinor;
    public int SikuliVersionSub;
    public String SXVersion;
    public String SXVersionLong;
    public String SXVersionShort;
    public String SXBuild;
    public String SXBuildNumber;
    public String SXVersionIDE;
    public String SXVersionAPI;
    public String SXSystemVersion;
    public String SXJavaVersion;
    public String[] ServerList;
    public static final String libOpenCV = Core.NATIVE_LIBRARY_NAME;
    public static final String runCmdError = "*****error*****";
    public static String NL = "\n";
    public File fLibsProvided;
    public File fLibsLocal;
    public boolean useLibsProvided;
    private String lastResult;
    public boolean isJythonReady;
    static final long started = new Date().getTime();
    static final long obsolete = started - 172800000L;
    static boolean optTesting = false;
    File isRunning;
    FileOutputStream isRunningFile;
    String isRunningFilename;
    private boolean didExport;
    public static boolean isRunningIDE = false;
    Class<?> cIDE;
    Method mHide;
    Method mShow;
    private static RobotDesktop cleanupRobot = null;
    private static boolean isLibExported = false;
    List<String> sxClasspath;

    public static boolean isIDE() {
        return startAsIDE;
    }

    public static void start(Type type, String[] args) {
        Debug.init();
        if (Type.API.equals((Object)type)) {
            startAsIDE = false;
            if (args.length == 1 && "buildDate".equals(args[0])) {
                RunTime runTime = RunTime.get();
                System.out.println(runTime.SXBuild);
                System.exit(0);
            }
            if (args.length == 1 && "createlibs".equals(args[0])) {
                Debug.off();
                CodeSource codeSource = Sikulix.class.getProtectionDomain().getCodeSource();
                if (codeSource != null && codeSource.getLocation().toString().endsWith("classes/")) {
                    File libsSource = new File(new File(codeSource.getLocation().getFile()).getParentFile().getParentFile(), "src/main/resources");
                    for (String sys : new String[]{"mac", "windows", "linux"}) {
                        Sikulix.print("******* %s", sys);
                        String sxcontentFolder = String.format("sikulixlibs/%s/libs64", sys);
                        List<String> sikulixlibs = RunTime.get().getResourceList(sxcontentFolder);
                        String sxcontent = "";
                        for (String lib : sikulixlibs) {
                            if (lib.equals("sikulixcontent")) continue;
                            sxcontent = sxcontent + lib + "\n";
                        }
                        Sikulix.print("%s", sxcontent);
                        FileManager.writeStringToFile(sxcontent, new File(libsSource, sxcontentFolder + "/sikulixcontent"));
                    }
                }
                System.exit(0);
            }
        }
        List<String> finalArgs = RunTime.evalArgsStart(args);
        File runningJar = RunTime.getRunningJar(type);
        String jarName = runningJar.getName();
        RunTime.startLog(1, "Running: %s", runningJar);
        File fAppData = RunTime.getAppPath();
        RunTime.startLog(1, "AppData: %s", fAppData);
        String classPath = "";
        if (!jarName.endsWith(".jar")) {
            classPath = System.getProperty("java.class.path");
            return;
        }
        classPath = ExtensionManager.makeClassPath(runningJar);
        ArrayList<String> cmd = new ArrayList<String>();
        System.getProperty("java.home");
        if (RunTime.get().runningWindows) {
            cmd.add(System.getProperty("java.home") + "\\bin\\java.exe");
        } else {
            cmd.add(System.getProperty("java.home") + "/bin/java");
        }
        if (RunTime.get().isJava9(new String[0])) {
            cmd.add("--add-opens");
            cmd.add("java.desktop/javax.swing.plaf.basic=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/sun.nio.ch=ALL-UNNAMED");
            cmd.add("--add-opens");
            cmd.add("java.base/java.io=ALL-UNNAMED");
            cmd.add("-Dnashorn.args=--no-deprecation-warning");
        }
        cmd.add("-Dfile.encoding=UTF-8");
        if (startAsIDE) {
            cmd.add("-Dsikuli.IDE_should_run");
        } else {
            cmd.add("-Dsikuli.API_should_run");
        }
        if (!classPath.isEmpty()) {
            cmd.add("-cp");
            cmd.add(classPath);
        }
        if (startAsIDE) {
            cmd.add("org.sikuli.ide.SikulixIDE");
        } else {
            cmd.add("org.sikuli.script.support.SikulixAPI");
        }
        cmd.addAll(finalArgs);
        RunTime.startLog(3, "*********************** leaving start", new Object[0]);
        if (RunTime.shouldDetach()) {
            ProcessRunner.detach(cmd);
            System.exit(0);
        } else {
            int exitCode = ProcessRunner.runBlocking(cmd);
            System.exit(exitCode);
        }
    }

    private static File getRunningJar(Type type) {
        File jarFile = null;
        String jarName = "notKnown";
        CodeSource codeSrc = RunTime.class.getProtectionDomain().getCodeSource();
        if (Type.IDE.equals((Object)type)) {
            try {
                Class<?> cIDE = Class.forName("org.sikuli.ide.SikulixIDE");
                codeSrc = cIDE.getProtectionDomain().getCodeSource();
            }
            catch (ClassNotFoundException e) {
                RunTime.startLog(-1, "IDE startup: not possible for: %s", e.getMessage());
                System.exit(1);
            }
        }
        if (codeSrc != null && codeSrc.getLocation() != null) {
            try {
                jarName = codeSrc.getLocation().getPath();
                jarName = URLDecoder.decode(jarName, "utf8");
            }
            catch (UnsupportedEncodingException e) {
                RunTime.startLog(-1, "URLDecoder: not possible: %s", jarName);
                System.exit(1);
            }
            jarFile = new File(jarName);
        }
        return jarFile;
    }

    public static void afterStart(Type type, String[] args) {
        String startType = "IDE";
        if (Type.IDE.equals((Object)type)) {
            if (null == System.getProperty("sikuli.IDE_should_run")) {
                System.out.println("[ERROR] org.sikuli.ide.SikulixIDE: unauthorized use. Use: org.sikuli.ide.Sikulix");
                System.exit(1);
            }
        } else {
            if (null == System.getProperty("sikuli.API_should_run")) {
                System.out.println("[ERROR] org.sikuli.script.SikulixAPI: unauthorized use. Use: org.sikuli.script.Sikulix");
                System.exit(1);
            }
            startType = "API";
        }
        RunTime.evalArgsStart(args);
        Debug.log(3, "Sikulix: starting " + startType, new Object[0]);
        RunTime.evalArgs(args);
        ExtensionManager.readExtensions(true);
        if (RunTime.isQuiet()) {
            Debug.quietOn();
        } else if (RunTime.isVerbose()) {
            Debug.setWithTimeElapsed(RunTime.getElapsedStart());
            Debug.setGlobalDebug(3);
            Debug.globalTraceOn();
            Debug.setStartWithTrace();
        }
        if (!RunTime.getLogFile().isEmpty()) {
            Debug.setLogFile(RunTime.getLogFile());
        }
        if (!RunTime.getUserLogFile().isEmpty()) {
            Debug.setUserLogFile(RunTime.getUserLogFile());
        }
        if (RunTime.runningScripts()) {
            HotkeyManager.getInstance().addHotkey("Abort", new HotkeyListener(){

                @Override
                public void hotkeyPressed(HotkeyEvent e) {
                    RunTime.get();
                    if (RunTime.runningScripts()) {
                        Runner.abortAll();
                        RunTime.terminate(254, "AbortKey was pressed: aborting all running scripts", new Object[0]);
                    }
                }
            });
            int exitCode = Runner.runScripts(RunTime.getRunScripts(), userArgs, new IScriptRunner.Options());
            if (exitCode > 255) {
                exitCode = 254;
            }
            RunTime.terminate(exitCode, "", new Object[0]);
        }
        if (RunTime.shouldRunPythonServer()) {
            RunTime.get().installStopHotkeyPythonServer();
            if (Debug.getDebugLevel() == 3) {
                // empty if block
            }
            RunTime.startPythonServer();
        }
        if (RunTime.shouldRunServer()) {
            Class<?> cServer = null;
            try {
                cServer = Class.forName("org.sikuli.script.runners.ServerRunner");
                cServer.getMethod("run", new Class[0]).invoke(null, new Object[0]);
                RunTime.terminate();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            try {
                cServer = Class.forName("org.sikuli.script.support.SikulixServer");
                if (!((Boolean)cServer.getMethod("run", new Class[0]).invoke(null, new Object[0])).booleanValue()) {
                    RunTime.terminate(1, "SikulixServer: terminated with errors", new Object[0]);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            RunTime.terminate();
        }
    }

    public void installStopHotkeyPythonServer() {
        HotkeyManager.getInstance().addHotkey("Abort", new HotkeyListener(){

            @Override
            public void hotkeyPressed(HotkeyEvent e) {
                Debug.log(3, "Stop HotKey was pressed", new Object[0]);
                RunTime.get();
                if (RunTime.shouldRunPythonServer()) {
                    RunTime.stopPythonServer();
                    RunTime.terminate();
                }
            }
        });
    }

    public static void startPythonServer() {
        if (!RunTime.isRunningPyServer()) {
            try {
                Class.forName("py4j.GatewayServer");
                pythonServer = new GatewayServer();
            }
            catch (ClassNotFoundException e) {
                Debug.error("Python server: py4j not on classpath", new Object[0]);
                RunTime.terminate();
            }
            pythonServer.start(false);
        }
    }

    public static void stopPythonServer() {
        if (RunTime.isRunningPyServer()) {
            Debug.logp("Python server: trying to stop", new Object[0]);
            pythonServer.shutdown();
            pythonServer = null;
        }
    }

    public static boolean isRunningPyServer() {
        return null != pythonServer;
    }

    public static File asFolder(String option) {
        if (null == option) {
            return null;
        }
        File folder = new File(option);
        if (!folder.isAbsolute()) {
            folder = new File(RunTime.get().fWorkDir, option);
        }
        if (folder.isDirectory() && folder.exists()) {
            return folder;
        }
        return null;
    }

    public static File asFile(String option) {
        if (null == option) {
            return null;
        }
        if (null == RunTime.asFolder(option)) {
            File file = new File(option);
            if (!file.isAbsolute()) {
                file = new File(RunTime.get().fWorkDir, option);
            }
            if (file.exists()) {
                return file;
            }
        }
        return null;
    }

    public static void evalArgs(String[] args) {
        String cmdValue;
        CommandArgs cmdArgs = new CommandArgs();
        CommandLine cmdLine = cmdArgs.getCommandLine(args);
        boolean cmdLineValid = true;
        if (cmdLine == null) {
            RunTime.startLog(-1, "Did not find any valid option on command line!", new Object[0]);
            cmdLineValid = false;
        } else {
            RunTime.setArgs(cmdArgs.getUserArgs(), cmdArgs.getSXArgs());
        }
        if (cmdLineValid && cmdLine.hasOption("h")) {
            cmdArgs.printHelp();
            System.exit(0);
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.DEBUG.shortname()) && (cmdValue = cmdLine.getOptionValue(CommandArgsEnum.DEBUG.longname())) != null) {
            Debug.setDebugLevel(cmdValue);
        }
        if (cmdLineValid && cmdLine.hasOption("g")) {
            if (cmdLine.hasOption("s")) {
                serverGroups = cmdLine.getOptionValue("g");
                RunTime.startLog(3, "groups (-g): %s", serverGroups);
            } else {
                RunTime.startLog(-1, "groups (-g): currently only accepted with -s", new Object[0]);
            }
        }
        if (cmdLineValid && cmdLine.hasOption("x")) {
            if (cmdLine.hasOption("s")) {
                serverExtra = cmdLine.getOptionValue("x");
                RunTime.startLog(3, "extra (-x): %s", serverExtra);
            } else {
                RunTime.startLog(-1, "extra (-x): currently only accepted with -s", new Object[0]);
            }
        }
        if (cmdLineValid && cmdLine.hasOption("s")) {
            serverOptions = cmdLine.getOptionValues("s");
        }
        if (cmdLineValid && cmdLine.hasOption("m")) {
            RunTime.setAllowMultiple();
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.LOGFILE.shortname())) {
            logFile = cmdLine.getOptionValue(CommandArgsEnum.LOGFILE.longname());
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.USERLOGFILE.shortname())) {
            userLogFile = cmdLine.getOptionValue(CommandArgsEnum.USERLOGFILE.longname());
        }
        if (cmdLineValid && cmdLine.hasOption("c")) {
            System.setProperty("sikuli.console", "false");
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.LOAD.shortname())) {
            loadScripts = cmdLine.getOptionValues(CommandArgsEnum.LOAD.longname());
        }
        if (cmdLineValid && cmdLine.hasOption(CommandArgsEnum.RUN.shortname())) {
            runScripts = RunTime.resolveRelativeFiles(cmdLine.getOptionValues(CommandArgsEnum.RUN.longname()));
        }
    }

    public static String[] resolveRelativeFiles(String[] givenScripts) {
        String[] runScripts = new String[givenScripts.length];
        String baseDir = RunTime.get().fWorkDir.getPath();
        for (int i = 0; i < runScripts.length; ++i) {
            String givenScript = givenScripts[i];
            String file = RunTime.resolveRelativeFile(givenScript, baseDir);
            if (file == null) {
                file = RunTime.resolveRelativeFile(givenScript + ".sikuli", baseDir);
                if (file == null) {
                    runScripts[i] = "?" + givenScript;
                    continue;
                }
            } else if (i == 0 && file.endsWith(".sikuli")) {
                baseDir = new File(file).getParent();
            }
            IScriptRunner.EffectiveRunner runnerAndFile = Runner.getEffectiveRunner(file);
            IScriptRunner runner = runnerAndFile.getRunner();
            String fileToRun = runnerAndFile.getScript();
            File possibleDir = null;
            if (null == fileToRun) {
                for (String ending : new String[]{"", ".sikuli"}) {
                    possibleDir = new File(file + ending);
                    if (possibleDir.exists()) break;
                    possibleDir = null;
                }
                if (null == possibleDir) {
                    runScripts[i] = "?" + givenScript;
                    continue;
                }
                baseDir = possibleDir.getAbsolutePath();
                runnerAndFile = Runner.getEffectiveRunner(baseDir);
                fileToRun = runnerAndFile.getScript();
                fileToRun = fileToRun == null ? "!" + baseDir : baseDir;
            }
            runScripts[i] = fileToRun;
        }
        return runScripts;
    }

    public static String resolveRelativeFile(String scriptName, String baseDir) {
        if (RunTime.get().runningWindows && (scriptName.startsWith("\\") || scriptName.startsWith("/"))) {
            scriptName = new File(scriptName).getAbsolutePath();
            return scriptName;
        }
        File file = new File(scriptName);
        if (!file.isAbsolute()) {
            File inBaseDir = new File(baseDir, scriptName);
            if (inBaseDir.exists()) {
                file = inBaseDir;
            } else {
                File inWorkDir = new File(RunTime.get().fWorkDir, scriptName);
                if (inWorkDir.exists()) {
                    file = inWorkDir;
                } else {
                    File inUserDir = new File(RunTime.get().fUserDir, scriptName);
                    if (inUserDir.exists()) {
                        file = inUserDir;
                    } else {
                        return null;
                    }
                }
            }
        }
        return file.getAbsolutePath();
    }

    private static List<String> evalArgsStart(String[] args) {
        ArrayList<String> finalArgs = new ArrayList<String>();
        for (String arg : args) {
            if ("-v".equals(arg)) {
                RunTime.setVerbose();
            } else if ("-q".equals(arg)) {
                RunTime.setQuiet();
            } else if ("-r".equals(arg)) {
                shouldRunScript = true;
            } else if ("-s".equals(arg)) {
                asServer = true;
            } else if ("-p".equals(arg)) {
                asPyServer = true;
            }
            finalArgs.add(arg);
        }
        return finalArgs;
    }

    private static void setArgs(String[] args, String[] sargs) {
        userArgs = args;
        sxArgs = sargs;
    }

    public static String[] getSXArgs() {
        return sxArgs;
    }

    public static void setUserArgs(String[] args) {
        userArgs = new String[args.length];
        int n = 0;
        String[] stringArray = args;
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String arg;
            RunTime.userArgs[n] = arg = stringArray[i];
            ++n;
        }
    }

    public static String[] getUserArgs() {
        return userArgs;
    }

    public static void printArgs() {
        int i;
        String[] xargs = RunTime.getSXArgs();
        if (xargs.length > 0) {
            RunTime.startLog(1, "--- Sikuli parameters ---", new Object[0]);
            for (i = 0; i < xargs.length; ++i) {
                RunTime.startLog(1, "%d: %s", i + 1, xargs[i]);
            }
        }
        if ((xargs = RunTime.getUserArgs()).length > 0) {
            RunTime.startLog(1, "--- User parameters ---", new Object[0]);
            for (i = 0; i < xargs.length; ++i) {
                RunTime.startLog(1, "%d: %s", i + 1, xargs[i]);
            }
        }
    }

    public static long getElapsedStart() {
        return elapsedStart;
    }

    public static String getLogFile() {
        return logFile;
    }

    public static String getUserLogFile() {
        return userLogFile;
    }

    public static String[] getLoadScripts() {
        return loadScripts;
    }

    public static String[] getRunScripts() {
        return runScripts;
    }

    public static boolean runningScripts() {
        return shouldRunScript;
    }

    public static boolean shouldRunServer() {
        return asServer;
    }

    public static String[] getServerOptions() {
        return serverOptions;
    }

    public static String getServerGroups() {
        return serverGroups;
    }

    public static String getServerExtra() {
        return serverExtra;
    }

    public static boolean shouldRunPythonServer() {
        return asPyServer;
    }

    public static void setAllowMultiple() {
        allowMultiple = true;
    }

    public static boolean isAllowMultiple() {
        return allowMultiple;
    }

    public static boolean shouldDetach() {
        return !RunTime.runningScripts() && !RunTime.shouldRunServer() && !RunTime.shouldRunPythonServer();
    }

    public static File getAppPath() {
        File fUserDir;
        if (null != sxAppPath) {
            return sxAppPath;
        }
        String userHome = System.getProperty("user.home");
        if (userHome == null || userHome.isEmpty() || !(fUserDir = new File(userHome)).exists()) {
            RunTime.startLog(-1, "JavaSystemProperty::user.home not valid: %s", userHome);
            System.exit(-1);
        } else {
            if ("w".equals(osNameShort)) {
                String appPath = System.getenv("APPDATA");
                if (appPath != null && !appPath.isEmpty()) {
                    sxAppPath = new File(new File(appPath), "Sikulix");
                }
            } else {
                sxAppPath = "m".equals(osNameShort) ? new File(new File(fUserDir, "Library/Application Support"), "Sikulix") : new File(fUserDir, ".Sikulix");
            }
            if (!sxAppPath.exists()) {
                sxAppPath.mkdirs();
            }
            if (!sxAppPath.exists()) {
                RunTime.startLog(-1, "JavaSystemProperty::user.home not valid: %s", userHome);
                System.exit(-1);
            }
        }
        return sxAppPath;
    }

    public static boolean isVerbose() {
        return verbose;
    }

    public static void setVerbose() {
        verbose = true;
        Debug.setDebugLevel(3);
        Debug.setWithTimeElapsed(RunTime.getElapsedStart());
        Debug.setGlobalDebug(3);
        Debug.globalTraceOn();
        Debug.setStartWithTrace();
    }

    public static boolean isQuiet() {
        return quiet;
    }

    public static void setQuiet() {
        quiet = true;
    }

    public static void startLog(int level, String msg, Object ... args) {
        String typ = startAsIDE ? "IDE" : "API";
        String msgShow = String.format("startUp: %s: ", typ);
        if (!RunTime.isVerbose()) {
            return;
        }
        if (level < 0) {
            msgShow = "[ERROR]" + msgShow + msg;
            System.out.println(String.format(msgShow, args));
            return;
        }
        if (RunTime.isQuiet()) {
            return;
        }
        if (RunTime.isVerbose()) {
            msgShow = level > 0 ? "[DEBUG]" + msgShow + msg : "[INFO]" + msgShow + msg;
            System.out.println(String.format(msgShow, args));
        }
    }

    public static String arrayToQuotedString(String[] args) {
        String ret = "";
        for (String s : args) {
            if (s.contains(" ")) {
                s = "\"" + s + "\"";
            }
            ret = ret + s + " ";
        }
        return ret;
    }

    private void log(int level, String message, Object ... args) {
        Debug.logx(level, "RunTime:" + message, args);
    }

    private void logp(String message, Object ... args) {
        Debug.logx(-3, message, args);
    }

    private void logp(int level, String message, Object ... args) {
        if (level <= Debug.getDebugLevel()) {
            this.logp(message, args);
        }
    }

    public boolean runningIDE() {
        return Type.IDE.equals((Object)this.runType);
    }

    public int getLastScriptRunReturnCode() {
        return this.lastScriptRunReturnCode;
    }

    public void setLastScriptRunReturnCode(int lastScriptRunReturnCode) {
        this.lastScriptRunReturnCode = lastScriptRunReturnCode;
    }

    private RunTime() {
        this.minLvl = this.lvl = 3;
        this.runningAs = RunType.OTHER;
        this.runType = Type.INIT;
        this.sxBuild = "";
        this.sxBuildStamp = "";
        this.jreVersion = System.getProperty("java.runtime.version");
        this.optionsIDE = null;
        this.classLoader = RunTime.class.getClassLoader();
        this.userName = "";
        this.clsRef = RunTime.class;
        this.classPathActual = new ArrayList<URL>();
        this.classPathList = new ArrayList<String>();
        this.fTempPath = null;
        this.fBaseTempPath = null;
        this.fpBaseTempPath = "";
        this.fLibsFolder = null;
        this.fpJarLibs = "/sikulixlibs/";
        this.fpSysLibs = null;
        this.areLibsExported = false;
        this.libsLoaded = new HashMap<String, Boolean>();
        this.fUserDir = null;
        this.fWorkDir = null;
        this.lastScriptRunReturnCode = 0;
        this.fAppPath = null;
        this.fSikulixAppPath = null;
        this.fSikulixExtensions = null;
        this.standardExtensions = new String[]{"selenium4sikulix"};
        this.fSikulixLib = null;
        this.fSikulixDownloadsGeneric = null;
        this.fSikulixDownloadsBuild = null;
        this.fSxBase = null;
        this.fSxBaseJar = null;
        this.fSxProject = null;
        this.fSxProjectTestScriptsJS = null;
        this.fSxProjectTestScripts = null;
        this.fpContent = "sikulixcontent";
        this.runningJar = true;
        this.runningInProject = false;
        this.runningWindows = false;
        this.runningMac = false;
        this.runningLinux = false;
        this.osNameSysProp = System.getProperty("os.name");
        this.osVersionSysProp = System.getProperty("os.version");
        this.javaShow = "not-set";
        this.javaArch = 32;
        this.osArch = "??";
        this.javaVersion = 0;
        this.javahome = new File(System.getProperty("java.home"));
        this.osName = "NotKnown";
        this.sysName = "NotKnown";
        this.osVersion = "";
        this.appType = null;
        this.linuxDistro = "???LINUX???";
        this.SXVersion = "";
        this.SXBuild = "";
        this.SXBuildNumber = "";
        this.ServerList = new String[0];
        this.useLibsProvided = false;
        this.lastResult = "";
        this.isJythonReady = false;
        this.isRunning = null;
        this.isRunningFile = null;
        this.isRunningFilename = "s_i_k_u_l_i-ide-isrunning";
        this.didExport = false;
        this.cIDE = null;
        this.mHide = null;
        this.mShow = null;
        this.sxClasspath = new ArrayList<String>();
    }

    public static synchronized RunTime get() {
        if (runTime == null) {
            return RunTime.get(Type.API);
        }
        return runTime;
    }

    static boolean isObsolete(long refTime) {
        if (refTime == 0L) {
            return false;
        }
        return refTime < obsolete;
    }

    public boolean isTesting() {
        return optTesting;
    }

    public static synchronized RunTime get(Type typ) {
        int optDebugLevel;
        if (runTime != null) {
            return runTime;
        }
        runTime = new RunTime();
        if (Debug.getDebugLevel() > 3) {
            runTime.dumpSysProps();
        }
        String vJava = System.getProperty("java.specification.version");
        String vVM = System.getProperty("java.vm.version");
        String vClass = System.getProperty("java.class.version");
        RunTime.runTime.osArch = System.getProperty("os.arch");
        String vSysArch = System.getProperty("sun.arch.data.model");
        if (vSysArch != null) {
            if (vSysArch.contains("64")) {
                RunTime.runTime.javaArch = 64;
            } else {
                vSysArch = null;
            }
        }
        try {
            if (vJava.startsWith("1.")) {
                RunTime.runTime.javaVersion = Integer.parseInt(vJava.substring(2, 3));
            } else {
                String[] parts = vJava.split("\\.");
                RunTime.runTime.javaVersion = Integer.parseInt(parts[0]);
            }
            RunTime.runTime.javaShow = String.format("java %d version %s vm %s class %s arch %s", RunTime.runTime.javaVersion, vJava, vVM, vClass, vSysArch);
        }
        catch (Exception parts) {
            // empty catch block
        }
        if (RunTime.runTime.javaVersion < 8) {
            throw new SikuliXception(String.format("fatal: Java version must at least be 8 (%s)", RunTime.runTime.javaShow));
        }
        if (null == vSysArch) {
            throw new SikuliXception(String.format("fatal: Java arch must be 64 Bit (%s)", RunTime.runTime.javaShow));
        }
        RunTime.runTime.osVersion = RunTime.runTime.osVersionSysProp;
        String os = RunTime.runTime.osNameSysProp.toLowerCase();
        if (os.startsWith("windows")) {
            RunTime.runTime.sysName = "windows";
            RunTime.runTime.osName = "Windows";
            RunTime.runTime.runningWindows = true;
            NL = "\r\n";
        } else if (os.startsWith("mac")) {
            RunTime.runTime.sysName = "mac";
            RunTime.runTime.osName = "Mac OSX";
            RunTime.runTime.runningMac = true;
        } else if (os.startsWith("linux")) {
            RunTime.runTime.sysName = "linux";
            RunTime.runTime.osName = "Linux";
            RunTime.runTime.runningLinux = true;
        } else {
            RunTime.runTime.sysName = os;
            RunTime.runTime.osName = RunTime.runTime.osNameSysProp;
            RunTime.runTime.runningLinux = true;
            RunTime.runTime.linuxDistro = RunTime.runTime.osNameSysProp;
        }
        RunTime.runTime.fpJarLibs = RunTime.runTime.fpJarLibs + RunTime.runTime.sysName + "/libs" + RunTime.runTime.javaArch;
        RunTime.runTime.fpSysLibs = RunTime.runTime.fpJarLibs.substring(1);
        String aFolder = System.getProperty("user.home");
        if (aFolder == null || aFolder.isEmpty() || !(RunTime.runTime.fUserDir = new File(aFolder)).exists()) {
            throw new SikuliXception(String.format("fatal: JavaSystemProperty::user.home not valid", new Object[0]));
        }
        aFolder = System.getProperty("user.dir");
        if (aFolder == null || aFolder.isEmpty() || !(RunTime.runTime.fWorkDir = new File(aFolder)).exists()) {
            throw new SikuliXception(String.format("fatal: JavaSystemProperty::user.dir not valid", new Object[0]));
        }
        RunTime.runTime.fSikulixAppPath = new File("SikulixAppDataNotAvailable");
        if (RunTime.runTime.runningWindows) {
            appDataMsg = "init: Windows: %APPDATA% not valid (null or empty) or is not accessible: %s";
            String tmpdir = System.getenv("APPDATA");
            if (tmpdir != null && !tmpdir.isEmpty()) {
                RunTime.runTime.fAppPath = new File(tmpdir);
                RunTime.runTime.fSikulixAppPath = new File(RunTime.runTime.fAppPath, "Sikulix");
            }
        } else if (RunTime.runTime.runningMac) {
            appDataMsg = "init: Mac: SikulxAppData does not exist or is not accessible: %s";
            RunTime.runTime.fAppPath = new File(RunTime.runTime.fUserDir, "Library/Application Support");
            RunTime.runTime.fSikulixAppPath = new File(RunTime.runTime.fAppPath, "Sikulix");
        } else if (RunTime.runTime.runningLinux) {
            RunTime.runTime.fAppPath = RunTime.runTime.fUserDir;
            RunTime.runTime.fSikulixAppPath = new File(RunTime.runTime.fAppPath, ".Sikulix");
            appDataMsg = "init: Linux: SikulxAppData does not exist or is not accessible: %s";
        }
        RunTime.runTime.fSikulixStore = new File(RunTime.runTime.fSikulixAppPath, "SikulixStore");
        RunTime.runTime.fSikulixStore.mkdirs();
        sxOptions = Options.init(runTime);
        optTesting = sxOptions.isOption("testing", false);
        if (optTesting) {
            Debug.info("Options: testing = on", new Object[0]);
        }
        int n = optDebugLevel = optTesting ? Debug.getDebugLevel() : sxOptions.getOptionInteger("Debug.level", -1);
        if (optDebugLevel > Debug.getDebugLevel()) {
            Debug.info("Options: Debug.level = %d", optDebugLevel);
            Debug.on(optDebugLevel);
        }
        Settings.init(runTime);
        runTime.initSikulixOptions();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RunTime.runShutdownHook();
            }
        });
        runTime.init(typ);
        if (Type.IDE.equals((Object)typ)) {
            runTime.initIDEbefore();
            runTime.initAPI();
            runTime.initIDEafter();
        } else {
            runTime.initAPI();
        }
        return runTime;
    }

    public Rectangle getMonitor(int n) {
        if (Screen.isHeadless()) {
            return new Rectangle();
        }
        return Screen.getMonitor(n);
    }

    public Rectangle hasPoint(Point aPoint) {
        return Screen.hasPoint(aPoint);
    }

    private void init(Type typ) {
        String tmpdir;
        if ("winapp".equals(sxOptions.getOption("testing"))) {
            this.log(this.lvl, "***** for testing: simulating WinApp", new Object[0]);
            testingWinApp = true;
        }
        for (String line : preLogMessages.split(";")) {
            if (line.isEmpty()) continue;
            this.log(this.lvl, line, new Object[0]);
        }
        this.log(4, "global init: entering as: %s", new Object[]{typ});
        this.sxBuild = this.SXBuild;
        this.sxBuildStamp = this.sxBuild.replace("_", "").replace("-", "").replace(":", "").substring(0, 12);
        if (System.getProperty("user.name") != null) {
            this.userName = System.getProperty("user.name");
        }
        if (this.userName.isEmpty()) {
            this.userName = "unknown";
        }
        if ((tmpdir = System.getProperty("java.io.tmpdir")) == null || tmpdir.isEmpty()) {
            throw new SikuliXception("init: java.io.tmpdir not valid (null or empty");
        }
        this.fTempPath = new File(tmpdir);
        this.fBaseTempPath = new File(this.fTempPath, String.format("Sikulix_%d", FileManager.getRandomInt()));
        this.fpBaseTempPath = this.fBaseTempPath.getAbsolutePath();
        this.fBaseTempPath.mkdirs();
        try {
            File tempTest = new File(this.fBaseTempPath, "tempTest.txt");
            FileManager.writeStringToFile("temp test", tempTest);
            boolean success = true;
            if (tempTest.exists()) {
                tempTest.delete();
                if (tempTest.exists()) {
                    success = false;
                }
            } else {
                success = false;
            }
            if (!success) {
                throw new SikuliXception("init: java.io.tmpdir not useable");
            }
        }
        catch (Exception e) {
            throw new SikuliXception("init: java.io.tmpdir not writable");
        }
        this.log(3, "temp folder ok: %s", this.fpBaseTempPath);
        if (Type.IDE.equals((Object)typ) && !RunTime.runningScripts() && !RunTime.isAllowMultiple()) {
            this.isRunning = new File(this.fTempPath, this.isRunningFilename);
            boolean shouldTerminate = false;
            try {
                this.isRunning.createNewFile();
                this.isRunningFile = new FileOutputStream(this.isRunning);
                if (null == this.isRunningFile.getChannel().tryLock()) {
                    Class<?> classIDE = Class.forName("org.sikuli.ide.SikulixIDE");
                    Method stopSplash = classIDE.getMethod("stopSplash", new Class[0]);
                    stopSplash.invoke(null, new Object[0]);
                    Sikulix.popError("Terminating: IDE already running");
                    shouldTerminate = true;
                }
            }
            catch (Exception ex) {
                Sikulix.popError("Terminating on FatalError: cannot access IDE lock for/n" + this.isRunning);
                shouldTerminate = true;
            }
            if (shouldTerminate) {
                System.exit(1);
            }
        }
        for (String aFile : this.fTempPath.list()) {
            if ((!aFile.startsWith("Sikulix") || !new File(aFile).isFile()) && (!aFile.startsWith("jffi") || !aFile.endsWith(".tmp"))) continue;
            FileManager.deleteFileOrFolder(new File(this.fTempPath, aFile));
        }
        try {
            if (!this.fSikulixAppPath.exists()) {
                this.fSikulixAppPath.mkdirs();
            }
            if (!this.fSikulixAppPath.exists()) {
                throw new SikuliXception(String.format(appDataMsg, this.fSikulixAppPath));
            }
            this.fSikulixExtensions = new File(this.fSikulixAppPath, "Extensions");
            if (!this.fSikulixExtensions.exists()) {
                this.fSikulixExtensions.mkdir();
            }
            this.fSikulixDownloadsGeneric = new File(this.fSikulixAppPath, "SikulixDownloads");
            if (!this.fSikulixDownloadsGeneric.exists()) {
                this.fSikulixDownloadsGeneric.mkdir();
            }
            this.fSikulixLib = new File(this.fSikulixAppPath, "Lib");
            this.fSikulixSetup = new File(this.fSikulixAppPath, "SikulixSetup");
            this.fLibsProvided = new File(this.fSikulixAppPath, this.fpSysLibs);
            this.fLibsLocal = this.fLibsProvided.getParentFile().getParentFile();
        }
        catch (Exception ex) {
            throw new SikuliXception(String.format(appDataMsg + ex.toString(), this.fSikulixAppPath));
        }
        this.clsRef = RunTime.class;
        CodeSource codeSrc = this.clsRef.getProtectionDomain().getCodeSource();
        this.fSxBaseJar = null;
        URL urlCodeSrc = null;
        String urlCodeSrcProto = "not-set";
        if (codeSrc != null) {
            urlCodeSrc = codeSrc.getLocation();
            urlCodeSrcProto = urlCodeSrc.getProtocol();
            if (null != codeSrc) {
                this.fSxBaseJar = new File(codeSrc.getLocation().getPath());
                if (urlCodeSrcProto == "file") {
                    this.runningAs = RunType.CLASSES;
                    if (urlCodeSrc.getPath().endsWith(".jar")) {
                        this.runningAs = RunType.JAR;
                    }
                } else {
                    this.runningAs = RunType.OTHER;
                }
            }
        }
        this.appType = "from a jar";
        if (this.fSxBaseJar != null) {
            String baseJarName = this.fSxBaseJar.getName();
            this.fSxBase = this.fSxBaseJar.getParentFile();
            this.log(4, "runningAs: %s (%s) in: %s", new Object[]{this.runningAs, baseJarName, this.fSxBase.getAbsolutePath()});
            Debug.setWithTimeElapsed();
            if (baseJarName.contains("classes")) {
                this.runningJar = false;
                this.fSxProject = this.fSxBase.getParentFile().getParentFile();
                this.log(4, "not jar - supposing Maven project: %s", this.fSxProject);
                this.appType = "in Maven project from classes";
                this.runningInProject = true;
            } else if ("target".equals(this.fSxBase.getName())) {
                this.fSxProject = this.fSxBase.getParentFile().getParentFile();
                this.log(4, "folder target detected - supposing Maven project: %s", this.fSxProject);
                this.appType = "in Maven project from some jar";
                this.runningInProject = true;
            }
        } else {
            this.dumpClassPath();
            throw new SikuliXception(String.format("no valid Java context (%s)", this.clsRef));
        }
        if (this.runningInProject) {
            this.fSxProjectTestScriptsJS = new File(this.fSxProject, "StuffContainer/testScripts/testJavaScript");
            this.fSxProjectTestScripts = new File(this.fSxProject, "StuffContainer/testScripts");
        }
        this.runType = typ;
        if (Debug.getDebugLevel() == this.minLvl) {
            this.show();
        }
        this.log(4, "global init: leaving", new Object[0]);
    }

    public static void terminate() {
        RunTime.terminate(0, "", new Object[0]);
    }

    public static void terminate(int retval, String message, Object ... args) {
        String outMsg = String.format(message, args);
        if (!outMsg.isEmpty()) {
            System.out.println("TERMINATING: " + outMsg);
        }
        if (retval < 999) {
            isTerminating = true;
            RunTime.cleanUp();
            System.exit(retval);
        }
        throw new SikuliXception(String.format("fatal: " + outMsg, new Object[0]));
    }

    public static void cleanUp() {
        if (!isTerminating) {
            runTime.log(3, "***** running cleanUp *****", new Object[0]);
            Highlight.closeAll();
            Settings.DefaultHighlightColor = "RED";
            Settings.DefaultHighlightTime = 2.0f;
            Settings.Highlight = false;
            Settings.setShowActions(false);
            FindFailed.reset();
        }
        try {
            VNCScreen.stopAll();
            ADBScreen.stop();
        }
        catch (Exception e) {
            Debug.info("Error while stopping VNCScreen: %s", e.getMessage());
        }
        Observing.cleanUp();
        HotkeyManager.reset(isTerminating);
        if (null != cleanupRobot) {
            cleanupRobot.keyUp();
        }
        Mouse.reset();
        if (isTerminating) {
            RunTime.stopPythonServer();
        }
    }

    private static void runShutdownHook() {
        isTerminating = true;
        if (Debug.isStartWithTrace()) {
            Debug.on(3);
            Debug.globalTraceOn();
        }
        runTime.log(RunTime.runTime.lvl, "***** final cleanup at System.exit() *****", new Object[0]);
        RunTime.cleanUp();
        if (RunTime.runTime.isRunning != null) {
            try {
                RunTime.runTime.isRunningFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            RunTime.runTime.isRunning.delete();
        }
        for (File f : RunTime.runTime.fTempPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (name.toLowerCase().contains("sikuli")) {
                    if (name.contains("Sikulix_")) {
                        if (RunTime.isObsolete(new File(dir, name).lastModified()) || name.equals(runTime.fBaseTempPath.getName())) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                return false;
            }
        })) {
            runTime.log(4, "cleanTemp: " + f.getName(), new Object[0]);
            FileManager.deleteFileOrFolder(f.getAbsolutePath());
        }
    }

    void initSikulixOptions() {
        Properties prop = new Properties();
        String svf = "sikulixversion.txt";
        try {
            InputStream is = RunTime.class.getClassLoader().getResourceAsStream("Settings/" + svf);
            if (is == null) {
                String msg = String.format("fatal: initSikulixVersion: not found on classpath: %s", "Settings/" + svf);
                Debug.error(msg, new Object[0]);
                throw new SikuliXception(msg);
            }
            prop.load(is);
            is.close();
            this.SXVersion = prop.getProperty("sikulixvproject");
            String[] version = this.SXVersion.replace("-SNAPSHOT", "").split("\\.");
            if (version.length != 3) {
                throw new SikuliXception(String.format("Settings: wrong version format: %s", this.SXVersion));
            }
            this.SikuliVersionMajor = Integer.decode(version[0]);
            this.SikuliVersionMinor = Integer.decode(version[1]);
            this.SikuliVersionSub = Integer.decode(version[2]);
            this.SXBuild = prop.getProperty("sikulixbuild");
            this.SXBuildNumber = prop.getProperty("sikulixbuildnumber");
            if (this.SXBuildNumber.contains("TRAVIS_BUILD_NUMBER")) {
                this.SXBuildNumber = "";
            }
        }
        catch (Exception e) {
            String msg = String.format("Settings: load version file %s did not work: %s", svf, e.getMessage());
            Debug.error(msg, new Object[0]);
            throw new SikuliXception(msg);
        }
        this.SXVersionIDE = "SikulixIDE-" + this.SXVersion;
        this.SXVersionAPI = "SikulixAPI " + this.SXVersion;
        this.SXVersionLong = this.SXBuildNumber.isEmpty() ? this.SXVersion + String.format("-%s", this.SXBuild) : this.SXVersion + String.format("-#%s-%s", this.SXBuildNumber, this.SXBuild);
        this.SXVersionShort = this.SXVersion.replace("-SNAPSHOT", "");
        String osn = "UnKnown";
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("mac")) {
            osn = "Mac";
        } else if (os.startsWith("windows")) {
            osn = "Windows";
        } else if (os.startsWith("linux")) {
            osn = "Linux";
        }
        this.SXSystemVersion = osn + System.getProperty("os.version");
        this.SXJavaVersion = "Java" + this.javaVersion + "(" + this.javaArch + ")" + this.jreVersion;
    }

    public String getOption(String oName) {
        return sxOptions.getOption(oName);
    }

    public Options options() {
        return sxOptions;
    }

    private boolean libsLoad(String libName) {
        this.log(this.lvl, "loadlib: trying %s", libName);
        String msg = "loadLib: %s";
        if (!this.areLibsExported) {
            this.libsExport();
        }
        if (!this.areLibsExported) {
            throw new SikuliXception("loadLib: deferred exporting of libs did not work");
        }
        File fLibsFolderUsed = this.fLibsFolder;
        if (this.runningWindows) {
            libName = libName + ".dll";
        } else if (this.runningMac) {
            libName = "lib" + libName + ".dylib";
        } else if (this.runningLinux) {
            libName = "lib" + libName + ".so";
        }
        File fLib = new File(this.fLibsFolder, libName);
        int level = this.lvl;
        if (!this.runningLinux) {
            Boolean vLib = this.libsLoaded.get(libName);
            if (vLib == null || !fLib.exists()) {
                if (!fLib.exists()) {
                    throw new SikuliXception(String.format("loadlib: %s not in any libs folder", libName));
                }
                vLib = false;
            }
            if (vLib.booleanValue()) {
                msg = msg + " already loaded";
                this.log(++level, msg, libName);
                return true;
            }
        }
        try {
            if (this.runningLinux && libName.startsWith("libopen")) {
                libName = "opencv_java";
                System.loadLibrary(libName);
            } else {
                System.load(fLib.getAbsolutePath());
            }
        }
        catch (Exception e) {
            this.log(-1, "not usable: %s", e.getMessage());
            RunTime.terminate(999, "problem with native library: " + libName, new Object[0]);
        }
        catch (UnsatisfiedLinkError e) {
            this.log(-1, msg + " (failed) probably dependent libs missing:\n%s", libName, e.getMessage());
            String helpURL = "https://github.com/RaiMan/SikuliX1/wiki/macOS-Linux:-Support-Libraries-for-OpenCV-4";
            if (RunTime.isIDE()) {
                Debug.error("Save your work, correct the problem and restart the IDE!", new Object[0]);
                try {
                    Desktop.getDesktop().browse(new URI(helpURL));
                }
                catch (IOException iOException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            Debug.error("see: " + helpURL, new Object[0]);
            RunTime.terminate(999, "problem with native library: " + libName, new Object[0]);
        }
        this.libsLoaded.put(libName, true);
        this.log(level, msg + " (success)", libName);
        return true;
    }

    public boolean shouldExport() {
        return this.didExport;
    }

    private void libsExport() {
        String[] fpList = this.fTempPath.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("SikulixLibs");
            }
        });
        if (fpList.length > 0) {
            this.log(this.lvl, "libsExport: deleting obsolete libs folders in Temp", new Object[0]);
            for (String entry : fpList) {
                if (entry.endsWith(this.sxBuildStamp)) continue;
                FileManager.deleteFileOrFolder(new File(this.fTempPath, entry));
            }
        }
        if ((fpList = this.fSikulixAppPath.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("SikulixLibs_");
            }
        })).length > 0) {
            this.log(this.lvl, "libsExport: deleting obsolete libs folders in AppPath", new Object[0]);
            for (String entry : fpList) {
                FileManager.deleteFileOrFolder(new File(this.fSikulixAppPath, entry));
            }
        }
        this.fLibsFolder = new File(this.fSikulixAppPath, "SikulixLibs");
        String libMsg = "folder exists:";
        if (this.fLibsFolder.exists()) {
            Matcher matcher;
            String[] resourceList = this.fLibsFolder.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.contains("_MadeForSikuliX");
                }
            });
            String libVersion = "";
            String libStamp = "";
            if (resourceList.length > 0 && (matcher = Pattern.compile("(.*?)_(.*?)_MadeForSikuliX.*?txt").matcher(resourceList[0])).find()) {
                libVersion = matcher.group(1);
                libStamp = matcher.group(2);
            }
            if (libVersion.isEmpty() || !libVersion.equals(this.getVersionShort()) || libStamp.length() != this.sxBuildStamp.length() || 0 != libStamp.compareTo(this.sxBuildStamp)) {
                FileManager.deleteFileOrFolder(this.fLibsFolder);
                this.log(this.lvl, "libsExport: folder has wrong content: %s (%s - %s)", this.fLibsFolder, libVersion, libStamp);
            }
        }
        if (!this.fLibsFolder.exists()) {
            this.fLibsFolder.mkdirs();
            if (!this.fLibsFolder.exists()) {
                throw new SikuliXception("libsExport: folder not available: " + this.fLibsFolder.toString());
            }
            String libToken = String.format("%s_%s_MadeForSikuliX64%s.txt", this.getVersionShort(), this.sxBuildStamp, this.runningMac ? "M" : (this.runningWindows ? "W" : "L"));
            FileManager.writeStringToFile("*** Do not delete this file ***\n", new File(this.fLibsFolder, libToken));
            libMsg = "folder created:";
            List<String> nativesList = this.getResourceList(this.fpJarLibs);
            for (String aFile : nativesList) {
                String copyMsg = "exported";
                String inFile = new File(this.fpJarLibs, aFile).getPath();
                if (this.runningWindows) {
                    inFile = inFile.replace("\\", "/");
                }
                try (FileOutputStream outFile = new FileOutputStream(new File(this.fLibsFolder, aFile));
                     InputStream inStream = this.clsRef.getResourceAsStream(inFile);){
                    RunTime.copy(inStream, outFile);
                    this.libsLoaded.put(aFile, false);
                }
                catch (Exception ex) {
                    copyMsg = String.format("failed: %s", ex.getMessage());
                }
                copyMsg = String.format("libsExport: %s: %s", aFile, copyMsg);
                if (copyMsg.contains("failed")) {
                    FileManager.deleteFileOrFolder(this.fLibsFolder);
                    this.log(-1, copyMsg, new Object[0]);
                    break;
                }
                this.log(this.lvl + 1, copyMsg, new Object[0]);
                this.didExport = true;
            }
        }
        if (this.runningWindows) {
            this.addToWindowsSystemPath(this.fLibsFolder);
            if (!this.checkJavaUsrPath(this.fLibsFolder)) {
                this.log(-1, "Problems setting up on Windows - see errors - might not work and crash later", new Object[0]);
            }
            String lib = "jawt.dll";
            File fJawtDll = new File(this.fLibsFolder, lib);
            FileManager.deleteFileOrFolder(fJawtDll);
            FileManager.xcopy(new File(this.javahome, "bin/" + lib), fJawtDll);
            if (!fJawtDll.exists()) {
                throw new SikuliXception("problem copying " + fJawtDll);
            }
        }
        this.log(this.lvl, "libsExport: " + libMsg + " %s (%s - %s)", this.fLibsFolder, this.getVersionShort(), this.sxBuildStamp);
        this.areLibsExported = true;
    }

    public static boolean loadLibrary(String libname) {
        if (isTerminating) {
            return false;
        }
        return RunTime.get().libsLoad(libname);
    }

    public static boolean loadLibrary(String libname, boolean useLibsProvided) {
        RunTime runTime = RunTime.get();
        runTime.useLibsProvided = useLibsProvided;
        return RunTime.loadLibrary(libname);
    }

    private void addToWindowsSystemPath(File fLibsFolder) {
        for (File bridjFile : RunTime.runTime.fTempPath.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("BridJExtractedLibraries");
            }
        })) {
            runTime.log(4, "cleanTemp: " + bridjFile.getName(), new Object[0]);
            FileManager.deleteFileOrFolder(bridjFile);
        }
        String syspath = WinUtil.getEnv("PATH");
        if (syspath == null) {
            throw new SikuliXception("addToWindowsSystemPath: cannot access system path");
        }
        String libsPath = fLibsFolder.getAbsolutePath();
        if (!syspath.toUpperCase().contains(libsPath.toUpperCase())) {
            syspath = WinUtil.setEnv("PATH", libsPath + ";" + syspath);
            if (null != syspath && !syspath.toUpperCase().contains(libsPath.toUpperCase())) {
                this.log(-1, "addToWindowsSystemPath: adding to system path did not work:\n%s", syspath);
                throw new SikuliXception("addToWindowsSystemPath: did not work - see error");
            }
            this.log(this.lvl, "addToWindowsSystemPath: added to systempath:\n%s", libsPath);
        }
    }

    private boolean checkJavaUsrPath(File fLibsFolder) {
        if (this.isJava9(new String[0])) {
            return true;
        }
        String fpLibsFolder = fLibsFolder.getAbsolutePath();
        Field usrPathsField = null;
        boolean contained = false;
        try {
            usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
        }
        catch (NoSuchFieldException ex) {
            this.log(-1, "checkJavaUsrPath: get\n%s", ex);
        }
        catch (SecurityException ex) {
            this.log(-1, "checkJavaUsrPath: get\n%s", ex);
        }
        if (usrPathsField != null) {
            usrPathsField.setAccessible(true);
            try {
                String[] javapaths;
                for (String p : javapaths = (String[])usrPathsField.get(null)) {
                    if (!new File(p).equals(fLibsFolder)) continue;
                    contained = true;
                    break;
                }
                if (!contained) {
                    String[] newPaths = Arrays.copyOf(javapaths, javapaths.length + 1);
                    newPaths[newPaths.length - 1] = fpLibsFolder;
                    usrPathsField.set(null, newPaths);
                    this.log(this.lvl, "checkJavaUsrPath: added to ClassLoader.usrPaths", new Object[0]);
                    contained = true;
                }
            }
            catch (IllegalAccessException ex) {
                this.log(-1, "checkJavaUsrPath: set\n%s", ex);
            }
            catch (IllegalArgumentException ex) {
                this.log(-1, "checkJavaUsrPath: set\n%s", ex);
            }
            return contained;
        }
        return false;
    }

    private void initIDEbefore() {
        this.log(4, "initIDEbefore: entering", new Object[0]);
        isRunningIDE = true;
        this.log(4, "initIDEbefore: leaving", new Object[0]);
    }

    private void initIDEafter() {
        this.log(4, "initIDEafter: entering", new Object[0]);
        try {
            this.cIDE = Class.forName("org.sikuli.ide.SikulixIDE");
            this.mHide = this.cIDE.getMethod("hideIDE", new Class[0]);
            this.mShow = this.cIDE.getMethod("showIDE", new Class[0]);
        }
        catch (Exception ex) {
            this.log(-1, "SikulixIDE: reflection: %s", ex.getMessage());
        }
        this.log(4, "initIDEafter: leaving", new Object[0]);
    }

    public void hideIDE() {
        if (null != this.cIDE) {
            try {
                this.mHide.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void showIDE() {
        if (null != this.cIDE) {
            try {
                this.mShow.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void initAPI() {
        this.log(4, "initAPI: entering", new Object[0]);
        try {
            cleanupRobot = new RobotDesktop();
        }
        catch (AWTException aWTException) {
            // empty catch block
        }
        this.log(4, "initAPI: leaving", new Object[0]);
    }

    public void exportLib() {
        if (isLibExported) {
            return;
        }
        if (!this.fSikulixLib.exists() || !new File(this.fSikulixLib, "sikuli").exists()) {
            this.fSikulixLib.mkdir();
            this.extractResourcesToFolder("Lib", this.fSikulixLib, null);
        } else {
            this.extractResourcesToFolder("Lib/sikuli", new File(this.fSikulixLib, "sikuli"), null);
        }
        File fLibRobot = new File(RunTime.get().fSikulixLib, "robot");
        if (fLibRobot.exists()) {
            FileManager.deleteFileOrFolder(fLibRobot);
        }
        isLibExported = true;
    }

    public void crash() {
        int x = 1 / 0;
    }

    public static void pause(int time) {
        try {
            Thread.sleep(time * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void pause(float time) {
        try {
            Thread.sleep((int)(time * 1000.0f));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isRunningFromJar() {
        return this.runningJar;
    }

    public boolean isJava9(String ... args) {
        if (this.javaVersion > 8) {
            if (args.length > 0) {
                this.log(-1, "*** Java 9+: %s", args[0]);
            }
            return true;
        }
        return false;
    }

    public boolean isJava8() {
        return this.javaVersion > 7;
    }

    public boolean needsRobotFake() {
        return this.runningMac && Settings.ClickTypeHack;
    }

    public void show() {
        if (sxOptions.hasOptions()) {
            sxOptions.dumpOptions();
        }
        this.logp("***** show environment for %s %s", new Object[]{this.SXVersionLong, this.runType});
        this.logp("user.home: %s", this.fUserDir);
        this.logp("user.dir (work dir): %s", this.fWorkDir);
        this.logp("user.name: %s", this.userName);
        this.logp("java.io.tmpdir: %s", this.fTempPath);
        this.logp("running %dBit(%s) on %s (%s) %s", this.javaArch, this.osArch, osNameShort, this.linuxDistro.contains("???") ? this.osVersion : this.linuxDistro, this.appType);
        this.logp(this.javaShow, new Object[0]);
        this.logp("app data folder: %s", this.fSikulixAppPath);
        if (this.runningJar) {
            this.logp("executing jar: %s", this.fSxBaseJar);
        }
        if (Debug.getDebugLevel() > this.minLvl - 1 || this.isJythonReady) {
            this.dumpClassPath("sikulix");
            if (this.isJythonReady) {
                int saveLvl = Debug.getDebugLevel();
                Debug.setDebugLevel(this.lvl);
                JythonSupport.get().showSysPath();
                Screen.showMonitors();
                Debug.setDebugLevel(saveLvl);
            }
        }
        this.logp("***** show environment end", new Object[0]);
    }

    public boolean testSwitch() {
        return 0L == new Date().getTime() / 10000L % 2L;
    }

    public String getVersionShort() {
        return this.SXVersionShort;
    }

    public String getSystemInfo() {
        return String.format("%s/%s/%s", this.SXVersionLong, this.SXSystemVersion, this.SXJavaVersion);
    }

    public boolean isVersionRelease() {
        return !this.SXVersion.endsWith("-SNAPSHOT");
    }

    public String getVersion() {
        return this.SXVersion;
    }

    public void getStatus() {
        System.out.println("***** System Information Dump *****");
        System.out.println(String.format("*** SystemInfo\n%s", this.getSystemInfo()));
        System.getProperties().list(System.out);
        System.out.println("*** System Environment");
        for (String key : System.getenv().keySet()) {
            System.out.println(String.format("%s = %s", key, System.getenv(key)));
        }
        System.out.println("*** Java Class Path");
        URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        URL[] urls = sysLoader.getURLs();
        for (int i = 0; i < urls.length; ++i) {
            System.out.println(String.format("%d: %s", i, urls[i]));
        }
        System.out.println("***** System Information Dump ***** end *****");
    }

    public List<String> getResourceList(String res) {
        return this.getResourceList(res, this.clsRef);
    }

    public List<String> getResourceList(String res, Class classReference) {
        ArrayList<String> resList = new ArrayList<String>();
        CodeSource codeSource = classReference.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            return resList;
        }
        InputStream aIS = null;
        String content = null;
        res = new File(res, "sikulixcontent").getPath();
        if (this.runningWindows) {
            res = res.replace("\\", "/");
        }
        if (!res.startsWith("/")) {
            res = "/" + res;
        }
        try {
            aIS = classReference.getResourceAsStream(res);
            if (aIS != null) {
                content = new String(this.copy(aIS));
                aIS.close();
            }
            this.log(this.lvl + 1, "getResourceList: %s (%s)", res, content);
            aIS = null;
        }
        catch (Exception ex) {
            this.log(-1, "getResourceList: %s (%s)", res, ex);
        }
        try {
            if (aIS != null) {
                aIS.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (null != content) {
            String[] names;
            for (String name : names = content.split("\n")) {
                if (name.equals("sikulixcontent")) continue;
                resList.add(name.trim());
            }
        }
        return resList;
    }

    public List<String> extractResourcesToFolder(String fpRessources, File fFolder, FilenameFilter filter) {
        List<String> content = this.resourceList(fpRessources, filter);
        if (content == null) {
            return null;
        }
        if (fFolder == null) {
            return content;
        }
        return this.doExtractToFolderWithList(fpRessources, fFolder, content);
    }

    public List<String> doExtractToFolderWithList(String fpRessources, File fFolder, List<String> content) {
        int count = 0;
        int ecount = 0;
        String subFolder = "";
        if (content != null && content.size() > 0) {
            for (String eFile : content) {
                if (eFile == null) continue;
                if (eFile.endsWith("/")) {
                    subFolder = eFile.substring(0, eFile.length() - 1);
                    continue;
                }
                if (!subFolder.isEmpty()) {
                    eFile = new File(subFolder, eFile).getPath();
                }
                if (this.extractResourceToFile(fpRessources, eFile, fFolder)) {
                    this.log(this.lvl + 1, "extractResourceToFile done: %s", eFile);
                    ++count;
                    continue;
                }
                ++ecount;
            }
        }
        if (ecount > 0) {
            this.log(this.lvl, "files exported: %d - skipped: %d from %s to:\n %s", count, ecount, fpRessources, fFolder);
        } else {
            this.log(this.lvl, "files exported: %d from: %s to:\n %s", count, fpRessources, fFolder);
        }
        return content;
    }

    public List<String> extractResourcesToFolderFromJar(String aJar, String fpRessources, File fFolder, FilenameFilter filter) {
        List<String> content = new ArrayList<String>();
        File faJar = new File(aJar);
        URL uaJar = null;
        fpRessources = FileManager.slashify(fpRessources, false);
        if (faJar.isAbsolute()) {
            if (!faJar.exists()) {
                this.log(-1, "extractResourcesToFolderFromJar: does not exist:\n%s", faJar);
                return null;
            }
            try {
                uaJar = new URL("jar", null, "file:" + aJar);
            }
            catch (MalformedURLException ex) {
                this.log(-1, "extractResourcesToFolderFromJar: bad URL for:\n%s", faJar);
                return null;
            }
        }
        uaJar = this.fromClasspath(aJar);
        if (uaJar == null) {
            this.log(-1, "extractResourcesToFolderFromJar: not on classpath: %s", aJar);
            return null;
        }
        try {
            String sJar = "file:" + uaJar.getPath() + "!/";
            uaJar = new URL("jar", null, sJar);
        }
        catch (MalformedURLException ex) {
            this.log(-1, "extractResourcesToFolderFromJar: bad URL for:\n%s", uaJar);
            return null;
        }
        content = this.doResourceListJar(uaJar, fpRessources, content, filter);
        if (fFolder == null) {
            return content;
        }
        this.copyFromJarToFolderWithList(uaJar, fpRessources, content, fFolder);
        return content;
    }

    public boolean extractResourceToFile(String inPrefix, String inFile, File outDir) {
        return this.extractResourceToFile(inPrefix, inFile, outDir, "");
    }

    public boolean extractResourceToFile(String inPrefix, String inFile, File outDir, String outFile) {
        String content = inPrefix + "/" + inFile;
        try {
            File out;
            InputStream aIS;
            String string = content = this.runningWindows ? content.replace("\\", "/") : content;
            if (!content.startsWith("/")) {
                content = "/" + content;
            }
            if ((aIS = this.clsRef.getResourceAsStream(content)) == null) {
                File fInFile = new File(content);
                if (!fInFile.exists()) {
                    throw new IOException(String.format("resource not accessible: %s", content));
                }
                aIS = new FileInputStream(fInFile);
            }
            File file = out = outFile.isEmpty() ? new File(outDir, inFile) : new File(outDir, outFile);
            if (!out.getParentFile().exists()) {
                out.getParentFile().mkdirs();
            }
            FileOutputStream aFileOS = new FileOutputStream(out);
            RunTime.copy(aIS, aFileOS);
            aIS.close();
            aFileOS.close();
        }
        catch (Exception ex) {
            this.log(-1, "extractResourceToFile: %s\n%s", content, ex);
            return false;
        }
        return true;
    }

    public String extractResourceToString(String inPrefix, String inFile, String encoding) {
        InputStream aIS = null;
        String out = null;
        String content = inPrefix + "/" + inFile;
        if (!content.startsWith("/")) {
            content = "/" + content;
        }
        try {
            content = this.runningWindows ? content.replace("\\", "/") : content;
            aIS = this.clsRef.getResourceAsStream(content);
            if (aIS == null) {
                throw new IOException("resource not accessible");
            }
            if (encoding == null) {
                encoding = "UTF-8";
                out = new String(this.copy(aIS));
            } else {
                out = encoding.isEmpty() ? new String(this.copy(aIS), "UTF-8") : new String(this.copy(aIS), encoding);
            }
            aIS.close();
            aIS = null;
        }
        catch (Exception ex) {
            this.log(-1, "extractResourceToString as %s from:\n%s\n%s", encoding, content, ex);
        }
        try {
            if (aIS != null) {
                aIS.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out;
    }

    public URL resourceLocation(String folderOrFile) {
        this.log(this.lvl, "resourceLocation: (%s) %s", this.clsRef, folderOrFile);
        if (!folderOrFile.startsWith("/")) {
            folderOrFile = "/" + folderOrFile;
        }
        return this.clsRef.getResource(folderOrFile);
    }

    private List<String> resourceList(String folder, FilenameFilter filter) {
        List<String> files = new ArrayList<String>();
        if (!folder.startsWith("/")) {
            folder = "/" + folder;
        }
        URL uFolder = this.resourceLocation(folder);
        File fFolder = null;
        if (uFolder == null) {
            fFolder = new File(folder);
            if (fFolder.exists()) {
                files = this.doResourceListFolder(fFolder, files, filter);
            } else {
                this.log(this.lvl, "resourceList: not found: %s", folder);
            }
            return files;
        }
        try {
            uFolder = new URL(uFolder.toExternalForm().replaceAll(" ", "%20"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        URL uContentList = this.clsRef.getResource(folder + "/" + this.fpContent);
        if (uContentList != null) {
            return this.doResourceListWithList(folder, files, filter);
        }
        try {
            fFolder = new File(uFolder.toURI());
            this.log(this.lvl, "resourceList: having folder: %s", fFolder);
            files.add(fFolder.getPath());
            files = this.doResourceListFolder(fFolder, files, filter);
            files.remove(0);
            return files;
        }
        catch (Exception ex) {
            if (!"jar".equals(uFolder.getProtocol())) {
                this.log(this.lvl, "resourceList:\n%s", folder);
                this.log(-1, "resourceList: URL neither folder nor jar:\n%s", ex);
                return null;
            }
            String[] parts = uFolder.getPath().split("!");
            if (parts.length < 2 || !parts[0].startsWith("file:")) {
                this.log(this.lvl, "resourceList:\n%s", folder);
                this.log(-1, "resourceList: not a valid jar URL: " + uFolder.getPath(), new Object[0]);
                return null;
            }
            String fpFolder = parts[1];
            this.log(this.lvl, "resourceList: having jar: %s", uFolder);
            return this.doResourceListJar(uFolder, fpFolder, files, filter);
        }
    }

    public String[] resourceListAsFile(String folder, File target, FilenameFilter filter) {
        String content = this.resourceListAsString(folder, filter);
        if (content == null) {
            this.log(-1, "resourceListAsFile: did not work: %s", folder);
            return null;
        }
        if (target != null) {
            try {
                FileManager.deleteFileOrFolder(target.getAbsolutePath());
                target.getParentFile().mkdirs();
                PrintWriter aPW = new PrintWriter(target);
                aPW.write(content);
                aPW.close();
            }
            catch (Exception ex) {
                this.log(-1, "resourceListAsFile: %s:\n%s", target, ex);
            }
        }
        return content.split(System.getProperty("line.separator"));
    }

    public String[] resourceListAsSikulixContent(String folder, File targetFolder, FilenameFilter filter) {
        List<String> contentList = this.resourceList(folder, filter);
        if (contentList == null) {
            this.log(-1, "resourceListAsSikulixContent: did not work: %s", folder);
            return null;
        }
        File target = null;
        String[] arrString = new String[contentList.size()];
        try {
            PrintWriter aPW = null;
            if (targetFolder != null) {
                target = new File(targetFolder, this.fpContent);
                FileManager.deleteFileOrFolder(target);
                target.getParentFile().mkdirs();
                aPW = new PrintWriter(target);
            }
            int n = 0;
            for (String line : contentList) {
                arrString[n++] = line;
                if (targetFolder == null) continue;
                aPW.println(line);
            }
            if (targetFolder != null) {
                aPW.close();
            }
        }
        catch (Exception ex) {
            this.log(-1, "resourceListAsFile: %s:\n%s", target, ex);
        }
        return arrString;
    }

    public String[] resourceListAsSikulixContentFromJar(String aJar, String folder, File targetFolder, FilenameFilter filter) {
        List<String> contentList = this.extractResourcesToFolderFromJar(aJar, folder, null, filter);
        if (contentList == null || contentList.size() == 0) {
            this.log(-1, "resourceListAsSikulixContentFromJar: did not work: %s", folder);
            return null;
        }
        File target = null;
        String[] arrString = new String[contentList.size()];
        try {
            PrintWriter aPW = null;
            if (targetFolder != null) {
                target = new File(targetFolder, this.fpContent);
                FileManager.deleteFileOrFolder(target);
                target.getParentFile().mkdirs();
                aPW = new PrintWriter(target);
            }
            int n = 0;
            for (String line : contentList) {
                arrString[n++] = line;
                if (targetFolder == null) continue;
                aPW.println(line);
            }
            if (targetFolder != null) {
                aPW.close();
            }
        }
        catch (Exception ex) {
            this.log(-1, "resourceListAsFile: %s:\n%s", target, ex);
        }
        return arrString;
    }

    public String resourceListAsString(String folder, FilenameFilter filter) {
        return this.resourceListAsString(folder, filter, null);
    }

    public String resourceListAsString(String folder, FilenameFilter filter, String separator) {
        List<String> aList = this.resourceList(folder, filter);
        if (aList == null) {
            return null;
        }
        if (separator == null) {
            separator = System.getProperty("line.separator");
        }
        String out = "";
        String subFolder = "";
        if (aList != null && aList.size() > 0) {
            for (String eFile : aList) {
                if (eFile == null) continue;
                if (eFile.endsWith("/")) {
                    subFolder = eFile.substring(0, eFile.length() - 1);
                    continue;
                }
                if (!subFolder.isEmpty()) {
                    eFile = new File(subFolder, eFile).getPath();
                }
                out = out + eFile.replace("\\", "/") + separator;
            }
        }
        return out;
    }

    private List<String> doResourceListFolder(File fFolder, List<String> files, FilenameFilter filter) {
        int localLevel = testing ? this.lvl : this.lvl + 1;
        String subFolder = "";
        if (fFolder.isDirectory()) {
            String[] subList;
            if (files.size() > 0 && !FileManager.pathEquals(fFolder.getPath(), files.get(0))) {
                subFolder = fFolder.getPath().substring(files.get(0).length() + 1).replace("\\", "/") + "/";
                if (filter != null && !filter.accept(new File(files.get(0), subFolder), "")) {
                    return files;
                }
            } else {
                this.logp(localLevel, "scanning folder:\n%s", fFolder);
                subFolder = "/";
                files.add(subFolder);
            }
            for (String entry : subList = fFolder.list()) {
                File fEntry = new File(fFolder, entry);
                if (fEntry.isDirectory()) {
                    files.add(fEntry.getAbsolutePath().substring(1 + files.get(0).length()).replace("\\", "/") + "/");
                    this.doResourceListFolder(fEntry, files, filter);
                    files.add(subFolder);
                    continue;
                }
                if (filter != null && !filter.accept(fFolder, entry)) continue;
                this.logp(localLevel, "from %s adding: %s", subFolder.isEmpty() ? "." : subFolder, entry);
                files.add(fEntry.getAbsolutePath().substring(1 + fFolder.getPath().length()));
            }
        }
        return files;
    }

    public List<String> doResourceListWithList(String folder, List<String> files, FilenameFilter filter) {
        String content;
        String[] contentList = content.split((content = this.extractResourceToString(folder, this.fpContent, "")).indexOf("\r") != -1 ? "\r\n" : "\n");
        if (filter == null) {
            files.addAll(Arrays.asList(contentList));
        } else {
            for (String fpFile : contentList) {
                if (!filter.accept(new File(fpFile), "")) continue;
                files.add(fpFile);
            }
        }
        return files;
    }

    private List<String> doResourceListJar(URL uJar, String fpResource, List<String> files, FilenameFilter filter) {
        String fpJar = uJar.getPath().split("!")[0];
        int localLevel = testing ? this.lvl : this.lvl + 1;
        String fileSep = "/";
        if (!fpJar.endsWith(".jar")) {
            return files;
        }
        this.logp(localLevel, "scanning jar:\n%s", uJar);
        fpResource = (fpResource.startsWith("/") ? fpResource.substring(1) : fpResource) + "/";
        File fFolder = new File(fpResource);
        File fSubFolder = null;
        String subFolder = "";
        boolean skip = false;
        try {
            ZipEntry zEntry;
            ZipInputStream zJar = new ZipInputStream(new URL(fpJar).openStream());
            while ((zEntry = zJar.getNextEntry()) != null) {
                String zePath;
                if (zEntry.getName().endsWith("/") || !(zePath = zEntry.getName()).startsWith(fpResource)) continue;
                String zeName = zePath.substring(fpResource.length());
                int nSep = zeName.lastIndexOf(fileSep);
                String zefName = zeName.substring(nSep + 1, zeName.length());
                String zeSub = "";
                if (nSep > -1) {
                    zeSub = zeName.substring(0, nSep + 1);
                    if (!subFolder.equals(zeSub)) {
                        subFolder = zeSub;
                        fSubFolder = new File(fFolder, subFolder);
                        skip = false;
                        if (filter != null && !filter.accept(fSubFolder, "")) {
                            skip = true;
                            continue;
                        }
                        files.add(zeSub);
                    }
                    if (skip) {
                        continue;
                    }
                } else if (!subFolder.isEmpty()) {
                    subFolder = "";
                    fSubFolder = fFolder;
                    files.add("/");
                }
                if (filter != null && !filter.accept(fSubFolder, zefName)) continue;
                files.add(zefName);
                this.logp(localLevel, "from %s adding: %s", zeSub.isEmpty() ? "." : zeSub, zefName);
            }
        }
        catch (Exception ex) {
            this.log(-1, "doResourceListJar: %s", ex);
            return files;
        }
        return files;
    }

    public List<String> listFilesInJar(URL uJar) {
        String fpJar = uJar.getPath().split("!")[0];
        int localLevel = testing ? this.lvl : this.lvl + 1;
        String fileSep = "/";
        if (!fpJar.endsWith(".jar")) {
            return null;
        }
        this.logp(localLevel, "listFilesInJar: scanning jar:\n%s", uJar);
        ArrayList<String> files = new ArrayList<String>();
        try {
            ZipEntry zEntry;
            ZipInputStream zJar = new ZipInputStream(new URL(fpJar).openStream());
            while ((zEntry = zJar.getNextEntry()) != null) {
                if (zEntry.getName().endsWith("/")) continue;
                String zePath = zEntry.getName();
                files.add(zePath);
                this.logp(localLevel, "listFilesInJar: adding: %s", zePath);
            }
        }
        catch (Exception ex) {
            this.log(-1, "listFilesInJar: %s", ex);
            return files;
        }
        return files;
    }

    private boolean copyFromJarToFolderWithList(URL uJar, String fpRessource, List<String> files, File fFolder) {
        if (files == null || files.isEmpty()) {
            this.log(this.lvl, "copyFromJarToFolderWithList: list of files is empty", new Object[0]);
            return false;
        }
        String fpJar = uJar.getPath().split("!")[0];
        if (!fpJar.endsWith(".jar")) {
            return false;
        }
        int localLevel = testing ? this.lvl : this.lvl + 1;
        this.logp(localLevel, "scanning jar:\n%s", uJar);
        fpRessource = fpRessource.startsWith("/") ? fpRessource.substring(1) : fpRessource;
        String subFolder = "";
        int maxFiles = files.size() - 1;
        int nFiles = 0;
        int prefix = fpRessource.length();
        fpRessource = fpRessource + (!fpRessource.isEmpty() ? "/" : "");
        String current = "/";
        boolean shouldStop = false;
        try {
            ZipEntry zEntry;
            ZipInputStream zJar = new ZipInputStream(new URL(fpJar).openStream());
            while ((zEntry = zJar.getNextEntry()) != null) {
                String zPath = zEntry.getName();
                if (zPath.endsWith("/")) continue;
                while (current.endsWith("/")) {
                    if (nFiles > maxFiles) {
                        shouldStop = true;
                        break;
                    }
                    String string = subFolder = current.length() == 1 ? "" : current;
                    if ((current = files.get(nFiles++)).endsWith("/")) continue;
                    current = fpRessource + subFolder + current;
                    break;
                }
                if (shouldStop) break;
                if (!zPath.startsWith(current)) continue;
                if (zPath.length() == fpRessource.length() - 1) {
                    this.log(-1, "extractResourcesToFolderFromJar: only ressource folders allowed - use filter", new Object[0]);
                    return false;
                }
                this.logp(localLevel, "copying: %s", zPath);
                File out = new File(fFolder, zPath.substring(prefix));
                if (!out.getParentFile().exists()) {
                    out.getParentFile().mkdirs();
                }
                FileOutputStream aFileOS = new FileOutputStream(out);
                RunTime.copy(zJar, aFileOS);
                aFileOS.close();
                if (nFiles > maxFiles) break;
                if ((current = files.get(nFiles++)).endsWith("/")) continue;
                current = fpRessource + subFolder + current;
            }
            zJar.close();
        }
        catch (Exception ex) {
            this.log(-1, "doResourceListJar: %s", ex);
            return false;
        }
        return true;
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] tmp = new byte[8192];
        while ((len = in.read(tmp)) > 0) {
            out.write(tmp, 0, len);
        }
        out.flush();
    }

    private byte[] copy(InputStream inputStream) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int length = 0;
        while ((length = inputStream.read(buffer)) != -1) {
            baos.write(buffer, 0, length);
        }
        return baos.toByteArray();
    }

    private void storeClassPath() {
        if (this.isJava9(new String[0])) {
            String separator = File.pathSeparator;
            String cp = System.getProperty("java.class.path");
            this.classPathList = Arrays.asList(cp.split(separator));
        } else {
            this.classPathActual.clear();
            URLClassLoader sysLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            this.classPathActual = Arrays.asList(sysLoader.getURLs());
            this.classPathList.clear();
            for (URL urlPath : this.classPathActual) {
                this.classPathList.add(urlPath.toExternalForm());
            }
        }
    }

    public void dumpClassPath() {
        this.dumpClassPath(null);
    }

    public void dumpClassPath(String filter) {
        filter = filter == null ? "" : filter;
        this.logp("*** classpath dump %s", filter);
        this.storeClassPath();
        filter = filter.toUpperCase();
        int n = 0;
        for (String sEntry : this.classPathList) {
            if (!filter.isEmpty() && !sEntry.toUpperCase().contains(filter)) {
                ++n;
                continue;
            }
            this.logp("%3d: %s", n, sEntry);
            ++n;
        }
        this.logp("*** classpath dump end", new Object[0]);
    }

    private String isOnClasspath(String artefact, boolean isJar) {
        artefact = FileManager.slashify(artefact, false);
        String cpe = null;
        if (this.classPathList.isEmpty()) {
            this.storeClassPath();
        }
        for (String entry : this.classPathList) {
            String sEntry = FileManager.slashify(new File(entry).getPath(), false);
            if (!sEntry.contains(artefact) || isJar && (!sEntry.endsWith(".jar") || !new File(sEntry).getName().contains(artefact) || new File(sEntry).getName().contains("4" + artefact))) continue;
            cpe = new File(entry).getPath();
            break;
        }
        return cpe;
    }

    public String isJarOnClasspath(String artefact) {
        return this.isOnClasspath(artefact, true);
    }

    public String isOnClasspath(String artefact) {
        return this.isOnClasspath(artefact, false);
    }

    public URL fromClasspath(String artefact) {
        artefact = FileManager.slashify(artefact, false).toUpperCase();
        URL cpe = null;
        String scpe = null;
        if (this.classPathActual.isEmpty()) {
            this.storeClassPath();
        }
        for (String entry : this.classPathList) {
            String sEntry = FileManager.slashify(new File(entry).getPath(), false);
            if (!sEntry.toUpperCase().contains(artefact)) continue;
            scpe = entry;
            break;
        }
        if (null != scpe) {
            try {
                cpe = new URL(scpe);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return cpe;
    }

    public boolean isOnClasspath(URL path) {
        if (this.classPathActual.isEmpty()) {
            this.storeClassPath();
        }
        for (String string : this.classPathList) {
        }
        return false;
    }

    public boolean addToClasspath(String jarOrFolder) {
        return this.addToClasspath(jarOrFolder, "");
    }

    public boolean addToClasspath(String jarOrFolder, String caller) {
        if (null != this.isOnClasspath(jarOrFolder)) {
            return true;
        }
        if (this.isJava9("skipped: addToClasspath() - caller: " + caller)) {
            this.sxClasspath.add(jarOrFolder);
            return false;
        }
        if (!new File(jarOrFolder).exists()) {
            this.log(-1, "addToClasspath: does not exist - not added:\n%s", jarOrFolder);
            return false;
        }
        return false;
    }

    public File asExtension(String fpJar) {
        File fJarFound = new File(FileManager.normalizeAbsolute(fpJar));
        if (!fJarFound.exists()) {
            String fpCPEntry = runTime.isOnClasspath(fJarFound.getName());
            if (fpCPEntry == null) {
                fJarFound = new File(RunTime.runTime.fSikulixExtensions, fpJar);
                if (!fJarFound.exists() && !(fJarFound = new File(RunTime.runTime.fSikulixLib, fpJar)).exists()) {
                    fJarFound = null;
                }
            } else {
                fJarFound = new File(fpCPEntry, fJarFound.getName());
            }
        } else {
            return null;
        }
        return fJarFound;
    }

    public void dumpSysProps() {
        this.dumpSysProps(null);
    }

    public void dumpSysProps(String filter) {
        filter = filter == null ? "" : filter;
        this.logp("*** system properties dump " + filter, new Object[0]);
        Properties sysProps = System.getProperties();
        ArrayList<String> keysProp = new ArrayList<String>();
        Integer nL = 0;
        for (Object e : sysProps.keySet()) {
            String entry = (String)e;
            if (entry.length() > nL) {
                nL = entry.length();
            }
            if (!filter.isEmpty() && (filter.isEmpty() || !entry.contains(filter))) continue;
            keysProp.add(entry);
        }
        Collections.sort(keysProp);
        String form = "%-" + nL.toString() + "s = %s";
        for (Object e : keysProp) {
            this.logp(form, e, sysProps.get(e));
        }
        this.logp("*** system properties dump end" + filter, new Object[0]);
    }

    public String runcmd(String cmd) {
        return this.runcmd(new String[]{cmd});
    }

    public String runcmd(String[] args) {
        int retVal;
        if (args.length == 0) {
            return "";
        }
        boolean silent = false;
        if (args.length == 1) {
            String separator = "\"";
            ArrayList<String> argsx = new ArrayList<String>();
            String cmd = args[0];
            if (Settings.isWindows()) {
                cmd = cmd.replaceAll("\\\\ ", "%20;");
            }
            StringTokenizer toks = new StringTokenizer(cmd);
            while (toks.hasMoreTokens()) {
                String tok = toks.nextToken(" ");
                if (tok.length() == 0 || separator.equals(tok)) continue;
                if (tok.startsWith(separator)) {
                    if (tok.endsWith(separator)) {
                        tok = tok.substring(1, tok.length() - 1);
                    } else {
                        tok = tok.substring(1);
                        tok = tok + toks.nextToken(separator);
                    }
                }
                argsx.add(tok.replaceAll("%20;", " "));
            }
            args = argsx.toArray(new String[0]);
        }
        if (args[0].startsWith("!")) {
            silent = true;
            args[0] = args[0].substring(1);
        }
        if (args[0].startsWith("#")) {
            String pgm = args[0].substring(1);
            args[0] = new File(pgm).getAbsolutePath();
            this.runcmd(new String[]{"chmod", "ugo+x", args[0]});
        }
        String result = "";
        String error = runCmdError + NL;
        String errorOut = "";
        boolean hasError = false;
        try {
            String s;
            if (!silent) {
                if (this.lvl <= Debug.getDebugLevel()) {
                    this.log(this.lvl, RunTime.arrayToQuotedString(args), new Object[0]);
                } else {
                    Debug.info("runcmd: " + RunTime.arrayToQuotedString(args), new Object[0]);
                }
            }
            Process process = Runtime.getRuntime().exec(args);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((s = stdInput.readLine()) != null) {
                if (s.isEmpty()) continue;
                result = result + s + NL;
            }
            while ((s = stdError.readLine()) != null) {
                if (s.isEmpty()) continue;
                errorOut = errorOut + s + NL;
            }
            if (!errorOut.isEmpty()) {
                error = error + errorOut;
                hasError = true;
            }
            process.waitFor();
            retVal = process.exitValue();
            process.destroy();
        }
        catch (Exception e) {
            this.log(-1, "fatal error: " + e, new Object[0]);
            result = String.format(error + "%s", e);
            retVal = 9999;
            hasError = true;
        }
        if (hasError) {
            result = result + error;
        }
        this.lastResult = result;
        return String.format("%d%s%s", retVal, NL, result);
    }

    public String getLastCommandResult() {
        return this.lastResult;
    }

    public static enum Type {
        IDE,
        API,
        INIT;

    }

    public static enum RunType {
        JAR,
        CLASSES,
        OTHER;

    }

    public class oneFileFilter
    implements FilenameFilter {
        String aFile;

        public oneFileFilter(String aFileGiven) {
            this.aFile = aFileGiven;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.contains(this.aFile);
        }
    }

    private static enum theSystem {
        WIN,
        MAC,
        LUX,
        FOO;

    }
}

