/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script.support;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.reflections.Reflections;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.sikuli.basics.Debug;
import org.sikuli.script.ImagePath;
import org.sikuli.script.runners.AbstractScriptRunner;
import org.sikuli.script.runners.InvalidRunner;
import org.sikuli.script.support.IScriptRunner;
import org.sikuli.script.support.RunTime;

public class Runner {
    static final String me = "Runner: ";
    static final int lvl = 3;
    static final RunTime runTime = RunTime.get();
    private static List<IScriptRunner> runners = new LinkedList<IScriptRunner>();
    private static List<IScriptRunner> supportedRunners = new LinkedList<IScriptRunner>();
    private static boolean isReady = false;
    public static final int FILE_NOT_FOUND = 256;
    public static final int NOT_SUPPORTED = 257;

    static void log(int level, String message, Object ... args) {
        Debug.logx(level, me + message, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initRunners() {
        List<IScriptRunner> list = runners;
        synchronized (list) {
            if (isReady) {
                return;
            }
            if (runners.isEmpty()) {
                Reflections reflections = new Reflections(new Object[]{ClasspathHelper.forPackage((String)"org.sikuli.script.runners", (ClassLoader[])new ClassLoader[0]), new SubTypesScanner()});
                Set classes = reflections.getSubTypesOf(AbstractScriptRunner.class);
                for (Class cl : classes) {
                    IScriptRunner current = null;
                    try {
                        current = (IScriptRunner)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        Runner.log(3, "init: %s: warning: not possible", cl);
                        continue;
                    }
                    String name = current.getName();
                    if (name == null || name.startsWith("Not")) continue;
                    runners.add(current);
                    if (!current.isSupported()) continue;
                    Runner.log(3, "added: %s %s %s", current.getName(), Arrays.toString(current.getExtensions()), current.getType());
                    supportedRunners.add(current);
                }
            }
            isReady = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IScriptRunner getRunner(String identifier) {
        if (identifier == null) {
            return null;
        }
        List<IScriptRunner> list = runners;
        synchronized (list) {
            Runner.initRunners();
            for (IScriptRunner runner : supportedRunners) {
                if (!runner.canHandle(identifier)) continue;
                return runner;
            }
            return new InvalidRunner();
        }
    }

    public static IScriptRunner.EffectiveRunner getEffectiveRunner(String identifier) {
        IScriptRunner runner = Runner.getRunner(identifier);
        return runner.getEffectiveRunner(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IScriptRunner> getRunners() {
        List<IScriptRunner> list = runners;
        synchronized (list) {
            Runner.initRunners();
            return new LinkedList<IScriptRunner>(supportedRunners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IScriptRunner getRunner(Class<? extends IScriptRunner> runnerClass) {
        List<IScriptRunner> list = runners;
        synchronized (list) {
            Runner.initRunners();
            for (IScriptRunner r : supportedRunners) {
                if (!r.getClass().equals(runnerClass)) continue;
                return r;
            }
        }
        return new InvalidRunner(runnerClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getExtensions() {
        List<IScriptRunner> list = runners;
        synchronized (list) {
            Runner.initRunners();
            HashSet<String> extensions = new HashSet<String>();
            for (IScriptRunner runner : runners) {
                for (String ex : runner.getExtensions()) {
                    extensions.add(ex);
                }
            }
            return extensions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getNames() {
        List<IScriptRunner> list = runners;
        synchronized (list) {
            Runner.initRunners();
            HashSet<String> names = new HashSet<String>();
            for (IScriptRunner runner : runners) {
                names.add(runner.getName());
            }
            return names;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getTypes() {
        List<IScriptRunner> list = runners;
        synchronized (list) {
            Runner.initRunners();
            HashSet<String> types = new HashSet<String>();
            for (IScriptRunner runner : runners) {
                types.add(runner.getType());
            }
            return types;
        }
    }

    public static int runScript(String script, String[] args, IScriptRunner.Options options) {
        if (script.contains("\n")) {
            String selector;
            String[] header = script.substring(0, Math.min(100, script.length())).trim().split("\n");
            IScriptRunner runner = null;
            if (header.length > 0 && (runner = Runner.getRunner(selector = header[0])).isSupported()) {
                script = script.replaceFirst(selector, "").trim();
                return runner.evalScript(script, options);
            }
            return 0;
        }
        File scriptFile = new File(script);
        if (!scriptFile.isAbsolute()) {
            File currentScript = null;
            File currentFolder = new File(ImagePath.getBundlePath()).getParentFile();
            try {
                currentScript = new File(currentFolder, script).getCanonicalFile();
            }
            catch (IOException e) {
                Runner.log(-1, "canonical file problem: %s / %s", currentFolder, script);
            }
            if (null == currentScript || !currentScript.exists()) {
                if (null != currentScript) {
                    if (FilenameUtils.getExtension((String)script).isEmpty()) {
                        try {
                            currentScript = new File(currentFolder, script + ".sikuli").getCanonicalFile();
                        }
                        catch (IOException e) {
                            Runner.log(-1, "canonical file problem: %s / %s", currentFolder, script + ".sikuli");
                            currentScript = null;
                        }
                    }
                    if (null == currentScript || !currentScript.exists()) {
                        currentScript = null;
                    }
                }
                if (null == currentScript) {
                    Runner.log(-1, "script not found: %s", script);
                    return 256;
                }
            }
            script = currentScript.getPath();
        }
        return Runner.runScripts(new String[]{script}, args, options);
    }

    public static int runScripts(String[] runScripts, String[] args, IScriptRunner.Options options) {
        int exitCode = 0;
        if (runScripts != null && runScripts.length > 0) {
            for (String scriptGiven : runScripts) {
                if (scriptGiven.startsWith("!")) {
                    Runner.log(3, "runscript: new base directory: %s", scriptGiven.substring(1));
                    continue;
                }
                if (scriptGiven.startsWith("?")) {
                    scriptGiven = scriptGiven.substring(1);
                    exitCode = 256;
                } else {
                    Runner.log(3, "runscript: running script: %s", scriptGiven);
                    IScriptRunner runner = Runner.getRunner(scriptGiven);
                    RunTime.get().setLastScriptRunReturnCode(0);
                    exitCode = runner.runScript(scriptGiven, args, options);
                    RunTime.get().setLastScriptRunReturnCode(exitCode);
                }
                if (exitCode == 0) continue;
                if (exitCode != 256) break;
                Runner.log(-1, "runscript: (%d) not found: %s", exitCode, scriptGiven);
                break;
            }
        }
        return exitCode;
    }

    public static synchronized int run(String script, String[] args, IScriptRunner.Options options) {
        IScriptRunner runner = Runner.getRunner(script);
        int retVal = runner.runScript(script, args, options);
        return retVal;
    }

    public static void abortAll() {
        for (IScriptRunner runner : supportedRunners) {
            runner.abort();
        }
    }

    public static File getScriptFile(File fScriptFolder) {
        if (fScriptFolder == null) {
            return null;
        }
        if (fScriptFolder.isDirectory()) {
            for (File aFile : fScriptFolder.listFiles()) {
                if (aFile.isDirectory() || !FilenameUtils.getBaseName((String)aFile.getName()).toLowerCase().equals(FilenameUtils.getBaseName((String)fScriptFolder.getName()).toLowerCase())) continue;
                for (IScriptRunner runner : Runner.getRunners()) {
                    if (!runner.canHandle(aFile.getName())) continue;
                    return aFile;
                }
            }
        }
        return null;
    }
}

