/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.sikuli.basics.Debug;
import org.sikuli.util.CommandArgsEnum;

public class CommandArgs {
    private Options cmdArgs;
    ArrayList<String> userArgs = new ArrayList();
    ArrayList<String> sikuliArgs = new ArrayList();
    static String argsOrg = "";

    public CommandArgs() {
        this.init();
    }

    public CommandLine getCommandLine(String[] args) {
        PosixParser parser = new PosixParser();
        CommandLine cmd = null;
        boolean isUserArg = false;
        for (int i = 0; i < args.length; ++i) {
            if (!isUserArg && args[i].startsWith("--")) {
                isUserArg = true;
                continue;
            }
            if (isUserArg) {
                this.userArgs.add(args[i]);
                continue;
            }
            this.sikuliArgs.add(args[i]);
        }
        try {
            cmd = parser.parse(this.cmdArgs, this.sikuliArgs.toArray(new String[0]), true);
        }
        catch (ParseException exp) {
            Debug.error(exp.getMessage(), new Object[0]);
        }
        return cmd;
    }

    public String[] getUserArgs() {
        return this.userArgs.toArray(new String[0]);
    }

    public String[] getSXArgs() {
        return this.sikuliArgs.toArray(new String[0]);
    }

    private void init() {
        this.cmdArgs = new Options();
        this.cmdArgs.addOption(CommandArgsEnum.HELP.shortname(), CommandArgsEnum.HELP.longname(), false, CommandArgsEnum.HELP.description());
        OptionBuilder.withLongOpt((String)CommandArgsEnum.DEBUG.longname());
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)CommandArgsEnum.DEBUG.argname());
        OptionBuilder.withDescription((String)CommandArgsEnum.DEBUG.description());
        this.cmdArgs.addOption(OptionBuilder.create((char)CommandArgsEnum.DEBUG.shortname().charAt(0)));
        OptionBuilder.withLongOpt((String)CommandArgsEnum.LOGFILE.longname());
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)CommandArgsEnum.LOGFILE.argname());
        OptionBuilder.withDescription((String)CommandArgsEnum.LOGFILE.description());
        this.cmdArgs.addOption(OptionBuilder.create((char)CommandArgsEnum.LOGFILE.shortname().charAt(0)));
        OptionBuilder.withLongOpt((String)CommandArgsEnum.USERLOGFILE.longname());
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)CommandArgsEnum.USERLOGFILE.argname());
        OptionBuilder.withDescription((String)CommandArgsEnum.USERLOGFILE.description());
        this.cmdArgs.addOption(OptionBuilder.create((char)CommandArgsEnum.USERLOGFILE.shortname().charAt(0)));
        this.cmdArgs.addOption(CommandArgsEnum.CONSOLE.shortname(), CommandArgsEnum.CONSOLE.longname(), false, CommandArgsEnum.CONSOLE.description());
        this.cmdArgs.addOption(CommandArgsEnum.VERBOSE.shortname(), CommandArgsEnum.VERBOSE.longname(), false, CommandArgsEnum.VERBOSE.description());
        this.cmdArgs.addOption(CommandArgsEnum.QUIET.shortname(), CommandArgsEnum.QUIET.longname(), false, CommandArgsEnum.QUIET.description());
        this.cmdArgs.addOption(CommandArgsEnum.MULTI.shortname(), CommandArgsEnum.MULTI.longname(), false, CommandArgsEnum.MULTI.description());
        OptionBuilder.withLongOpt((String)CommandArgsEnum.SERVER.longname());
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)CommandArgsEnum.SERVER.argname());
        OptionBuilder.withDescription((String)CommandArgsEnum.SERVER.description());
        this.cmdArgs.addOption(OptionBuilder.create((char)CommandArgsEnum.SERVER.shortname().charAt(0)));
        OptionBuilder.withLongOpt((String)CommandArgsEnum.PYTHONSERVER.longname());
        OptionBuilder.hasOptionalArg();
        OptionBuilder.withArgName((String)CommandArgsEnum.PYTHONSERVER.argname());
        OptionBuilder.withDescription((String)CommandArgsEnum.PYTHONSERVER.description());
        this.cmdArgs.addOption(OptionBuilder.create((char)CommandArgsEnum.PYTHONSERVER.shortname().charAt(0)));
        OptionBuilder.withLongOpt((String)CommandArgsEnum.LOAD.longname());
        OptionBuilder.withDescription((String)CommandArgsEnum.LOAD.description());
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName((String)CommandArgsEnum.LOAD.argname());
        this.cmdArgs.addOption(OptionBuilder.create((char)CommandArgsEnum.LOAD.shortname().charAt(0)));
        OptionBuilder.withLongOpt((String)CommandArgsEnum.RUN.longname());
        OptionBuilder.withDescription((String)CommandArgsEnum.RUN.description());
        OptionBuilder.hasOptionalArgs();
        OptionBuilder.withArgName((String)CommandArgsEnum.RUN.argname());
        this.cmdArgs.addOption(OptionBuilder.create((char)CommandArgsEnum.RUN.shortname().charAt(0)));
    }

    public void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(80, "\n", "----- Running SikuliX -------------", this.cmdArgs, "-----\n<foobar.sikuli> (.sikuli might be omitted, is assumed)\npath relative to current working directory or absolute path\nthough deprecated: so called executables .skl can be used too\n------\nanything after --\nor after something beginning with --\ngo to script as user parameters (respecting enclosing \")\n------\n-d use this option if you encounter any weird problems\nDebugLevel=3 and all output goes to <workingFolder>/SikuliLog.text\n----------------------------------------------------------------", true);
    }

    public static String[] scanArgs(String[] args) {
        argsOrg = System.getenv("SIKULI_COMMAND");
        if (argsOrg == null) {
            argsOrg = System.getProperty("sikuli.SIKULI_COMMAND");
        }
        if (argsOrg == null) {
            argsOrg = "";
        }
        String sep = "\"";
        String temp = null;
        ArrayList<String> nargs = new ArrayList<String>();
        for (String arg : args) {
            if (arg.startsWith("asApp")) continue;
            if (arg.startsWith(sep)) {
                if (!arg.endsWith(sep)) {
                    temp = arg.substring(1);
                    continue;
                }
            } else if (arg.endsWith(sep)) {
                if (temp != null) {
                    arg = temp + " " + arg.substring(0, arg.length() - 1);
                    if (argsOrg != null && !argsOrg.contains(arg)) {
                        arg = arg.replace(" ", " *?");
                        Pattern pat = Pattern.compile("(" + arg + ")");
                        Matcher m = pat.matcher(argsOrg);
                        arg = m.find() ? m.group() : "?" + arg + "?";
                    }
                    temp = null;
                }
            } else if (temp != null) {
                temp = temp + " " + arg;
                continue;
            }
            nargs.add(arg);
        }
        return nargs.toArray(new String[0]);
    }

    public String getArgsOrg() {
        return argsOrg;
    }
}

