/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import se.vidstige.jadb.AdbFilterInputStream;
import se.vidstige.jadb.AdbFilterOutputStream;
import se.vidstige.jadb.ITransportFactory;
import se.vidstige.jadb.JadbConnection;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.RemoteFile;
import se.vidstige.jadb.RemoteFileRecord;
import se.vidstige.jadb.SyncTransport;
import se.vidstige.jadb.Transport;
import se.vidstige.jadb.managers.Bash;

public class JadbDevice {
    private static final int DEFAULT_MODE = 436;
    private final String serial;
    private final ITransportFactory transportFactory;

    JadbDevice(String serial, ITransportFactory tFactory) {
        this.serial = serial;
        this.transportFactory = tFactory;
    }

    static JadbDevice createAny(JadbConnection connection) {
        return new JadbDevice(connection);
    }

    private JadbDevice(ITransportFactory tFactory) {
        this.serial = null;
        this.transportFactory = tFactory;
    }

    private State convertState(String type) {
        switch (type) {
            case "device": {
                return State.Device;
            }
            case "offline": {
                return State.Offline;
            }
            case "bootloader": {
                return State.BootLoader;
            }
            case "recovery": {
                return State.Recovery;
            }
        }
        return State.Unknown;
    }

    private Transport getTransport() throws IOException, JadbException {
        Transport transport = this.transportFactory.createTransport();
        this.send(transport, this.serial == null ? "host:transport-any" : "host:transport:" + this.serial);
        return transport;
    }

    public String getSerial() {
        return this.serial;
    }

    public State getState() throws IOException, JadbException {
        Transport transport = this.transportFactory.createTransport();
        this.send(transport, this.serial == null ? "host:get-state" : "host-serial:" + this.serial + ":get-state");
        State state = this.convertState(transport.readString());
        transport.close();
        return state;
    }

    public InputStream executeShell(String command, String ... args) throws IOException, JadbException {
        Transport transport = this.getTransport();
        StringBuilder shellLine = this.buildCmdLine(command, args);
        this.send(transport, "shell:" + shellLine.toString());
        return new AdbFilterInputStream(new BufferedInputStream(transport.getInputStream()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void executeShell(OutputStream output, String command, String ... args) throws IOException, JadbException {
        Transport transport = this.getTransport();
        StringBuilder shellLine = this.buildCmdLine(command, args);
        this.send(transport, "shell:" + shellLine.toString());
        if (output != null) {
            try (AdbFilterOutputStream out = new AdbFilterOutputStream(output);){
                transport.readResponseTo(out);
            }
        }
    }

    public InputStream execute(String command, String ... args) throws IOException, JadbException {
        Transport transport = this.getTransport();
        StringBuilder shellLine = this.buildCmdLine(command, args);
        this.send(transport, "exec:" + shellLine.toString());
        return new BufferedInputStream(transport.getInputStream());
    }

    private StringBuilder buildCmdLine(String command, String ... args) {
        StringBuilder shellLine = new StringBuilder(command);
        for (String arg : args) {
            shellLine.append(" ");
            shellLine.append(Bash.quote(arg));
        }
        return shellLine;
    }

    public List<RemoteFile> list(String remotePath) throws IOException, JadbException {
        Transport transport = this.getTransport();
        SyncTransport sync = transport.startSync();
        sync.send("LIST", remotePath);
        ArrayList<RemoteFile> result = new ArrayList<RemoteFile>();
        RemoteFileRecord dent = sync.readDirectoryEntry();
        while (dent != RemoteFileRecord.DONE) {
            result.add(dent);
            dent = sync.readDirectoryEntry();
        }
        return result;
    }

    public void push(InputStream source, long lastModified, int mode, RemoteFile remote) throws IOException, JadbException {
        Transport transport = this.getTransport();
        SyncTransport sync = transport.startSync();
        sync.send("SEND", remote.getPath() + "," + Integer.toString(mode));
        sync.sendStream(source);
        sync.sendStatus("DONE", (int)lastModified);
        sync.verifyStatus();
    }

    public void push(File local, RemoteFile remote) throws IOException, JadbException {
        try (FileInputStream fileStream = new FileInputStream(local);){
            this.push(fileStream, local.lastModified(), 436, remote);
        }
    }

    public void pull(RemoteFile remote, OutputStream destination) throws IOException, JadbException {
        Transport transport = this.getTransport();
        SyncTransport sync = transport.startSync();
        sync.send("RECV", remote.getPath());
        sync.readChunksTo(destination);
    }

    public void pull(RemoteFile remote, File local) throws IOException, JadbException {
        try (FileOutputStream fileStream = new FileOutputStream(local);){
            this.pull(remote, fileStream);
        }
    }

    private void send(Transport transport, String command) throws IOException, JadbException {
        transport.send(command);
        transport.verifyResponse();
    }

    public String toString() {
        return "Android Device with serial " + this.serial;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serial == null ? 0 : this.serial.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JadbDevice other = (JadbDevice)obj;
        if (this.serial == null) {
            return other.serial == null;
        }
        return this.serial.equals(other.serial);
    }

    public static enum State {
        Unknown,
        Offline,
        Device,
        Recovery,
        BootLoader;

    }
}

