/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.JComponent;
import org.sikuli.guide.AnimationFactory;
import org.sikuli.guide.AnimationListener;
import org.sikuli.guide.Animator;
import org.sikuli.guide.ComponentMover;
import org.sikuli.guide.Guide;
import org.sikuli.guide.MoveAnimator;
import org.sikuli.guide.NewAnimator;
import org.sikuli.guide.ShadowRenderer;
import org.sikuli.guide.SxAnchor;
import org.sikuli.script.Pattern;
import org.sikuli.script.Region;

public class Visual
extends JComponent
implements Cloneable {
    public boolean hasChanged = false;
    public int PADDING_X = 4;
    public int PADDING_Y = 4;
    Region targetRegion = null;
    Visual targetComponent = null;
    Pattern targetPattern = null;
    Guide currentGuide = null;
    public Layout layout;
    public Layout currentLayout = this.layout = Layout.OVER;
    public static Color defColor = Color.RED;
    Color color;
    public static Color defColorFront = Color.MAGENTA;
    Color colorFront;
    public static Color defColorBack = Color.WHITE;
    Color colorBack;
    public static Color defColorFrame = Color.BLACK;
    Color colorFrame;
    public static Color defColorText = Color.BLACK;
    Color colorText;
    public static int defStroke = 3;
    int stroke;
    public static String defFont = "";
    String fontName = "";
    public static int defFontSize = 0;
    int fontSize = 0;
    static int defMaxWidth = 300;
    int maxWidth;
    String text = "";
    private boolean autoLayoutEnabled = false;
    private boolean autoResizeEnabled = false;
    private boolean autoMoveEnabled = false;
    private boolean autoVisibilityEnabled = false;
    private Rectangle actualBounds = new Rectangle();
    Margin margin = null;
    int offsetx = 0;
    int offsety = 0;
    float zoomLevel = 1.0f;
    ComponentMover cm;
    float opacity = 1.0f;
    ShadowRenderer shadowRenderer;
    private int defShadowSize = 10;
    int shadowSize = 0;
    private int defShadowOffset = 2;
    int shadowOffset = 0;
    boolean animationRunning = false;
    AnimationSequence animationSequence = new AnimationSequence();
    Animator entrance_anim;
    Animator emphasis_anim;
    AnimationListener animationListener;
    AutoLayout autolayout = null;
    private ArrayList<Visual> followers = new ArrayList();
    Visual leader;

    public void setGuide(Guide g) {
        this.currentGuide = g;
    }

    public Region getTarget() {
        if (this.targetRegion != null) {
            return this.targetRegion;
        }
        return this.getRegion();
    }

    public Visual setScale(float scale) {
        return this;
    }

    public Visual setLayout(Layout lo) {
        this.currentLayout = this.layout;
        this.layout = lo;
        this.setLocationRelative(lo);
        return this;
    }

    public Visual setColors(Color all, Color front, Color back, Color frame, Color text) {
        if (all != null) {
            this.color = all;
        }
        if (front != null) {
            this.colorFront = front;
            this.setForeground(this.colorFront);
        }
        if (back != null) {
            this.colorBack = back;
            this.setBackground(this.colorBack);
        }
        if (frame != null) {
            this.colorFrame = frame;
        }
        if (text != null) {
            this.colorText = text;
        }
        return this;
    }

    public Visual setColors(int[] front, int[] back, int[] frame, int[] text) {
        Color cf = null;
        Color cb = null;
        Color cr = null;
        Color ct = null;
        if (front != null) {
            cf = new Color(front[0], front[1], front[2]);
        }
        if (back != null) {
            cb = new Color(back[0], back[1], back[2]);
        }
        if (frame != null) {
            cr = new Color(frame[0], frame[1], frame[2]);
        }
        if (text != null) {
            ct = new Color(text[0], text[1], text[2]);
        }
        this.setColors(null, cf, cb, cr, ct);
        return this;
    }

    public Visual setColor(Color color) {
        this.setColors(null, color, color, null, null);
        return this;
    }

    public Visual setColor(int r, int g, int b) {
        this.setColor(new Color(r, g, b));
        return this;
    }

    public Visual setTextColor(Color color) {
        this.setColors(null, null, null, null, color);
        return this;
    }

    public Visual setTextColor(int r, int g, int b) {
        this.setTextColor(new Color(r, g, b));
        return this;
    }

    public static String getColorHex(Color col) {
        String rgb = Integer.toHexString(col.getRGB());
        return rgb.substring(2, rgb.length()).toUpperCase();
    }

    public Visual setStroke(int stk) {
        this.stroke = stk;
        return this;
    }

    public Visual setFont(String font, int fontSize) {
        if (font != null && !this.fontName.isEmpty()) {
            this.fontName = font;
            this.hasChanged = true;
        }
        if (fontSize > 0 && this.fontSize > 0) {
            this.fontSize = fontSize;
            this.hasChanged = true;
        }
        if (this.hasChanged) {
            this.hasChanged = false;
        }
        return this;
    }

    public Visual setFontSize(int i) {
        this.setFont(null, i);
        return this;
    }

    String getStyleString() {
        String s = "font-size:" + this.fontSize + "px;color:#" + Visual.getColorHex(this.colorText) + ";background-color:#" + Visual.getColorHex(this.colorBack) + ";padding:3px";
        if (!this.fontName.isEmpty()) {
            s = "font:" + this.fontName + ";" + s;
        }
        return s;
    }

    public Visual setMaxWidth(int w) {
        this.maxWidth = w;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public Visual setText(String text) {
        if (!this.text.isEmpty()) {
            this.text = text;
        }
        return this;
    }

    public Visual() {
        this.init();
    }

    private void init() {
        this.cm = new ComponentMover();
        this.setMovable(false);
        this.setActualLocation(0, 0);
        this.setActualSize(new Dimension(0, 0));
        this.color = defColor;
        this.colorFront = defColorFront;
        this.colorBack = defColorBack;
        this.colorFrame = defColorFrame;
        this.colorText = defColorText;
        this.stroke = defStroke;
        this.fontName = defFont;
        this.fontSize = defFontSize;
        this.maxWidth = defMaxWidth;
    }

    public void setAutoLayoutEnabled(boolean autoLayoutEnabled) {
        this.autoLayoutEnabled = autoLayoutEnabled;
    }

    public boolean isAutoLayoutEnabled() {
        return this.autoLayoutEnabled;
    }

    public void setAutoResizeEnabled(boolean autoResizeEnabled) {
        this.autoResizeEnabled = autoResizeEnabled;
    }

    public boolean isAutoResizeEnabled() {
        return this.autoResizeEnabled;
    }

    public void setAutoMoveEnabled(boolean autoMoveEnabled) {
        this.autoMoveEnabled = autoMoveEnabled;
    }

    public boolean isAutoMoveEnabled() {
        return this.autoMoveEnabled;
    }

    public void setAutoVisibilityEnabled(boolean autoVisibilityEnabled) {
        this.autoVisibilityEnabled = autoVisibilityEnabled;
    }

    public boolean isAutoVisibilityEnabled() {
        return this.autoVisibilityEnabled;
    }

    public Rectangle getActualBounds() {
        return this.actualBounds;
    }

    public Region getRegion() {
        return Region.create(this.getBounds());
    }

    public void setActualBounds(Rectangle actualBounds) {
        this.actualBounds = (Rectangle)actualBounds.clone();
        Rectangle paintBounds = (Rectangle)actualBounds.clone();
        if (this.hasShadow()) {
            paintBounds.x -= this.shadowSize - this.shadowOffset;
            paintBounds.y -= this.shadowSize - this.shadowOffset;
            paintBounds.width += 2 * this.shadowSize;
            paintBounds.height += 2 * this.shadowSize;
        }
        super.setBounds(paintBounds);
        this.updateAllFollowers();
    }

    public Point getCenter() {
        Point loc = new Point(this.getActualLocation());
        Dimension size = this.getActualSize();
        loc.x += size.width / 2;
        loc.y += size.height / 2;
        return loc;
    }

    public Dimension getActualSize() {
        return new Dimension(this.getActualWidth(), this.getActualHeight());
    }

    public void setActualSize(int width, int height) {
        if (height == 0) {
            this.setActualSize(new Dimension(width, this.getActualHeight()));
        } else if (width == 0) {
            this.setActualSize(new Dimension(this.getActualWidth(), height));
        } else {
            this.setActualSize(new Dimension(width, height));
        }
    }

    public void setActualSize(Dimension actualSize) {
        this.actualBounds.setSize(actualSize);
        Dimension paintSize = (Dimension)actualSize.clone();
        if (this.hasShadow()) {
            paintSize.width += 2 * this.shadowSize;
            paintSize.height += 2 * this.shadowSize;
        }
        super.setSize(paintSize);
        this.updateAllFollowers();
    }

    public int getActualWidth() {
        return this.getActualBounds().width;
    }

    public int getActualHeight() {
        return this.getActualBounds().height;
    }

    public Point getActualLocation() {
        return this.actualBounds.getLocation();
    }

    public void offsetLocation(int x, int y) {
        this.setActualLocation(this.getActualLocation().x + x, this.getActualLocation().y + y);
    }

    public void setActualLocation(Point location) {
        this.setActualLocation(location.x, location.y);
    }

    public void setActualLocation(int x, int y) {
        int paintX = x;
        int paintY = y;
        this.actualBounds.setLocation(x, y);
        if (this.hasShadow()) {
            paintX -= this.shadowSize - this.shadowOffset;
            paintY -= this.shadowSize - this.shadowOffset;
        }
        super.setLocation(paintX, paintY);
        this.updateAllFollowers();
    }

    public void setMargin(int top, int left, int bottom, int right) {
        this.margin = new Margin();
        this.margin.top = top;
        this.margin.left = left;
        this.margin.bottom = bottom;
        this.margin.right = right;
    }

    public void setOffset(int offsetx, int offsety) {
        this.offsetx = offsetx;
        this.offsety = offsety;
        this.offsetLocation(offsetx, offsety);
    }

    public void setZoomLevel(float zoomLevel) {
    }

    public void setMovable(boolean movable) {
        if (movable) {
            this.cm.registerComponent(this);
        } else {
            this.cm.deregisterComponent(this);
        }
    }

    public void setOpacity(float opacity) {
        if (opacity > 0.0f) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        this.opacity = opacity;
        for (Visual sklComp : this.getFollowers()) {
            sklComp.setOpacity(opacity);
        }
        Rectangle r = this.getBounds();
        if (this.getTopLevelAncestor() != null) {
            this.getTopLevelAncestor().repaint();
        }
    }

    public void updateComponent() {
    }

    public void paintPlain(Graphics g) {
        super.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics2D g2 = image.createGraphics();
        if (this.shadowRenderer != null) {
            this.shadowRenderer.paintComponent(g2);
            g2.translate(this.shadowSize - this.shadowOffset, this.shadowSize - this.shadowOffset);
        }
        super.paint(g2);
        Graphics2D g2d = (Graphics2D)g;
        ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, this.opacity));
        g2d.drawImage(image, 0, 0, null, null);
    }

    public void setShadowDefault() {
        this.setShadow(this.defShadowSize, this.defShadowOffset);
    }

    public void setShadow(int shadowSize, int shadowOffset) {
        this.shadowSize = shadowSize;
        this.shadowOffset = shadowOffset;
        this.shadowRenderer = new ShadowRenderer(this, shadowSize);
        super.setSize(this.getActualWidth() + 2 * shadowSize, this.getActualHeight() + 2 * shadowSize);
        Point p = this.getActualLocation();
        p.x = p.x - shadowSize + shadowOffset;
        p.y = p.y - shadowSize + shadowOffset;
        super.setLocation(p.x, p.y);
    }

    boolean hasShadow() {
        return this.shadowRenderer != null;
    }

    AnimationFactory getAnimationFactory() {
        return new AnimationFactory();
    }

    public void addAnimation(NewAnimator anim) {
        this.animationSequence.add(anim);
    }

    public void addMoveAnimation(Point source, Point destination) {
        this.animationSequence.add(AnimationFactory.createMoveAnimation(this, source, destination));
    }

    public void addResizeAnimation(Dimension currentSize, Dimension targetSize) {
        this.animationSequence.add(AnimationFactory.createResizeAnimation(this, currentSize, targetSize));
    }

    public void addCircleAnimation(Point origin, float radius) {
        this.animationSequence.add(AnimationFactory.createCircleAnimation(this, origin, radius));
    }

    public void addFadeinAnimation() {
        if (this.opacity < 1.0f) {
            this.animationSequence.add(AnimationFactory.createOpacityAnimation(this, this.opacity, 1.0f));
        }
    }

    public void addFadeoutAnimation() {
        if (this.opacity > 0.0f) {
            this.animationSequence.add(AnimationFactory.createOpacityAnimation(this, this.opacity, 0.0f));
        }
    }

    public void addSlideAnimation(Point destination, Layout side) {
        Point p0 = new Point(destination);
        Point p1 = new Point(destination);
        if (side == Layout.RIGHT) {
            p0.x += 20;
        } else if (side == Layout.BOTTOM) {
            p0.y += 20;
        } else if (side == Layout.TOP) {
            p0.y -= 20;
        } else if (side == Layout.LEFT) {
            p0.x -= 20;
        }
        this.setActualLocation(p0);
        this.addMoveAnimation(p0, p1);
    }

    public void startAnimation() {
        this.animationSequence.start();
    }

    public void stopAnimation() {
        if (this.emphasis_anim != null) {
            this.emphasis_anim.stop();
        }
        if (this.entrance_anim != null) {
            this.entrance_anim.stop();
        }
    }

    public Animator createSlidingAnimator(int offset_x, int offset_y) {
        Point dest = this.getActualLocation();
        Point src = new Point(dest.x + offset_x, dest.y + offset_y);
        return new MoveAnimator(this, src, dest);
    }

    public Animator createMoveAnimator(int dest_x, int dest_y) {
        Point src = this.getActualLocation();
        Point dest = new Point(dest_x, dest_y);
        return new MoveAnimator(this, src, dest);
    }

    public void resizeTo(Dimension targetSize) {
    }

    public void moveTo(Point targetLocation) {
        NewAnimator anim = AnimationFactory.createCenteredMoveAnimation(this, this.getActualLocation(), targetLocation);
        anim.start();
    }

    public void moveTo(Point targetLocation, AnimationListener listener) {
        NewAnimator anim = AnimationFactory.createCenteredMoveAnimation(this, this.getActualLocation(), targetLocation);
        anim.setListener(listener);
        anim.start();
    }

    public void popin() {
        Dimension targetSize = new Dimension(this.getActualSize());
        targetSize.width = (int)((double)targetSize.width / 1.2);
        targetSize.height = (int)((double)targetSize.height / 1.2);
        NewAnimator anim = AnimationFactory.createCenteredResizeToAnimation(this, targetSize);
        anim.start();
    }

    public void popout() {
        this.setShadowDefault();
        Dimension targetSize = new Dimension(this.getActualSize());
        targetSize.width = (int)((double)targetSize.width * 1.2);
        targetSize.height = (int)((double)targetSize.height * 1.2);
        NewAnimator anim = AnimationFactory.createCenteredResizeToAnimation(this, targetSize);
        anim.start();
    }

    public void setEntranceAnimation(Animator anim) {
        if (this.entrance_anim != null) {
            this.entrance_anim.stop();
        } else {
            this.entrance_anim = anim;
        }
    }

    public void setEmphasisAnimation(Animator anim) {
        if (this.emphasis_anim != null) {
            this.emphasis_anim.stop();
        }
        if (this.entrance_anim != null) {
            this.entrance_anim.stop();
        }
        this.emphasis_anim = anim;
    }

    public void addAnimationListener(AnimationListener listener) {
        this.animationListener = listener;
    }

    public void animationCompleted() {
        if (this.animationListener != null) {
            this.animationListener.animationCompleted();
        }
    }

    public Visual left() {
        this.left(0);
        return this;
    }

    public Visual left(int x) {
        this.setLayout(Layout.LEFT);
        if (x != 0) {
            this.setOffset(-x, 0);
        }
        return this;
    }

    public Visual right() {
        return this.right(0);
    }

    public Visual right(int x) {
        this.setLayout(Layout.RIGHT);
        if (x != 0) {
            this.setOffset(x, 0);
        }
        return this;
    }

    public Visual above() {
        return this.above(0);
    }

    public Visual above(int y) {
        this.setLayout(Layout.TOP);
        if (y != 0) {
            this.setOffset(0, -y);
        }
        return this;
    }

    public Visual below() {
        return this.below(0);
    }

    public Visual below(int y) {
        this.setLayout(Layout.BOTTOM);
        if (y != 0) {
            this.setOffset(0, y);
        }
        return this;
    }

    public <RCPS> Visual setTarget(RCPS target) {
        if (target instanceof Region) {
            this.targetRegion = (Region)target;
        } else if (target instanceof Visual) {
            this.targetComponent = (Visual)target;
        } else if (target instanceof Pattern) {
            this.targetPattern = (Pattern)target;
        } else if (target instanceof String) {
            this.targetPattern = new Pattern((String)target);
        }
        if (this.targetPattern != null) {
            this.targetComponent = new SxAnchor(this.targetPattern);
            this.currentGuide.addToFront(this.targetComponent);
            this.setLayout(this.layout);
        }
        this.updateComponent();
        return this;
    }

    public Visual setLocationRelative(Layout side) {
        if (this.targetRegion != null) {
            this.setLocationRelativeToRegion(this.targetRegion, side);
        } else if (this.targetComponent != null) {
            this.setLocationRelativeToComponent(this.targetComponent, side);
        }
        return this;
    }

    public void setLocationRelativeToComponent(Visual comp, Layout side) {
        if (this.autolayout != null) {
            this.autolayout.stop();
        }
        comp.addFollower(this);
        this.autolayout = new AutoLayoutBySide(comp, side);
        this.autolayout.update();
    }

    public void setLocationRelativeToComponent(Visual comp, int offsetx, int offsety) {
        if (this.autolayout != null) {
            this.autolayout.stop();
        }
        comp.addFollower(this);
        this.autolayout = new AutoLayoutByOffset(comp, offsetx, offsety);
        this.autolayout.update();
    }

    public void setLocationRelativeToComponent(Visual comp, float relativeX, float relativeY) {
        if (this.autolayout != null) {
            this.autolayout.stop();
        }
        this.autolayout = new AutoLayoutByRatio(comp, relativeX, relativeY);
        this.autolayout.update();
    }

    public void setLocationRelativeToComponent(Visual leader) {
        if (this.autolayout != null) {
            this.autolayout.stop();
        }
        leader.addFollower(this);
        this.autolayout = new AutoLayoutByMovement(leader);
        this.autolayout.update();
    }

    public void setLocationRelativeToPoint(Point point, Layout side) {
        Rectangle bounds = this.getActualBounds();
        if (side == Layout.CENTER) {
            this.setActualLocation(point.x - bounds.width / 2, point.y - bounds.height / 2);
        }
    }

    public Visual setLocationRelativeToRegion(Region region, Layout side) {
        Region orgReg = new Region(region);
        if (this.margin != null) {
            region.x -= this.margin.left;
            region.y -= this.margin.top;
            region.w += this.margin.left + this.margin.right;
            region.h += this.margin.top + this.margin.bottom;
            this.targetRegion = region;
            this.margin = null;
        }
        if (this.offsetx > 0 || this.offsety > 0) {
            region.x += this.offsetx;
            region.y += this.offsety;
            this.targetRegion = region;
            this.offsetx = 0;
            this.offsety = 0;
        }
        this.layout = side;
        int height = this.getActualHeight();
        int width = this.getActualWidth();
        if (side == Layout.TOP) {
            this.setActualLocation(region.x + region.w / 2 - width / 2, region.y - height);
        } else if (side == Layout.BOTTOM) {
            this.setActualLocation(region.x + region.w / 2 - width / 2, region.y + region.h);
        } else if (side == Layout.LEFT) {
            this.setActualLocation(region.x - width, region.y + region.h / 2 - height / 2);
        } else if (side == Layout.RIGHT) {
            this.setActualLocation(region.x + region.w, region.y + region.h / 2 - height / 2);
        } else if (side == Layout.INSIDE) {
            this.setActualLocation(region.x + region.w / 2 - width / 2, region.y + region.h / 2 - height / 2);
        } else if (side == Layout.OVER) {
            this.setActualBounds(region.getRect());
        } else if (side == Layout.ORIGIN) {
            this.setActualLocation(region.x, region.y);
        }
        return this;
    }

    public void setHorizontalAlignmentWithRegion(Region region, float f) {
        int x0 = region.x;
        int x1 = region.x + region.w - this.getActualWidth();
        int x = (int)((float)x0 + (float)(x1 - x0) * f);
        this.setActualLocation(x, this.getActualLocation().y);
    }

    public void setVerticalAlignmentWithRegion(Region region, float f) {
        int y0 = region.y;
        int y1 = region.y + region.h - this.getActualHeight();
        int y = (int)((float)y0 + (float)(y1 - y0) * f);
        this.setActualLocation(this.getActualLocation().x, y);
    }

    public void removeFromLeader() {
        if (this.leader != null) {
            this.leader.removeFollower(this);
        }
        this.leader = null;
    }

    public void addFollower(Visual sklComp) {
        sklComp.setVisible(this.isVisible());
        sklComp.setOpacity(this.opacity);
        if (this.followers.indexOf(sklComp) < 0) {
            this.followers.add(sklComp);
            sklComp.removeFromLeader();
            sklComp.leader = this;
        }
    }

    private void updateAllFollowers() {
        for (Visual sklComp : this.getFollowers()) {
            if (sklComp.autolayout == null) continue;
            sklComp.autolayout.update();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        for (Visual follower : this.getFollowers()) {
            follower.setVisible(visible);
        }
        super.setVisible(visible);
    }

    public ArrayList<Visual> getFollowers() {
        return this.followers;
    }

    public Visual getLeader() {
        return this.leader;
    }

    public void removeFollower(Visual comp) {
        this.followers.remove(comp);
    }

    public Rectangle getFollowerBounds() {
        Rectangle bounds = new Rectangle(this.getBounds());
        for (Visual sklComp : this.getFollowers()) {
            bounds.add(sklComp.getBounds());
        }
        return bounds;
    }

    public void removeFrom(Container container) {
        for (Visual follower : this.getFollowers()) {
            follower.removeFrom(container);
        }
        container.remove(this);
    }

    @Override
    public String toString() {
        return "" + this.getClass() + " [actualBounds=" + this.getActualBounds() + "]";
    }

    public Object clone() {
        try {
            Visual clone = (Visual)super.clone();
            clone.followers = new ArrayList();
            clone.removeFromLeader();
            clone.actualBounds = new Rectangle(this.actualBounds);
            clone.autolayout = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public static enum Layout {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT,
        FOLLOWERS,
        INSIDE,
        OVER,
        ORIGIN,
        CENTER,
        AROUND;

    }

    class Margin {
        int top;
        int left;
        int bottom;
        int right;

        Margin() {
        }
    }

    class AnimationSequence {
        Queue<NewAnimator> queue = new LinkedBlockingQueue<NewAnimator>();

        AnimationSequence() {
        }

        private void startNextAnimation() {
            if (this.queue.peek() != null) {
                NewAnimator anim = this.queue.remove();
                anim.start();
                anim.setListener(new AnimationListener(){

                    @Override
                    public void animationCompleted() {
                        AnimationSequence.this.startNextAnimation();
                    }
                });
            }
        }

        public void add(NewAnimator animator) {
            this.queue.add(animator);
        }

        public void start() {
            this.startNextAnimation();
        }
    }

    class AutoLayout
    implements ComponentListener {
        private Visual targetComponent;

        AutoLayout(Visual targetComponent) {
            this.setTargetComponent(targetComponent);
        }

        public void setTargetComponent(Visual targetComponent) {
            this.targetComponent = targetComponent;
        }

        public Visual getTargetComponent() {
            return this.targetComponent;
        }

        void update() {
        }

        void stop() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentResized(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    class AutoLayoutBySide
    extends AutoLayout {
        Layout side;

        AutoLayoutBySide(Visual targetComponent, Layout side) {
            super(targetComponent);
            this.side = side;
        }

        @Override
        void update() {
            if (this.side == Layout.FOLLOWERS) {
                Visual.this.setBounds(this.getTargetComponent().getBounds());
                Rectangle totalBounds = this.getTargetComponent().getFollowerBounds();
                totalBounds.grow(5, 5);
                Visual.this.setBounds(totalBounds);
            } else {
                Visual.this.setLocationRelativeToRegion(this.getTargetComponent().getRegion(), this.side);
            }
            super.update();
        }
    }

    class AutoLayoutByOffset
    extends AutoLayout {
        int offsetx;
        int offsety;

        AutoLayoutByOffset(Visual targetComponent, int offsetx, int offsety) {
            super(targetComponent);
            this.offsetx = offsetx;
            this.offsety = offsety;
        }

        @Override
        void update() {
            Visual.this.setOffset(this.offsetx, this.offsety);
            Region region = new Region(Visual.this.leader.getBounds());
            Visual.this.setLocationRelativeToRegion(region, Layout.ORIGIN);
            super.update();
        }
    }

    class AutoLayoutByRatio
    extends AutoLayout {
        float x;
        float y;

        AutoLayoutByRatio(Visual targetComponent, float x, float y) {
            super(targetComponent);
            this.x = x;
            this.y = y;
        }

        @Override
        void update() {
            Region region = new Region(this.getTargetComponent().getBounds());
            Visual.this.setHorizontalAlignmentWithRegion(region, this.x);
            Visual.this.setVerticalAlignmentWithRegion(region, this.y);
            super.update();
        }
    }

    class AutoLayoutByMovement
    extends AutoLayout {
        int x;
        int y;
        Point targetLocation;

        AutoLayoutByMovement(Visual targetComponent) {
            super(targetComponent);
            this.targetLocation = new Point(targetComponent.getActualLocation());
            this.x = targetComponent.getX();
            this.y = targetComponent.getY();
        }

        @Override
        public void update() {
            Point newTargetLocation = this.getTargetComponent().getActualLocation();
            int dx = newTargetLocation.x - this.targetLocation.x;
            int dy = newTargetLocation.y - this.targetLocation.y;
            this.targetLocation = newTargetLocation;
            Point actualLocation = Visual.this.getActualLocation();
            actualLocation.x += dx;
            actualLocation.y += dy;
            Visual.this.setActualLocation(actualLocation.x, actualLocation.y);
        }
    }
}

