/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.natives;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.sikuli.basics.Debug;
import org.sikuli.natives.OSUtil;
import org.sikuli.script.App;
import org.sikuli.script.Region;
import org.sikuli.script.runners.AppleScriptRunner;
import org.sikuli.script.support.IScriptRunner;
import org.sikuli.script.support.RunTime;
import org.sikuli.script.support.Runner;

public class MacUtil
implements OSUtil {
    private static boolean _askedToEnableAX = false;
    static String cmd = "set found to \"NotFound\"\ntry\ntell application \"System Events\"\n#LINE#\nend tell\nif not (found is equal to \"NotFound\") then\nset windowName to \"\"\ntry\nset windowName to name of first window of found\nend try\nset found to {name of found, \u00abclass idux\u00bb of found, windowName, file of found}\nend if\nend try\nfound\n";
    static String cmdLineApp = "set found to first item of (processes whose displayed name is \"#APP#\")";
    static String cmdLinePID = "set found to first item of (processes whose unix id is equal to #PID#)";
    private static final IScriptRunner.Options SILENT_OPTIONS = new IScriptRunner.Options().setSilent(true);
    String cmdGetWindows = "set theWindows to {}\nrepeat with win in (windows of application \"#APP#\" whose visible is true)\ncopy {name of win, bounds of win} to end of theWindows\nend repeat\ntheWindows\n";

    @Override
    public void checkFeatureAvailability() {
        RunTime.get();
        RunTime.loadLibrary("MacUtil");
    }

    @Override
    public App get(App app) {
        String name = app.getName();
        int pid = app.getPID();
        String theCmd = "";
        if (pid < 0) {
            List<App> apps;
            if (!name.isEmpty() && (apps = this.getApps(name)).size() > 0) {
                App theApp = apps.get(0);
                app.setPID(theApp.getPID());
                app.setName(theApp.getName());
                app.setToken(theApp.getToken());
                app.setExec(theApp.getExec());
                app.setWindow(theApp.getWindowTitle());
            }
            return app;
        }
        theCmd = cmd.replace("#LINE#", cmdLinePID);
        theCmd = theCmd.replaceAll("#PID#", "" + pid);
        int retVal = Runner.getRunner(AppleScriptRunner.class).evalScript(theCmd, SILENT_OPTIONS);
        String result = RunTime.get().getLastCommandResult().trim();
        if (retVal > -1) {
            if (!result.contains("NotFound")) {
                String[] parts = result.split(",");
                if (parts.length > 1) {
                    app.setName(parts[0].trim());
                    app.setPID(parts[1].trim());
                }
                if (parts.length > 2) {
                    app.setWindow(parts[2].trim());
                }
                if (parts.length > 3) {
                    for (int i = 3; i < parts.length; ++i) {
                        String part = parts[i].trim();
                        if (part.startsWith("alias ")) {
                            String[] folders = part.split(":");
                            part = "";
                            for (int nf = 1; nf < folders.length; ++nf) {
                                part = part + "/" + folders[nf];
                            }
                            app.setExec(part);
                            continue;
                        }
                        app.setWindow(app.getWindowTitle() + "," + parts);
                    }
                }
            }
        } else {
            app.reset();
        }
        return app;
    }

    @Override
    public boolean open(App app) {
        int ret;
        String appName = app.getExec().isEmpty() ? app.getName() : app.getExec();
        String cmd = "open -a \"" + appName + "\"";
        if (!app.getOptions().isEmpty()) {
            cmd = cmd + " --args " + app.getOptions();
        }
        return (ret = MacUtil.shRun(cmd)) == 0;
    }

    @Override
    public boolean switchto(App app) {
        if (app.isValid()) {
            String cmd = "tell application \"" + app.getName() + "\" to activate";
            return 0 == Runner.getRunner(AppleScriptRunner.class).evalScript(cmd, SILENT_OPTIONS);
        }
        return false;
    }

    @Override
    public App switchto(String title, int index) {
        return new App();
    }

    @Override
    public boolean close(App app) {
        int ret = app.getPID() > -1 ? this.close(app.getPID()) : this.close(app.getExec().startsWith(app.getName()) ? app.getName() : app.getExec());
        if (ret == 0) {
            app.reset();
        }
        return ret == 0;
    }

    private static int shRun(String sCmd) {
        String[] cmd = new String[]{"sh", "-c", sCmd};
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            p.waitFor();
            return p.exitValue();
        }
        catch (Exception e) {
            return -1;
        }
    }

    private int close(String appName) {
        String cmd = "ps aux |  grep \"" + appName + "\" | grep -v \"grep\" | awk '{print $2}' | xargs kill";
        return MacUtil.shRun(cmd);
    }

    private int close(int pid) {
        String cmd = "kill " + pid;
        return MacUtil.shRun(cmd);
    }

    @Override
    public Rectangle getWindow(App app) {
        return this.getWindow(app, 0);
    }

    @Override
    public Rectangle getWindow(App app, int winNum) {
        int pid = MacUtil.getPID(app.getName());
        return this.getWindow(pid, winNum);
    }

    @Override
    public Rectangle getWindow(String appName) {
        return this.getWindow(new App(appName), 0);
    }

    private Rectangle getWindow(int pid) {
        return this.getWindow(pid, 0);
    }

    private Rectangle getWindow(int pid, int winNum) {
        Rectangle rect = MacUtil.getRegion(pid, winNum);
        return rect;
    }

    @Override
    public Rectangle getFocusedWindow() {
        Rectangle rect = MacUtil.getFocusedRegion();
        return rect;
    }

    @Override
    public List<Region> getWindows(App app) {
        ArrayList<Region> windows = new ArrayList<Region>();
        String theCmd = this.cmdGetWindows.replace("#APP#", app.getName());
        int retVal = Runner.getRunner(AppleScriptRunner.class).evalScript(theCmd, SILENT_OPTIONS);
        String result = RunTime.get().getLastCommandResult().trim();
        if (retVal > -1 && !result.isEmpty()) {
            Debug.trace("getWindows: %s", result);
            String[] parts = result.split(",");
            int lenResult = parts.length;
            if (lenResult % 5 != 0) {
                Debug.error("getWindow: at least one window title has a comma - giving up: %s", result);
                return windows;
            }
            for (int nWin = 0; nWin < lenResult; nWin += 5) {
                try {
                    int x = Integer.parseInt(parts[nWin + 1].trim());
                    int y = Integer.parseInt(parts[nWin + 2].trim());
                    int w = Integer.parseInt(parts[nWin + 3].trim()) - x;
                    int h = Integer.parseInt(parts[nWin + 4].trim()) - y;
                    Region reg = new Region(x, y, w, h);
                    reg.setName(parts[nWin]);
                    windows.add(reg);
                    continue;
                }
                catch (NumberFormatException e) {
                    Debug.error("getWindow: invalid coordinates: %s", result);
                }
            }
        }
        return windows;
    }

    @Override
    public List<App> getApps(String name) {
        new App();
        String cmd = "tell application \"System Events\"\nset plist to (processes whose background only is false)\nset resultlist to {}\nrepeat with n from 1 to the length of plist\nset proc to item n of plist\nset pwin to \"\"\ntry\nset pwin to name of first window of proc\nend try\nset entry to {pwin as text, \"|||\", \u00abclass idux\u00bb of proc as text,displayed name of proc as text, name of proc as text, get file of proc, \"###\"}\nset end of resultlist to entry\nend repeat\nend tell\nresultlist";
        int retVal = Runner.getRunner(AppleScriptRunner.class).evalScript(cmd, SILENT_OPTIONS);
        String result = RunTime.get().getLastCommandResult().trim();
        String[] processes = (", " + result).split(", ###");
        ArrayList<App> appList = new ArrayList<App>();
        int pid = 0;
        for (String process : processes) {
            if (process.startsWith(", ")) {
                process = process.substring(2);
            }
            App theApp = new App();
            String[] parts = process.split(", \\|\\|\\|,");
            String pWin = parts[0].trim();
            parts = parts[1].split(",");
            try {
                pid = Integer.parseInt(parts[0].trim());
            }
            catch (NumberFormatException e) {
                --pid;
            }
            String dispName = parts[1].trim();
            String procName = parts[2].trim();
            String[] pAlias = parts[3].split(":");
            String pExec = pAlias[pAlias.length - 1];
            String pToken = String.format("%s|%s|%s", dispName, procName, pExec);
            if (!name.isEmpty() && !pToken.toUpperCase().contains(name.toUpperCase())) continue;
            theApp.setName(dispName);
            theApp.setPID(pid);
            theApp.setToken(pToken);
            theApp.setExec(pExec);
            theApp.setWindow(pWin);
            appList.add(theApp);
        }
        return appList;
    }

    public static native int getPID(String var0);

    public static native Rectangle getRegion(int var0, int var1);

    public static native Rectangle getFocusedRegion();
}

