/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.natives;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Tlhelp32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.platform.win32.WinUser;
import com.sun.jna.ptr.IntByReference;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.sikuli.natives.OSUtil;
import org.sikuli.natives.SXUser32;
import org.sikuli.script.App;
import org.sikuli.script.Region;
import org.sikuli.script.runners.ProcessRunner;

public class WinUtil
implements OSUtil {
    static final User32 user32 = User32.INSTANCE;
    static final SXUser32 sxuser32 = SXUser32.INSTANCE;
    static final int BUFFERSIZE = Short.MAX_VALUE;
    static final Kernel32 kernel32 = Kernel32.INSTANCE;

    @Override
    public void checkFeatureAvailability() {
    }

    @Override
    public App get(App app) {
        App.log("Win:get(App): %s", app);
        app = app.getPID() > 0 ? WinUtil.getTaskByPID(app) : WinUtil.getTaskByName(app);
        return app;
    }

    @Override
    public List<App> getApps(String name) {
        ArrayList<App> apps = new ArrayList<App>();
        List<ProcessInfo> processes = WinUtil.allProcesses();
        for (ProcessInfo p : processes) {
            String winTitle;
            if (!p.getImageName().contains(name) || (winTitle = WinUtil.getTopWindowTitle(p.getPid())) == null) continue;
            App theApp = new App();
            theApp.setName(p.getImageName());
            theApp.setWindow(winTitle);
            theApp.setPID(p.getPid());
            apps.add(theApp);
        }
        return apps;
    }

    @Override
    public boolean open(App app) {
        if (app.isValid()) {
            return 0 == this.switchApp(app.getPID(), 0);
        }
        String cmd = app.getExec();
        String workDir = app.getWorkDir();
        if (!app.getOptions().isEmpty()) {
            return ProcessRunner.startApp(cmd, workDir, app.getOptions());
        }
        return ProcessRunner.startApp(cmd, workDir);
    }

    @Override
    public boolean switchto(App app) {
        int pid;
        if (!app.isValid()) {
            return false;
        }
        for (int loopCount = 0; loopCount < 100 && (pid = this.switchApp(app.getPID(), 0)) > 0; ++loopCount) {
            if (pid != app.getPID()) continue;
            app.setFocused(true);
            WinUtil.getTaskByPID(app);
            return true;
        }
        return false;
    }

    @Override
    public App switchto(String title, int index) {
        App app = new App();
        int pid = this.switchApp(title, index);
        if (pid > 0) {
            app.setPID(pid);
            return WinUtil.getTaskByPID(app);
        }
        return app;
    }

    private int switchApp(String appName, int num) {
        List<WindowInfo> windows = WinUtil.getWindowsForName(appName);
        if (windows.size() > num) {
            return this.switchAppWindow(windows.get(num));
        }
        return 0;
    }

    private int switchApp(int pid, int num) {
        List<WindowInfo> windows = WinUtil.getWindowsForPid(pid);
        if (windows.size() > num) {
            return this.switchAppWindow(windows.get(num));
        }
        return 0;
    }

    private int switchAppWindow(WindowInfo window) {
        boolean success;
        WinDef.HWND hwnd = window.getHwnd();
        WinUser.WINDOWPLACEMENT lpwndpl = new WinUser.WINDOWPLACEMENT();
        user32.GetWindowPlacement(hwnd, lpwndpl);
        if (lpwndpl.showCmd == 2 || lpwndpl.showCmd == 6) {
            user32.ShowWindow(hwnd, 9);
        }
        if (success = user32.SetForegroundWindow(hwnd)) {
            user32.SetFocus(hwnd);
            IntByReference windowPid = new IntByReference();
            user32.GetWindowThreadProcessId(hwnd, windowPid);
            return windowPid.getValue();
        }
        return 0;
    }

    @Override
    public boolean close(App app) {
        return ProcessRunner.closeApp("" + app.getPID());
    }

    @Override
    public Rectangle getWindow(App app) {
        return this.getWindow(app, 0);
    }

    @Override
    public Rectangle getWindow(App app, int winNum) {
        this.get(app);
        if (!app.isValid()) {
            return null;
        }
        WinDef.HWND hwnd = WinUtil.getHwnd(app.getPID(), winNum);
        return hwnd != null ? WinUtil.getRectangle(hwnd, winNum) : null;
    }

    @Override
    public Rectangle getWindow(String title) {
        WinDef.HWND hwnd = WinUtil.getHwnd(title, 0);
        return hwnd != null ? WinUtil.getRectangle(hwnd, 0) : null;
    }

    @Override
    public Rectangle getFocusedWindow() {
        WinDef.RECT rect;
        WinDef.HWND hwnd = user32.GetForegroundWindow();
        boolean success = user32.GetWindowRect(hwnd, rect = new WinDef.RECT());
        return success ? rect.toRectangle() : null;
    }

    @Override
    public List<Region> getWindows(App app) {
        app = this.get(app);
        List<WindowInfo> windows = WinUtil.getWindowsForPid(app.getPID());
        ArrayList<Region> regions = new ArrayList<Region>();
        for (WindowInfo w : windows) {
            regions.add(Region.create(WinUtil.getRectangle(w.getHwnd(), 0)));
        }
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ProcessInfo> allProcesses() {
        ArrayList<ProcessInfo> processList = new ArrayList<ProcessInfo>();
        WinNT.HANDLE snapshot = Kernel32.INSTANCE.CreateToolhelp32Snapshot(Tlhelp32.TH32CS_SNAPPROCESS, new WinDef.DWORD(0L));
        try {
            Tlhelp32.PROCESSENTRY32.ByReference pe = new Tlhelp32.PROCESSENTRY32.ByReference();
            boolean more = Kernel32.INSTANCE.Process32First(snapshot, (Tlhelp32.PROCESSENTRY32)pe);
            while (more) {
                int pid = pe.th32ProcessID.intValue();
                String name = WinUtil.getProcessImageName(pe.th32ProcessID.intValue());
                if (null != name) {
                    processList.add(new ProcessInfo(pid, name));
                }
                more = Kernel32.INSTANCE.Process32Next(snapshot, (Tlhelp32.PROCESSENTRY32)pe);
            }
            ArrayList<ProcessInfo> arrayList = processList;
            return arrayList;
        }
        finally {
            Kernel32.INSTANCE.CloseHandle(snapshot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getProcessImageName(int pid) {
        WinNT.HANDLE hProcess = Kernel32.INSTANCE.OpenProcess(4096, false, pid);
        if (hProcess != null) {
            try {
                char[] imageNameChars = new char[1024];
                IntByReference imageNameLen = new IntByReference(imageNameChars.length);
                if (Kernel32.INSTANCE.QueryFullProcessImageName(hProcess, 0, imageNameChars, imageNameLen)) {
                    String name;
                    String string = name = FilenameUtils.getName((String)new String(imageNameChars, 0, imageNameLen.getValue()));
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(hProcess);
            }
        }
        return null;
    }

    private static App getTaskByName(App app) {
        if (app.isWindow()) {
            return WinUtil.getTaskByWindow(app);
        }
        new File(app.getExec()).getName();
        String appName = app.getToken().isEmpty() ? new File(app.getExec()).getName() : app.getToken();
        App.log("Win:getTaskByName: %s", appName);
        List<ProcessInfo> processes = WinUtil.allProcesses();
        for (ProcessInfo p : processes) {
            if (p.getImageName() == null || !p.getImageName().equals(appName)) continue;
            app.setPID(p.getPid());
            app.setWindow(WinUtil.getTopWindowTitle(p.getPid()));
            return app;
        }
        return app;
    }

    private static App getTaskByPID(App app) {
        if (!app.isValid()) {
            return app;
        }
        App.log("Win:getTaskByPID: %s", app.getPID());
        List<ProcessInfo> processes = WinUtil.allProcesses();
        for (ProcessInfo p : processes) {
            if (p.getPid() != app.getPID()) continue;
            app.setWindow(WinUtil.getTopWindowTitle(p.getPid()));
            return app;
        }
        app.reset();
        return app;
    }

    private static App getTaskByWindow(App app) {
        App.log("Win:getTaskByWindow: %s", app.getName());
        String title = app.getName();
        List<WindowInfo> windows = WinUtil.allWindows();
        for (WindowInfo window : windows) {
            String windowTitle = window.getTitle();
            if (windowTitle == null || !windowTitle.contains(title)) continue;
            int pid = window.getPid();
            app.setPID(pid);
            app.setWindow(windowTitle);
            List<ProcessInfo> processes = WinUtil.allProcesses();
            for (ProcessInfo pInfo : processes) {
                if (pid != pInfo.getPid()) continue;
                app.setNameGiven(app.getName());
                app.setName(pInfo.getImageName());
            }
            return app;
        }
        return app;
    }

    public static List<WindowInfo> allWindows() {
        final ArrayList<WindowInfo> windows = new ArrayList<WindowInfo>();
        boolean result = user32.EnumWindows(new WinUser.WNDENUMPROC(){

            public boolean callback(WinDef.HWND hwnd, Pointer data) {
                if (user32.IsWindowVisible(hwnd)) {
                    IntByReference windowPid = new IntByReference();
                    user32.GetWindowThreadProcessId(hwnd, windowPid);
                    String windowTitle = WinUtil.getWindowTitle(hwnd);
                    windows.add(new WindowInfo(hwnd, windowPid.getValue(), windowTitle));
                }
                return true;
            }
        }, null);
        if (!result && Kernel32.INSTANCE.GetLastError() != 0) {
            throw new RuntimeException("Couldn't enumerate windows.");
        }
        return windows;
    }

    private static List<WindowInfo> getWindowsForPid(int pid) {
        return WinUtil.allWindows().stream().filter(w -> w.getPid() == pid).collect(Collectors.toList());
    }

    private static List<WindowInfo> getWindowsForName(String name) {
        return WinUtil.allWindows().stream().filter(w -> {
            String imageName = WinUtil.getProcessImageName(w.getPid());
            if (imageName != null && imageName.equals(name + ".exe")) {
                return true;
            }
            String windowTitle = w.getTitle();
            return windowTitle != null && windowTitle.contains(name);
        }).collect(Collectors.toList());
    }

    public static String getWindowTitle(WinDef.HWND hWnd) {
        char[] text = new char[1024];
        int length = user32.GetWindowText(hWnd, text, 1024);
        return length > 0 ? new String(text, 0, length) : null;
    }

    public static String getTopWindowTitle(int pid) {
        List<WindowInfo> windows = WinUtil.getWindowsForPid(pid);
        if (!windows.isEmpty()) {
            return WinUtil.getWindowsForPid(pid).get(0).getTitle();
        }
        return null;
    }

    private static Rectangle getRectangle(WinDef.HWND hwnd, int winNum) {
        WinDef.RECT rect = new WinDef.RECT();
        boolean success = user32.GetWindowRect(hwnd, rect);
        return success ? rect.toRectangle() : null;
    }

    private static WinDef.HWND getHwnd(String appName, int winNum) {
        List<WindowInfo> windows = WinUtil.getWindowsForName(appName);
        if (windows.size() > winNum) {
            return windows.get(winNum).getHwnd();
        }
        return null;
    }

    private static WinDef.HWND getHwnd(int pid, int winNum) {
        List<WindowInfo> windows = WinUtil.getWindowsForPid(pid);
        if (windows.size() > winNum) {
            return windows.get(winNum).getHwnd();
        }
        return null;
    }

    public static int isNumLockOn() {
        int winNumLock = 144;
        return sxuser32.GetKeyState(winNumLock);
    }

    public static int isScrollLockOn() {
        int winScrollLock = 145;
        return sxuser32.GetKeyState(winScrollLock);
    }

    public static int isCapsLockOn() {
        int winCapsLock = 20;
        return sxuser32.GetKeyState(winCapsLock);
    }

    public static String getEnv(String envKey) {
        char[] retChar = new char[Short.MAX_VALUE];
        String envVal = null;
        int retInt = kernel32.GetEnvironmentVariable(envKey, retChar, Short.MAX_VALUE);
        if (retInt > 0) {
            envVal = new String(Arrays.copyOfRange(retChar, 0, retInt));
        }
        return envVal;
    }

    public static String setEnv(String envKey, String envVal) {
        boolean retOK = kernel32.SetEnvironmentVariable(envKey, envVal);
        if (retOK) {
            return WinUtil.getEnv(envKey);
        }
        return null;
    }

    public static final class ProcessInfo {
        private int pid;
        private String imageName;

        public ProcessInfo(int pid, String imageName) {
            this.pid = pid;
            this.imageName = imageName;
        }

        public int getPid() {
            return this.pid;
        }

        public String getImageName() {
            return this.imageName;
        }
    }

    public static final class WindowInfo {
        public WinDef.HWND hwnd;
        public int pid;
        public String title;

        public WindowInfo(WinDef.HWND hwnd, int pid, String title) {
            this.hwnd = hwnd;
            this.pid = pid;
            this.title = title;
        }

        public WinDef.HWND getHwnd() {
            return this.hwnd;
        }

        public int getPid() {
            return this.pid;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

