/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Mouse;
import org.sikuli.script.Offset;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.support.IRobot;
import org.sikuli.script.support.IScreen;

public class Location
implements Comparable<Location> {
    public int x;
    public int y;
    private IScreen otherScreen = null;

    public static Location getDefaultInstance4py() {
        return new Location(0, 0);
    }

    public static Location make4py(ArrayList args) {
        Debug.log(3, "make: args: %s", args);
        Location loc = Location.getDefaultInstance4py();
        if (null != args) {
            int argn = 1;
            for (Object arg : args) {
                Debug.log(3, "%d: %s (%s)", argn++, arg.getClass().getSimpleName(), arg);
            }
            if (args.size() == 2) {
                int num = 2;
                for (Object arg : args) {
                    if (!(arg instanceof Integer) && !(arg instanceof Double)) continue;
                    --num;
                }
                if (num == 0) {
                    loc = new Location((Integer)args.get(0), (Integer)args.get(1));
                }
            } else if (args.size() == 1) {
                loc = new Location((Location)args.get(0));
            }
        }
        return loc;
    }

    public Location setX(int x) {
        this.x = x;
        return this;
    }

    public Location setX(double x) {
        this.x = (int)x;
        return this;
    }

    public int getX() {
        return this.x;
    }

    public Location setY(int y) {
        this.y = y;
        return this;
    }

    public Location setY(double y) {
        this.y = (int)y;
        return this;
    }

    public int getY() {
        return this.y;
    }

    public Location set(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Location set(double x, double y) {
        this.set((int)x, (int)y);
        return this;
    }

    public Point getPoint() {
        return new Point(this.x, this.y);
    }

    public boolean isOtherScreen() {
        return this.otherScreen != null;
    }

    public Location setOtherScreen(IScreen scr) {
        this.otherScreen = scr;
        return this;
    }

    private Location setOtherScreen(Location loc) {
        if (loc.isOtherScreen()) {
            this.setOtherScreen(loc.getScreen());
        }
        return this;
    }

    public Location(double x, double y) {
        this.x = (int)x;
        this.y = (int)y;
    }

    public Location(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Location(Offset offset) {
        this.x = offset.x;
        this.y = offset.y;
    }

    public Location(Location loc) {
        this.x = loc.x;
        this.y = loc.y;
        if (loc.isOtherScreen()) {
            this.otherScreen = loc.getScreen();
        }
    }

    public Location(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public IScreen getScreen() {
        if (this.otherScreen != null) {
            return this.otherScreen;
        }
        for (int i = 0; i < Screen.getNumberScreens(); ++i) {
            Rectangle r = Screen.getScreen(i).getBounds();
            if (!r.contains(this.x, this.y)) continue;
            return Screen.getScreen(i);
        }
        Debug.error("Location: outside any screen (%s, %s) - subsequent actions might not work as expected", this.x, this.y);
        return null;
    }

    public Screen getMonitor() {
        Screen scr = null;
        if (this.otherScreen == null) {
            for (int i = 0; i < Screen.getNumberScreens(); ++i) {
                Rectangle r = Screen.getScreen(i).getBounds();
                if (!r.contains(this.x, this.y)) continue;
                scr = Screen.getScreen(i);
                break;
            }
        } else {
            Debug.error("Location: getMonitor: (%s, %s) not on real screen - using primary", this.x, this.y);
            scr = Screen.getPrimaryScreen();
        }
        if (scr == null) {
            Debug.error("Location: getMonitor: (%s, %s) outside any screen - using primary", this.x, this.y);
            scr = Screen.getPrimaryScreen();
        }
        return scr;
    }

    public Color getColor() {
        if (this.getScreen() == null) {
            return null;
        }
        return this.getScreen().getRobot().getColorAt(this.x, this.y);
    }

    public Region grow() {
        return this.grow(Settings.DefaultPadding, Settings.DefaultPadding);
    }

    public Region grow(int w, int h) {
        return Region.grow(this, w, h);
    }

    public Region grow(int wh) {
        return this.grow(wh, wh);
    }

    public Region grow(int CREATE_X_DIRECTION, int CREATE_Y_DIRECTION, int w, int h) {
        return Region.create(this, CREATE_X_DIRECTION, CREATE_Y_DIRECTION, w, h);
    }

    public Region union(Location loc) {
        Rectangle r1 = new Rectangle(this.x, this.y, 0, 0);
        Rectangle r2 = new Rectangle(loc.x, loc.y, 0, 0);
        Region reg = new Region(r1.union(r2));
        return reg;
    }

    @Deprecated
    public Location moveFor(int dx, int dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public Location translate(int dx, int dy) {
        return this.moveFor(dx, dy);
    }

    @Deprecated
    public Location moveTo(int X, int Y) {
        this.x = X;
        this.y = Y;
        return this;
    }

    public Location move(int X, int Y) {
        return this.moveTo(X, Y);
    }

    public Offset getOffset(Location loc) {
        return new Offset(loc.x - this.x, loc.y - this.y);
    }

    public Location copyTo(int scrID) {
        return this.copyTo(Screen.getScreen(scrID));
    }

    public Location copyTo(IScreen screen) {
        IScreen s = this.getScreen();
        s = s == null ? Screen.getPrimaryScreen() : s;
        Location o = new Location(s.getBounds().getLocation());
        Location n = new Location(screen.getBounds().getLocation());
        return new Location(n.x + this.x - o.x, n.y + this.y - o.y);
    }

    public Location offset(int dx, int dy) {
        return new Location(this.x + dx, this.y + dy);
    }

    public Location offset(Object whatever) {
        Offset offset = new Offset(whatever);
        return new Location(this.x + offset.x, this.y + offset.y);
    }

    public Location left(int dx) {
        return new Location(this.x - dx, this.y).setOtherScreen(this);
    }

    public Location right(int dx) {
        return new Location(this.x + dx, this.y).setOtherScreen(this);
    }

    public Location above(int dy) {
        return new Location(this.x, this.y - dy).setOtherScreen(this);
    }

    public Location below(int dy) {
        return new Location(this.x, this.y + dy).setOtherScreen(this);
    }

    public Location hover() {
        Mouse.move(this);
        return this;
    }

    public Location click() {
        Mouse.click(this, "L", new Integer[0]);
        return this;
    }

    public Location doubleClick() {
        Mouse.click(this, "LD", new Integer[0]);
        return this;
    }

    public Location rightClick() {
        Mouse.click(this, "R", new Integer[0]);
        return this;
    }

    public boolean equals(Object oThat) {
        if (this == oThat) {
            return true;
        }
        if (!(oThat instanceof Location)) {
            return false;
        }
        Location that = (Location)oThat;
        return this.x == that.x && this.y == that.y;
    }

    @Override
    public int compareTo(Location loc) {
        if (this.equals(loc)) {
            return 0;
        }
        if (loc.x > this.x) {
            return 1;
        }
        if (loc.x == this.x && loc.y > this.y) {
            return 1;
        }
        return -1;
    }

    public String toString() {
        String scrText;
        String string = this.getScreen() == null ? "?" : (scrText = "" + (-1 == this.getScreen().getID() ? "Union" : "" + this.getScreen().getID()));
        if (this.isOtherScreen()) {
            scrText = this.getScreen().getIDString();
        }
        return String.format("L[%d,%d]@S(%s)", this.x, this.y, scrText);
    }

    public String toStringShort() {
        return "L(" + this.x + "," + this.y + ")";
    }

    public String toJSON() {
        return String.format("[\"L\", %d, %d]", this.x, this.y);
    }

    protected IRobot getRobotForPoint(String action) {
        if (this.getScreen() == null) {
            Debug.error("Point %s outside any screen for %s - might not work", this, action);
            return Screen.getGlobalRobot();
        }
        return this.getScreen().getRobot();
    }
}

