/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Image;
import org.sikuli.script.Match;
import org.sikuli.script.SikuliXception;
import org.sikuli.script.TextRecognizer;

public class OCR {
    protected static final int PAGE_ITERATOR_LEVEL_WORD = 3;
    protected static final int PAGE_ITERATOR_LEVEL_LINE = 2;
    private static Options options = new Options();

    public static Options globalOptions() {
        return options;
    }

    public static Options reset() {
        return OCR.globalOptions().reset();
    }

    public static void status() {
        Debug.logp("Global settings " + OCR.globalOptions().toString(), new Object[0]);
    }

    public static <SFIRBS> String readText(SFIRBS from) {
        return OCR.readText(from, OCR.globalOptions());
    }

    public static <SFIRBS> String readText(SFIRBS from, Options options) {
        return TextRecognizer.get(options).readText(from);
    }

    public static <SFIRBS> String readLine(SFIRBS from) {
        return OCR.readLine(from, OCR.globalOptions());
    }

    public static <SFIRBS> String readLine(SFIRBS from, Options options) {
        return OCR.readText(from, options.clone().asLine());
    }

    public static <SFIRBS> List<Match> readLines(SFIRBS from) {
        return OCR.readLines(from, OCR.globalOptions());
    }

    public static <SFIRBS> List<Match> readLines(SFIRBS from, Options options) {
        return TextRecognizer.get(options).readLines(from);
    }

    public static <SFIRBS> String readWord(SFIRBS from) {
        return OCR.readWord(from, OCR.globalOptions());
    }

    public static <SFIRBS> String readWord(SFIRBS from, Options options) {
        return OCR.readText(from, options.clone().asWord());
    }

    public static <SFIRBS> List<Match> readWords(SFIRBS from) {
        return OCR.readWords(from, OCR.globalOptions());
    }

    public static <SFIRBS> List<Match> readWords(SFIRBS from, Options options) {
        return TextRecognizer.get(options).readWords(from);
    }

    public static <SFIRBS> String readChar(SFIRBS from) {
        return OCR.readChar(from, OCR.globalOptions());
    }

    public static <SFIRBS> String readChar(SFIRBS from, Options options) {
        return OCR.readText(from, options.clone().asChar());
    }

    public static class Options
    implements Cloneable {
        private int oem;
        private int psm;
        private String language;
        protected static String defaultDataPath = null;
        private String dataPath;
        private float textHeight;
        private static final int OPTIMAL_X_HEIGHT = 30;
        private Image.Interpolation resizeInterpolation;
        private Float bestDPI = null;
        private static final int TESSERACT_USER_DEFINED_DPI = 300;
        private int userDPI;
        private Map<String, String> variables = new LinkedHashMap<String, String>();
        private Set<String> configs = new LinkedHashSet<String>();

        public Options() {
            this.reset();
        }

        public Options clone() {
            Options options = new Options();
            options.oem = this.oem;
            options.psm = this.psm;
            options.language = this.language;
            options.dataPath = this.dataPath;
            options.textHeight = this.textHeight;
            options.resizeInterpolation = this.resizeInterpolation;
            options.variables = new LinkedHashMap<String, String>(this.variables);
            options.configs = new LinkedHashSet<String>(this.configs);
            options.bestDPI = this.bestDPI;
            options.userDPI = this.userDPI;
            return options;
        }

        public Options reset() {
            this.oem = OEM.DEFAULT.ordinal();
            this.psm = PSM.AUTO.ordinal();
            this.language = Settings.OcrLanguage;
            this.dataPath = null;
            this.textHeight = Options.getDefaultTextHeight();
            this.resizeInterpolation = Image.Interpolation.LINEAR;
            this.variables.clear();
            this.configs.clear();
            this.bestDPI = null;
            this.userDPI(300);
            return this;
        }

        public String toString() {
            String msg = String.format("OCR.Options:\ndata = %s\nlanguage(%s) oem(%d) psm(%d) height(%.1f) factor(%.2f) dpi(%d)", this.dataPath(), this.language(), this.oem(), this.psm(), Float.valueOf(this.textHeight()), Float.valueOf(this.factor()), Toolkit.getDefaultToolkit().getScreenResolution());
            if (this.hasVariablesOrConfigs()) {
                msg = msg + "\n" + this.logVariablesConfigs();
            }
            return msg;
        }

        protected void validate() {
            if (!new File(this.dataPath(), this.language() + ".traineddata").exists()) {
                throw new SikuliXception(String.format("OCR: language: no %s.traineddata in %s", this.language(), this.dataPath()));
            }
        }

        public int oem() {
            return this.oem;
        }

        public Options oem(int oem) {
            if (oem < 0 || oem > 3) {
                throw new IllegalArgumentException(String.format("OCR: Invalid OEM %s (0 .. 3)", oem));
            }
            this.oem = oem;
            return this;
        }

        public Options oem(OEM oem) {
            this.oem(oem.ordinal());
            return this;
        }

        public int psm() {
            return this.psm;
        }

        public Options psm(int psm) {
            if (psm < 0 || psm > 13) {
                throw new IllegalArgumentException(String.format("OCR: Invalid PSM %s (0 .. 12)", psm));
            }
            if (!(psm != PSM.OSD_ONLY.ordinal() && psm != PSM.AUTO_OSD.ordinal() && psm != PSM.SPARSE_TEXT_OSD.ordinal() || new File(this.dataPath(), "osd.traineddata").exists())) {
                throw new IllegalArgumentException(String.format("OCR: setPSM(%d): needs OSD, but no osd.traineddata found in tessdata folder", psm));
            }
            this.psm = psm;
            return this;
        }

        public Options psm(PSM psm) {
            this.psm(psm.ordinal());
            return this;
        }

        public Options resetPSM() {
            this.psm = -1;
            return this;
        }

        public Options asLine() {
            return this.psm(PSM.SINGLE_LINE);
        }

        public Options asWord() {
            return this.psm(PSM.SINGLE_WORD);
        }

        public Options asChar() {
            return this.psm(PSM.SINGLE_CHAR);
        }

        public String language() {
            return this.language;
        }

        public Options language(String language) {
            if (language == null || language.isEmpty()) {
                throw new IllegalArgumentException(String.format("OCR: Invalid language %s", language));
            }
            this.language = language;
            return this;
        }

        public String dataPath() {
            if (this.dataPath == null) {
                return defaultDataPath;
            }
            return this.dataPath;
        }

        public Options dataPath(String dataPath) {
            if (dataPath != null && !"tessdata".equals(new File(dataPath).getName())) {
                dataPath = new File(dataPath, "tessdata").getAbsolutePath();
            }
            this.dataPath = dataPath;
            return this;
        }

        public Options smallFont() {
            this.textHeight(10.0f);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static float getDefaultTextHeight() {
            Graphics g = new BufferedImage(100, 100, 1).getGraphics();
            try {
                Font font = g.getFont();
                FontMetrics fm = g.getFontMetrics(font);
                float f = fm.getLineMetrics("X", g).getHeight();
                return f;
            }
            finally {
                g.dispose();
            }
        }

        public float textHeight() {
            return this.textHeight;
        }

        public Options textHeight(float height) {
            this.textHeight = height;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Options fontSize(int size) {
            Graphics g = new BufferedImage(100, 100, 1).getGraphics();
            try {
                Font font = new Font(g.getFont().getFontName(), 0, size);
                FontMetrics fm = g.getFontMetrics(font);
                this.textHeight(fm.getLineMetrics("X", g).getHeight());
                Options options = this;
                return options;
            }
            finally {
                g.dispose();
            }
        }

        protected Image.Interpolation resizeInterpolation() {
            return this.resizeInterpolation;
        }

        public Options resizeInterpolation(Image.Interpolation method) {
            this.resizeInterpolation = method;
            return this;
        }

        protected float bestDPI() {
            return this.bestDPI.floatValue();
        }

        public Options bestDPI(int dpi) {
            this.bestDPI = Float.valueOf(dpi);
            return this;
        }

        public Options userDPI(int dpi) {
            if (dpi == 0) {
                dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            }
            if (dpi < 70 || dpi > 2400) {
                throw new IllegalArgumentException(String.format("OCR: Invalid user DPI: %s (must be 70 .. 2400)", dpi));
            }
            this.userDPI = dpi;
            this.variable("user_defined_dpi", Integer.toString(dpi));
            return this;
        }

        protected float factor() {
            if (this.bestDPI != null) {
                return this.bestDPI.floatValue() / (float)Toolkit.getDefaultToolkit().getScreenResolution();
            }
            return 30.0f / this.textHeight;
        }

        public Map<String, String> variables() {
            return this.variables;
        }

        public Options variable(String key, String value) {
            this.variables.put(key, value);
            return this;
        }

        public List<String> configs() {
            return new ArrayList<String>(this.configs);
        }

        public Options configs(String ... configs) {
            this.configs(Arrays.asList(configs));
            return this;
        }

        public Options configs(List<String> configs) {
            this.configs = new LinkedHashSet<String>(configs);
            return this;
        }

        private boolean hasVariablesOrConfigs() {
            return !this.configs.isEmpty() || !this.variables.isEmpty();
        }

        private String logVariablesConfigs() {
            String logConfigs = "";
            if (!logConfigs.isEmpty()) {
                logConfigs = "configs: " + logConfigs;
            }
            String logVariables = "";
            for (String key : this.variables.keySet()) {
                if (!logVariables.isEmpty()) {
                    logVariables = logVariables + ",";
                }
                logVariables = logVariables + key + ":" + this.variables.get(key);
            }
            if (!logVariables.isEmpty()) {
                logVariables = "variables: " + logVariables;
            }
            return (logConfigs + logVariables).trim();
        }
    }

    public static enum PSM {
        OSD_ONLY,
        AUTO_OSD,
        AUTO_ONLY,
        AUTO,
        SINGLE_COLUMN,
        SINGLE_BLOCK_VERT_TEXT,
        SINGLE_BLOCK,
        SINGLE_LINE,
        SINGLE_WORD,
        CIRCLE_WORD,
        SINGLE_CHAR,
        SPARSE_TEXT,
        SPARSE_TEXT_OSD,
        RAW_LINE;

    }

    public static enum OEM {
        TESSERACT_ONLY,
        LSTM_ONLY,
        TESSERACT_LSTM_COMBINED,
        DEFAULT;

    }
}

