/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.script;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.sikuli.basics.Debug;
import org.sikuli.basics.FileManager;
import org.sikuli.basics.Settings;
import org.sikuli.script.FindFailed;
import org.sikuli.script.Location;
import org.sikuli.script.Region;
import org.sikuli.script.SX;
import org.sikuli.script.runnerSupport.JythonSupport;
import org.sikuli.script.support.RunTime;
import org.sikuli.script.support.SikulixAPI;
import org.sikuli.vnc.VNCScreen;

public class Sikulix {
    private static int lvl = 3;
    private static Point locPopAt = null;

    public static void main(String[] args) throws FindFailed {
        System.setProperty("sikuli.API_should_run", "develop");
        RunTime.start(RunTime.Type.API, args);
        SikulixAPI.main(args);
    }

    private static void log(int level, String message, Object ... args) {
        Debug.logx(level, "Sikulix: " + message, args);
    }

    public static String print(String msg, Object ... args) {
        String outMsg = String.format(msg, args);
        System.out.println(outMsg);
        return outMsg;
    }

    public static Location popat(Location at) {
        locPopAt = new Point(at.x, at.y);
        return new Location(locPopAt);
    }

    public static Location popat(Region at) {
        locPopAt = new Point(at.getCenter().x, at.getCenter().y);
        return new Location(locPopAt);
    }

    public static Location popat(int atx, int aty) {
        locPopAt = new Point(atx, aty);
        return new Location(locPopAt);
    }

    public static Location popat() {
        locPopAt = Sikulix.getLocPopAt();
        return new Location(locPopAt);
    }

    private static Point getLocPopAt() {
        Rectangle screen0 = RunTime.get().getMonitor(0);
        if (null == screen0) {
            return null;
        }
        return new Point((int)screen0.getCenterX(), (int)screen0.getCenterY());
    }

    public static Location getCurrentPopLocation() {
        if (null == locPopAt && null == (locPopAt = Sikulix.getLocPopAt())) {
            return null;
        }
        return new Location(locPopAt);
    }

    private static JFrame popLocation() {
        if (null == locPopAt && null == (locPopAt = Sikulix.getLocPopAt())) {
            return null;
        }
        return Sikulix.popLocation(Sikulix.locPopAt.x, Sikulix.locPopAt.y);
    }

    private static JFrame popLocation(int x, int y) {
        JFrame anchor = new JFrame();
        anchor.setAlwaysOnTop(true);
        anchor.setUndecorated(true);
        anchor.setSize(1, 1);
        anchor.setLocation(x, y);
        anchor.setVisible(true);
        return anchor;
    }

    public static void popup(String message) {
        Sikulix.popup(message, "Sikuli");
    }

    public static void popup(String message, String title) {
        SX.popup(new Object[0]);
    }

    public static void popError(String message) {
        Sikulix.popError(message, "Sikuli");
    }

    public static void popError(String message, String title) {
        SX.popError(message, title);
    }

    public static boolean popAsk(String msg) {
        return Sikulix.popAsk(msg, null);
    }

    public static boolean popAsk(String msg, String title) {
        if (title == null) {
            title = "... something to decide!";
        }
        return SX.popAsk(msg, title);
    }

    public static String popSelect(String msg, String[] options, String preset) {
        return Sikulix.popSelect(msg, null, options, preset);
    }

    public static String popSelect(String msg, String[] options) {
        if (options.length == 0) {
            return "";
        }
        return Sikulix.popSelect(msg, null, options, options[0]);
    }

    public static String popSelect(String msg, String title, String[] options) {
        if (options.length == 0) {
            return "";
        }
        return Sikulix.popSelect(msg, title, options, options[0]);
    }

    public static String popSelect(String msg, String title, String[] options, String preset) {
        if (title == null || "".equals(title)) {
            title = "... something to select!";
        }
        if (options.length == 0) {
            return "";
        }
        if (preset == null) {
            preset = options[0];
        }
        return SX.popSelect(msg, title, preset, null, null, null, options);
    }

    public static String popFile(String title) {
        return SX.popFile(title);
    }

    public static String input(String msg, String preset, String title, boolean hidden) {
        JFrame anchor = Sikulix.popLocation();
        String ret = "";
        if (!hidden) {
            if ("".equals(title)) {
                title = "Sikuli input request";
            }
            ret = (String)JOptionPane.showInputDialog(anchor, msg, title, -1, null, null, preset);
        } else {
            preset = "";
            JTextArea tm = new JTextArea(msg);
            tm.setColumns(20);
            tm.setLineWrap(true);
            tm.setWrapStyleWord(true);
            tm.setEditable(false);
            tm.setBackground(new JLabel().getBackground());
            JPasswordField pw = new JPasswordField(preset);
            JPanel pnl = new JPanel();
            pnl.setLayout(new BoxLayout(pnl, 1));
            pnl.add(pw);
            pnl.add(Box.createVerticalStrut(10));
            pnl.add(tm);
            int retval = JOptionPane.showConfirmDialog(anchor, pnl, title, 2);
            if (0 == retval) {
                char[] pwc = pw.getPassword();
                for (int i = 0; i < pwc.length; ++i) {
                    ret = ret + pwc[i];
                    pwc[i] = '\u0000';
                }
            }
        }
        if (anchor != null) {
            anchor.dispose();
        }
        return ret;
    }

    public static String input(String msg, String title, boolean hidden) {
        return Sikulix.input(msg, "", title, hidden);
    }

    public static String input(String msg, boolean hidden) {
        return Sikulix.input(msg, "", "", hidden);
    }

    public static String input(String msg, String preset, String title) {
        return Sikulix.input(msg, preset, title, false);
    }

    public static String input(String msg, String preset) {
        return Sikulix.input(msg, preset, "", false);
    }

    public static String input(String msg) {
        return Sikulix.input(msg, "", "", false);
    }

    public static String inputText(String msg) {
        return Sikulix.inputText(msg, "", 0, 0, "");
    }

    public static String inputText(String msg, int lines, int width) {
        return Sikulix.inputText(msg, "", lines, width, "");
    }

    public static String inputText(String msg, int lines, int width, String text) {
        return Sikulix.inputText(msg, "", lines, width, text);
    }

    public static String inputText(String msg, String text) {
        return Sikulix.inputText(msg, "", 0, 0, text);
    }

    public static String inputText(String msg, String title, int lines, int width, String text) {
        width = Math.max(20, width);
        lines = Math.max(9, lines);
        if ("".equals(title)) {
            title = "SikuliX input request";
        }
        JTextArea ta = new JTextArea("");
        String fontname = "Dialog";
        int pluswidth = 1;
        if (Settings.InputFontMono) {
            fontname = "Monospaced";
            pluswidth = 3;
        }
        ta.setFont(new Font(fontname, 0, Math.max(14, Settings.InputFontSize)));
        int w = (width + pluswidth) * ta.getFontMetrics(ta.getFont()).charWidth('m');
        int h = (lines + 1) * ta.getFontMetrics(ta.getFont()).getHeight();
        ta.setText(text);
        ta.setLineWrap(true);
        ta.setWrapStyleWord(true);
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(ta);
        sp.setPreferredSize(new Dimension(w, h));
        JTextArea tm = new JTextArea("");
        tm.setFont(new Font(fontname, 0, Math.max(14, Settings.InputFontSize)));
        tm.setColumns(width);
        tm.setText(msg);
        tm.setLineWrap(true);
        tm.setWrapStyleWord(true);
        tm.setEditable(false);
        tm.setBackground(new JLabel().getBackground());
        JPanel pnl = new JPanel();
        pnl.setLayout(new BoxLayout(pnl, 1));
        pnl.add(sp);
        pnl.add(Box.createVerticalStrut(10));
        pnl.add(tm);
        pnl.add(Box.createVerticalStrut(10));
        JFrame anchor = Sikulix.popLocation();
        int ret = JOptionPane.showConfirmDialog(anchor, pnl, title, 2);
        if (anchor != null) {
            anchor.dispose();
        }
        if (0 == ret) {
            return ta.getText();
        }
        return null;
    }

    public static String run(String cmdline) {
        return Sikulix.run(new String[]{cmdline});
    }

    public static String run(String[] cmd) {
        return RunTime.get().runcmd(cmd);
    }

    public static VNCScreen vncStart(String theIP, int thePort, String password, int cTimeout, int timeout) {
        return VNCScreen.start(theIP, thePort, password, cTimeout, timeout);
    }

    public static VNCScreen vncStart(String theIP, int thePort, int cTimeout, int timeout) {
        return VNCScreen.start(theIP, thePort, cTimeout, timeout);
    }

    public static boolean buildJarFromFolder(String targetJar, String sourceFolder) {
        Sikulix.log(lvl, "buildJarFromFolder: \nfrom Folder: %s\nto Jar: %s", sourceFolder, targetJar);
        File fJar = new File(targetJar);
        if (!fJar.getParentFile().exists()) {
            Sikulix.log(-1, "buildJarFromFolder: parent folder of Jar not available", new Object[0]);
            return false;
        }
        File fSrc = new File(sourceFolder);
        if (!fSrc.exists() || !fSrc.isDirectory()) {
            Sikulix.log(-1, "buildJarFromFolder: source folder not available", new Object[0]);
            return false;
        }
        String prefix = null;
        if ((new File(fSrc, "__init__.py").exists() || new File(fSrc, "__init__$py.class").exists()) && (prefix = fSrc.getName()).endsWith("_")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return FileManager.buildJar(targetJar, new String[]{null}, new String[]{sourceFolder}, new String[]{prefix}, null);
    }

    public static boolean compileJythonFolder(String fpSource, String fpTarget) {
        JythonSupport jython = JythonSupport.get();
        if (jython != null) {
            File fTarget = new File(fpTarget);
            FileManager.deleteFileOrFolder(fTarget);
            fTarget.mkdirs();
            if (!fTarget.exists()) {
                Sikulix.log(-1, "compileJythonFolder: target folder not available\n%", fTarget);
                return false;
            }
            File fSource = new File(fpSource);
            if (!fSource.exists()) {
                Sikulix.log(-1, "compileJythonFolder: source folder not available\n", fSource);
                return false;
            }
            if (fTarget.equals(fSource)) {
                Sikulix.log(-1, "compileJythonFolder: target folder cannot be the same as the source folder", new Object[0]);
                return false;
            }
            FileManager.xcopy(fSource, fTarget);
            if (!jython.interpreterExecString("import compileall")) {
                return false;
            }
            jython = Sikulix.doCompileJythonFolder(jython, fTarget);
            FileManager.traverseFolder(fTarget, new CompileJythonFilter(jython));
        }
        return false;
    }

    private static JythonSupport doCompileJythonFolder(JythonSupport jython, File fSource) {
        String fpSource = FileManager.slashify(fSource.getAbsolutePath(), false);
        if (!jython.interpreterExecString(String.format("compileall.compile_dir(\"%s\",maxlevels = 0, quiet = 1)", fpSource))) {
            return null;
        }
        for (File aFile : fSource.listFiles()) {
            if (!aFile.getName().endsWith(".py")) continue;
            aFile.delete();
        }
        return jython;
    }

    private static class CompileJythonFilter
    extends FileManager.FileFilter {
        JythonSupport jython = null;

        CompileJythonFilter(JythonSupport jython) {
            this.jython = jython;
        }

        @Override
        public boolean accept(File entry) {
            if (this.jython != null && entry.isDirectory()) {
                this.jython = Sikulix.doCompileJythonFolder(this.jython, entry);
            }
            return false;
        }
    }
}

