/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RadialGradientPaint;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.sikuli.basics.Debug;
import org.sikuli.basics.Settings;
import org.sikuli.script.Location;
import org.sikuli.script.Region;

public class Highlight
extends JFrame {
    static boolean hasTL = false;
    static boolean hasPPTL = false;
    static boolean hasPPTP = false;
    static double gdW = -1.0;
    static double gdH = -1.0;
    static List<Highlight> highlights = new ArrayList<Highlight>();
    int side = 70;
    float halfSide = (float)this.side * 0.5f;
    int locx = -1;
    int locy = -1;
    int sidex = -1;
    int sidey = -1;
    int frameX = -1;
    int frameY = -1;
    Region region = null;
    boolean showable = false;
    private int defaultOpaque = 30;
    private Color defaultColor = new Color(255, 0, 0, this.defaultOpaque);
    private Color givenColor = null;
    private static boolean inCloseAll;

    public boolean isShowable() {
        return this.showable;
    }

    private Highlight() {
        if (!hasPPTL) {
            Debug.error("Highlight: is not supported in your environment", new Object[0]);
            Debug.error("Highlight: TansparencySupport: TL: %s PPTL: %s PPTP: %s", hasTL, hasPPTL, hasPPTP);
        } else {
            this.showable = true;
            this.setUndecorated(true);
            this.setBackground(new Color(0, 0, 0, 0));
            this.setAlwaysOnTop(true);
            this.setDefaultCloseOperation(3);
            this.setType(Window.Type.UTILITY);
            this.setFocusableWindowState(false);
            this.setAutoRequestFocus(false);
        }
    }

    public Highlight(Location loc) {
        this();
        if (this.isShowable()) {
            this.locx = loc.x;
            this.locy = loc.y;
            JPanel panel = this.initAsCross();
            this.setContentPane(panel);
        }
    }

    public Highlight(Region reg) {
        this(reg, null);
    }

    public Highlight(Region reg, String color) {
        this();
        if (this.isShowable()) {
            this.givenColor = this.evalColor(color);
            this.region = reg;
            this.locx = reg.x;
            this.locy = reg.y;
            this.sidex = reg.h;
            this.sidey = reg.w;
            JPanel panel = this.initAsFrame();
            if (panel == null) {
                this.getRootPane().setBorder(BorderFactory.createLineBorder(this.givenColor, 3));
            } else {
                this.setContentPane(panel);
            }
        }
    }

    private JPanel initAsCross() {
        this.setSize(this.side, this.side);
        this.frameX = this.locx - (int)this.halfSide;
        this.frameY = this.locy - (int)this.halfSide;
        JPanel panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (g instanceof Graphics2D) {
                    int side = this.getWidth();
                    Point2D.Float center = new Point2D.Float(Highlight.this.halfSide, Highlight.this.halfSide);
                    Color redFull = new Color(255, 0, 0, 150);
                    Color redTrans = new Color(255, 0, 0, 0);
                    float radius = Highlight.this.halfSide;
                    float[] dist = new float[]{0.0f, 1.0f};
                    Color[] colorsRed = new Color[]{redFull, redTrans};
                    Color[] colorsBlack = new Color[]{Color.BLACK, Color.WHITE};
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setPaint(new RadialGradientPaint(center, radius, dist, colorsRed));
                    g2d.fillRect(0, 0, side, side);
                    g2d.setPaint(new RadialGradientPaint(center, radius, dist, colorsBlack));
                    g2d.fillRect((int)Highlight.this.halfSide - 1, 0, 2, side);
                    g2d.fillRect(0, (int)Highlight.this.halfSide - 1, side, 2);
                }
            }
        };
        return panel;
    }

    private Color getColor() {
        if (null == this.givenColor) {
            return this.defaultColor;
        }
        return new Color(this.givenColor.getRed(), this.givenColor.getGreen(), this.givenColor.getBlue(), this.defaultOpaque);
    }

    private Color evalColor(String color) {
        Color targetColor = Color.RED;
        if (color == null) {
            color = Settings.DefaultHighlightColor;
        }
        if (color.startsWith("#")) {
            if (color.length() > 7) {
                if (color.length() == 10) {
                    int cR = 255;
                    int cG = 0;
                    int cB = 0;
                    try {
                        cR = Integer.decode(color.substring(1, 4));
                        cG = Integer.decode(color.substring(4, 7));
                        cB = Integer.decode(color.substring(7, 10));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    try {
                        targetColor = new Color(cR, cG, cB);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else {
                try {
                    targetColor = new Color(Integer.decode(color));
                }
                catch (NumberFormatException cR) {}
            }
        } else {
            if (!color.endsWith("Gray") || "Gray".equals(color)) {
                color = color.toUpperCase();
            }
            try {
                Field field = Class.forName("java.awt.Color").getField(color);
                targetColor = (Color)field.get(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return targetColor;
    }

    private JPanel initAsFrame() {
        int lineWidth = 3;
        this.frameX = this.locx - lineWidth;
        this.frameY = this.locy - lineWidth;
        final int frameW = this.sidey + 2 * lineWidth;
        final int frameH = this.sidex + 2 * lineWidth;
        this.setSize(frameW, frameH);
        if (Settings.HighlightTransparent) {
            return null;
        }
        JPanel panel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (g instanceof Graphics2D) {
                    Point2D.Float center = new Point2D.Float((float)frameW / 2.0f, (float)frameH / 2.0f);
                    Color colorFull = Highlight.this.getColor();
                    Color colorTrans = new Color(colorFull.getRed(), colorFull.getGreen(), colorFull.getBlue(), 0);
                    float radius = Math.max(center.x, center.y);
                    float[] dist = new float[]{0.0f, 1.0f};
                    Color[] colors = new Color[]{colorTrans, colorFull};
                    Graphics2D g2d = (Graphics2D)g;
                    g2d.setPaint(new RadialGradientPaint(center, radius, dist, colors));
                    g2d.fillRect(0, 0, frameW, frameH);
                }
            }
        };
        panel.setBorder(BorderFactory.createLineBorder(this.givenColor, 3));
        return panel;
    }

    public static Highlight fakeHighlight() {
        return null;
    }

    public Highlight doShow() {
        return this.doShow(0.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Highlight doShow(double secs) {
        if (!this.isShowable()) return this;
        this.setLocation(this.frameX, this.frameY);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Highlight.this.setVisible(false);
                Highlight.this.dispose();
            }
        });
        Class<Highlight> clazz = Highlight.class;
        synchronized (Highlight.class) {
            if (!highlights.contains(this)) {
                highlights.add(this);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Highlight.this.setVisible(true);
                }
            });
            if (!(secs > 0.0)) return this;
            try {
                Thread.sleep((int)(1000.0 * (secs + Settings.WaitAfterHighlight)));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.close();
            return this;
        }
    }

    public void unShow() {
        if (this.isShowable()) {
            this.setVisible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isShowable()) {
            this.setVisible(false);
        }
        this.dispose();
        this.showable = false;
        if (null != this.region) {
            this.region.internalUseOnlyHighlightReset();
        }
        if (inCloseAll) {
            return;
        }
        Class<Highlight> clazz = Highlight.class;
        synchronized (Highlight.class) {
            highlights.remove(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Class<Highlight> clazz = Highlight.class;
        synchronized (Highlight.class) {
            if (highlights.size() > 0) {
                inCloseAll = true;
                for (Highlight highlight : highlights) {
                    highlight.close();
                }
                highlights.clear();
                inCloseAll = false;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        gdW = gd.getDefaultConfiguration().getBounds().getWidth();
        gdH = gd.getDefaultConfiguration().getBounds().getHeight();
        hasTL = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
        hasPPTL = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT);
        hasPPTP = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSPARENT);
        inCloseAll = false;
    }
}

