/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.IOException;
import java.net.InetSocketAddress;
import se.vidstige.jadb.ConnectionToRemoteDeviceException;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.Transport;

public class HostConnectionCommand {
    private final Transport transport;
    private final ResponseValidator responseValidator;

    HostConnectionCommand(Transport transport, ResponseValidator responseValidator) {
        this.transport = transport;
        this.responseValidator = responseValidator;
    }

    InetSocketAddress executeHostCommand(String command, InetSocketAddress inetSocketAddress) throws IOException, JadbException, ConnectionToRemoteDeviceException {
        this.transport.send(String.format("host:%s:%s:%d", command, inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
        this.verifyTransportLevel();
        this.verifyProtocolLevel();
        return inetSocketAddress;
    }

    private void verifyTransportLevel() throws IOException, JadbException {
        this.transport.verifyResponse();
    }

    private void verifyProtocolLevel() throws IOException, ConnectionToRemoteDeviceException {
        String status = this.transport.readString();
        this.responseValidator.validate(status);
    }

    static interface ResponseValidator {
        public void validate(String var1) throws ConnectionToRemoteDeviceException;
    }

    static class ResponseValidatorBase
    implements ResponseValidator {
        private final String successMessage;
        private final String errorMessage;

        ResponseValidatorBase(String successMessage, String errorMessage) {
            this.successMessage = successMessage;
            this.errorMessage = errorMessage;
        }

        @Override
        public void validate(String response) throws ConnectionToRemoteDeviceException {
            if (!this.checkIfConnectedSuccessfully(response) && !this.checkIfAlreadyConnected(response)) {
                throw new ConnectionToRemoteDeviceException(this.extractError(response));
            }
        }

        private boolean checkIfConnectedSuccessfully(String response) {
            return response.startsWith(this.successMessage);
        }

        private boolean checkIfAlreadyConnected(String response) {
            return response.startsWith(this.errorMessage);
        }

        private String extractError(String response) {
            int lastColon = response.lastIndexOf(58);
            if (lastColon != -1) {
                return response.substring(lastColon);
            }
            return response;
        }
    }
}

