/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JPanel;
import org.sikuli.basics.Debug;
import org.sikuli.guide.GlobalMouseMotionListener;
import org.sikuli.guide.GlobalMouseMotionTracker;
import org.sikuli.guide.Guide;
import org.sikuli.guide.SxClickable;
import org.sikuli.guide.Transition;
import org.sikuli.guide.Visual;
import org.sikuli.script.Region;
import org.sikuli.util.OverlayTransparentWindow;

public class ClickableWindow
extends OverlayTransparentWindow
implements MouseListener,
Transition,
GlobalMouseMotionListener {
    Guide guide;
    JPanel jp = null;
    ArrayList<SxClickable> clickables = new ArrayList();
    private SxClickable lastClicked;
    private Rectangle maxR;
    Point clickLocation;
    GlobalMouseMotionTracker mouseTracker;
    Transition.TransitionListener token;
    Cursor handCursor = new Cursor(12);
    Cursor defaultCursor = new Cursor(0);
    Cursor hourglassCursor = new Cursor(3);
    Cursor currentCursor = null;

    public ClickableWindow(Guide guide) {
        super(new Color(0.1f, 0.0f, 0.0f, 0.005f), null);
        this.guide = guide;
        this.jp = this.getJPanel();
        this.mouseTracker = GlobalMouseMotionTracker.getInstance();
        this.mouseTracker.addListener(this);
        this.setVisible(false);
        this.setFocusableWindowState(false);
        this.addMouseListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                ClickableWindow.this.mouseTracker.stop();
            }
        });
    }

    @Override
    public void toFront() {
        super.toFront();
    }

    public void addClickable(SxClickable c) {
        this.clickables.add(c);
        SxClickable c1 = new SxClickable(null);
        c1.setLocationRelativeToComponent(c, Visual.Layout.OVER);
        this.jp.add(c1);
    }

    public void addClickableRegion(Region region, String name) {
        SxClickable c = new SxClickable(region);
        c.setName(name);
        this.addClickable(c);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        Debug.log("[ClickableWindow] clicked on " + e.getX() + "," + e.getY(), new Object[0]);
        Point p = e.getPoint();
        this.lastClicked = null;
        for (SxClickable c : this.clickables) {
            if (!c.getActualBounds().contains(p)) continue;
            this.lastClicked = c;
            p.x -= c.getX();
            p.y -= c.getY();
            c.globalMouseClicked(p);
        }
        if (this.lastClicked != null && this.token != null) {
            this.setVisible(false);
            this.token.transitionOccurred(this);
        }
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    @Override
    public String waitForTransition(Transition.TransitionListener token) {
        this.token = token;
        this.maxR = this.clickables.get(0).getBounds();
        if (this.clickables.size() > 1) {
            for (SxClickable c : this.clickables.subList(1, this.clickables.size())) {
                this.maxR = this.maxR.union(c.getActualBounds());
            }
        }
        this.setBounds(this.maxR);
        this.setVisible(true);
        this.mouseTracker.start();
        return "Next";
    }

    @Override
    public void globalMouseMoved(int x, int y) {
        Point p = new Point(x, y);
        Visual cc = null;
        for (SxClickable c : this.clickables) {
            if (c.getBounds().contains(p)) {
                c.setMouseOver(true);
                cc = c;
                continue;
            }
            c.setMouseOver(false);
        }
        if (cc != null) {
            this.setLocation(0, 0);
            this.setSize(cc.getActualLocation().x + cc.getActualWidth(), cc.getActualLocation().y + cc.getActualHeight());
        } else {
            this.setBounds(this.maxR);
        }
    }

    @Override
    public void globalMouseIdled(int x, int y) {
    }

    public SxClickable getLastClicked() {
        return this.lastClicked;
    }

    public ArrayList<SxClickable> getClickables() {
        return this.clickables;
    }

    public void clear() {
        this.clickables.clear();
        this.getContentPane().removeAll();
    }
}

