/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.sikuli.guide.ComponentMover;
import org.sikuli.guide.HTMLTextPane;
import org.sikuli.guide.Transition;
import org.sikuli.util.OverlayTransparentWindow;

public class TransitionDialog
extends OverlayTransparentWindow
implements Transition {
    static Point userPreferredLocation = null;
    Box buttons;
    JLabel titleBar;
    Button defaultButton;
    TextPane textPane;
    String command = null;
    boolean isLocationSet = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dismiss() {
        this.setVisible(false);
        this.dispose();
        TransitionDialog transitionDialog = this;
        synchronized (transitionDialog) {
            this.notify();
        }
    }

    @Override
    public void setTitle(String title) {
        this.titleBar.setText(title);
        this.titleBar.setVisible(true);
    }

    public String getActionCommand() {
        return this.command;
    }

    public TransitionDialog() {
        this.init("");
    }

    public TransitionDialog(String text) {
        this.init(text);
    }

    public void setLocationToUserPreferredLocation() {
        if (userPreferredLocation != null) {
            this.setLocation(userPreferredLocation);
        } else {
            this.setLocationRelativeTo(null);
        }
    }

    public void setTimeout(int timeout) {
        Timer timer = new Timer(timeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TransitionDialog.this.command = null;
                TransitionDialog.this.dismiss();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    void init(String text) {
        this.setBackground(Color.yellow);
        this.setForeground(Color.black);
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        this.add(content);
        this.textPane = new TextPane();
        this.textPane.setText(text);
        this.textPane.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        Color darkyellow = new Color(238, 185, 57);
        this.titleBar = new JLabel();
        this.titleBar.setFont(new Font("sansserif", 1, 14));
        this.titleBar.setBackground(darkyellow);
        this.titleBar.setOpaque(true);
        this.titleBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 3, 5));
        this.titleBar.setSize(this.titleBar.getPreferredSize());
        this.titleBar.setVisible(false);
        this.buttons = new Box(0);
        this.defaultButton = new Button("Close");
        this.buttons.add(this.defaultButton);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        content.add(this.titleBar);
        content.add(this.textPane);
        content.add(this.buttons);
        this.titleBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.buttons.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.textPane.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.titleBar.setAlignmentX(0.0f);
        this.textPane.setAlignmentX(0.0f);
        this.buttons.setAlignmentX(0.0f);
        ComponentMover cm = new ComponentMover();
        cm.registerComponent(this);
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String waitForTransition(Transition.TransitionListener token) {
        this.setVisible(true);
        this.toFront();
        this.setAlwaysOnTop(true);
        Point startLocation = this.getLocation();
        this.pack();
        TransitionDialog transitionDialog = this;
        synchronized (transitionDialog) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        Point endLocation = this.getLocation();
        if (endLocation.x != startLocation.x || endLocation.y != startLocation.y) {
            userPreferredLocation = endLocation;
        }
        this.setVisible(false);
        return this.command;
    }

    public void addButton(String name) {
        if (this.defaultButton != null) {
            this.buttons.remove(this.defaultButton);
            this.buttons.removeAll();
            this.defaultButton = null;
        }
        this.buttons.add(new Button(name));
    }

    public void setText(String text) {
        this.textPane.setText(text);
        this.pack();
    }

    class TextPane
    extends HTMLTextPane {
        public TextPane() {
            this.setFont(new Font("sansserif", 0, 14));
            this.setBorder(BorderFactory.createEmptyBorder(5, 3, 5, 3));
        }
    }

    class Button
    extends JButton
    implements ActionListener {
        public Button(String text) {
            super(text);
            Font f = new Font("sansserif", 1, 12);
            this.setFont(f);
            this.setFocusable(false);
            this.setActionCommand(text);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TransitionDialog.this.command = e.getActionCommand();
            TransitionDialog.this.dismiss();
        }
    }
}

